/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import mynotes.ColorScheme;
import mynotes.Commands;
import mynotes.MyDisplayable;
import mynotes.MyNotes;
import mynotes.ResourceBundle;
import mynotes.TextEditor;

public class TextViewer
extends Canvas
implements MyDisplayable,
CommandListener {
    private int x;
    private int y;
    private int width;
    private int height = this.getHeight();
    private int lineHeight;
    private int y0;
    private int textHeight;
    private String[] rows;
    private int[] nlUpperCounter;
    int numOfRows;
    final int SIZE_INC;
    private Graphics g;
    private static int scrollBarWidth = 5;
    private static final int lineSpace = 5;
    int newLineCounter;
    int menuBarHeight;
    int titleBarHeight;
    String title;
    Vector commands;
    private String text;
    MyDisplayable back;
    private boolean isFirstRun;
    TextEditor textEditor = null;
    int listHeight;
    Font font;
    CommandListener listener;

    public TextViewer() {
        this.SIZE_INC = 20;
        this.width = this.getWidth();
        this.commands = new Vector();
        this.commands.addElement(null);
        this.commands.addElement(null);
        this.setCommandListener(this);
        this.setFullScreenMode(true);
        this.title = new String("");
    }

    public void init(int n, int n2, int n3, int n4, Graphics graphics, String string) {
        int n5;
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.g = graphics;
        this.width -= scrollBarWidth;
        this.font = Font.getFont((int)0, (int)0, (int)0);
        this.lineHeight = this.font.getHeight();
        this.menuBarHeight = this.lineHeight + 2;
        this.titleBarHeight = this.lineHeight + 2;
        this.listHeight = n4 - this.menuBarHeight - this.titleBarHeight;
        this.g.setFont(this.font);
        this.rows = new String[20];
        this.nlUpperCounter = new int[20];
        this.numOfRows = 0;
        int n6 = 0;
        this.newLineCounter = 0;
        do {
            n5 = string.indexOf(10, n6);
            int n7 = this.newLineCounter++;
            if (n5 == -1) {
                n5 = string.length();
            }
            String string2 = string.substring(n6, n5);
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = string2.length();
            boolean bl = true;
            this.y0 = 0;
            while (bl) {
                n9 = string2.indexOf(" ", n8 + 1);
                if (n9 <= n8) {
                    n9 = n13;
                    bl = false;
                }
                if (n12 + (n11 = this.g.getFont().stringWidth(string2.substring(n8, n9))) < this.width) {
                    n12 += n11;
                    n8 = n9;
                    continue;
                }
                this.addRow(string2.substring(n10, n8), n7);
                n10 = n8 + 1;
                if (n11 > this.width) {
                    n9 = n8;
                    for (n12 = n11; n12 > this.width; n12 -= n11) {
                        n11 = 0;
                        while (n11 < this.width) {
                            n11 = this.g.getFont().stringWidth(string2.substring(n10, ++n9));
                        }
                        n11 = this.g.getFont().stringWidth(string2.substring(n10, --n9));
                        this.addRow(string2.substring(n10, n9), n7);
                        n8 = n9;
                        n10 = n9;
                    }
                    n12 = 0;
                    continue;
                }
                n8 = n9;
            }
            this.addRow(string2.substring(n10, n13), n7);
        } while ((n6 = n5 + 1) < string.length());
        this.textHeight = this.numOfRows * this.lineHeight + 5 * this.newLineCounter;
        this.width += scrollBarWidth;
    }

    public void start(String string, String string2, MyDisplayable myDisplayable, TextEditor textEditor) {
        this.addCommand(Commands.BACK, 5);
        this.back = myDisplayable;
        this.isFirstRun = true;
        this.textEditor = textEditor;
        if (this.textEditor != null) {
            this.addCommand(Commands.EDIT, 8);
        } else {
            this.addCommand(null, 8);
        }
        this.text = string2;
        this.setTitle(string);
        this.setFullScreenMode(true);
        this.activate();
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    private int addRow(String string, int n) {
        if (this.numOfRows == this.rows.length) {
            String[] stringArray = new String[this.numOfRows + 20];
            int[] nArray = new int[this.numOfRows + 20];
            System.arraycopy(this.rows, 0, stringArray, 0, this.numOfRows);
            System.arraycopy(this.nlUpperCounter, 0, nArray, 0, this.numOfRows);
            this.rows = stringArray;
            this.nlUpperCounter = nArray;
        }
        this.rows[this.numOfRows] = string;
        this.nlUpperCounter[this.numOfRows] = n;
        ++this.numOfRows;
        return this.numOfRows;
    }

    void drawTitleBar() {
        this.g.setColor(ColorScheme.CL_TITLEBARBACKGROUND);
        this.g.fillRect(this.x, this.y, this.width, this.titleBarHeight);
        this.g.setColor(ColorScheme.CL_TITLEBARFONT);
        if (this.title != null) {
            this.g.setFont(this.font);
            this.g.drawString(this.title, this.x + 1, this.y + 1, 20);
        }
    }

    void drawMenuBar() {
        Command command;
        this.g.setFont(this.font);
        this.g.setColor(ColorScheme.CL_MENUBARBACKGROUND);
        this.g.fillRect(this.x, this.height - this.menuBarHeight, this.width, this.menuBarHeight);
        this.g.setColor(ColorScheme.CL_MENUBARFONT);
        if (this.commands.size() > 2) {
            this.g.drawString(ResourceBundle.getString("menu"), 3, this.height - this.menuBarHeight + 1, 20);
        }
        if ((command = (Command)this.commands.elementAt(1)) != null) {
            this.g.drawString(command.getLabel(), this.width - 3, this.height - this.menuBarHeight + 1, 24);
        }
        if ((command = (Command)this.commands.elementAt(0)) != null) {
            this.g.drawString(command.getLabel(), this.width / 2, this.height - this.menuBarHeight + 1, 17);
        }
    }

    void drawScrollBar() {
        int n;
        int n2 = 0;
        int n3 = 0;
        double d = 1.0;
        int n4 = n = this.textHeight <= this.listHeight ? this.textHeight : this.listHeight;
        if (this.textHeight <= this.listHeight) {
            n3 = 0;
            n2 = this.listHeight;
            d = 1.0;
        } else {
            int n5 = this.textHeight - this.y0 - this.listHeight;
            n5 = n5 < 0 ? 0 : n5;
            d = (double)n / (double)this.textHeight;
            if (d < 0.1) {
                d = 0.1;
            }
            n2 = (int)((double)this.listHeight * d);
            n3 = (int)((double)(-this.listHeight) * (double)this.y0 / (double)this.textHeight);
        }
        if (n2 != this.listHeight) {
            this.g.setColor(ColorScheme.CL_SCROLLBAR);
            this.g.fillRect(this.width - scrollBarWidth, this.y + this.titleBarHeight, scrollBarWidth, this.listHeight);
            this.g.setColor(ColorScheme.CL_SCROLLBOX);
            this.g.fillRect(this.width - scrollBarWidth, this.y + this.titleBarHeight + n3, scrollBarWidth, n2);
        }
    }

    void drawText() {
        this.g.setColor(ColorScheme.CL_TEXTBACKGROUND);
        this.g.fillRect(this.x, this.y + this.titleBarHeight, this.width, this.listHeight);
        this.g.setColor(ColorScheme.CL_TEXTFONT);
        int n = this.y0;
        this.g.setFont(this.font);
        for (int i = 0; i < this.numOfRows; ++i) {
            int n2 = this.titleBarHeight + 5 * this.nlUpperCounter[i];
            if (n + n2 + this.lineHeight > 0) {
                this.g.drawString(this.rows[i], this.x + 1, this.y + n + n2, 20);
            }
            if ((n += this.lineHeight) > this.listHeight) break;
        }
    }

    public void addCommand(Command command, int n) {
        switch (n) {
            case 5: {
                this.commands.setElementAt(command, 1);
                break;
            }
            case 8: {
                this.commands.setElementAt(command, 0);
                break;
            }
            case 2: {
                this.commands.addElement(command);
            }
        }
    }

    public void lineDown() {
        if (this.textHeight > this.listHeight) {
            this.y0 -= this.lineHeight;
            if (this.listHeight - this.y0 > this.textHeight) {
                this.y0 = this.listHeight - this.textHeight;
            }
        }
    }

    public void lineUp() {
        if (this.textHeight > this.listHeight) {
            this.y0 += this.lineHeight;
            if (this.y0 > 0) {
                this.y0 = 0;
            }
        }
    }

    public void pageUp() {
        if (this.textHeight > this.listHeight) {
            this.y0 = this.y0 + this.listHeight - this.lineHeight;
            if (this.y0 > 0) {
                this.y0 = 0;
            }
        }
    }

    public void pageDown() {
        if (this.textHeight > this.listHeight) {
            this.y0 = this.y0 - this.listHeight + this.lineHeight;
            if (this.listHeight - this.y0 > this.textHeight) {
                this.y0 = this.listHeight - this.textHeight;
            }
        }
    }

    public void goBegin() {
        this.y0 = 0;
    }

    public void goEnd() {
        this.y0 = -(this.textHeight - this.listHeight);
        if (this.y0 > 0) {
            this.y0 = 0;
        }
    }

    public String getText() {
        return this.text;
    }

    protected void paint(Graphics graphics) {
        this.height = this.getHeight();
        this.width = this.getWidth();
        if (this.isFirstRun) {
            this.init(0, 0, this.width, this.height, graphics, this.text);
            this.isFirstRun = false;
        }
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.setClip(this.x, this.y, this.width, this.height);
        this.drawText();
        this.drawScrollBar();
        this.drawTitleBar();
        this.drawMenuBar();
        graphics.setClip(n, n2, n3, n4);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Commands.BACK) {
            this.back.activate();
        }
        if (command == Commands.EDIT) {
            this.textEditor.start(2, this.getTitle(), this.getText(), this.back, this);
        }
    }

    protected void keyRepeated(int n) {
        if (this.hasRepeatEvents()) {
            // empty if block
        }
    }

    protected void keyPressed(int n) {
        Command command;
        int n2 = 2128506;
        try {
            n2 = this.getGameAction(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if ((n == 35 || n == -7 || n == -22 || n == 22 || n == -203) && this.listener != null) {
            command = (Command)this.commands.elementAt(1);
            this.listener.commandAction(command, (Displayable)this);
        }
        if ((n2 == 8 || n == 53) && this.listener != null) {
            command = (Command)this.commands.elementAt(0);
            this.listener.commandAction(command, (Displayable)this);
        }
        if (n2 == 1 || n == 50) {
            this.lineUp();
        }
        if (n2 == 6 || n == 56) {
            this.lineDown();
        }
        if (n2 == 2 || n == 51) {
            this.pageUp();
        }
        if (n2 == 5 || n == 57) {
            this.pageDown();
        }
        if (n == 49) {
            this.goBegin();
        }
        if (n == 55) {
            this.goEnd();
        }
        this.repaint();
    }

    public void setCommandListener(CommandListener commandListener) {
        this.listener = commandListener;
    }

    public void activate() {
        MyNotes.display.setCurrent((Displayable)this);
    }
}

