/*
 * Decompiled with CFR 0.152.
 */
package com.lenin.files.electroid.game;

import com.lenin.files.electroid.game.Resources;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.game.Sprite;

public class Plate
extends Sprite {
    public static final int ROWS = 10;
    private static final int INTERVAL = 40;
    private static final int PADDING_V = 6;
    private static final int PADDING_H = 7;
    private static final int INIT_WIDTH = 59;
    private static final int VELOCITY = 4;
    private int velocity;
    private int width;
    private int displayWidth;
    private Timer animator;
    private Resources r;

    public Plate(int displayWidth, Resources r) {
        super(r.plate, r.plate.getWidth(), r.plate.getHeight() / 10);
        this.displayWidth = displayWidth;
        this.r = r;
        this.width = r.scale(59.0);
        this.setCollisionRectangle();
        this.defineReferencePixel((int)((double)this.getWidth() * 0.5 + 0.5), (int)((double)this.getHeight() * 0.5 + 0.5));
        this.velocity = 0;
    }

    public void stretch() {
        this.animator = new Timer();
        TimerTask stretch = new TimerTask(){

            public void run() {
                if (Plate.this.getFrame() < Plate.this.getRawFrameCount() - 1) {
                    Plate plate = Plate.this;
                    plate.width = plate.width + Plate.this.r.scale(4.0);
                    Plate.this.correctPosition();
                    Plate.this.nextFrame();
                    Plate.this.setCollisionRectangle();
                } else {
                    this.cancel();
                }
            }
        };
        this.animator.schedule(stretch, 0L, 40L);
    }

    public void shrink() {
        this.animator = new Timer();
        TimerTask shrink = new TimerTask(){

            public void run() {
                if (Plate.this.getFrame() > 0) {
                    Plate plate = Plate.this;
                    plate.width = plate.width - Plate.this.r.scale(4.0);
                    Plate.this.correctPosition();
                    Plate.this.prevFrame();
                    Plate.this.setCollisionRectangle();
                } else {
                    this.cancel();
                }
            }
        };
        this.animator.schedule(shrink, 0L, 40L);
    }

    private void setCollisionRectangle() {
        this.defineCollisionRectangle((int)((double)(this.getWidth() - this.width) * 0.5 + 0.5) + this.r.scale(7.0), this.r.scale(6.0), this.width - this.r.scale(7.0), this.getHeight());
    }

    private void correctPosition() {
        if (this.getRightX() > this.displayWidth) {
            this.move(-2, 0);
        } else if (this.getLeftX() < 0) {
            this.move(2, 0);
        }
    }

    public void moveLeft() {
        this.velocity = -this.r.scale(4.0);
        this.move(this.velocity, 0);
    }

    public void moveRight() {
        this.velocity = this.r.scale(4.0);
        this.move(this.velocity, 0);
    }

    public int getLeftX() {
        return this.getX() + (int)((double)(this.getWidth() - this.width) * 0.5 + (double)this.r.scale(7.0) + 0.5);
    }

    public int getRightX() {
        return this.getLeftX() + this.width - 2 * this.r.scale(7.0);
    }

    public int getTopY() {
        return this.getY() + this.r.scale(6.0);
    }

    public int getPlateWidth() {
        return this.width;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public void setMoving(int x) {
        this.velocity = x < this.getRefPixelX() ? -4 : 4;
    }

    public boolean isMoving() {
        return this.velocity != 0;
    }

    public void stop() {
        this.velocity = 0;
    }
}

