/*
 * Decompiled with CFR 0.152.
 */
package com.lenin.files.electroid.sensors;

public abstract class AccelerationProvider {
    private Listener listener;

    protected final void dataReceived(double ax, double ay, double az) {
        if (this.listener != null) {
            this.listener.dataReceived(ax, ay, az);
        }
    }

    public abstract void close();

    public static AccelerationProvider getProvider(Listener listener) {
        AccelerationProvider provider = null;
        try {
            if (AccelerationProvider.sensorsSupported()) {
                Class<?> c = Class.forName("com.lenin.files.electroid.sensors.AccelerationProviderImpl");
                provider = (AccelerationProvider)c.newInstance();
                provider.listener = listener;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return provider;
    }

    public static boolean sensorsSupported() {
        try {
            Class.forName("javax.microedition.sensor.SensorConnection");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static interface Listener {
        public void dataReceived(double var1, double var3, double var5);
    }
}

