/*
 * Decompiled with CFR 0.152.
 */
package com.lenin.files.electroid;

import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class ImageHelper {
    private static ImageHelper self;

    private ImageHelper() {
    }

    public static ImageHelper getInstance() {
        if (self == null) {
            self = new ImageHelper();
        }
        return self;
    }

    public Image loadImage(String imagepath, int width, int height) throws RuntimeException {
        return ImageHelper.scaleImage(this.loadImage(imagepath), width, height);
    }

    public Image loadImage(String imagepath, float scaling) throws RuntimeException {
        return ImageHelper.scaleImage(this.loadImage(imagepath), scaling);
    }

    public Image loadImage(String imagepath) throws RuntimeException {
        Image image;
        try {
            InputStream in = this.getClass().getResourceAsStream(imagepath);
            image = Image.createImage((InputStream)in);
        }
        catch (Exception e) {
            throw new RuntimeException("ImageLoader failed to load image:" + imagepath + " " + e.getMessage());
        }
        return image;
    }

    public static Image scaleImage(Image original, float scaling) {
        return ImageHelper.scaleImage(original, (int)((double)(scaling * (float)original.getWidth()) + 0.5), (int)((double)(scaling * (float)original.getHeight()) + 0.5));
    }

    public static Image scaleImage(Image original, int newWidth, int newHeight) {
        Image scaledImage = original;
        int originalWidth = original.getWidth();
        if (originalWidth <= newWidth) {
            scaledImage = ImageHelper.pixelMixing(original, newWidth, newHeight);
        } else if (originalWidth > newWidth) {
            scaledImage = ImageHelper.bilinearInterpolation(original, newWidth, newHeight);
        }
        return scaledImage;
    }

    private static Image pixelMixing(Image original, int newWidth, int newHeight) {
        int[] rawInput = new int[original.getHeight() * original.getWidth()];
        original.getRGB(rawInput, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int oWidth = original.getWidth();
        int[] oX16 = new int[newWidth + 1];
        int newX = 0;
        while (newX <= newWidth) {
            oX16[newX] = (newX * oWidth << 4) / newWidth;
            ++newX;
        }
        int[] oXStartWidth = new int[newWidth];
        int[] oXEndWidth = new int[newWidth];
        int newX2 = 0;
        while (newX2 < newWidth) {
            oXStartWidth[newX2] = 16 - oX16[newX2] % 16;
            oXEndWidth[newX2] = oX16[newX2 + 1] % 16;
            ++newX2;
        }
        int oHeight = original.getHeight();
        int[] oY16 = new int[newHeight + 1];
        int newY = 0;
        while (newY <= newHeight) {
            oY16[newY] = (newY * oHeight << 4) / newHeight;
            ++newY;
        }
        int newY2 = 0;
        while (newY2 < newHeight) {
            int oY16Start = oY16[newY2];
            int oY16End = oY16[newY2 + 1];
            int oYStart = oY16Start >>> 4;
            int oYEnd = oY16End >>> 4;
            int oYStartHeight = 16 - oY16Start % 16;
            int oYEndHeight = oY16End % 16;
            int newX3 = 0;
            while (newX3 < newWidth) {
                int oX16Start = oX16[newX3];
                int oX16End = oX16[newX3 + 1];
                int oXStart = oX16Start >>> 4;
                int oXEnd = oX16End >>> 4;
                int outArea = 0;
                int outColorArea = 0;
                int outAlpha = 0;
                int outRed = 0;
                int outGreen = 0;
                int outBlue = 0;
                int j = oYStart;
                while (j <= oYEnd) {
                    int areaHeight = 16;
                    if (oYStart == oYEnd) {
                        areaHeight = oY16End - oY16Start;
                    } else if (j == oYStart) {
                        areaHeight = oYStartHeight;
                    } else if (j == oYEnd) {
                        areaHeight = oYEndHeight;
                    }
                    if (areaHeight != 0) {
                        int i = oXStart;
                        while (i <= oXEnd) {
                            int areaWidth = 16;
                            if (oXStart == oXEnd) {
                                areaWidth = oX16End - oX16Start;
                            } else if (i == oXStart) {
                                areaWidth = oXStartWidth[newX3];
                            } else if (i == oXEnd) {
                                areaWidth = oXEndWidth[newX3];
                            }
                            if (areaWidth != 0) {
                                int area = areaWidth * areaHeight;
                                outArea += area;
                                int argb = rawInput[i + j * original.getWidth()];
                                int a = argb >>> 24;
                                if (a != 0) {
                                    area = a * area;
                                    outColorArea += area;
                                    int r = (argb & 0xFF0000) >>> 16;
                                    int g = (argb & 0xFF00) >>> 8;
                                    int b = argb & 0xFF;
                                    outRed += area * r;
                                    outGreen += area * g;
                                    outBlue += area * b;
                                }
                            }
                            ++i;
                        }
                    }
                    ++j;
                }
                if (outColorArea > 0) {
                    outAlpha = outColorArea / outArea;
                    outRed /= outColorArea;
                    outGreen /= outColorArea;
                    outBlue /= outColorArea;
                }
                rawOutput[newX3 + newY2 * newWidth] = outAlpha << 24 | outRed << 16 | outGreen << 8 | outBlue;
                ++newX3;
            }
            ++newY2;
        }
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)true);
    }

    private static Image bilinearInterpolation(Image original, int newWidth, int newHeight) {
        int[] rawInput = new int[original.getHeight() * original.getWidth()];
        original.getRGB(rawInput, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int oWidth = original.getWidth();
        int[] oX16 = new int[newWidth];
        int max = oWidth - 1 << 4;
        int newX = 0;
        while (newX < newWidth) {
            oX16[newX] = (((newX << 1) + 1) * oWidth << 3) / newWidth - 8;
            if (oX16[newX] < 0) {
                oX16[newX] = 0;
            } else if (oX16[newX] > max) {
                oX16[newX] = max;
            }
            ++newX;
        }
        int oHeight = original.getHeight();
        int[] oY16 = new int[newHeight];
        max = oHeight - 1 << 4;
        int newY = 0;
        while (newY < newHeight) {
            oY16[newY] = (((newY << 1) + 1) * oHeight << 3) / newHeight - 8;
            if (oY16[newY] < 0) {
                oY16[newY] = 0;
            } else if (oY16[newY] > max) {
                oY16[newY] = max;
            }
            ++newY;
        }
        int[] oX = new int[2];
        int[] oY = new int[2];
        int[] wX = new int[2];
        int[] wY = new int[2];
        int newY2 = 0;
        while (newY2 < newHeight) {
            oY[0] = oY16[newY2] >>> 4;
            wY[1] = oY16[newY2] & 0xF;
            wY[0] = 16 - wY[1];
            oY[1] = wY[1] == 0 ? oY[0] : oY[0] + 1;
            int newX2 = 0;
            while (newX2 < newWidth) {
                oX[0] = oX16[newX2] >>> 4;
                wX[1] = oX16[newX2] & 0xF;
                wX[0] = 16 - wX[1];
                oX[1] = wX[1] == 0 ? oX[0] : oX[0] + 1;
                int outWeight = 0;
                int outColorWeight = 0;
                int outAlpha = 0;
                int outRed = 0;
                int outGreen = 0;
                int outBlue = 0;
                int j = 0;
                while (j < 2) {
                    int i = 0;
                    while (i < 2) {
                        if (wY[j] != 0 && wX[i] != 0) {
                            int w = wX[i] * wY[j];
                            outWeight += w;
                            int argb = rawInput[oX[i] + oY[j] * original.getWidth()];
                            int a = argb >>> 24;
                            if (a != 0) {
                                w = a * w;
                                outColorWeight += w;
                                int r = (argb & 0xFF0000) >>> 16;
                                int g = (argb & 0xFF00) >>> 8;
                                int b = argb & 0xFF;
                                outRed += w * r;
                                outGreen += w * g;
                                outBlue += w * b;
                            }
                        }
                        ++i;
                    }
                    ++j;
                }
                if (outColorWeight > 0) {
                    outAlpha = outColorWeight / outWeight;
                    outRed /= outColorWeight;
                    outGreen /= outColorWeight;
                    outBlue /= outColorWeight;
                }
                rawOutput[newX2 + newY2 * newWidth] = outAlpha << 24 | outRed << 16 | outGreen << 8 | outBlue;
                ++newX2;
            }
            ++newY2;
        }
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)true);
    }
}

