/*
 * Decompiled with CFR 0.152.
 */
package com.lenin.files.electroid.game;

import com.lenin.files.electroid.game.Ball;
import com.lenin.files.electroid.game.Brick;
import com.lenin.files.electroid.game.Resources;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;

public class BrickGrid {
    private static final int ROWS = 6;
    private static final int COLUMNS = 9;
    private static final int TILE_WIDTH = 22;
    private static final int TILE_HEIGHT = 14;
    private final int LEFT_X;
    private final int TOP_Y;
    private int count = 0;
    int displayWidth;
    int displayHeight;
    private Brick[][] bricks;
    private Resources r;

    public BrickGrid(LayerManager lm, int displayWidth, int displayHeight, Resources resources) {
        this.r = resources;
        this.bricks = new Brick[6][9];
        this.displayWidth = displayWidth;
        this.displayHeight = displayHeight;
        this.LEFT_X = this.r.scale(18.0);
        this.TOP_Y = this.r.scale(24.0);
    }

    public Brick collidesWith(Ball ball) {
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 9) {
                Brick brick = this.bricks[i][j];
                if (brick != null && this.bricks[i][j].collidesWith(ball, false)) {
                    if (brick.getFrame() % 2 == 1) {
                        this.bricks[i][j] = null;
                        --this.count;
                    }
                    brick.nextFrame();
                    return brick;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public void load(LayerManager lm, int[][] layout) {
        this.count = 0;
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 9) {
                Brick brick = this.bricks[i][j];
                if (brick != null) {
                    lm.remove((Layer)brick);
                    this.bricks[i][j] = null;
                }
                if (layout[i][j] > 0) {
                    brick = new Brick(layout[i][j] - 1, this.r);
                    brick.setPosition(this.LEFT_X + this.r.scale(j * 22), this.TOP_Y + this.r.scale(i * 14));
                    this.bricks[i][j] = brick;
                    lm.append((Layer)brick);
                    ++this.count;
                }
                ++j;
            }
            ++i;
        }
    }

    public void writeTo(DataOutputStream dout) throws IOException {
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 9) {
                Brick brick = this.bricks[i][j];
                if (brick != null) {
                    dout.writeInt(brick.getFrame() + 1);
                } else {
                    dout.writeInt(0);
                }
                ++j;
            }
            ++i;
        }
    }

    public int[][] readFrom(DataInputStream din) throws IOException {
        int[][] layout = new int[6][9];
        this.count = 0;
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 9) {
                layout[i][j] = din.readInt();
                if (layout[i][j] > 0) {
                    ++this.count;
                }
                ++j;
            }
            ++i;
        }
        return layout;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }
}

