/*
 * Decompiled with CFR 0.152.
 */
package com.lenin.files.electroid.game;

import com.lenin.files.electroid.ImageHelper;
import javax.microedition.lcdui.Image;

public class Resources {
    private static boolean initialized = false;
    public Image background;
    public Image signOn;
    public Image signOff;
    public Image ball;
    public Image life;
    public Image dashboard;
    public Image menuButton;
    public Image newGameButton;
    public Image gameOver;
    public Image plate;
    public Image bricks;
    public Image spark;
    public Image verticalWall;
    public Image horizontalWall;
    public final String SAMPLE_BONUS;
    public final String SAMPLE_BUTTON;
    public final String SAMPLE_DEATH;
    public final String SAMPLE_EXPLOSION;
    public final String SAMPLE_TELEPORT;
    public final String SAMPLE_TRANSITION;
    public final String SAMPLE_WALL;
    public final String SAMPLE_COLLISION;
    public final String SAMPLE_COLLISION2;
    public final String SAMPLE_COLLISION3;
    public final String SAMPLE_ELECTRICITY;
    public float scaling = 1.0f;

    public Resources(float scaling) {
        this.SAMPLE_BONUS = "/bonus.mp3";
        this.SAMPLE_BUTTON = "/button.mp3";
        this.SAMPLE_DEATH = "/death.mp3";
        this.SAMPLE_EXPLOSION = "/explosion.mp3";
        this.SAMPLE_TELEPORT = "/teleport.mp3";
        this.SAMPLE_TRANSITION = "/transition.mp3";
        this.SAMPLE_WALL = "/wall.mp3";
        this.SAMPLE_COLLISION = "/collision.mp3";
        this.SAMPLE_COLLISION2 = "/collision2.mp3";
        this.SAMPLE_COLLISION3 = "/collision3.mp3";
        this.SAMPLE_ELECTRICITY = "/electricity.mp3";
        this.scaling = scaling;
        this.loadResources();
    }

    public void freeResources() {
        initialized = false;
        this.background = null;
        this.signOn = null;
        this.signOff = null;
        this.ball = null;
        this.dashboard = null;
        this.menuButton = null;
        this.newGameButton = null;
        this.gameOver = null;
        this.plate = null;
        this.bricks = null;
        this.spark = null;
        this.verticalWall = null;
        this.horizontalWall = null;
    }

    public void loadResources() {
        if (!initialized) {
            ImageHelper ih = ImageHelper.getInstance();
            this.background = ih.loadImage("/background.png", this.scaling);
            this.signOn = ih.loadImage("/explonoid_on.png", this.scaling);
            this.signOff = ih.loadImage("/explonoid_off.png", this.scaling);
            this.ball = ih.loadImage("/ball.png", this.scaling);
            this.life = ImageHelper.scaleImage(this.ball, 0.5f);
            this.dashboard = ih.loadImage("/dashboard.png", this.scaling);
            this.menuButton = ih.loadImage("/menu_button.png", this.scaling);
            this.newGameButton = ih.loadImage("/new_game_button.png", this.scaling);
            this.gameOver = ih.loadImage("/game_over.png", this.scaling);
            this.plate = ih.loadImage("/plate.png");
            this.plate = ImageHelper.scaleImage(this.plate, this.scale(this.plate.getWidth()), this.scale(this.plate.getHeight() / 10) * 10);
            this.bricks = ih.loadImage("/bricks.png");
            this.bricks = ImageHelper.scaleImage(this.bricks, this.scale(this.bricks.getWidth() / 2) * 2, this.scale(this.bricks.getHeight() / 5) * 5);
            this.spark = ih.loadImage("/spark.png");
            this.spark = ImageHelper.scaleImage(this.spark, this.scale(this.spark.getWidth() / 20) * 20, this.scale(this.spark.getHeight()));
            this.verticalWall = ih.loadImage("/vertical_wall.png");
            this.verticalWall = ImageHelper.scaleImage(this.verticalWall, this.scale(this.verticalWall.getWidth() / 2) * 2, this.scale(this.verticalWall.getHeight()));
            this.horizontalWall = ih.loadImage("/horizontal_wall.png");
            this.horizontalWall = ImageHelper.scaleImage(this.horizontalWall, this.scale(this.horizontalWall.getWidth()), this.scale(this.horizontalWall.getHeight() / 2) * 2);
            initialized = true;
        }
    }

    public int scale(double value) {
        double result = (double)this.scaling * value;
        return result < 0.0 ? (int)(result - 0.5) : (int)(result + 0.5);
    }
}

