/*
 * Decompiled with CFR 0.152.
 */
package com.lenin.files.electroid.menu;

import com.lenin.files.electroid.effects.Slideable;
import com.lenin.files.electroid.menu.Menu;
import com.lenin.files.electroid.menu.MenuItem;
import com.lenin.files.electroid.menu.ToggleMenuItem;
import com.lenin.files.electroid.sensors.AccelerationProvider;
import javax.microedition.lcdui.Graphics;

public class MainMenu
extends Menu
implements Slideable {
    public static final int ITEM_COUNT = 7;
    public static final int RESUME = 0;
    public static final int NEWGAME = 1;
    public static final int SENSORS = 2;
    public static final int SOUNDS = 3;
    public static final int HELP = 4;
    public static final int EXIT = 5;
    public static final int INFO = 6;
    public final int OUT_CX;
    public final int IN_CX;
    private final ToggleMenuItem sensors;
    private final ToggleMenuItem sounds;
    private int x;
    private int y;
    private int width;
    private int cornerY;

    public MainMenu(int cornerX, int cornerY, int width, int height, Menu.Listener l, double scaling) {
        super(7, l);
        this.width = width;
        this.cornerY = cornerY;
        this.setItem(0, new MenuItem(this.loadSprite("/resume.png", 2, scaling)));
        this.setItem(1, new MenuItem(this.loadSprite("/new_game.png", 2, scaling)));
        this.sensors = new ToggleMenuItem(this.loadSprite("/sensors.png", 4, scaling));
        if (AccelerationProvider.sensorsSupported()) {
            this.sensors.set(true);
        } else {
            this.sensors.set(false);
        }
        this.setItem(2, this.sensors);
        this.sounds = new ToggleMenuItem(this.loadSprite("/sounds.png", 4, scaling));
        this.setItem(3, this.sounds);
        this.sounds.set(true);
        this.setItem(4, new MenuItem(this.loadSprite("/help.png", 2, scaling)));
        this.setItem(5, new MenuItem(this.loadSprite("/exit.png", 2, scaling)));
        this.setItem(6, new MenuItem(this.loadSprite("/info.png", 2, scaling)));
        this.IN_CX = cornerX + width / 2;
        this.x = this.OUT_CX = this.IN_CX - width;
        this.y = cornerY + height / 35 * 15;
        this.positionItemsHorizontally();
        this.positionItemsVertically();
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public boolean toggleSounds() {
        return this.sounds.toggle();
    }

    public boolean toggleSensors() {
        if (AccelerationProvider.sensorsSupported()) {
            this.sensors.toggle();
        }
        return this.sensors.isOn();
    }

    public boolean slideIn() {
        int distance = this.x - this.IN_CX;
        distance = (int)((double)distance * 0.8);
        this.x = this.IN_CX + distance;
        this.positionItemsHorizontally();
        return distance != 0;
    }

    public boolean slideOut() {
        int distance = this.x - this.OUT_CX;
        distance = (int)((double)distance * 0.8);
        this.x = this.OUT_CX + distance;
        this.positionItemsHorizontally();
        return distance != 0;
    }

    public final void positionItemsHorizontally() {
        MenuItem item;
        int i = 0;
        while (i < 6) {
            item = this.getItem(i);
            item.setHorizontalCenter(this.x);
            ++i;
        }
        item = this.getItem(6);
        item.setPosition(this.x - this.width / 2, this.cornerY);
    }

    public final void positionItemsVertically() {
        int newY = this.y;
        MenuItem resume = this.getItem(0);
        if (!resume.isVisible()) {
            newY -= resume.getHeight() / 2;
        }
        int i = 0;
        while (i < 6) {
            MenuItem item = this.getItem(i);
            item.setCenter(item.getX(), newY);
            newY += item.getHeight();
            ++i;
        }
    }

    public void hideResume() {
        this.getItem(0).setVisibile(false);
        this.positionItemsVertically();
    }

    public void showResume() {
        this.getItem(0).setVisibile(true);
        this.selectItem(0);
        this.positionItemsVertically();
    }
}

