/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.BCC;
import app.CUtils;
import app.Game;
import app.Resources;
import bightcode.util.Animation;
import java.util.Random;

public class InteractiveObject
implements Resources {
    public static final int _TYPE_PYGMY_ = 0;
    public static final int _TYPE_BIRD_ = 1;
    public static final int _TYPE_COCONUT_ = 3;
    public static final int _TYPE_COCONUT_HALF_ = 4;
    public static final int _TYPE_SIGN_POST_ = 5;
    public static final int _TYPE_IDOL_ = 6;
    public static final int _TYPE_FISH_ = 7;
    public static final int _TYPE_SUN_ = 8;
    public static final int _TYPE_FISHING_POLE_ = 9;
    public static final int _TYPE_VOLCANO_ = 10;
    public static final int _TYPE_PALM_TREE_ = 11;
    public static final int _TYPE_HURRICANE_CLOUD_ = 13;
    public static final int _TYPE_STORM_CLOUD_ = 14;
    public static final int _TYPE_FIREWOOD_ = 15;
    public static final int _TYPE_METEOR_ = 16;
    public static final int _TYPE_LAVA_BURST_ = 17;
    public static final int _TYPE_DROPPINGS_ = 18;
    public static final int _TYPE_MOON_ = 19;
    public static final int _TYPE_DINO_EGG_ = 20;
    public static final int _TYPE_LIGHTNING_CURSOR_ = 21;
    public static final int _TYPE_CLOUD_ = 22;
    public static final int _TYPE_SPEAR_ = 23;
    public static final int _TYPE_TREX_ = 24;
    public static final int _TYPE_FIRE_ = 25;
    public static int _VELOCITY_CREATURE_WALK_HORIZONTAL_ = 2;
    public static int _VELOCITY_CREATURE_RUN_HORIZONTAL_ = 6;
    public static int _VELOCITY_CREATURE_WALK_VERTICAL_ = 2;
    public static int _VELOCITY_CREATURE_FALL_ = 28;
    public static int _VELOCITY_CREATURE_BLAST_OFF_ = -38;
    public static int _VELOCITY_CREATURE_FALL_BEHIND_ = 2;
    public static int _VELOCITY_CREATURE_BACKAWAY_ = 2;
    public static int _VELOCITY_BURNING_INTO_WATER_X_ = 4;
    public static int _VELOCITY_DODO_BIRD_FLY_ = 6;
    public static int _VELOCITY_TREX_DROWN_ = 17;
    public static int _VELOCITY_CLOUD_BOUNCE_X_ = 4;
    public static int _VELOCITY_TREX_WALK_HORIZONTAL_ = 3;
    public static int _FLICK_VELOCITY_MIN_ = 23;
    public static int _VELOCITY_FISH_X_ = 3;
    public static int _VELOCITY_POOP_X_ = _VELOCITY_DODO_BIRD_FLY_ / 2;
    public static int _GRAVITY_SPEAR_ = 1;
    public static int _GRAVITY_SPEAR_MAX_ = 6;
    public static int _VELOCITY_SPEAR_THROW_X_ = 14;
    public static int _VELOCITY_SPEAR_THROW_Y_ = 5;
    public static int _VELOCITY_BOUNCE_ = 1;
    public static int _BOUNCE_HEIGHT_ = 1;
    public static int _BOUNCE_HEIGHT_HIGH_ = 2;
    public static int _BOUNCE_HIGH_HEIGHT_ = 50;
    public static int _COCONUT_VELOCITY_MIN_ = 15;
    public static int _COCONUT_VELOCITY_MAX_ = 18;
    public static int _GRAVITY_COCONUT_ = 3;
    public static int _GRAVITY_COCONUT_MAX_ = _COCONUT_VELOCITY_MAX_ * 2;
    public static int _COCONUT_VELOCITY_X_0_ = -2;
    public static int _COCONUT_VELOCITY_X_1_ = -1;
    public static int _COCONUT_VELOCITY_X_2_ = -1;
    public static int _COCONUT_VELOCITY_X_3_ = -1;
    public static int _COCONUT_VELOCITY_X_4_ = -1;
    public static int _COCONUT_VELOCITY_X_5_ = 1;
    public static int _COCONUT_VELOCITY_X_6_ = 1;
    public static int _COCONUT_VELOCITY_X_7_ = 1;
    public static int _COCONUT_VELOCITY_X_8_ = 1;
    public static int _COCONUT_VELOCITY_X_9_ = 2;
    public static int _SUN_MOVE_ACCELERATION_ = -3;
    public static int _SUN_ACCELERATION_Y_ = 15;
    public static int _HURRICANE_VELOCITY_X_0_ = -10;
    public static int _HURRICANE_VELOCITY_X_1_ = -9;
    public static int _HURRICANE_VELOCITY_X_2_ = -9;
    public static int _HURRICANE_VELOCITY_X_3_ = -8;
    public static int _HURRICANE_VELOCITY_X_4_ = -8;
    public static int _HURRICANE_VELOCITY_X_5_ = -7;
    public static int _HURRICANE_VELOCITY_X_6_ = -7;
    public static int _HURRICANE_VELOCITY_X_7_ = -6;
    public static int _HURRICANE_VELOCITY_X_8_ = -6;
    public static int _HURRICANE_VELOCITY_X_9_ = -5;
    public static int _HURRICANE_VELOCITY_Y_0_ = -7;
    public static int _HURRICANE_VELOCITY_Y_1_ = -7;
    public static int _HURRICANE_VELOCITY_Y_2_ = -6;
    public static int _HURRICANE_VELOCITY_Y_3_ = -6;
    public static int _HURRICANE_VELOCITY_Y_4_ = -5;
    public static int _HURRICANE_VELOCITY_Y_5_ = 5;
    public static int _HURRICANE_VELOCITY_Y_6_ = 6;
    public static int _HURRICANE_VELOCITY_Y_7_ = 6;
    public static int _HURRICANE_VELOCITY_Y_8_ = 7;
    public static int _HURRICANE_VELOCITY_Y_9_ = 7;
    public static int _SUN_MOVE_Y_ = 11;
    public static final int _COCONUT_VELOCITY_Y_0_ = -(_COCONUT_VELOCITY_MIN_ + _COCONUT_VELOCITY_X_0_);
    public static final int _COCONUT_VELOCITY_Y_1_ = -(_COCONUT_VELOCITY_MIN_ + _COCONUT_VELOCITY_X_1_);
    public static final int _COCONUT_VELOCITY_Y_2_ = -(_COCONUT_VELOCITY_MIN_ + _COCONUT_VELOCITY_X_2_);
    public static final int _COCONUT_VELOCITY_Y_3_ = -(_COCONUT_VELOCITY_MIN_ + _COCONUT_VELOCITY_X_3_);
    public static final int _COCONUT_VELOCITY_Y_4_ = -(_COCONUT_VELOCITY_MIN_ + _COCONUT_VELOCITY_X_4_);
    public static final int _COCONUT_VELOCITY_Y_5_ = -(_COCONUT_VELOCITY_MIN_ - _COCONUT_VELOCITY_X_5_);
    public static final int _COCONUT_VELOCITY_Y_6_ = -(_COCONUT_VELOCITY_MIN_ - _COCONUT_VELOCITY_X_6_);
    public static final int _COCONUT_VELOCITY_Y_7_ = -(_COCONUT_VELOCITY_MIN_ - _COCONUT_VELOCITY_X_7_);
    public static final int _COCONUT_VELOCITY_Y_8_ = -(_COCONUT_VELOCITY_MIN_ - _COCONUT_VELOCITY_X_8_);
    public static final int _COCONUT_VELOCITY_Y_9_ = -(_COCONUT_VELOCITY_MIN_ - _COCONUT_VELOCITY_X_9_);
    public static final int _DIMENSIONS_X1_ = 0;
    public static final int _DIMENSIONS_Y1_ = 1;
    public static final int _DIMENSIONS_X2_ = 2;
    public static final int _DIMENSIONS_Y2_ = 3;
    public static final int _DIMENSIONS_W_ = 4;
    public static final int _DIMENSIONS_H_ = 5;
    public static final int _DIMENSIONS_SIZE_ = 6;
    public static final int _DIRECTION_NONE_ = -1;
    public static final int _DIRECTION_UP_ = 0;
    public static final int _DIRECTION_RIGHT_ = 1;
    public static final int _DIRECTION_DOWN_ = 2;
    public static final int _DIRECTION_LEFT_ = 3;
    public static final int _DIRECTION_DROP_ = 4;
    public static final int _DIRECTION_TOTAL_ = 5;
    public static final int _TIME_MOVEMENT_CREATURE_MIN_ = 3000;
    public static final int _TIME_MOVEMENT_CREATURE_MAX_ = 8000;
    public static final int _TIME_MOVEMENT_TREX_MIN_ = 2100;
    public static final int _TIME_MOVEMENT_TREX_MAX_ = 2500;
    public static final int _TIME_THOUGHT_BUBBLE_MIN_ = 8000;
    public static final int _TIME_THOUGHT_BUBBLE_MAX_ = 8000;
    public static final int _TIME_DANCE_MIN_ = 1000;
    public static final int _TIME_DANCE_ = 3000;
    public static final int _TIME_DANCE_MAX_ = 5000;
    public static final int _IDLE_SNEEZE_ = 0;
    public static final int _IDLE_CHESTBEAT_ = 1;
    public static final int _IDLE_SKIRTFALLCENSORED_ = 2;
    public static final int _IDLE_SKIRTFALLUNDERWEAR_ = 3;
    public static final int _IDLE_YAWN_ = 4;
    public static final int _IDLE_SLEEP_ = 5;
    public static final int _IDLE_WAVE_ = 6;
    public static final int _IDLE_SUN_1_ = 7;
    public static final int _IDLE_SUN_2_ = 8;
    public static final int _IDLE_SUN_3_ = 9;
    public static final int _IDLE_ANIM_TOTAL_ = 12;
    public static final int _IDLE_TIME_ = 10000;
    public static final int _IDLE_TIME_WEATHER_ = 3000;
    public static final int _STATS_DEATHS_ = 0;
    public static final int _STATS_DEATH_FLICK_DROWN_ = 1;
    public static final int _STATS_DEATH_DROP_DROWN_ = 2;
    public static final int _STATS_DEATH_QUAKE_DROWN_ = 3;
    public static final int _STATS_DEATH_HURRICANE_DROWN_ = 4;
    public static final int _STATS_DEATH_VOLCANO_FLICK_ = 5;
    public static final int _STATS_DEATH_TREX_FOOD_ = 6;
    public static final int _STATS_DEATH_LIGHTNING_ZAP_ = 7;
    public static final int _STATS_DEATH_BURN_FIREPIT_ = 8;
    public static final int _STATS_DEATH_BURN_MAGMA_ = 9;
    public static final int _STATS_DEATH_BURN_OVERHEAT_ = 10;
    public static final int _STATS_DEATH_VAPORIZED_ = 11;
    public static final int _STATS_DEATH_FALL_FLAT_ = 12;
    public static final int _STATS_DEATH_FROZEN_SHATTER_ = 13;
    public static final int _STATS_DEATH_CHOKE_FISH_ = 14;
    public static final int _STATS_DEATH_CHOKE_DODO_ = 15;
    public static final int _STATS_GIFT_DANCE_ = 16;
    public static final int _STATS_GIFT_COCONUT_ = 17;
    public static final int _STATS_GIFT_RAW_FISH_ = 18;
    public static final int _STATS_GIFT_COOK_FISH_ = 19;
    public static final int _STATS_GIFT_COOK_DODO_ = 20;
    public static final int _STATS_TOTAL_ = 21;
    public static final int _MOOD_TYPE_SAD_ = 0;
    public static final int _MOOD_TYPE_FREAKEDOUT_ = 1;
    public static final int _MOOD_TYPE_ANGRY_ = 2;
    public static final int _MOOD_TYPE_ANNOYED_ = 3;
    public static final int _MOOD_TYPE_HAPPY_ = 4;
    public static final int _MOOD_TYPE_CONTENT_ = 5;
    public static final int _SCREEN_REGION_NONE_ = -1;
    public static final int _SCREEN_REGION_CLOUDS_ = 0;
    public static final int _SCREEN_REGION_HURRICANE_CLOUD_ = 1;
    public static final int _SCREEN_REGION_SUN_AND_MOON_ = 3;
    public static final int _SCREEN_REGION_BIRD_ = 4;
    public static final int _SCREEN_REGION_VOLCANO_ = 5;
    public static final int _SCREEN_REGION_LAND_BACK_ = 6;
    public static final int _SCREEN_REGION_LAND_FRONT_ = 7;
    public static final int _SCREEN_REGION_SEA_ = 8;
    private boolean mbFlick;
    private boolean mbLevitating;
    short miID;
    short miType;
    short miDirection;
    short miDistance;
    short miVelocity;
    short miVelocityCloud;
    short miFlickLandingID;
    short miFlickDif;
    short miFlickDrowningID;
    short miCoconutBounceID;
    short miPoopDirection;
    short miGravityOffset;
    short miThoughtBubbleID;
    short miDinoEggCracks;
    short miScreenRegion;
    short miDrowningFrame;
    short miDrowningSplashesTotal;
    short miAccelerationX;
    short miAccelerationMaxX;
    short miAccelerationY;
    short miAccelerationMaxY;
    int miTimeTillMovementRandom;
    int miTimeThought;
    int miIdleTime;
    int miDanceTime;
    int miSunAcceleration;
    short miTimeTillChangeDirection;
    int miBurnTime;
    int miBurnMoveTime;
    boolean mbBurnMoveRight;
    boolean mbDead;
    boolean mbDying;
    boolean mbSelected;
    boolean mbJump;
    boolean mbSquished;
    boolean mbZapped;
    boolean mbCheckPancake;
    boolean mbCarryingLog;
    boolean mbFrozen;
    boolean mbFreezing;
    boolean mbFreezeDrown;
    boolean mbOverheating;
    boolean mbHeatUpWalk;
    boolean mbLavaBurn;
    boolean mbAnimating;
    boolean mbChoking;
    boolean mbStumbling;
    boolean mbStumbleDown;
    boolean mbSleeping;
    boolean mbTossed;
    boolean mbBurning;
    boolean mbIdling;
    boolean mbDrowning;
    boolean mbRising;
    boolean mbHappy;
    boolean mbEating;
    boolean mbEatAnimation;
    boolean mbEatFish;
    boolean mbDrawInFrontOnSelect;
    boolean mbCooked;
    boolean mbBurned;
    int miJumpX;
    int miJumpY;
    boolean mbBounce;
    boolean mbBounceClip;
    boolean mbOnPygmy;
    boolean mbUnderwater;
    boolean mbPreviousTRexAnimRoar;
    boolean mbTRexChargeLeft;
    boolean mbChangeDirection;
    boolean mbBounceUp;
    boolean mbBounceDown;
    boolean mbBounceHigh;
    BCC mbccCore;
    Animation mAnimations;
    InteractiveObject mLog;
    int[] miaDimensions;
    short[] miaBoundries;
    int[] miaStats;
    short[] miaDrownAnimationsX;
    short[] miaDrownAnimationsY;
    short miMood;
    Random r = new Random(1000L);

    InteractiveObject(int iType, BCC core) {
        this.miType = (short)iType;
        this.mbccCore = core;
        this.mAnimations = null;
        this.miDirection = (short)-1;
        this.miFlickLandingID = (short)-1;
        this.miFlickDrowningID = (short)-1;
        this.miCoconutBounceID = (short)-1;
        this.miTimeThought = 0;
        this.stopThoughtBubble();
        this.miVelocity = 0;
        this.miVelocityCloud = 0;
        this.miDinoEggCracks = 0;
        this.miTimeTillMovementRandom = -1;
        this.mbDead = true;
        this.mbLevitating = false;
        this.mbFlick = false;
        this.mbJump = false;
        this.mbCheckPancake = false;
        this.mbDrowning = false;
        this.mbEating = false;
        this.mbChangeDirection = false;
        this.miaDimensions = new int[6];
        CUtils.MEMSET(this.miaDimensions, -1, 6);
        this.miaBoundries = new short[6];
        CUtils.MEMSET(this.miaBoundries, (short)-1, 6);
        this.miaStats = (int[])(this.miType == 0 ? new int[21] : null);
        switch (this.miType) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 15: 
            case 16: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                this.miScreenRegion = (short)7;
                break;
            }
            case 1: {
                this.miScreenRegion = (short)4;
                break;
            }
            case 8: 
            case 19: {
                this.miScreenRegion = (short)3;
                this.miSunAcceleration = _SUN_ACCELERATION_Y_;
                break;
            }
            case 13: {
                this.miScreenRegion = 1;
                break;
            }
            case 14: 
            case 21: 
            case 22: {
                this.miScreenRegion = 0;
                break;
            }
            case 10: {
                this.miScreenRegion = (short)5;
                this.miSunAcceleration = 0;
                break;
            }
            case 11: 
            case 17: 
            case 18: {
                this.miScreenRegion = (short)-1;
            }
        }
    }

    void addInteractiveObjectToScreen() {
        this.mbDead = false;
        if (this.mLog != null && this.mLog.mbDead) {
            this.mLog.setPosition(this.getX(), this.mLog.getY());
            this.mLog.addInteractiveObjectToScreen();
            this.mLog = null;
        }
        if (this.miType == 0) {
            this.mAnimations.setAnimationClass(100);
            this.mAnimations.autoplay(false);
            this.mbAnimating = true;
            this.miDirection = (short)4;
            this.miVelocity = (short)_VELOCITY_CREATURE_FALL_;
            this.miDistance = (short)(Game._PYGMY_BOUNDRY_Y_ + this.mbccCore.getRandom(Game._PYGMY_BOUNDRY_H_));
        } else if (this.miType == 1) {
            if (this.miDirection != 4 && !this.mbCooked && !this.mbBurned) {
                this.mAnimations.setAnimationClass(this.mbccCore.miaAnimations[15]);
                this.mAnimations.miAnchor = 3;
                this.mAnimations.loopAnimation(true);
                this.setDimensions(this.mAnimations.getFrameWidth(0), this.mAnimations.getFrameHeight(0));
                this.miDirection = (short)3;
                this.miDistance = (short)(Game.REAL_W - Game._DODO_BIRD_DISTANCE_OFFSET_X_);
                this.miVelocity = (short)_VELOCITY_DODO_BIRD_FLY_;
                this.miScreenRegion = (short)4;
                this.mAnimations.applyTransform(0);
            }
        } else if (this.miType == 9) {
            this.miDirection = (short)4;
            this.miVelocity = (short)_VELOCITY_CREATURE_FALL_;
            this.miDistance = (short)(Game._PYGMY_BOUNDRY_Y_ + Game._FISHING_POLE_FALL_OFFSET_Y_ - this.getY());
        } else if (this.miType == 15) {
            this.miDirection = (short)4;
            this.miVelocity = (short)_VELOCITY_CREATURE_FALL_;
            this.miDistance = (short)(Game._PYGMY_BOUNDRY_Y_ - this.getY());
        } else if (this.miType == 16) {
            this.miDirection = (short)4;
            this.miVelocity = (short)_VELOCITY_CREATURE_FALL_;
            this.miDistance = (short)(Game._PYGMY_BOUNDRY_Y_ - Game._METEOR_FALL_OFFSET_Y_);
            this.mbSquished = true;
        } else if (this.miType == 17) {
            this.miDirection = (short)4;
            this.miVelocity = (short)(_VELOCITY_CREATURE_FALL_ * 3 / 2);
            this.miDistance = (short)(Game._PYGMY_BOUNDRY_Y_ + Game._LAVA_BURST_OFFSET_Y_ - this.getY());
        } else if (this.miType == 18) {
            this.miDirection = (short)4;
            this.miVelocity = (short)_VELOCITY_CREATURE_FALL_;
            this.miDistance = (short)(Game._PYGMY_BOUNDRY_Y_ - this.getY() - Game._DROPPINGS_FALL_OFFSET_Y_);
        } else if (this.miType == 23) {
            this.miDirection = (short)4;
            this.miVelocity = (short)_VELOCITY_CREATURE_FALL_;
            this.miDistance = (short)(Game._PYGMY_BOUNDRY_Y_ + 1 - this.getY());
        } else if (this.miType == 24) {
            this.miDirection = (short)4;
            this.miVelocity = (short)_VELOCITY_CREATURE_FALL_;
            this.miDistance = (short)(Game._PYGMY_BOUNDRY_Y_ + Game._TREX_FALL_OFFSET_Y_ - 1);
            this.mAnimations.setAnimationClass(14);
            this.mAnimations.setFrame(12);
            this.mAnimations.loopAnimation(false);
        } else if (this.miType == 20) {
            this.mAnimations.setAnimationClass(27);
            this.miDirection = (short)4;
            this.miDistance = (short)(Game._DINO_EGG_BOUNDRY_Y_ - Game._DINO_EGG_OFFSET_Y_ - this.getY());
            this.miVelocity = (short)_VELOCITY_CREATURE_FALL_;
        }
    }

    void dropInteractiveObject(int iY) {
        switch (this.miType) {
            case 0: {
                if (this.mbFrozen || this.mbCooked || this.mbChoking) break;
                this.mAnimations.setAnimationClass(100);
                this.mbAnimating = true;
                break;
            }
            case 16: {
                this.mbSquished = this.getY() <= Game._PYGMY_BOUNDRY_Y_ - Game._METEOR_KILL_HEIGHT_;
            }
        }
        this.miDistance = (short)(iY - this.miaDimensions[3]);
        if (this.miDistance > _BOUNCE_HIGH_HEIGHT_ && this.miType != 0) {
            this.mbBounceHigh = true;
        }
        this.miDirection = (short)4;
        this.miVelocity = (short)_VELOCITY_CREATURE_FALL_;
    }

    void setEat(int iEatenID, boolean bEatRight, int iFoodCook) {
        if (this.miType == 0) {
            this.stopMovement();
            if (bEatRight) {
                if (iEatenID == 13 && iFoodCook == 2) {
                    this.mAnimations.setAnimationClass(13);
                } else if (iEatenID == 13 && iFoodCook == 1) {
                    this.mAnimations.setAnimationClass(15);
                } else if (iEatenID == 13) {
                    this.mAnimations.setAnimationClass(17);
                } else if (iEatenID == 21 && iFoodCook == 2) {
                    this.mAnimations.setAnimationClass(9);
                } else if (iEatenID == 21 && iFoodCook == 1) {
                    this.mAnimations.setAnimationClass(11);
                } else {
                    this.mAnimations.setAnimationClass(19);
                }
            } else if (iEatenID == 13 && iFoodCook == 2) {
                this.mAnimations.setAnimationClass(14);
            } else if (iEatenID == 13 && iFoodCook == 1) {
                this.mAnimations.setAnimationClass(16);
            } else if (iEatenID == 13) {
                this.mAnimations.setAnimationClass(18);
            } else if (iEatenID == 21 && iFoodCook == 2) {
                this.mAnimations.setAnimationClass(10);
            } else if (iEatenID == 21 && iFoodCook == 1) {
                this.mAnimations.setAnimationClass(12);
            } else {
                this.mAnimations.setAnimationClass(20);
            }
            this.mbEatAnimation = true;
        }
    }

    void setFly() {
        if (this.miType == 1) {
            this.mAnimations.setAnimationClass(this.mbccCore.miaAnimations[15]);
            this.mAnimations.loopAnimation(true);
            if (!this.mbCooked && !this.mbBurned) {
                if (this.getX() < Game._GAME_BACKGROUND_W_ / 2) {
                    this.miDirection = 1;
                    this.miDistance = (short)9999;
                    this.miVelocity = (short)(-_VELOCITY_DODO_BIRD_FLY_);
                    this.mAnimations.applyTransform(2);
                } else {
                    this.miDirection = (short)3;
                    this.miDistance = (short)9999;
                    this.miVelocity = (short)_VELOCITY_DODO_BIRD_FLY_;
                    this.mAnimations.applyTransform(0);
                }
            }
        }
    }

    void setMovementFlick(int iFlickLandingID, int iDif) {
        this.miFlickLandingID = (short)iFlickLandingID;
        this.miAccelerationY = (short)Game._ACCELERATION_START_Y_;
        this.miAccelerationMaxY = (short)Game._ACCELERATION_MAX_Y_;
        if (this.miFlickLandingID == 4 && iDif < 0 || this.miFlickLandingID == 5 && iDif > 0) {
            this.miFlickDif = 0;
            this.miAccelerationX = 0;
            this.miAccelerationMaxX = 0;
        } else {
            this.miFlickDif = (short)iDif;
            this.miAccelerationX = (short)(this.miFlickDif * 2);
            this.miAccelerationMaxX = (short)(this.miFlickDif * 5);
        }
        if (this.miType == 0) {
            this.mAnimations.setAnimationClass(42);
            this.mbAnimating = true;
            this.mbDying = true;
        }
    }

    void setMovementFallFromFlick(int iVolcanoX) {
        int iX;
        this.miAccelerationY = 0;
        this.miAccelerationMaxY = 0;
        this.mAnimations.setAnimationClass(this.mbccCore.miaAnimations[7]);
        this.miAccelerationMaxY = (short)8;
        switch (this.miFlickDif) {
            case 4: 
            case 5: {
                this.miAccelerationMaxX = (short)2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.miAccelerationMaxX = 1;
                break;
            }
            case -5: 
            case -4: {
                this.miAccelerationMaxX = (short)-2;
                break;
            }
            case -3: 
            case -2: 
            case -1: {
                this.miAccelerationMaxX = (short)-1;
                break;
            }
            default: {
                this.miAccelerationMaxX = 0;
            }
        }
        if (this.miAccelerationX > 0) {
            this.miAccelerationX = (short)((this.miAccelerationX + 1) / 3 + 1);
        } else if (this.miAccelerationX < 0) {
            this.miAccelerationX = (short)((this.miAccelerationX - 1) / 3 - 1);
        }
        int iY = -Game._PYGMY_FALL_FROM_FLICK_OFFSET_Y_;
        if (iVolcanoX > -1) {
            iX = iVolcanoX;
            this.miFlickDif = 0;
            this.miAccelerationX = 0;
            this.miAccelerationMaxX = 0;
        } else {
            iX = this.getX();
            iX += this.miFlickDif * 5;
        }
        if (iX > Game._GAME_BACKGROUND_W_ - Game._FLICK_RIGHTSIDE_BOUNDRY_) {
            iX = Game._GAME_BACKGROUND_W_ - 10;
            this.miAccelerationX = 0;
            this.miAccelerationMaxX = 0;
        }
        if (iX < 10) {
            iX = 0;
            this.miAccelerationX = 0;
            this.miAccelerationMaxX = 0;
        }
        this.setPosition(iX, iY);
        this.miDirection = (short)4;
        this.miDistance = (short)(Game._VOLCANO_Y_ + Game._PYGMY_FALL_FROM_FLICK_OFFSET_Y_ - Game._VOLCANO_FALL_OFFSET_Y_ / 2);
        this.miVelocity = (short)_VELOCITY_CREATURE_FALL_BEHIND_;
        this.miFlickDrowningID = this.miFlickLandingID;
        this.miFlickLandingID = (short)-1;
    }

    void setMovementCoconutBounce(int iCoconutBounceID) {
        this.miCoconutBounceID = (short)iCoconutBounceID;
        this.miGravityOffset = 0;
    }

    void stopMovement() {
        if (this.miType == 0) {
            this.mbIdling = false;
            this.mbCarryingLog = false;
            this.mbAnimating = false;
            this.mbEatAnimation = false;
        } else if (this.miType == 24) {
            if (this.mAnimations.characterTransform == 0) {
                this.mAnimations.setAnimationClass(11);
            } else {
                this.mAnimations.setAnimationClass(21);
            }
            this.mAnimations.loopAnimation(true);
        }
        this.miCoconutBounceID = (short)-1;
        this.miGravityOffset = 0;
        this.miDanceTime = 0;
        this.miDirection = (short)-1;
        this.miDistance = 0;
        this.miVelocity = 0;
        this.miTimeTillMovementRandom = 0;
    }

    void startDancing() {
        if (this.miType == 0) {
            if (this.miThoughtBubbleID != 1) {
                this.stopThoughtBubble();
            }
            this.miDanceTime = 3000;
            this.mAnimations.setAnimationClass(this.mbccCore.miaAnimations[5]);
            this.mAnimations.loopAnimation(true);
            this.mbAnimating = true;
        }
    }

    void queueUpMovementRandom() {
        this.mbChangeDirection = true;
        this.miTimeTillChangeDirection = (short)750;
        this.setMovementRandom();
        this.miVelocity = 0;
        this.mAnimations.setAnimationClass(148);
    }

    void setMovementRandom() {
        if (this.miType == 0 && !this.mbDying) {
            int val;
            this.stopThoughtBubble();
            this.miDirection = (short)this.getRandom(6);
            switch (this.miDirection) {
                case 0: {
                    this.miDirection = 0;
                    this.miDistance = (short)(this.miaDimensions[3] - this.miaBoundries[1] - 1);
                    this.miVelocity = (short)(-_VELOCITY_CREATURE_WALK_VERTICAL_);
                    break;
                }
                case 1: 
                case 2: {
                    this.miDirection = 1;
                    this.miDistance = (short)(this.miaBoundries[2] - this.miaDimensions[2] - 1);
                    this.miVelocity = (short)_VELOCITY_CREATURE_WALK_HORIZONTAL_;
                    break;
                }
                case 3: {
                    this.miDirection = (short)2;
                    this.miDistance = (short)(this.miaBoundries[3] - this.miaDimensions[3] - 1);
                    this.miVelocity = (short)_VELOCITY_CREATURE_WALK_VERTICAL_;
                    break;
                }
                case 4: 
                case 5: {
                    this.miDirection = (short)3;
                    this.miDistance = (short)(this.miaDimensions[0] - this.miaBoundries[0] - 1);
                    this.miVelocity = (short)(-_VELOCITY_CREATURE_WALK_HORIZONTAL_);
                }
            }
            if (this.getX() + this.getWidth() > this.miaBoundries[2] - Game._PYGMY_WALK_TOWARDS_CENTER_OFFSET_X) {
                int val2 = this.getRandom(5);
                if (val2 < 4) {
                    this.miDirection = (short)3;
                    this.miDistance = (short)(this.miaDimensions[0] - this.miaBoundries[0] - 1);
                    this.miVelocity = (short)(-_VELOCITY_CREATURE_WALK_HORIZONTAL_);
                }
            } else if (this.getX() < this.miaBoundries[0] + Game._PYGMY_WALK_TOWARDS_CENTER_OFFSET_X && (val = this.getRandom(5)) < 4) {
                this.miDirection = 1;
                this.miDistance = (short)(this.miaBoundries[2] - this.miaDimensions[2] - 1);
                this.miVelocity = (short)_VELOCITY_CREATURE_WALK_HORIZONTAL_;
            }
            if (this.miDirection == 3) {
                if (this.mAnimations.miAnimationClass != 155 && this.mAnimations.miAnimationClass != 40) {
                    this.mAnimations.setAnimationClass(155);
                    this.mAnimations.loopAnimation(true);
                }
            } else if (this.miDirection == 1) {
                if (this.mAnimations.miAnimationClass != 154 && this.mAnimations.miAnimationClass != 39) {
                    this.mAnimations.setAnimationClass(154);
                    this.mAnimations.loopAnimation(true);
                }
            } else {
                this.mAnimations.setAnimationClass(this.mbccCore.miaAnimations[4]);
                this.mAnimations.loopAnimation(true);
            }
            this.miDistance = (short)(this.miDistance / 8 + this.getRandom(this.miDistance * 2 / 3));
        } else if (this.miType == 24) {
            if (this.mAnimations.miAnimationClass != 11 && this.mAnimations.miAnimationClass != 21) {
                this.setNextMovementRandom();
                return;
            }
            int rand = this.getRandom(4);
            if (rand < 2 || this.mbPreviousTRexAnimRoar) {
                this.mbPreviousTRexAnimRoar = false;
                this.miDirection = this.miaDimensions[2] + Game._TREX_ISLAND_SIDE_OFFSET_X_ >= this.miaBoundries[2] ? (short)1 : (this.miaDimensions[0] - Game._TREX_ISLAND_SIDE_OFFSET_X_ <= this.miaBoundries[0] ? (short)0 : (this.mbTRexChargeLeft ? (short)1 : 0));
                switch (this.miDirection) {
                    case 0: {
                        if (this.mAnimations.characterTransform != 0) {
                            this.mAnimations.setAnimationClass(0);
                            this.mAnimations.loopAnimation(false);
                            this.miVelocity = 0;
                        } else {
                            this.mAnimations.setAnimationClass(10);
                            this.mAnimations.loopAnimation(true);
                            this.miVelocity = (short)_VELOCITY_TREX_WALK_HORIZONTAL_;
                        }
                        this.miDirection = 1;
                        this.miDistance = (short)(this.miaBoundries[2] - this.miaDimensions[2]);
                        this.mAnimations.applyTransform(0);
                        break;
                    }
                    case 1: {
                        if (this.mAnimations.characterTransform == 0) {
                            this.mAnimations.setAnimationClass(1);
                            this.mAnimations.loopAnimation(false);
                            this.miVelocity = 0;
                        } else {
                            this.mAnimations.setAnimationClass(20);
                            this.mAnimations.loopAnimation(true);
                            this.miVelocity = (short)(-_VELOCITY_TREX_WALK_HORIZONTAL_);
                        }
                        this.miDirection = (short)3;
                        this.miDistance = (short)(this.miaDimensions[0] - this.miaBoundries[0]);
                        this.mAnimations.applyTransform(2);
                    }
                }
            } else {
                this.mbPreviousTRexAnimRoar = true;
                if (this.mAnimations.characterTransform == 0) {
                    this.mAnimations.setAnimationClass(3);
                } else {
                    this.mAnimations.setAnimationClass(13);
                }
                this.mAnimations.loopAnimation(false);
                this.setNextMovementRandom();
            }
        }
    }

    void setNextMovementRandom() {
        if (this.miTimeTillMovementRandom < 1 && !this.mbDying) {
            if (this.miType == 0) {
                this.miTimeTillMovementRandom = 3000 + this.getRandom(5000);
            } else if (this.miType == 24) {
                this.miTimeTillMovementRandom = 2100 + this.getRandom(400);
            }
        }
    }

    void moveSun() {
        if (this.mbRising) {
            this.setPosition(this.miaDimensions[0], this.miaDimensions[1] - _SUN_MOVE_Y_ + this.miSunAcceleration);
            this.miSunAcceleration += _SUN_MOVE_ACCELERATION_;
            if (this.miaDimensions[1] <= Game._SUN_Y_) {
                this.setPosition(this.miaDimensions[0], Game._SUN_Y_);
                this.mbRising = false;
            }
        } else {
            this.setPosition(this.miaDimensions[0], this.miaDimensions[1] + _SUN_MOVE_Y_ + this.miSunAcceleration);
            this.miSunAcceleration -= _SUN_MOVE_ACCELERATION_;
            if (this.miaDimensions[1] >= Game._MOONSET_Y_) {
                this.mbRising = true;
            }
        }
    }

    void movePosition(int iX, int iY) {
        this.miaDimensions[0] = this.miaDimensions[0] + iX;
        this.miaDimensions[1] = this.miaDimensions[1] + iY;
        this.miaDimensions[2] = this.miaDimensions[2] + iX;
        this.miaDimensions[3] = this.miaDimensions[3] + iY;
    }

    void setPosition(int iX, int iY) {
        this.miaDimensions[0] = iX;
        this.miaDimensions[1] = iY;
        this.miaDimensions[2] = iX + this.miaDimensions[4];
        this.miaDimensions[3] = iY + this.miaDimensions[5];
    }

    void setDimensions(int iW, int iH) {
        this.miaDimensions[4] = iW;
        this.miaDimensions[5] = iH;
        this.miaDimensions[2] = this.miaDimensions[0] + iW;
        this.miaDimensions[3] = this.miaDimensions[1] + iH;
    }

    void setBoundries(int iX, int iY, int iW, int iH) {
        this.miaBoundries[0] = (short)iX;
        this.miaBoundries[1] = (short)iY;
        this.miaBoundries[4] = (short)iW;
        this.miaBoundries[5] = (short)iH;
        this.miaBoundries[2] = (short)(iX + iW);
        this.miaBoundries[3] = (short)(iY + iH);
    }

    void setSelected(boolean bSelected) {
        this.mbSelected = bSelected;
        if (this.mbSelected) {
            switch (this.miType) {
                case 0: {
                    if (this.mbDying) break;
                    this.mAnimations.setAnimationClass(this.mbccCore.miaAnimations[2]);
                    this.mAnimations.loopAnimation(false);
                }
            }
        }
    }

    void jumpIntoWater() {
        this.mbBurning = true;
        this.miDirection = (short)4;
        this.miGravityOffset = 0;
        if (this.mbStumbling) {
            this.miVelocity = (short)_VELOCITY_CREATURE_FALL_;
            this.miDistance = (short)(Game._WATER_THRESHOLD_ - this.getY() - this.getHeight() + 2);
            this.miAccelerationX = 0;
        } else {
            this.miVelocity = (short)(-_VELOCITY_CREATURE_FALL_ / 2);
            this.miDistance = (short)(Game._WATER_THRESHOLD_ - this.getY());
            this.miAccelerationX = (short)_VELOCITY_BURNING_INTO_WATER_X_;
        }
    }

    void vaporize() {
        if (this.mAnimations.miAnimationClass != 43) {
            this.stopMovement();
            this.stopThoughtBubble();
            this.mAnimations.setAnimationClass(43);
            this.mAnimations.loopAnimation(false);
            this.mAnimations.autoplay(true);
        }
        this.mbAnimating = true;
        this.mbDying = true;
    }

    void zap() {
        if (this.miType == 0) {
            if (this.mAnimations.miAnimationClass != 43) {
                this.mAnimations.setAnimationClass(43);
                this.mAnimations.loopAnimation(false);
                this.mAnimations.autoplay(true);
                this.mbAnimating = true;
                this.mbDying = true;
                this.mbZapped = true;
            }
        } else if (this.miType == 1) {
            if (this.mAnimations.miAnimationClass != this.mbccCore.miaAnimations[18]) {
                this.stopMovement();
                this.mbBounceUp = false;
                this.mbBounceDown = false;
                this.mAnimations.setAnimationClass(this.mbccCore.miaAnimations[18]);
                this.miScreenRegion = (short)7;
                this.setDimensions(this.mAnimations.getFrameWidth(this.mAnimations.getEndFrame()), this.mAnimations.getFrameHeight(this.mAnimations.getEndFrame()));
                this.mAnimations.loopAnimation(false);
            }
            this.mbCooked = true;
        }
    }

    void cook() {
        if (!this.mbCooked) {
            this.mbCooked = true;
            if (this.miType == 0) {
                this.mbDying = true;
            }
        }
    }

    void burn() {
        if (!this.mbBurned) {
            this.mbBurned = true;
            if (this.miType == 0) {
                this.mbDying = true;
            }
        }
    }

    void choke() {
        if (!this.mbChoking) {
            this.mbChoking = true;
            this.mbDying = true;
        }
    }

    void blownAway() {
        if (!this.mbTossed) {
            this.mbTossed = true;
            if (!this.mbBurned && !this.mbCooked) {
                this.miDirection = 1;
                this.miDistance = (short)9999;
                this.miVelocity = (short)(-_VELOCITY_DODO_BIRD_FLY_);
                if (this.mAnimations != null) {
                    this.mAnimations.applyTransform(2);
                }
            }
        }
    }

    void crackDinoEgg() {
        switch (this.miDinoEggCracks) {
            case 0: {
                this.mAnimations.setAnimationClass(26);
                break;
            }
            case 1: {
                this.mAnimations.setAnimationClass(24);
                break;
            }
            case 2: {
                this.mAnimations.setAnimationClass(22);
            }
        }
        this.miDinoEggCracks = (short)(this.miDinoEggCracks + 1);
    }

    void pickupSpear(boolean bLeft) {
        this.stopMovement();
        if (bLeft) {
            this.mAnimations.setAnimationClass(81);
        } else {
            this.mAnimations.setAnimationClass(80);
        }
        this.mAnimations.loopAnimation(false);
    }

    void carryLogToFire(InteractiveObject iLog) {
        if (!this.mbCarryingLog) {
            this.stopThoughtBubble();
            this.mAnimations.setAnimationClass(58);
            this.mLog = iLog;
            this.mAnimations.loopAnimation(false);
            this.mbCarryingLog = true;
            this.mbAnimating = true;
        }
    }

    int idleAnimation(int iWeather) {
        int iRand = this.mbccCore.getRandom(12);
        this.mbAnimating = true;
        if (iWeather == 1) {
            this.mAnimations.setAnimationClass(70);
            this.mAnimations.loopAnimation(false);
            this.mbDying = true;
            this.mbOverheating = true;
            this.miBurnTime = 1000 + this.mbccCore.getRandom(3000);
            this.stopMovement();
            this.mbIdling = false;
        } else if (iWeather == 2) {
            this.mAnimations.setAnimationClass(76);
            this.mAnimations.loopAnimation(true);
            this.mbDying = true;
            this.mbFreezing = true;
            this.miBurnTime = 1000 + this.mbccCore.getRandom(3000);
        } else {
            this.mbIdling = true;
            switch (iRand) {
                case 0: {
                    this.mAnimations.setAnimationClass(35);
                    this.mAnimations.loopAnimation(false);
                    break;
                }
                case 1: {
                    this.mAnimations.setAnimationClass(37);
                    this.mAnimations.loopAnimation(false);
                    break;
                }
                case 2: {
                    this.mAnimations.setAnimationClass(60);
                    this.mAnimations.loopAnimation(false);
                    break;
                }
                case 3: {
                    this.mAnimations.setAnimationClass(62);
                    this.mAnimations.loopAnimation(false);
                    break;
                }
                case 4: {
                    this.mAnimations.setAnimationClass(116);
                    this.mAnimations.loopAnimation(false);
                    break;
                }
                case 6: {
                    this.mAnimations.setAnimationClass(142);
                    this.mAnimations.loopAnimation(false);
                    break;
                }
                case 5: {
                    if (iWeather == 3) {
                        this.mAnimations.setAnimationClass(126);
                        this.mAnimations.loopAnimation(false);
                        this.mbSleeping = true;
                        break;
                    }
                }
                default: {
                    this.mAnimations.setAnimationClass(148);
                    this.mAnimations.loopAnimation(true);
                    this.miIdleTime = 10000;
                    this.mbIdling = false;
                    this.mbAnimating = false;
                }
            }
        }
        return this.mAnimations.miAnimationClass;
    }

    void setDrowning(int iAnimation, Animation anim) {
        this.mbDrowning = true;
        this.miDrowningFrame = 0;
        this.mbDying = true;
        if (iAnimation > -1) {
            this.mAnimations.setAnimationClass(iAnimation);
            this.mAnimations.loopAnimation(false);
        }
        int iWidth = this.getWidth();
        int iHeight = this.getHeight();
        if (this.getX() < this.miaBoundries[2] + Game._DROWNING_SIDE_RIGHT_SIDE_OFFSET_X_ && this.getX() > this.miaBoundries[2] - Game._DROWNING_OFFSET_ && this.miaDimensions[3] <= this.miaBoundries[3] && this.miaDimensions[3] >= this.miaBoundries[1]) {
            this.setPosition(this.miaBoundries[2] + Game._DROWNING_SIDE_RIGHT_SIDE_OFFSET_X_, this.getY());
        } else if (this.getX() > this.miaBoundries[0] - Game._DROWNING_SIDE_LEFT_SIDE_OFFSET_X_ && this.getX() < this.miaBoundries[0] + Game._DROWNING_OFFSET_ && this.miaDimensions[3] <= this.miaBoundries[3] && this.miaDimensions[3] >= this.miaBoundries[1]) {
            this.setPosition(this.miaBoundries[0] - Game._DROWNING_SIDE_LEFT_SIDE_OFFSET_X_, this.getY());
        }
        this.miDrowningSplashesTotal = this.miType == 24 ? (short)5 : (short)1;
        if (this.miaDrownAnimationsX != null) {
            this.miaDrownAnimationsX = null;
        }
        if (this.miaDrownAnimationsY != null) {
            this.miaDrownAnimationsY = null;
        }
        this.miaDrownAnimationsX = new short[this.miDrowningSplashesTotal];
        this.miaDrownAnimationsY = new short[this.miDrowningSplashesTotal];
        this.miaDrownAnimationsX[0] = (short)(this.getX() + iWidth / 2);
        this.miaDrownAnimationsY[0] = (short)(this.getY() + iHeight + anim.getFrameHeight(0) / 3);
        if (this.miType == 24) {
            this.miaDrownAnimationsY[0] = (short)(this.getY() + iHeight * 3 / 2 + anim.getFrameHeight(0) / 6);
            this.miaDrownAnimationsX[1] = (short)this.getX();
            this.miaDrownAnimationsY[1] = this.miaDrownAnimationsY[0];
            this.miaDrownAnimationsX[2] = (short)(this.getX() + iWidth);
            this.miaDrownAnimationsY[2] = this.miaDrownAnimationsY[0];
            this.miaDrownAnimationsX[3] = (short)(this.getX() + iWidth / 3);
            this.miaDrownAnimationsY[3] = this.miaDrownAnimationsY[0];
            this.miaDrownAnimationsX[4] = (short)(this.getX() + iWidth * 2 / 3);
            this.miaDrownAnimationsY[4] = this.miaDrownAnimationsY[0];
        } else if (this.miType == 0) {
            this.miaDrownAnimationsY[0] = (short)(this.getY() + iHeight + anim.getFrameHeight(0) / 6 + Game._PYGMY_SPLASH_OFFSET_);
            this.miaDrownAnimationsX[0] = (short)(this.miaDrownAnimationsX[0] + iWidth / 4);
        }
    }

    void setDead() {
        if (this.miType == 0) {
            this.increaseStat(0);
        }
        this.mbLevitating = false;
        this.mbSelected = false;
        this.mbFlick = false;
        this.mbCooked = false;
        this.mbBurned = false;
        this.mbAnimating = false;
        this.mbDying = false;
        this.mbZapped = false;
        this.mbSquished = false;
        this.mbStumbling = false;
        this.mbStumbleDown = false;
        this.mbChoking = false;
        this.mbTossed = false;
        this.mbIdling = false;
        this.mbSleeping = false;
        this.mbDrowning = false;
        this.mbHappy = false;
        this.mbFrozen = false;
        this.mbFreezing = false;
        this.mbOverheating = false;
        this.mbHeatUpWalk = false;
        this.mbLavaBurn = false;
        this.mbBurning = false;
        this.mbEating = false;
        this.mbEatAnimation = false;
        this.mbFreezeDrown = false;
        this.mbChangeDirection = false;
        this.miDirection = (short)-1;
        this.stopThoughtBubble();
        this.miFlickLandingID = (short)-1;
        this.miFlickDrowningID = (short)-1;
        this.miCoconutBounceID = (short)-1;
        this.miPoopDirection = (short)-1;
        this.miVelocity = 0;
        this.miDirection = (short)-1;
        if (this.mLog != null) {
            this.mLog.setPosition(this.getX(), this.mLog.getY());
            this.mLog.addInteractiveObjectToScreen();
            this.mLog = null;
        }
        if (this.miType == 7 && this.mAnimations != null) {
            this.mAnimations.setAnimationClass(this.mbccCore.miaAnimations[9]);
        }
        this.mbDead = true;
    }

    void increaseStat(int iStat) {
        if (this.miType == 0) {
            int n = iStat;
            this.miaStats[n] = this.miaStats[n] + 1;
        }
        if (iStat > 0) {
            this.setMood((short)(iStat - 1));
        }
    }

    void setStat(int iStat, short iValue) {
        if (this.miType == 0) {
            this.miaStats[iStat] = iValue;
        }
    }

    short getStat(int iStat) {
        if (this.miType == 0) {
            return (short)this.miaStats[iStat];
        }
        return 0;
    }

    void setMood(short iMood) {
        if (this.miType == 0) {
            this.miMood = iMood;
        }
    }

    short getMood() {
        if (this.miType == 0) {
            return this.miMood;
        }
        return 0;
    }

    void stopThoughtBubble() {
        this.miThoughtBubbleID = (short)-1;
        this.miTimeThought = 0;
    }

    void setDeaths(int iDeaths) {
        if (this.miType == 0) {
            this.miaStats[0] = this.miaStats[0] + 1;
        }
    }

    int getDeaths() {
        if (this.miType == 0) {
            return this.miaStats[0];
        }
        return 0;
    }

    int getX() {
        return this.miaDimensions[0];
    }

    int getY() {
        return this.miaDimensions[1];
    }

    int getWidth() {
        return this.miaDimensions[4];
    }

    int getHeight() {
        return this.miaDimensions[5];
    }

    int getCoconutBounceY() {
        return this.getCoconutBounceY(this.miCoconutBounceID, this.miGravityOffset);
    }

    int getCoconutBounceY(int iCoconutBounceID, int iGravity) {
        if (iCoconutBounceID > -1) {
            int iY = iGravity;
            switch (iCoconutBounceID) {
                case 0: {
                    iY += _COCONUT_VELOCITY_Y_0_;
                    break;
                }
                case 1: {
                    iY += _COCONUT_VELOCITY_Y_1_;
                    break;
                }
                case 2: {
                    iY += _COCONUT_VELOCITY_Y_2_;
                    break;
                }
                case 3: {
                    iY += _COCONUT_VELOCITY_Y_3_;
                    break;
                }
                case 4: {
                    iY += _COCONUT_VELOCITY_Y_4_;
                    break;
                }
                case 5: {
                    iY += _COCONUT_VELOCITY_Y_5_;
                    break;
                }
                case 6: {
                    iY += _COCONUT_VELOCITY_Y_6_;
                    break;
                }
                case 7: {
                    iY += _COCONUT_VELOCITY_Y_7_;
                    break;
                }
                case 8: {
                    iY += _COCONUT_VELOCITY_Y_8_;
                    break;
                }
                case 9: {
                    iY += _COCONUT_VELOCITY_Y_9_;
                }
            }
            return iY;
        }
        return 0;
    }

    boolean canLevitate() {
        switch (this.miType) {
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 24: 
            case 25: {
                return false;
            }
        }
        return this.miType != 4 || this.miCoconutBounceID == -1;
    }

    boolean canCook() {
        switch (this.miType) {
            case 0: {
                if (this.mbFrozen) {
                    return false;
                }
            }
            case 1: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    boolean canBurn() {
        switch (this.miType) {
            case 1: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    boolean isPressed(int[] iaDimensions, boolean bHalfY) {
        return this.isPressed(iaDimensions[0], iaDimensions[1], iaDimensions[4], iaDimensions[5], bHalfY);
    }

    boolean isPressed(int[] iaDimensions) {
        return this.isPressed(iaDimensions[0], iaDimensions[1], iaDimensions[4], iaDimensions[5], false);
    }

    boolean isPressed(int iX, int iY, int iW, int iH, boolean bHalfY) {
        int iExtra1 = 0;
        int iExtra2 = 0;
        int iExtraX2 = 0;
        if (bHalfY) {
            iExtra1 += this.miaDimensions[5] * 3 / 5;
            iExtra2 += iH * 3 / 5;
            iExtraX2 = iW / 4;
        }
        return iX + iW - iExtraX2 >= this.miaDimensions[0] && iX <= this.miaDimensions[2] - iExtraX2 && iY + iH >= this.miaDimensions[1] + iExtra1 && iY + iExtra2 <= this.miaDimensions[3];
    }

    boolean isPressedCoconut(int[] iaDimensions, int iCoconutBounceID, int iGravity, int iVelocity) {
        int iDif = iCoconutBounceID > -1 ? this.getCoconutBounceY(iCoconutBounceID, iGravity) : iVelocity;
        int iXCoco = iaDimensions[0];
        int iYCoco = iaDimensions[1] - iDif;
        int iWCoco = iaDimensions[4];
        int iHCoco = iaDimensions[5] + iDif;
        int iX = this.miaDimensions[0];
        int iY = this.miaDimensions[1] + Game._PYGMY_HAIR_OFFSET_Y_;
        int iW = this.miaDimensions[4];
        int iH = this.miaDimensions[5] - Game._PYGMY_HAIR_OFFSET_Y_;
        return iXCoco + iWCoco - iWCoco / 4 > iX && iXCoco + iWCoco / 4 < iX + iW && iYCoco + iHCoco >= iY && iYCoco <= iY + iH * 2 / 5;
    }

    boolean isPressedEat(int[] iaDimensions, boolean bThinking) {
        if (this.miaDimensions[0] > Game._PYGMY_BOUNDRY_X_ && this.miaDimensions[2] < Game._PYGMY_BOUNDRY_X_ + Game._PYGMY_BOUNDRY_W_) {
            if (bThinking) {
                return this.isPressed(iaDimensions[0] - iaDimensions[4] * 2, iaDimensions[1], iaDimensions[4] * 4, iaDimensions[5], false);
            }
            return this.isPressed(iaDimensions[0], iaDimensions[1], iaDimensions[4], iaDimensions[5], false);
        }
        return false;
    }

    void setLevitating(boolean bLevitating) {
        this.mbLevitating = bLevitating;
        if (this.mbLevitating) {
            if (this.miType == 0 && this.mAnimations.miAnimationClass != 41 && this.mAnimations.miAnimationClass != 42 && this.mAnimations.miAnimationClass != 88 && this.mAnimations.miAnimationClass != 2 && this.mAnimations.miAnimationClass != 74 && this.mAnimations.miAnimationClass != 75) {
                this.mAnimations.setAnimationClass(42);
            }
            this.mbFlick = false;
        }
    }

    void setFlicking(boolean bFlicking) {
        this.mbFlick = bFlicking;
        if (this.mbFlick) {
            this.mbLevitating = false;
        }
    }

    boolean isLevitating() {
        return this.mbLevitating;
    }

    boolean isFlicking() {
        return this.mbFlick;
    }

    int getRandom(int iMod) {
        if (iMod == 0) {
            return 0;
        }
        return this.r.nextInt(Math.abs(iMod));
    }

    void animate(int iTimeDif, int iGameMode) {
        int iY;
        int iX;
        if (this.miTimeTillChangeDirection > 0 && this.mbChangeDirection) {
            if (this.miDirection == 4 || this.mbDying) {
                this.miTimeTillChangeDirection = 0;
                this.mbChangeDirection = false;
            } else {
                this.miTimeTillChangeDirection = (short)(this.miTimeTillChangeDirection - iTimeDif);
                if (this.miTimeTillChangeDirection < 1) {
                    this.mbChangeDirection = false;
                    if (this.miDirection == 3) {
                        this.mAnimations.setAnimationClass(155);
                        this.mAnimations.loopAnimation(true);
                        this.miVelocity = (short)(-_VELOCITY_CREATURE_WALK_HORIZONTAL_);
                    } else if (this.miDirection == 1) {
                        this.mAnimations.setAnimationClass(154);
                        this.mAnimations.loopAnimation(true);
                        this.miVelocity = (short)_VELOCITY_CREATURE_WALK_HORIZONTAL_;
                    } else {
                        this.mAnimations.setAnimationClass(this.mbccCore.miaAnimations[4]);
                        this.miVelocity = this.miDirection == 2 ? (short)_VELOCITY_CREATURE_WALK_VERTICAL_ : (short)(-_VELOCITY_CREATURE_WALK_VERTICAL_);
                    }
                }
            }
        }
        if (this.miFlickLandingID > -1) {
            int iY2 = -_FLICK_VELOCITY_MIN_ - this.miAccelerationY;
            this.movePosition(this.miAccelerationX, iY2);
            if (this.miAccelerationX > 0) {
                if (this.miAccelerationX < this.miAccelerationMaxX) {
                    this.miAccelerationX = (short)(this.miAccelerationX + 1);
                }
            } else if (this.miAccelerationX < 0 && this.miAccelerationX > this.miAccelerationMaxX) {
                this.miAccelerationX = (short)(this.miAccelerationX - 1);
            }
            this.miAccelerationY = (short)(this.miAccelerationY * 2);
            if (this.miAccelerationY > this.miAccelerationMaxY) {
                this.miAccelerationY = this.miAccelerationMaxY;
            }
            return;
        }
        if (this.miFlickDrowningID > -1 && this.miDistance > 0 && this.mAnimations.miAnimationClass != 0) {
            short iMoveY = this.miAccelerationY > this.miDistance ? this.miDistance : this.miAccelerationY;
            this.movePosition(this.miAccelerationX, iMoveY);
            this.miDistance = (short)(this.miDistance - iMoveY);
            if (this.miDistance <= 0) {
                this.miDistance = 1;
            }
            if (this.miAccelerationX > this.miAccelerationMaxX) {
                this.miAccelerationX = (short)(this.miAccelerationX - 1);
            } else if (this.miAccelerationX < -this.miAccelerationMaxX) {
                this.miAccelerationX = (short)(this.miAccelerationX + 1);
            }
            if (this.miAccelerationY < this.miAccelerationMaxY) {
                this.miAccelerationY = (short)(this.miAccelerationY + 2);
            }
        }
        if (this.miCoconutBounceID > -1) {
            iX = 0;
            iY = this.miGravityOffset;
            switch (this.miCoconutBounceID) {
                case 0: {
                    iX += _COCONUT_VELOCITY_X_0_;
                    iY += _COCONUT_VELOCITY_Y_0_;
                    break;
                }
                case 1: {
                    iX += _COCONUT_VELOCITY_X_1_;
                    iY += _COCONUT_VELOCITY_Y_1_;
                    break;
                }
                case 2: {
                    iX += _COCONUT_VELOCITY_X_2_;
                    iY += _COCONUT_VELOCITY_Y_2_;
                    break;
                }
                case 3: {
                    iX += _COCONUT_VELOCITY_X_3_;
                    iY += _COCONUT_VELOCITY_Y_3_;
                    break;
                }
                case 4: {
                    iX += _COCONUT_VELOCITY_X_4_;
                    iY += _COCONUT_VELOCITY_Y_4_;
                    break;
                }
                case 5: {
                    iX += _COCONUT_VELOCITY_X_5_;
                    iY += _COCONUT_VELOCITY_Y_5_;
                    break;
                }
                case 6: {
                    iX += _COCONUT_VELOCITY_X_6_;
                    iY += _COCONUT_VELOCITY_Y_6_;
                    break;
                }
                case 7: {
                    iX += _COCONUT_VELOCITY_X_7_;
                    iY += _COCONUT_VELOCITY_Y_7_;
                    break;
                }
                case 8: {
                    iX += _COCONUT_VELOCITY_X_8_;
                    iY += _COCONUT_VELOCITY_Y_8_;
                    break;
                }
                case 9: {
                    iX += _COCONUT_VELOCITY_X_9_;
                    iY += _COCONUT_VELOCITY_Y_9_;
                }
            }
            this.movePosition(iX, iY);
            if (this.miaDimensions[1] > Game._LAND_THRESHOLD_) {
                this.miaDimensions[1] = Game._LAND_THRESHOLD_ + 1;
            }
            if (this.miGravityOffset < _GRAVITY_COCONUT_MAX_) {
                this.miGravityOffset = (short)(this.miGravityOffset + _GRAVITY_COCONUT_);
            }
        }
        if (this.mbTossed) {
            iX = 0;
            iY = 0;
            switch (this.mbccCore.getRandom(10)) {
                case 0: {
                    iX = _HURRICANE_VELOCITY_X_0_;
                    iY = _HURRICANE_VELOCITY_Y_0_;
                    break;
                }
                case 1: {
                    iX = _HURRICANE_VELOCITY_X_1_;
                    iY = _HURRICANE_VELOCITY_Y_1_;
                    break;
                }
                case 2: {
                    iX = _HURRICANE_VELOCITY_X_2_;
                    iY = _HURRICANE_VELOCITY_Y_2_;
                    break;
                }
                case 3: {
                    iX = _HURRICANE_VELOCITY_X_3_;
                    iY = _HURRICANE_VELOCITY_Y_3_;
                    break;
                }
                case 4: {
                    iX = _HURRICANE_VELOCITY_X_4_;
                    iY = _HURRICANE_VELOCITY_Y_4_;
                    break;
                }
                case 5: {
                    iX = _HURRICANE_VELOCITY_X_5_;
                    iY = _HURRICANE_VELOCITY_Y_5_;
                    break;
                }
                case 6: {
                    iX = _HURRICANE_VELOCITY_X_6_;
                    iY = _HURRICANE_VELOCITY_Y_6_;
                    break;
                }
                case 7: {
                    iX = _HURRICANE_VELOCITY_X_7_;
                    iY = _HURRICANE_VELOCITY_Y_7_;
                    break;
                }
                case 8: {
                    iX = _HURRICANE_VELOCITY_X_8_;
                    iY = _HURRICANE_VELOCITY_Y_8_;
                    break;
                }
                case 9: {
                    iX = _HURRICANE_VELOCITY_X_9_;
                    iY = _HURRICANE_VELOCITY_Y_9_;
                }
            }
            this.movePosition(iX, iY);
        }
        if (this.miDirection > -1 && this.mbBurning && this.miDirection == 4 && this.mAnimations.miAnimationClass != 1) {
            if (this.miGravityOffset < _VELOCITY_CREATURE_FALL_) {
                this.miGravityOffset = (short)(this.miGravityOffset + _VELOCITY_CREATURE_FALL_ / 4);
            }
            this.movePosition(this.miAccelerationX, this.miVelocity + this.miGravityOffset);
            this.miDistance = (short)(this.miDistance - (this.miVelocity + this.miGravityOffset));
            if (this.miDistance > 0) {
                return;
            }
        }
        if (this.miType == 0 && !this.mbDying) {
            if (this.mAnimations.miAnimationClass == 100 && this.mAnimations.getCurrentFrame() == this.mAnimations.getEndFrame()) {
                this.mbAnimating = false;
                if (iGameMode != 1 && iGameMode != 2) {
                    this.mAnimations.setAnimationClass(148);
                } else {
                    this.mbccCore.m_canvas.m_game.game_ReactToTRex(this.miID);
                }
            } else if (this.mbIdling && !this.mbSleeping && this.mAnimations.isAnimationFinished()) {
                this.mAnimations.setAnimationClass(148);
                this.mbIdling = false;
                this.miIdleTime = 10000;
                this.setNextMovementRandom();
            } else if (!(this.miDirection != -1 || this.mAnimations.miAnimationClass != 154 && this.mAnimations.miAnimationClass != 155 && this.mAnimations.miAnimationClass != 150 && this.mAnimations.miAnimationClass != 151 || this.mbEating && this.mbccCore.m_canvas.m_game.miEatingID == this.miID)) {
                this.mAnimations.setAnimationClass(148);
                this.mAnimations.loopAnimation(true);
                this.mbAnimating = false;
            }
        }
        if (this.miType == 23 && Math.abs(this.miVelocity) == _VELOCITY_SPEAR_THROW_X_ && this.miDirection != 4 && this.miDirection != -1) {
            this.movePosition(this.miVelocity, this.miGravityOffset);
            if (this.miGravityOffset < _GRAVITY_SPEAR_MAX_) {
                this.miGravityOffset = (short)(this.miGravityOffset + _GRAVITY_SPEAR_);
            }
            return;
        }
        if (this.miType == 18 && this.miDirection == 4) {
            if (this.miPoopDirection == 1) {
                this.movePosition(-_VELOCITY_POOP_X_, 0);
            } else {
                this.movePosition(_VELOCITY_POOP_X_, 0);
            }
        }
        if (this.miDanceTime > 0 && !this.mbDying) {
            this.miDanceTime -= iTimeDif;
            if (this.miDanceTime < 1) {
                this.mbAnimating = false;
                this.setMovementRandom();
            }
        } else if (!(this.miTimeTillMovementRandom <= 0 || this.mbAnimating || this.mbDying || this.mbEating)) {
            this.miTimeTillMovementRandom -= iTimeDif;
            if (this.miTimeTillMovementRandom < 1) {
                if (iGameMode == 0 || this.miType == 24) {
                    this.setMovementRandom();
                } else {
                    this.setNextMovementRandom();
                }
            }
        }
        if (this.mbCarryingLog && this.miDirection != 4 && !this.mbLevitating && !this.mbFlick) {
            if (this.miaDimensions[2] < Game._FIREPIT_X_ + Game._FIREPIT_W_ / 4) {
                if (this.mAnimations.miAnimationClass == 58 && this.mAnimations.isAnimationFinished()) {
                    this.mAnimations.setAnimationClass(39);
                    this.mAnimations.loopAnimation(true);
                    this.miDirection = 1;
                    this.miDistance = (short)(this.miaBoundries[2] - this.miaDimensions[2]);
                    this.miVelocity = (short)_VELOCITY_CREATURE_WALK_HORIZONTAL_;
                }
            } else if (this.miaDimensions[0] > Game._FIREPIT_X_ + Game._FIREPIT_W_ * 3 / 4) {
                if (this.mAnimations.miAnimationClass == 58 && this.mAnimations.isAnimationFinished()) {
                    this.mAnimations.setAnimationClass(40);
                    this.mAnimations.loopAnimation(true);
                    this.miDirection = (short)3;
                    this.miDistance = (short)(this.miaDimensions[0] - this.miaBoundries[0]);
                    this.miVelocity = (short)(-_VELOCITY_CREATURE_WALK_HORIZONTAL_);
                }
            } else if ((this.mAnimations.miAnimationClass == 58 || this.mAnimations.miAnimationClass == 59) && this.mAnimations.isAnimationFinished() || this.mAnimations.miAnimationClass == 39 || this.mAnimations.miAnimationClass == 40) {
                if (this.miaDimensions[0] + this.miaDimensions[4] / 2 >= Game._FIREPIT_X_ + Game._FIREPIT_W_ / 2) {
                    this.mAnimations.setAnimationClass(45);
                    this.mAnimations.loopAnimation(false);
                } else {
                    this.mAnimations.setAnimationClass(44);
                    this.mAnimations.loopAnimation(false);
                }
                this.mbCarryingLog = false;
                this.miDirection = (short)-1;
                this.miVelocity = 0;
            }
        }
        if (this.mbStumbling && this.mbDying) {
            if (this.mAnimations.miAnimationClass != 27 && this.mAnimations.miAnimationClass != 23 && this.mAnimations.miAnimationClass != 1) {
                this.mAnimations.setAnimationClass(27);
            }
            if (this.mbStumbleDown) {
                if (this.mAnimations.miAnimationClass == 23) {
                    this.jumpIntoWater();
                }
            } else if (this.getX() + this.getWidth() / 2 <= Game._PYGMY_BOUNDRY_X_ + Game._PYGMY_BOUNDRY_W_ / 2 && this.getX() + this.getWidth() / 2 >= Game._PYGMY_BOUNDRY_X_) {
                this.miDirection = (short)3;
                this.miDistance = (short)(this.getX() + this.getWidth() - Game._PYGMY_BOUNDRY_X_ - 20);
                this.miVelocity = (short)(-_VELOCITY_CREATURE_WALK_HORIZONTAL_ * 2);
            } else if (this.getX() > Game._PYGMY_BOUNDRY_X_ + Game._PYGMY_BOUNDRY_W_ / 2 && this.getX() <= Game._PYGMY_BOUNDRY_X_ + Game._PYGMY_BOUNDRY_W_) {
                this.miDirection = 1;
                this.miDistance = (short)(Game._PYGMY_BOUNDRY_X_ + Game._PYGMY_BOUNDRY_W_ - this.getX());
                this.miVelocity = (short)(_VELOCITY_CREATURE_WALK_HORIZONTAL_ * 2);
            } else {
                this.miDirection = (short)-1;
                this.miVelocity = 0;
            }
        }
        if (!(this.miType != 1 || this.mbCooked || this.mbBurned || this.mbTossed || this.mbLevitating || this.miDirection == 4)) {
            int iW = this.miaDimensions[4] + Game._GAME_BACKGROUND_W_;
            if (this.getX() < -this.miaDimensions[4]) {
                if (this.miType == 1) {
                    this.setPosition(-this.miaDimensions[4], this.miaDimensions[1]);
                    this.mAnimations.setAnimationClass(this.mbccCore.miaAnimations[15]);
                    this.miVelocity = (short)_VELOCITY_DODO_BIRD_FLY_;
                }
                this.miDirection = (short)3;
                this.miDistance = (short)(Game.REAL_W - Game._DODO_BIRD_DISTANCE_OFFSET_X_ + this.miaDimensions[4]);
                this.mAnimations.applyTransform(0);
            } else if (this.getX() > iW) {
                if (this.miType == 1) {
                    this.setPosition(Game._GAME_BACKGROUND_W_, this.miaDimensions[1]);
                    this.miVelocity = (short)(-_VELOCITY_DODO_BIRD_FLY_);
                }
                this.miDirection = 1;
                this.miDistance = (short)(Game.REAL_W - Game._DODO_BIRD_DISTANCE_OFFSET_X_ + this.miaDimensions[4]);
                this.mAnimations.applyTransform(2);
            }
        } else if (this.miType == 24 && this.mAnimations.isAnimationFinished() && this.miDirection != 0) {
            if (this.mAnimations.miAnimationClass == 0) {
                this.mAnimations.setAnimationClass(10);
                this.mAnimations.loopAnimation(true);
                this.miVelocity = (short)_VELOCITY_TREX_WALK_HORIZONTAL_;
            } else if (this.mAnimations.miAnimationClass == 1) {
                this.mAnimations.setAnimationClass(20);
                this.mAnimations.loopAnimation(true);
                this.miVelocity = (short)(-_VELOCITY_TREX_WALK_HORIZONTAL_);
            } else if (this.mAnimations.miAnimationClass == 5) {
                this.miDirection = (short)-1;
                this.miVelocity = 0;
                this.mbPreviousTRexAnimRoar = true;
                this.mAnimations.setAnimationClass(3);
                this.mAnimations.loopAnimation(false);
                this.setNextMovementRandom();
            } else if (this.mAnimations.miAnimationClass == 9 || this.mAnimations.miAnimationClass == 8 || this.mAnimations.miAnimationClass == 19 || this.mAnimations.miAnimationClass == 18) {
                this.miDirection = (short)-1;
                this.miVelocity = 0;
                this.mbPreviousTRexAnimRoar = true;
                if (this.mAnimations.characterTransform == 0) {
                    this.mAnimations.setAnimationClass(3);
                } else {
                    this.mAnimations.setAnimationClass(13);
                }
                this.mAnimations.loopAnimation(false);
                this.setMovementRandom();
            } else if (this.mAnimations.miAnimationClass == 3 || this.mAnimations.miAnimationClass == 2) {
                this.mAnimations.setAnimationClass(11);
                this.mAnimations.loopAnimation(true);
                this.miVelocity = 0;
                this.setNextMovementRandom();
            } else if (this.mAnimations.miAnimationClass == 15) {
                this.miDirection = (short)-1;
                this.miVelocity = 0;
                this.mbPreviousTRexAnimRoar = true;
                this.mAnimations.setAnimationClass(13);
                this.mAnimations.loopAnimation(false);
                this.setNextMovementRandom();
            } else if (this.mAnimations.miAnimationClass == 13 || this.mAnimations.miAnimationClass == 12) {
                this.mAnimations.setAnimationClass(21);
                this.mAnimations.loopAnimation(true);
                this.miVelocity = 0;
                this.setNextMovementRandom();
            }
        }
        if (this.miDirection != -1) {
            if (this.miDistance > 0) {
                if ((this.mAnimations.miAnimationClass == 94 || this.mAnimations.miAnimationClass == 92) && Math.abs(this.miVelocity) > this.miDistance) {
                    this.miVelocity = this.miVelocity < 0 ? (short)(-this.miDistance) : this.miDistance;
                }
                this.miDistance = (short)(this.miDistance - Math.abs(this.miVelocity));
                if (this.miDirection == 0 || this.miDirection == 2 || this.miDirection == 4) {
                    if (this.miDistance < 0) {
                        this.miVelocity = (short)(this.miVelocity + this.miDistance);
                        this.miDistance = 0;
                    }
                    this.setPosition(this.miaDimensions[0], this.miaDimensions[1] + this.miVelocity);
                } else {
                    this.setPosition(this.miaDimensions[0] + this.miVelocity, this.miaDimensions[1]);
                }
            } else if (this.miDirection == 4 && this.miaDimensions[3] >= Game._WATER_THRESHOLD_) {
                this.miDirection = (short)-1;
            } else if (this.miType == 1 && !this.mbCooked && !this.mbBurned) {
                if (this.miDirection == 3) {
                    this.mAnimations.setAnimationClass(this.mbccCore.miaAnimations[15]);
                    this.miDirection = 1;
                    this.miDistance = (short)(Game.REAL_W - Game._DODO_BIRD_DISTANCE_OFFSET_X_);
                    this.miVelocity = (short)(-_VELOCITY_DODO_BIRD_FLY_);
                    this.mAnimations.applyTransform(2);
                } else if (this.miDirection == 1) {
                    this.mAnimations.setAnimationClass(this.mbccCore.miaAnimations[15]);
                    this.miDirection = (short)3;
                    this.miDistance = (short)(Game.REAL_W - Game._DODO_BIRD_DISTANCE_OFFSET_X_);
                    this.miVelocity = (short)_VELOCITY_DODO_BIRD_FLY_;
                    this.mAnimations.applyTransform(0);
                }
            } else if (this.miType == 24) {
                if (this.mAnimations.miAnimationClass == 4) {
                    this.mAnimations.setAnimationClass(5);
                    this.mAnimations.loopAnimation(false);
                } else if (this.mAnimations.miAnimationClass == 14) {
                    this.mAnimations.setAnimationClass(15);
                    this.mAnimations.loopAnimation(false);
                } else if (this.mAnimations.miAnimationClass != 5 && this.mAnimations.miAnimationClass != 15) {
                    this.miDirection = (short)-1;
                    this.miVelocity = 0;
                    this.mbPreviousTRexAnimRoar = true;
                    if (this.mAnimations.characterTransform == 0) {
                        this.mAnimations.setAnimationClass(3);
                    } else {
                        this.mAnimations.setAnimationClass(13);
                    }
                    this.mAnimations.loopAnimation(false);
                    this.setNextMovementRandom();
                }
            } else {
                this.miDirection = (short)-1;
                if (!this.mbDying) {
                    if (this.miType != 0 && this.miType != 18 && this.miaDimensions[0] + this.miaDimensions[4] > Game._PYGMY_BOUNDRY_X_ && this.miaDimensions[0] < Game._PYGMY_BOUNDRY_X_ + Game._PYGMY_BOUNDRY_W_) {
                        if (this.mbBounceHigh) {
                            if (!this.mbBounceUp) {
                                this.mbBounceUp = true;
                                this.miDirection = (short)4;
                                this.miDistance = (short)_BOUNCE_HEIGHT_HIGH_;
                                this.miVelocity = (short)(-_VELOCITY_BOUNCE_);
                                if (this.miType == 20) {
                                    this.crackDinoEgg();
                                    return;
                                }
                            } else if (!this.mbBounceDown) {
                                this.mbBounceDown = true;
                                this.mbBounceHigh = false;
                                this.miDirection = (short)4;
                                this.miDistance = (short)_BOUNCE_HEIGHT_HIGH_;
                                this.miVelocity = (short)_VELOCITY_BOUNCE_;
                            }
                        } else if (!this.mbBounceUp) {
                            this.mbBounceUp = true;
                            this.miDirection = (short)4;
                            this.miDistance = (short)_BOUNCE_HEIGHT_;
                            this.miVelocity = (short)(-_VELOCITY_BOUNCE_);
                            if (this.miType == 20) {
                                this.crackDinoEgg();
                                return;
                            }
                        } else if (!this.mbBounceDown) {
                            this.mbBounceDown = true;
                            this.miDirection = (short)4;
                            this.miDistance = (short)_BOUNCE_HEIGHT_;
                            this.miVelocity = (short)_VELOCITY_BOUNCE_;
                        }
                    }
                    if (iGameMode == 0) {
                        this.setNextMovementRandom();
                    }
                    if (this.miType == 0) {
                        if (!(this.mAnimations.miAnimationClass != 83 && this.mAnimations.miAnimationClass != 131 || iGameMode != 1 && iGameMode != 2)) {
                            this.mAnimations.setAnimationClass(87);
                        } else if (!(this.mAnimations.miAnimationClass != 82 && this.mAnimations.miAnimationClass != 132 || iGameMode != 1 && iGameMode != 2)) {
                            this.mAnimations.setAnimationClass(86);
                        } else if (this.mAnimations.miAnimationClass != 100 && !this.mbEating) {
                            this.mAnimations.setAnimationClass(148);
                        } else if (this.mAnimations.miAnimationClass == 100) {
                            this.mAnimations.autoplay(true);
                        }
                    } else if (this.miType == 16) {
                        this.mbCheckPancake = true;
                    }
                } else if (this.mbFrozen && this.getX() >= Game._PYGMY_BOUNDRY_X_ && this.getX() <= Game._PYGMY_BOUNDRY_X_ + Game._PYGMY_BOUNDRY_W_) {
                    this.mAnimations.setAnimationClass(72);
                    this.mbFrozen = false;
                    this.mAnimations.loopAnimation(false);
                }
            }
        } else if (!(this.mAnimations.miAnimationClass != 83 && this.mAnimations.miAnimationClass != 131 || iGameMode != 1 && iGameMode != 2)) {
            this.mAnimations.setAnimationClass(87);
        } else if (!(this.mAnimations.miAnimationClass != 82 && this.mAnimations.miAnimationClass != 132 || iGameMode != 1 && iGameMode != 2)) {
            this.mAnimations.setAnimationClass(86);
        }
    }
}

