/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Category;
import JabpLite.CategoryStore;
import JabpLite.CategoryView;
import JabpLite.JabpLite;
import JabpLite.Sort;
import JabpLite.Utilities;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;

public class TopExpensesView
extends Canvas
implements CommandListener,
Runnable {
    Display display;
    Font font;
    Form touchScreenMenu;
    ChoiceGroup cgtsm;
    Alert alert;
    JabpLite parent;
    boolean filterFlag;
    Vector filterVector;
    int fs;
    int width;
    int height;
    int numItemsPage;
    int fontHeight;
    int fontWidth;
    int numberWidth;
    int nameWidth;
    int amountPosition;
    int currentX;
    int currentY;
    int totalExpenses;
    long timePointerOnScreen;

    public TopExpensesView(JabpLite jabpLite, Display display, boolean bl, Vector vector) {
        this.parent = jabpLite;
        this.display = display;
        this.filterFlag = bl;
        if (this.filterFlag) {
            this.filterVector = vector;
        }
        this.setFullScreenMode(this.parent.showFullCanvas);
        this.addCommand(this.parent.okCommand);
        this.addCommand(this.parent.exitCommand);
        this.setCommandListener(this);
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.alert.setTimeout(1500);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.setPositions();
        this.currentX = 0;
        this.currentY = this.fontHeight;
        if (this.parent.isAndroid) {
            this.display.callSerially((Runnable)this);
        }
    }

    void androidDelay() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void run() {
        this.androidDelay();
    }

    public void paint(Graphics graphics) {
        if (this.width != this.getWidth() || this.height != this.getHeight() - this.parent.heightAdjustment) {
            this.width = this.getWidth();
            this.height = this.getHeight() - this.parent.heightAdjustment;
            this.setPositions();
        }
        graphics.setFont(this.font);
        this.showHeader(graphics);
        this.showPage(graphics);
        this.showFooter(graphics);
    }

    void showPage(Graphics graphics) {
        int n;
        this.currentY = this.fontHeight;
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.fontHeight, this.width, this.height - this.fontHeight * 2);
        graphics.setColor(this.parent.colorFont);
        Vector<Category> vector = new Vector<Category>();
        CategoryStore categoryStore = new CategoryStore(this.parent);
        int n2 = categoryStore.getNumCategories();
        this.totalExpenses = 0;
        for (n = 0; n < n2; ++n) {
            Category category = categoryStore.getCategoryFromIndex(n);
            if (this.filterFlag) {
                category.current = (Integer)this.filterVector.elementAt(n);
            }
            vector.addElement(category);
            if (category.current <= 0) continue;
            this.totalExpenses += category.current;
        }
        categoryStore.closeCategoryStore();
        categoryStore = null;
        Sort.sortCategory(vector, 0, n2 - 1, true);
        n = Math.min(n2, this.numItemsPage);
        for (int i = 0; i < n; ++i) {
            Category category = (Category)vector.elementAt(i);
            if (category.current < 0 || this.currentY + this.fontHeight > this.height - this.fontHeight) continue;
            this.buildLine(graphics, category.name, category.current);
        }
        vector = null;
    }

    void showHeader(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, 0, this.width, this.fontHeight);
        graphics.setColor(this.parent.colorFont);
        String string = "Top Expenses";
        if (this.filterFlag) {
            string = string + "[*]";
        }
        graphics.drawString(string, this.parent.widthAdjustment, this.parent.fontAdjustment, 20);
        graphics.drawString("Amount", this.amountPosition + this.numberWidth - this.font.stringWidth("Amount"), this.parent.fontAdjustment, 20);
    }

    void showFooter(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.fontHeight, this.width, this.fontHeight);
        graphics.setColor(this.parent.colorFont);
        graphics.drawString("Total Expenses", this.parent.widthAdjustment, this.height - this.fontHeight + this.parent.fontAdjustment, 20);
        String string = "";
        string = Utilities.numberToString(this.totalExpenses, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        graphics.drawString(string, this.amountPosition + this.numberWidth - this.font.stringWidth(string), this.height - this.fontHeight + this.parent.fontAdjustment, 20);
    }

    void buildLine(Graphics graphics, String string, int n) {
        graphics.drawString(string, this.parent.widthAdjustment, this.currentY + this.parent.fontAdjustment, 20);
        String string2 = Utilities.numberToString(n, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        graphics.drawString(string2, this.amountPosition + this.numberWidth - this.font.stringWidth(string2), this.currentY + this.parent.fontAdjustment, 20);
        this.currentY += this.fontHeight;
    }

    void setPositions() {
        int n = 8;
        if (this.parent.mediumSize) {
            n = 0;
        }
        if (this.parent.largeSize) {
            n = 16;
        }
        this.font = Font.getFont((int)0, (int)0, (int)n);
        this.fontHeight = this.font.getHeight();
        this.numItemsPage = this.height / this.fontHeight - 2;
        this.numberWidth = this.font.stringWidth("999999.99");
        this.nameWidth = this.width - this.numberWidth - this.parent.widthAdjustment * 2 - 10;
        this.amountPosition = this.nameWidth + this.parent.widthAdjustment + 10;
    }

    protected void showNotify() {
        this.repaint();
    }

    protected void pointerPressed(int n, int n2) {
        this.timePointerOnScreen = System.currentTimeMillis();
    }

    protected void pointerReleased(int n, int n2) {
        this.displayTouchScreenMenu();
    }

    void displayTouchScreenMenu() {
        this.touchScreenMenu = new Form("Top Expenses Menu");
        this.cgtsm = new ChoiceGroup("Choose an option", 1);
        this.cgtsm.append("Close", null);
        this.cgtsm.append("Exit", null);
        this.touchScreenMenu.append((Item)this.cgtsm);
        this.touchScreenMenu.addCommand(this.parent.okCommand);
        this.touchScreenMenu.addCommand(this.parent.cancelCommand);
        this.touchScreenMenu.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.touchScreenMenu);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.parent.exitCommand) {
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this && command == this.parent.okCommand) {
            if (this.parent.cv == null) {
                this.parent.cv = new CategoryView(this.parent, this.display);
            }
            this.display.setCurrent((Displayable)this.parent.cv);
        }
        if (displayable == this.touchScreenMenu) {
            if (command == this.parent.okCommand) {
                int n = this.cgtsm.getSelectedIndex();
                if (n == 0) {
                    this.commandAction(this.parent.okCommand, (Displayable)this);
                }
                if (n == 2) {
                    this.parent.destroyApp(true);
                }
            } else {
                this.touchScreenMenu = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
    }
}

