/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.Category;
import JabpLite.CategoryForm;
import JabpLite.CategoryStore;
import JabpLite.CurrencyView;
import JabpLite.FindForm;
import JabpLite.FindView;
import JabpLite.InvestmentView;
import JabpLite.JabpLite;
import JabpLite.NameId;
import JabpLite.PreferenceForm;
import JabpLite.Regular;
import JabpLite.RegularStore;
import JabpLite.Split;
import JabpLite.StandingOrder;
import JabpLite.StandingOrderStore;
import JabpLite.StandingOrderView;
import JabpLite.TopExpensesView;
import JabpLite.Transaction;
import JabpLite.TransactionForm;
import JabpLite.TransactionStore;
import JabpLite.Utilities;
import JabpLite.ViewForm;
import java.util.Date;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStoreException;

public class CategoryView
extends Canvas
implements CommandListener,
Runnable {
    Category c;
    Category c1;
    Category oldC;
    CategoryForm cf;
    Form debug;
    Form filterForm;
    Form touchScreenMenu;
    ChoiceGroup cgtsm;
    CategoryStore cs;
    Alert alert;
    Display display;
    Font font;
    PreferenceForm pf;
    ChoiceGroup cgFilter;
    DateField dfFrom;
    DateField dfTo;
    FindForm ff;
    ViewForm vl;
    JabpLite parent;
    Date filterFromDate;
    Date filterToDate;
    Vector filterVector;
    int cameFrom;
    int filterTotal;
    String msg = "";
    Command filterCommand = new Command("Filter", 1, 5);
    Command topExpensesCommand = new Command("Top Expenses", 1, 5);
    boolean filterFlag = false;
    boolean paintWholeScreen = true;
    boolean paintHeaderOnly = false;
    int fs;
    int width;
    int height;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int numItems;
    int numItemsPage;
    int lineHeight;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int previousPos;
    int oldId;
    int startPos;
    int spacing;
    int numberWidth;
    int categoryWidth;
    int openPosition;
    int totalOpen;
    int currentPosition;
    int totalCurrent;
    int runMode;
    int minCategoryAmount;
    int maxCategoryAmount;
    long timePointerOnScreen;
    boolean pointerExecute;

    public CategoryView(JabpLite jabpLite, Display display) {
        this.parent = jabpLite;
        this.display = display;
        this.setFullScreenMode(this.parent.showFullCanvas);
        this.addCommand(this.parent.exitCommand);
        this.addCommand(this.parent.newCommand);
        this.addCommand(this.parent.editCommand);
        this.addCommand(this.parent.deleteCommand);
        this.addCommand(this.parent.showCommand);
        this.addCommand(this.parent.mainCommand);
        this.addCommand(this.parent.viewCommand);
        this.addCommand(this.parent.findCommand);
        this.addCommand(this.filterCommand);
        this.addCommand(this.topExpensesCommand);
        this.addCommand(this.parent.cancelCommand);
        this.setCommandListener(this);
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.alert.setTimeout(1500);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.cs = new CategoryStore(this.parent);
        this.numItems = this.cs.getNumCategories();
        this.setTotals();
        this.setPositions();
        this.currentX = 0;
        this.currentY = this.lineHeight;
        this.currentPos = 0;
        this.startPos = 0;
        this.runMode = 0;
        if (this.parent.isAndroid) {
            this.display.callSerially((Runnable)this);
        }
    }

    public void paint(Graphics graphics) {
        if (this.width != this.getWidth() || this.height != this.getHeight() - this.parent.heightAdjustment) {
            this.width = this.getWidth();
            this.height = this.getHeight() - this.parent.heightAdjustment;
            this.paintWholeScreen = true;
        }
        graphics.setFont(this.font);
        if (this.paintWholeScreen || this.parent.isBlackberry) {
            this.setPositions();
            this.showHeader(graphics);
            if (!this.paintHeaderOnly || this.parent.isBlackberry) {
                this.showPage(graphics);
                this.showFooter(graphics);
            }
        } else {
            this.showLines(graphics);
        }
        this.paintWholeScreen = true;
        this.paintHeaderOnly = false;
    }

    void showPage(Graphics graphics) {
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        graphics.setColor(this.parent.colorFont);
        if (this.numItems == 0) {
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                graphics.setColor(this.parent.colorCursor);
                graphics.fillRect(0, this.lineHeight * i + this.lineHeight, this.width, this.lineHeight);
                graphics.setColor(this.parent.colorFont);
            }
            this.c = this.cs.getCategoryFromIndex(i + this.startPos);
            this.c.open = 0;
            if (this.filterFlag) {
                int n = (Integer)this.filterVector.elementAt(i + this.startPos);
                if (this.width > 400) {
                    this.c.open = n;
                } else {
                    this.c.current = n;
                }
            }
            this.buildLine(graphics, this.c, this.lineHeight * i + this.lineHeight);
        }
        this.c = this.cs.getCategoryFromIndex(this.startPos + this.currentPos);
    }

    void showLines(Graphics graphics) {
        int n;
        if (this.numItems == 0) {
            return;
        }
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.lineHeight * this.previousPos + this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        this.c = this.cs.getCategoryFromIndex(this.previousPos + this.startPos);
        this.c.open = 0;
        if (this.filterFlag) {
            n = (Integer)this.filterVector.elementAt(this.previousPos + this.startPos);
            if (this.width > 400) {
                this.c.open = n;
            } else {
                this.c.current = n;
            }
        }
        this.buildLine(graphics, this.c, this.lineHeight * this.previousPos + this.lineHeight);
        graphics.setColor(this.parent.colorCursor);
        graphics.fillRect(0, this.lineHeight * this.currentPos + this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        this.c = this.cs.getCategoryFromIndex(this.currentPos + this.startPos);
        this.c.open = 0;
        if (this.filterFlag) {
            n = (Integer)this.filterVector.elementAt(this.currentPos + this.startPos);
            if (this.width > 400) {
                this.c.open = n;
            } else {
                this.c.current = n;
            }
        }
        this.buildLine(graphics, this.c, this.lineHeight * this.currentPos + this.lineHeight);
    }

    void showHeader(Graphics graphics) {
        int n = this.parent.lineSpacing + this.parent.fontAdjustment;
        if (this.msg.equals("")) {
            graphics.setColor(this.parent.colorHeading);
            graphics.fillRect(0, 0, this.width, this.lineHeight);
            graphics.setColor(this.parent.colorFont);
            String string = "Categories";
            if (this.filterFlag) {
                string = string + "[*]";
            }
            graphics.drawString(string, this.parent.widthAdjustment, n, 20);
            String string2 = "Filter";
            String string3 = "Current";
            if (this.filterFlag && this.width <= 400) {
                string3 = "Filter";
            }
            if (this.width > 400) {
                graphics.drawString(string2, this.openPosition + this.numberWidth - this.font.stringWidth(string2), n, 20);
            }
            graphics.drawString(string3, this.currentPosition + this.numberWidth - this.font.stringWidth(string3), n, 20);
        } else {
            graphics.setColor(this.parent.colorMessage);
            graphics.fillRect(0, 0, this.width, this.lineHeight);
            graphics.setColor(this.parent.colorFont);
            graphics.drawString(this.msg, this.parent.widthAdjustment, n, 20);
        }
    }

    void showFooter(Graphics graphics) {
        int n = this.height - this.lineHeight + this.parent.lineSpacing + this.parent.fontAdjustment;
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        graphics.drawString("Totals", this.parent.widthAdjustment, n, 20);
        String string = "";
        String string2 = "";
        if (this.filterFlag) {
            if (this.width > 400) {
                string = Utilities.numberToString(this.filterTotal, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
                string2 = Utilities.numberToString(this.totalCurrent, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            } else {
                string2 = Utilities.numberToString(this.filterTotal, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            }
        } else {
            string = Utilities.numberToString(this.totalOpen, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            string2 = Utilities.numberToString(this.totalCurrent, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        }
        if (this.width > 400) {
            graphics.drawString(string, this.openPosition + this.numberWidth - this.font.stringWidth(string), n, 20);
        }
        graphics.drawString(string2, this.currentPosition + this.numberWidth - this.font.stringWidth(string2), n, 20);
    }

    void drawUp() {
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.lineHeight;
            this.previousPos = this.currentPos--;
            if (this.currentY < this.lineHeight) {
                this.currentY = this.lineHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
            } else {
                this.paintWholeScreen = false;
            }
            this.repaint();
            this.serviceRepaints();
            return;
        }
    }

    void drawDown() {
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.lineHeight;
            this.previousPos = this.currentPos++;
            if (this.currentY + this.lineHeight * 2 > this.height) {
                this.currentY -= this.lineHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
            } else {
                this.paintWholeScreen = false;
            }
            this.repaint();
            this.serviceRepaints();
            return;
        }
    }

    void buildLine(Graphics graphics, Category category, int n) {
        int n2 = n + this.parent.lineSpacing + this.parent.fontAdjustment;
        int n3 = category.name.length();
        for (int i = 0; i < n3; ++i) {
            int n4 = n3 - i;
            if (this.font.stringWidth(category.name.substring(0, n4)) > this.categoryWidth) continue;
            graphics.drawString(category.name.substring(0, n4), this.parent.widthAdjustment, n2, 20);
            break;
        }
        String string = "";
        if (this.width > 400) {
            string = Utilities.numberToString(category.open, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            graphics.drawString(string, this.openPosition + this.numberWidth - this.font.stringWidth(string), n2, 20);
        }
        string = Utilities.numberToString(category.current, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        graphics.drawString(string, this.currentPosition + this.numberWidth - this.font.stringWidth(string), n2, 20);
    }

    void setPositions() {
        this.fs = 8;
        if (this.parent.mediumSize) {
            this.fs = 0;
        }
        if (this.parent.largeSize) {
            this.fs = 16;
        }
        this.font = Font.getFont((int)0, (int)0, (int)this.fs);
        this.fontHeight = this.font.getHeight();
        this.lineHeight = this.fontHeight + this.parent.lineSpacing * 2;
        this.numberWidth = this.minCategoryAmount < -9999999 || this.maxCategoryAmount > 99999999 ? (this.parent.isGroupingUsed ? this.font.stringWidth("9,999,999.99") : this.font.stringWidth("9999999.99")) : (this.minCategoryAmount < -999999 || this.maxCategoryAmount > 9999999 ? (this.parent.isGroupingUsed ? this.font.stringWidth("999,999.99") : this.font.stringWidth("999999.99")) : (this.minCategoryAmount < -99999 || this.maxCategoryAmount > 999999 ? (this.parent.isGroupingUsed ? this.font.stringWidth("99,999.99") : this.font.stringWidth("99999.99")) : (this.parent.isGroupingUsed ? this.font.stringWidth("9,999.99") : this.font.stringWidth("9999.99"))));
        this.numItemsPage = this.height / this.lineHeight - 2;
        this.spacing = 10;
        if (this.width > 500) {
            this.spacing = 20;
        }
        if (this.width > 640) {
            this.spacing = 30;
        }
        this.categoryWidth = this.width - this.numberWidth - this.parent.widthAdjustment * 2 - this.spacing;
        if (this.width > 640) {
            this.categoryWidth -= 250;
        }
        if (this.width > 500) {
            this.categoryWidth -= 100;
        }
        if (this.width > 400) {
            this.categoryWidth = this.categoryWidth - this.numberWidth - this.spacing;
            this.openPosition = this.categoryWidth + this.parent.widthAdjustment + this.spacing;
            this.currentPosition = this.openPosition + this.numberWidth + this.spacing;
        } else {
            this.currentPosition = this.categoryWidth + this.parent.widthAdjustment + this.spacing;
        }
    }

    Category showCategory() {
        this.oldC = new Category();
        this.oldC.clone(this.c);
        return this.c;
    }

    void newCategory(Category category) {
        this.c1 = category;
        this.c1.id = this.cs.saveNewCategory(this.c1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.cs.toByteArray(this.c1), 2);
        }
        if (this.c == null) {
            this.c = this.c1;
        }
        ++this.numItems;
        this.totalCurrent += this.c1.current;
        this.checkMinMax(this.c1);
        this.runMode = 4;
        this.display.callSerially((Runnable)this);
        this.repaint();
    }

    void editCategory(Category category) {
        this.c1 = category;
        this.cs.saveExistingCategory(this.c1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.cs.toByteArray(this.c1), 2);
        }
        this.totalCurrent += this.c1.current - this.oldC.current;
        this.checkMinMax(this.c1);
        if (!this.c1.name.equals(this.oldC.name)) {
            this.runMode = 1;
            this.display.callSerially((Runnable)this);
        } else {
            if (this.parent.syncMode) {
                this.parent.sync.saveSyncRecord(this.cs.toByteArray(this.oldC), -2);
            }
            this.msg = "";
        }
        this.repaint();
    }

    void deleteCategory(Category category) {
        this.c1 = category;
        this.cs.deleteCategory(this.c1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.cs.toByteArray(this.c1), -2);
        }
        this.cs.deleteIndex(this.startPos + this.currentPos);
        this.totalCurrent -= this.c1.current;
        RegularStore regularStore = new RegularStore(this.parent);
        RecordEnumeration recordEnumeration = regularStore.getRegulars();
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                Regular regular = regularStore.getRegular(n);
                if (!regular.category.equals(this.c1.name)) continue;
                regularStore.deleteRegular(regular);
                int n2 = regularStore.lookUpIndex(regular);
                regularStore.deleteIndex(n2);
                if (!this.parent.syncMode) continue;
                this.parent.sync.saveSyncRecord(regularStore.toByteArray(regular), -5);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " cv5c");
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        regularStore.closeRegularStore();
        regularStore = null;
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.lineHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.runMode = 4;
        this.display.callSerially((Runnable)this);
        this.repaint();
    }

    void checkMinMax(Category category) {
        this.minCategoryAmount = Math.min(this.minCategoryAmount, category.current);
        this.maxCategoryAmount = Math.max(this.maxCategoryAmount, category.current);
        this.minCategoryAmount = Math.min(this.minCategoryAmount, this.totalCurrent);
        this.maxCategoryAmount = Math.max(this.maxCategoryAmount, this.totalCurrent);
    }

    void setTotals() {
        this.totalCurrent = 0;
        this.minCategoryAmount = 0;
        this.maxCategoryAmount = 0;
        if (this.numItems <= 0) {
            return;
        }
        for (int i = 0; i < this.numItems; ++i) {
            this.c = this.cs.getCategoryFromIndex(i);
            this.totalOpen += this.c.open;
            this.totalCurrent += this.c.current;
            this.minCategoryAmount = Math.min(this.minCategoryAmount, this.c.current);
            this.maxCategoryAmount = Math.max(this.maxCategoryAmount, this.c.current);
        }
        this.minCategoryAmount = Math.min(this.minCategoryAmount, this.totalCurrent);
        this.maxCategoryAmount = Math.max(this.maxCategoryAmount, this.totalCurrent);
        this.c = this.cs.getCategoryFromIndex(0);
    }

    void updateCategoryName() {
        Object object;
        this.cs.deleteIndex(this.startPos + this.currentPos);
        this.cs.addIndex(this.c1);
        TransactionStore transactionStore = new TransactionStore(this.parent, new Account());
        RecordEnumeration recordEnumeration = transactionStore.getTransactions();
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                Transaction transaction = transactionStore.getTransaction(n);
                object = transactionStore.getTransaction(n);
                if (transaction.splitFlag) {
                    boolean bl = false;
                    for (int i = 0; i < transaction.ss.size(); ++i) {
                        Split split = transaction.ss.getSplit(i);
                        if (!split.category.equals(this.oldC.name)) continue;
                        split.category = this.c1.name;
                        transaction.ss.setSplit(split, i);
                        bl = true;
                    }
                    if (!bl) continue;
                    if (this.parent.syncMode) {
                        this.parent.sync.saveSyncRecord(transactionStore.toByteArray((Transaction)object), -8);
                    }
                    transactionStore.saveExistingTransaction(transaction);
                    if (!this.parent.syncMode) continue;
                    this.parent.sync.saveSyncRecord(transactionStore.toByteArray(transaction), 8);
                    continue;
                }
                if (!transaction.category.equals(this.oldC.name)) continue;
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(transactionStore.toByteArray(transaction), -8);
                }
                transaction.category = this.c1.name;
                transactionStore.saveExistingTransaction(transaction);
                if (!this.parent.syncMode) continue;
                this.parent.sync.saveSyncRecord(transactionStore.toByteArray(transaction), 8);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " cv5");
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        transactionStore.closeTransactionStore();
        transactionStore = null;
        StandingOrderStore standingOrderStore = new StandingOrderStore(this.parent);
        recordEnumeration = standingOrderStore.getStandingOrders();
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                object = standingOrderStore.getStandingOrder(n);
                if (!((StandingOrder)object).category.equals(this.oldC.name)) continue;
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(standingOrderStore.toByteArray((StandingOrder)object), -6);
                }
                ((StandingOrder)object).category = this.c1.name;
                standingOrderStore.saveExistingStandingOrder((StandingOrder)object);
                if (!this.parent.syncMode) continue;
                this.parent.sync.saveSyncRecord(standingOrderStore.toByteArray((StandingOrder)object), 6);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " cv5a");
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        standingOrderStore.closeStandingOrderStore();
        standingOrderStore = null;
        RegularStore regularStore = new RegularStore(this.parent);
        recordEnumeration = regularStore.getRegulars();
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                Regular regular = regularStore.getRegular(n);
                if (!regular.category.equals(this.oldC.name)) continue;
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(regularStore.toByteArray(regular), -5);
                }
                regular.category = this.c1.name;
                regularStore.saveExistingRegular(regular);
                if (!this.parent.syncMode) continue;
                this.parent.sync.saveSyncRecord(regularStore.toByteArray(regular), 5);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " cv5b");
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        regularStore.closeRegularStore();
        regularStore = null;
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.cs.toByteArray(this.oldC), -2);
        }
        if (this.parent.tv != null) {
            this.parent.tv.runThread();
        }
        if (this.parent.sov != null) {
            this.parent.sov.runThread();
        }
        this.setUpForm2();
        this.msg = "";
        this.repaint();
    }

    protected void showNotify() {
        this.repaint();
    }

    void setUpForm2() {
        if (!this.parent.createFormsInBackground) {
            this.parent.tf2a = new TransactionForm(this.parent);
            this.parent.tf2b = new TransactionForm(this.parent);
            return;
        }
        this.show("Creating forms in background...", false);
        this.parent.tf2a.build(false, this.parent.showMatchedCategories, false);
        this.parent.tf2b.build(false, this.parent.showMatchedCategories, true);
        this.show("", false);
    }

    void show(String string, boolean bl) {
        this.paintHeaderOnly = bl;
        this.msg = string;
        this.repaint();
        this.serviceRepaints();
    }

    void processFind() {
        if (this.filterFromDate == null) {
            this.filterFromDate = this.parent.todayDate;
        }
        if (this.filterToDate == null) {
            this.filterToDate = this.parent.todayDate;
        }
        long l = Utilities.longToDays(this.filterFromDate.getTime());
        long l2 = Utilities.longToDays(this.filterToDate.getTime());
        this.ff.execute2(this.c.name, this.filterFlag, l, l2);
        this.ff = null;
        this.msg = "";
        FindView findView = new FindView(this.parent, this.display, this.c.name, true);
        this.display.setCurrent((Displayable)findView);
    }

    void processFilter() {
        this.msg = "Processing, please wait...";
        this.repaint();
        this.serviceRepaints();
        TransactionStore transactionStore = new TransactionStore(this.parent, new Account());
        this.filterVector = transactionStore.buildCategoriesFromDates(this.filterFromDate, this.filterToDate);
        transactionStore.closeTransactionStore();
        this.filterTotal = 0;
        int n = this.filterVector.size();
        for (int i = 0; i < n; ++i) {
            this.filterTotal += ((Integer)this.filterVector.elementAt(i)).intValue();
        }
        this.msg = "";
        this.filterFlag = true;
        this.repaint();
        if (this.cameFrom == 1) {
            this.display.setCurrent((Displayable)this);
        } else {
            TopExpensesView topExpensesView = new TopExpensesView(this.parent, this.display, true, this.filterVector);
            this.display.setCurrent((Displayable)topExpensesView);
        }
    }

    void androidDelay() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void run() {
        if (this.runMode == 0) {
            this.androidDelay();
        }
        if (this.runMode == 1) {
            this.updateCategoryName();
        }
        if (this.runMode == 2) {
            this.processFind();
        }
        if (this.runMode == 3) {
            this.processFilter();
        }
        if (this.runMode == 4) {
            this.setUpForm2();
        }
    }

    protected void keyPressed(int n) {
        if (this.getGameAction(n) == 2) {
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.lineHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (this.getGameAction(n) == 5) {
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
            this.repaint();
            return;
        }
        if (this.getGameAction(n) == 8) {
            this.displayTouchScreenMenu();
            return;
        }
        if (this.getGameAction(n) == 1) {
            this.drawUp();
            return;
        }
        if (this.getGameAction(n) == 6) {
            this.drawDown();
            return;
        }
        if (n == 48) {
            int n2 = this.startPos + this.currentPos;
            this.debug = new Form("Record Properties");
            this.debug.append("Position " + n2 + " of " + this.numItems + "\n");
            short s = (short)n2;
            int n3 = ((NameId)this.cs.ht.get((Object)new Short((short)s))).id;
            this.debug.append("Record ID " + n3 + "\n");
            this.debug.append("Record length " + this.cs.getRecordSize(n3) + "\n");
            this.debug.append("RecordStore size " + this.cs.getSize() + "\n");
            this.debug.addCommand(this.parent.okCommand);
            this.debug.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.debug);
        }
    }

    protected void pointerPressed(int n, int n2) {
        this.pointerExecute = false;
        this.timePointerOnScreen = System.currentTimeMillis();
        if (n2 < this.lineHeight) {
            this.keyPressed(this.getKeyCode(2));
            return;
        }
        if (n2 > this.height - this.lineHeight) {
            this.keyPressed(this.getKeyCode(5));
            return;
        }
        this.pointerExecute = true;
        int n3 = (n2 - this.lineHeight) / this.lineHeight;
        if (n3 >= this.numItems) {
            return;
        }
        this.previousPos = this.currentPos;
        this.currentPos = n3;
        this.currentY = (this.currentPos + 1) * this.lineHeight;
        this.paintWholeScreen = true;
        this.repaint();
    }

    protected void pointerReleased(int n, int n2) {
        this.timePointerOnScreen = System.currentTimeMillis() - this.timePointerOnScreen;
        if (this.timePointerOnScreen > 1000L) {
            this.displayTouchScreenMenu();
            return;
        }
        if (!this.pointerExecute) {
            return;
        }
        this.displayTouchScreenMenu();
    }

    void displayTouchScreenMenu() {
        this.touchScreenMenu = new Form("Category Menu");
        this.cgtsm = new ChoiceGroup("Choose an option", 1);
        this.cgtsm.append("New", null);
        this.cgtsm.append("Edit", null);
        this.cgtsm.append("Delete", null);
        this.cgtsm.append("Show", null);
        this.cgtsm.append("Main", null);
        this.cgtsm.append("Switch Views", null);
        this.cgtsm.append("Find", null);
        this.cgtsm.append("Filter", null);
        this.cgtsm.append("Top Expenses", null);
        this.cgtsm.append("Exit", null);
        this.touchScreenMenu.append((Item)this.cgtsm);
        this.touchScreenMenu.addCommand(this.parent.okCommand);
        this.touchScreenMenu.addCommand(this.parent.cancelCommand);
        this.touchScreenMenu.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.touchScreenMenu);
    }

    void setFilterForm() {
        this.filterForm = new Form("Filter");
        this.cgFilter = new ChoiceGroup("Set", 1);
        this.cgFilter.append("Filter Off", null);
        this.cgFilter.append("Filter On", null);
        if (this.filterFlag) {
            this.cgFilter.setSelectedIndex(1, true);
        } else {
            this.cgFilter.setSelectedIndex(0, true);
        }
        this.filterForm.append((Item)this.cgFilter);
        if (this.filterFromDate == null) {
            this.filterFromDate = this.parent.todayDate;
        }
        if (this.filterToDate == null) {
            this.filterToDate = this.parent.todayDate;
        }
        this.dfFrom = new DateField("From Date", 1);
        this.dfFrom.setDate(this.filterFromDate);
        this.dfTo = new DateField("To Date", 1);
        this.dfTo.setDate(this.filterToDate);
        this.filterForm.append((Item)this.dfFrom);
        this.filterForm.append((Item)this.dfTo);
        this.filterForm.addCommand(this.parent.okCommand);
        this.filterForm.addCommand(this.parent.cancelCommand);
        this.filterForm.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.filterForm);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.parent.exitCommand) {
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this) {
            if (command == this.parent.newCommand) {
                this.cf = new CategoryForm(this.parent, new Category(), "New");
                this.cf.addCommand(this.parent.createCommand);
                this.cf.addCommand(this.parent.cancelCommand);
                this.cf.addCommand(this.parent.exitCommand);
                this.cf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.cf);
            }
            if (command == this.parent.editCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("No categories set up");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.msg = "Updating category, please wait...";
                this.repaint();
                this.cf = new CategoryForm(this.parent, this.showCategory(), "Edit");
                this.cf.addCommand(this.parent.updateCommand);
                this.cf.addCommand(this.parent.cancelCommand);
                this.cf.addCommand(this.parent.exitCommand);
                this.cf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.cf);
            }
            if (command == this.parent.deleteCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("No categories set up");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.cf = new CategoryForm(this.parent, this.showCategory(), "Delete");
                this.cf.addCommand(this.parent.deleteCommand);
                this.cf.addCommand(this.parent.cancelCommand);
                this.cf.addCommand(this.parent.exitCommand);
                this.cf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.cf);
            }
            if (command == this.parent.showCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("No categories set up");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.cf = new CategoryForm(this.parent, this.showCategory(), "Show");
                this.cf.addCommand(this.parent.okCommand);
                this.cf.addCommand(this.parent.exitCommand);
                this.cf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.cf);
            }
            if (command == this.parent.mainCommand) {
                this.display.setCurrent((Displayable)this.parent.av);
            }
            if (command == this.parent.viewCommand) {
                this.vl = new ViewForm();
                this.vl.addCommand(this.parent.okCommand);
                this.vl.addCommand(this.parent.cancelCommand);
                this.vl.addCommand(this.parent.exitCommand);
                this.vl.setCommandListener(this);
                this.display.setCurrent((Displayable)this.vl);
            }
            if (command == this.parent.findCommand) {
                this.msg = "Processing, please wait...";
                this.repaint();
                this.ff = new FindForm(this.parent, false);
                this.repaint();
                this.runMode = 2;
                this.display.callSerially((Runnable)this);
            }
            if (command == this.filterCommand) {
                this.cameFrom = 1;
                this.setFilterForm();
            }
            if (command == this.topExpensesCommand) {
                this.cameFrom = 2;
                this.setFilterForm();
            }
        }
        if (displayable == this.cf) {
            if (command == this.parent.deleteCommand) {
                this.cf = null;
                if (this.c.current != 0 || this.c.open != 0) {
                    this.alert.setString("Cannot delete, there are balances");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                StandingOrderStore standingOrderStore = new StandingOrderStore(this.parent);
                RecordEnumeration recordEnumeration = standingOrderStore.getStandingOrders();
                try {
                    while (recordEnumeration.hasNextElement()) {
                        int n = recordEnumeration.nextRecordId();
                        StandingOrder standingOrder = standingOrderStore.getStandingOrder(n);
                        if (!standingOrder.category.equals(this.c.name)) continue;
                        this.alert.setString("Cannot delete, there are standing orders");
                        this.display.setCurrent(this.alert, (Displayable)this);
                        recordEnumeration.destroy();
                        recordEnumeration = null;
                        standingOrderStore.closeStandingOrderStore();
                        standingOrderStore = null;
                        return;
                    }
                }
                catch (RecordStoreException recordStoreException) {
                    System.err.println((Object)((Object)recordStoreException) + " cv5a");
                }
                recordEnumeration.destroy();
                recordEnumeration = null;
                standingOrderStore.closeStandingOrderStore();
                standingOrderStore = null;
                this.display.setCurrent((Displayable)this);
                this.deleteCategory(this.c);
                this.parent.tf2 = null;
            }
            if (command == this.parent.okCommand) {
                this.msg = "";
                this.cf = null;
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.createCommand) {
                this.c1 = this.cf.update();
                if (this.c1.name.equals("")) {
                    this.alert.setString("Blank category name");
                    this.display.setCurrent(this.alert, (Displayable)this.cf);
                    return;
                }
                if (this.cs.lookUpId(this.c1) != 0) {
                    this.alert.setString(this.c1.name + " already exists");
                    this.display.setCurrent(this.alert, (Displayable)this.cf);
                    return;
                }
                this.display.setCurrent((Displayable)this);
                this.newCategory(this.c1);
                this.cf = null;
                this.parent.tf2 = null;
            }
            if (command == this.parent.updateCommand) {
                this.c1 = this.cf.update();
                if (this.c1.name.equals("")) {
                    this.alert.setString("Blank category name");
                    this.display.setCurrent(this.alert, (Displayable)this.cf);
                    return;
                }
                int n = this.c1.id;
                if (!this.c1.name.equals(this.oldC.name) && this.cs.lookUpId(this.c1) != 0) {
                    this.alert.setString(this.c1.name + " already exists");
                    this.display.setCurrent(this.alert, (Displayable)this.cf);
                    return;
                }
                this.c1.id = n;
                this.display.setCurrent((Displayable)this);
                this.editCategory(this.c1);
                this.cf = null;
                this.parent.tf2 = null;
            }
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.cf = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.vl) {
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.vl = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                if (this.vl.update() == 0) {
                    this.display.setCurrent((Displayable)this.parent.av);
                }
                if (this.vl.update() == 1) {
                    if (this.parent.tv == null) {
                        this.alert.setString("No account selected");
                        this.display.setCurrent(this.alert, (Displayable)this);
                    } else {
                        this.display.setCurrent((Displayable)this.parent.tv);
                    }
                }
                if (this.vl.update() == 2) {
                    this.display.setCurrent((Displayable)this);
                }
                if (this.vl.update() == 3) {
                    if (this.parent.sov == null) {
                        this.parent.sov = new StandingOrderView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.sov);
                }
                if (this.vl.update() == 4) {
                    if (this.parent.iv == null) {
                        this.parent.iv = new InvestmentView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.iv);
                }
                if (this.vl.update() == 5) {
                    if (this.parent.ccyv == null) {
                        this.parent.ccyv = new CurrencyView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.ccyv);
                }
            }
        }
        if (displayable == this.filterForm) {
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.filterForm = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                if (this.cgFilter.getSelectedIndex() == 1) {
                    this.filterFromDate = this.dfFrom.getDate();
                    this.filterToDate = this.dfTo.getDate();
                    this.filterForm = null;
                    this.display.setCurrent((Displayable)this);
                    this.runMode = 3;
                    this.display.callSerially((Runnable)this);
                } else {
                    this.filterFlag = false;
                    this.filterForm = null;
                    if (this.cameFrom == 1) {
                        this.display.setCurrent((Displayable)this);
                    } else {
                        TopExpensesView topExpensesView = new TopExpensesView(this.parent, this.display, false, null);
                        this.display.setCurrent((Displayable)topExpensesView);
                    }
                }
            }
        }
        if (displayable == this.debug) {
            this.debug = null;
            this.display.setCurrent((Displayable)this);
        }
        if (displayable == this.touchScreenMenu) {
            if (command == this.parent.okCommand) {
                int n = this.cgtsm.getSelectedIndex();
                if (n == 0) {
                    this.commandAction(this.parent.newCommand, (Displayable)this);
                }
                if (n == 1) {
                    this.commandAction(this.parent.editCommand, (Displayable)this);
                }
                if (n == 2) {
                    this.commandAction(this.parent.deleteCommand, (Displayable)this);
                }
                if (n == 3) {
                    this.commandAction(this.parent.showCommand, (Displayable)this);
                }
                if (n == 4) {
                    this.commandAction(this.parent.mainCommand, (Displayable)this);
                }
                if (n == 5) {
                    this.commandAction(this.parent.viewCommand, (Displayable)this);
                }
                if (n == 6) {
                    this.commandAction(this.parent.findCommand, (Displayable)this);
                }
                if (n == 7) {
                    this.commandAction(this.filterCommand, (Displayable)this);
                }
                if (n == 8) {
                    this.commandAction(this.topExpensesCommand, (Displayable)this);
                }
                if (n == 9) {
                    this.parent.destroyApp(true);
                }
            } else {
                this.touchScreenMenu = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
    }
}

