/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.AccountStore;
import JabpLite.Category;
import JabpLite.CategoryStore;
import JabpLite.Currency;
import JabpLite.CurrencyStore;
import JabpLite.JabpLite;
import JabpLite.StandingOrder;
import JabpLite.Utilities;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class StandingOrderForm
extends Form
implements Runnable {
    boolean ready = false;
    StandingOrder so;
    StandingOrder so1;
    String s1;
    JabpLite parent;
    DateField df1;
    DateField df2;
    TextField tfDescription;
    TextField tfReference;
    TextField tfAmount;
    TextField tfInterval;
    ChoiceGroup cgDRCR;
    ChoiceGroup cgPeriod;
    ChoiceGroup cgAccount;
    ChoiceGroup cgCategory;
    ChoiceGroup cgCurrency;
    ChoiceGroup cgTransfer;

    public StandingOrderForm(JabpLite jabpLite) {
        super("New Standing Order");
        this.parent = jabpLite;
    }

    void build() {
        if (!this.parent.isAndroid) {
            this.append("Building form ... please wait");
        }
        this.tfDescription = new TextField("Description", "", 64, 0);
        this.append((Item)this.tfDescription);
        int n = 2;
        if (!this.parent.numericEntry) {
            n = 0;
        }
        this.tfAmount = new TextField("Amount", "", 64, n);
        this.append((Item)this.tfAmount);
        int n2 = 4;
        if (this.parent.oldStyleChoice) {
            n2 = 1;
        }
        this.cgDRCR = new ChoiceGroup("DR/CR", n2);
        this.cgDRCR.append("Debit", null);
        this.cgDRCR.append("Credit", null);
        this.append((Item)this.cgDRCR);
        this.tfReference = new TextField("Reference", "", 64, 0);
        this.append((Item)this.tfReference);
        this.df1 = new DateField("Processing Date", 1);
        this.df1.setDate(this.parent.todayDate);
        this.append((Item)this.df1);
        this.df2 = new DateField("End Date", 1);
        this.df2.setDate(this.parent.todayDate);
        this.append((Item)this.df2);
        this.cgPeriod = new ChoiceGroup("Period", n2);
        this.cgPeriod.append("Yearly", null);
        this.cgPeriod.append("Monthly", null);
        this.cgPeriod.append("Daily", null);
        this.append((Item)this.cgPeriod);
        this.tfInterval = new TextField("Interval", "", 2, 2);
        this.append((Item)this.tfInterval);
        this.cgTransfer = new ChoiceGroup("Transfer", n2);
        this.cgTransfer.append("No", null);
        this.cgTransfer.append("Yes", null);
        this.append((Item)this.cgTransfer);
        this.cgAccount = new ChoiceGroup("Account", n2);
        AccountStore accountStore = new AccountStore(this.parent);
        int n3 = accountStore.getNumAccounts();
        for (int i = 0; i < n3; ++i) {
            Account account = accountStore.getAccountFromIndex(i);
            this.cgAccount.append(account.name, null);
        }
        this.append((Item)this.cgAccount);
        accountStore.closeAccountStore();
        accountStore = null;
        this.cgCategory = new ChoiceGroup("Category", n2);
        CategoryStore categoryStore = new CategoryStore(this.parent);
        n3 = categoryStore.getNumCategories();
        for (int i = 0; i < n3; ++i) {
            Category category = categoryStore.getCategoryFromIndex(i);
            this.cgCategory.append(category.name, null);
        }
        this.append((Item)this.cgCategory);
        categoryStore.closeCategoryStore();
        categoryStore = null;
        this.cgCurrency = new ChoiceGroup("Currency", n2);
        CurrencyStore currencyStore = new CurrencyStore(this.parent);
        n3 = currencyStore.getNumCurrencies();
        for (int i = 0; i < n3; ++i) {
            Currency currency = currencyStore.getCurrencyFromIndex(i);
            this.cgCurrency.append(currency.code, null);
            if (!currency.code.equals(this.parent.homeCurrency)) continue;
            this.cgCurrency.setSelectedIndex(i, true);
        }
        this.append((Item)this.cgCurrency);
        currencyStore.closeCurrencyStore();
        currencyStore = null;
        if (!this.parent.isAndroid) {
            this.delete(0);
        }
        this.ready = true;
    }

    void show(StandingOrder standingOrder, String string) {
        if (this.parent.isAndroid) {
            while (this.size() > 0) {
                this.delete(0);
            }
        }
        this.setTitle(string + " Standing Order");
        this.append("Desc: " + standingOrder.description + "\n");
        String string2 = " DR";
        if (standingOrder.amount >= 0) {
            string2 = " CR";
        }
        this.append("Amount: " + Utilities.numberToString(Math.abs(standingOrder.amount), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + string2 + "\n");
        this.append("Ref: " + standingOrder.reference + "\n");
        this.append("Start Date: " + this.showDate(standingOrder.longStartDate) + "\n");
        this.append("Next Date: " + this.showDate(standingOrder.longProcessingDate) + "\n");
        this.append("End Date: " + this.showDate(standingOrder.longEndDate) + "\n");
        if (standingOrder.period == 0) {
            string2 = "Yearly";
        }
        if (standingOrder.period == 1) {
            string2 = "Monthly";
        }
        if (standingOrder.period == 2) {
            string2 = "Daily";
        }
        this.append("Period: " + string2 + "\n");
        this.append("Interval: " + standingOrder.interval + "\n");
        string2 = standingOrder.transferFlag ? "Yes (" + standingOrder.transferAccount + ")" : "No";
        this.append("Transfer: " + string2 + "\n");
        this.append("Account: " + standingOrder.account + "\n");
        if (standingOrder.transferFlag) {
            return;
        }
        this.append("Category: " + standingOrder.category);
    }

    StandingOrder update() {
        String string;
        this.so.description = this.tfDescription.getString();
        int n = this.so.amount;
        this.so.amount = Utilities.stringToNumber(this.tfAmount.getString(), n, this.parent.numericEntry, this.parent.isEuropeanNumberFormat);
        if (this.cgDRCR.getSelectedIndex() == 0) {
            this.so.amount = -this.so.amount;
        }
        if (!(string = this.cgCurrency.getString(this.cgCurrency.getSelectedIndex())).equals(this.parent.homeCurrency)) {
            CurrencyStore currencyStore = new CurrencyStore(this.parent);
            Currency currency = currencyStore.getCurrencyFromName(string);
            this.so.amount = Utilities.foreignToHome(this.so.amount, currency.rate);
            currency = null;
            currencyStore.closeCurrencyStore();
            currencyStore = null;
        }
        this.so.reference = this.tfReference.getString();
        this.so.longProcessingDate = this.df1.getDate().getTime();
        this.so.longEndDate = this.df2.getDate().getTime();
        this.so.longStartDate = this.so.longProcessingDate;
        this.so.period = this.cgPeriod.getSelectedIndex();
        this.so.interval = Integer.valueOf(this.tfInterval.getString());
        this.so.account = this.cgAccount.getString(this.cgAccount.getSelectedIndex());
        this.so.transferFlag = this.cgTransfer.getSelectedIndex() != 0;
        if (this.so.transferFlag) {
            return this.so;
        }
        this.so.category = this.cgCategory.getString(this.cgCategory.getSelectedIndex());
        return this.so;
    }

    void set(StandingOrder standingOrder, String string) {
        this.so = standingOrder;
        this.s1 = string;
        if (this.ready) {
            this.run();
        } else {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void run() {
        this.setTitle(this.s1 + " Standing Order");
        this.tfDescription.setString(this.so.description);
        String string = "";
        if (this.so.amount != 0) {
            string = Utilities.numberToString(Math.abs(this.so.amount), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false);
        }
        this.tfAmount.setString(string);
        if (this.so.amount <= 0) {
            this.cgDRCR.setSelectedIndex(0, true);
        } else {
            this.cgDRCR.setSelectedIndex(1, true);
        }
        this.tfReference.setString(this.so.reference);
        if (this.s1.equals("New")) {
            this.df1.setDate(this.parent.todayDate);
            this.df2.setDate(this.parent.todayDate);
        } else {
            this.parent.genericDate.setTime(this.so.longProcessingDate + 3600000L);
            this.df1.setDate(this.parent.genericDate);
            this.parent.genericDate.setTime(this.so.longEndDate + 3600000L);
            this.df2.setDate(this.parent.genericDate);
        }
        this.cgPeriod.setSelectedIndex(this.so.period, true);
        String string2 = "";
        this.tfInterval.setString(String.valueOf(this.so.interval));
        if (!this.so.transferFlag) {
            this.cgTransfer.setSelectedIndex(0, true);
        }
        if (this.so.transferFlag) {
            this.cgTransfer.setSelectedIndex(1, true);
        }
        while (!this.ready) {
        }
        AccountStore accountStore = new AccountStore(this.parent);
        int n = accountStore.getNumAccounts();
        for (int i = 0; i < n; ++i) {
            Account account = accountStore.getAccountFromIndex(i);
            if (!account.name.equals(this.so.account)) continue;
            this.cgAccount.setSelectedIndex(i, true);
            break;
        }
        accountStore.closeAccountStore();
        accountStore = null;
        CategoryStore categoryStore = new CategoryStore(this.parent);
        n = categoryStore.getNumCategories();
        for (int i = 0; i < n; ++i) {
            Category category = categoryStore.getCategoryFromIndex(i);
            if (!category.name.equals(this.so.category)) continue;
            this.cgCategory.setSelectedIndex(i, true);
            break;
        }
        categoryStore.closeCategoryStore();
        categoryStore = null;
    }

    String showDate(long l) {
        this.parent.genericDate.setTime(l + 3600000L);
        this.parent.cal.setTime(this.parent.genericDate);
        String string = "" + this.parent.cal.get(5);
        if (string.length() < 2) {
            string = "0" + string;
        }
        int n = this.parent.cal.get(2) + 1;
        String string2 = "" + n;
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        String string3 = ("" + this.parent.cal.get(1)).substring(2, 4);
        if (this.parent.dateFormat == 0 || this.parent.dateFormat == 2) {
            return string + "/" + string2 + "/" + string3;
        }
        if (this.parent.dateFormat == 1 || this.parent.dateFormat == 3) {
            return string2 + "/" + string + "/" + string3;
        }
        return "";
    }
}

