/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.Category;
import JabpLite.CategoryForm;
import JabpLite.CategoryStore;
import JabpLite.CategoryView;
import JabpLite.CurrencyStore;
import JabpLite.CurrencyView;
import JabpLite.GoToDateForm;
import JabpLite.InvestmentView;
import JabpLite.JabpLite;
import JabpLite.LongId;
import JabpLite.MoveForm;
import JabpLite.NameId;
import JabpLite.Regular;
import JabpLite.RegularForm;
import JabpLite.RegularForm2;
import JabpLite.RegularStore;
import JabpLite.Split;
import JabpLite.SplitForm;
import JabpLite.SplitStore;
import JabpLite.StandingOrder;
import JabpLite.StandingOrderForm;
import JabpLite.StandingOrderStore;
import JabpLite.StandingOrderView;
import JabpLite.Transaction;
import JabpLite.TransactionForm;
import JabpLite.TransactionStore;
import JabpLite.TransferForm;
import JabpLite.Utilities;
import JabpLite.ViewForm;
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class TransactionView
extends Canvas
implements CommandListener,
Runnable {
    Account a;
    Transaction t;
    Transaction t1;
    Transaction oldT;
    CategoryForm cf;
    Regular r;
    Regular r1;
    RegularForm rf;
    RegularForm2 rf2;
    RegularStore rs;
    SplitForm sf;
    TransactionForm tf3;
    TransferForm trf;
    StandingOrderForm sof;
    TextField tf;
    Form debug;
    Form newStar;
    Form touchScreenMenu;
    ChoiceGroup cgtsm;
    TransactionStore ts;
    Alert alert;
    Display display;
    Font font;
    JabpLite parent;
    ViewForm vl;
    GoToDateForm gtdf;
    MoveForm mf;
    Date date;
    String msg = "";
    String oldName = "";
    boolean paintWholeScreen = true;
    boolean showedOutOfSpaceMessage = false;
    boolean isSplit = false;
    int rt;
    int fs;
    int width;
    int height;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int numItems;
    int numItemsPage;
    int lineHeight;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int previousPos;
    int oldId;
    int startPos;
    int dateWidth;
    int numberWidth;
    int reconciledWidth;
    int descriptionWidth;
    int descriptionPosition;
    int amountPosition;
    int spacing;
    int referenceWidth;
    int referencePosition;
    int categoryWidth;
    int categoryPosition;
    int runMode;
    int minDescriptionWidth;
    int currencyRate;
    int saveAsRegularFlag = 0;
    int storeMatchedPosition = 0;
    String matchedString = "";
    String showMatchedCategories = "";
    long timePointerOnScreen;
    boolean pointerExecute;

    public TransactionView(JabpLite jabpLite, Display display, Account account) {
        this.parent = jabpLite;
        this.display = display;
        this.setFullScreenMode(this.parent.showFullCanvas);
        this.a = account;
        this.addCommand(this.parent.exitCommand);
        this.addCommand(this.parent.newCommand);
        this.addCommand(this.parent.regularCommand);
        this.addCommand(this.parent.newStarCommand);
        this.addCommand(this.parent.newSplitCommand);
        this.addCommand(this.parent.saveAsRegularCommand);
        this.addCommand(this.parent.saveAsStandingOrderCommand);
        this.addCommand(this.parent.editCommand);
        this.addCommand(this.parent.deleteCommand);
        this.addCommand(this.parent.reconcileCommand);
        this.addCommand(this.parent.showCommand);
        this.addCommand(this.parent.moveCommand);
        this.addCommand(this.parent.mainCommand);
        this.addCommand(this.parent.toggleRCCommand);
        this.addCommand(this.parent.toggleDefaultActionCommand);
        this.addCommand(this.parent.viewCommand);
        this.addCommand(this.parent.goToDateCommand);
        this.addCommand(this.parent.cancelCommand);
        this.setCommandListener(this);
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.alert.setTimeout(1500);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.setPositions();
        this.saveAsRegularFlag = 0;
        this.rs = new RegularStore(this.parent);
        this.ts = new TransactionStore(this.parent, this.a);
        this.numItems = this.ts.getNumTransactions();
        this.rt = this.a.current;
        if (!this.a.currency.equals(this.parent.homeCurrency)) {
            CurrencyStore currencyStore = new CurrencyStore(this.parent);
            this.currencyRate = currencyStore.getCurrencyFromName((String)this.a.currency).rate;
            currencyStore.closeCurrencyStore();
            currencyStore = null;
        }
        this.currentX = 0;
        this.currentY = this.lineHeight;
        this.currentPos = 0;
        this.startPos = 0;
        this.parent.tf2a.setCommandListener(this);
        this.parent.tf2b.setCommandListener(this);
        if (!this.parent.tf2b.ready && this.parent.createFormsInBackground) {
            this.show("Creating form in background");
        }
        this.runMode = 0;
        if (this.parent.isAndroid) {
            this.display.callSerially((Runnable)this);
        }
    }

    void runThread() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void paint(Graphics graphics) {
        if (!this.showedOutOfSpaceMessage) {
            this.showedOutOfSpaceMessage = true;
            if (this.ts.getSizeAvailable() <= 1000) {
                this.alert.setTimeout(-2);
                this.alert.setString(this.parent.outOfSpaceMessage());
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (this.width != this.getWidth() || this.height != this.getHeight() - this.parent.heightAdjustment) {
            this.width = this.getWidth();
            this.height = this.getHeight() - this.parent.heightAdjustment;
            this.setPositions();
            this.paintWholeScreen = true;
        }
        graphics.setFont(this.font);
        if (this.paintWholeScreen || this.parent.isBlackberry) {
            this.showHeader(graphics);
            this.showPage(graphics);
            this.showFooter(graphics);
        } else {
            if (this.parent.runningTotal) {
                this.showHeader(graphics);
            }
            this.showLines(graphics);
        }
        this.paintWholeScreen = true;
    }

    void showPage(Graphics graphics) {
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        graphics.setColor(this.parent.colorFont);
        if (this.numItems == 0) {
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                graphics.setColor(this.parent.colorCursor);
                graphics.fillRect(0, this.lineHeight * i + this.lineHeight, this.width, this.lineHeight);
                graphics.setColor(this.parent.colorFont);
            }
            this.t = this.ts.getTransactionFromIndex(i + this.startPos);
            this.buildLine(graphics, this.t, this.lineHeight * i + this.lineHeight);
        }
        this.t = this.ts.getTransactionFromIndex(this.startPos + this.currentPos);
    }

    void showLines(Graphics graphics) {
        if (this.numItems == 0) {
            return;
        }
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.lineHeight * this.previousPos + this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        this.t = this.ts.getTransactionFromIndex(this.previousPos + this.startPos);
        this.buildLine(graphics, this.t, this.lineHeight * this.previousPos + this.lineHeight);
        graphics.setColor(this.parent.colorCursor);
        graphics.fillRect(0, this.lineHeight * this.currentPos + this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        this.t = this.ts.getTransactionFromIndex(this.currentPos + this.startPos);
        this.buildLine(graphics, this.t, this.lineHeight * this.currentPos + this.lineHeight);
    }

    void showHeader(Graphics graphics) {
        int n = this.parent.lineSpacing + this.parent.fontAdjustment;
        if (this.msg.equals("")) {
            graphics.setColor(this.parent.colorHeading);
            graphics.fillRect(0, 0, this.width, this.lineHeight);
            graphics.setColor(this.parent.colorFont);
            graphics.drawString(this.a.name, this.parent.widthAdjustment, n, 20);
            if (this.parent.runningTotal) {
                String string = this.a.currency.equals(this.parent.homeCurrency) ? Utilities.numberToString(this.rt, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) : this.a.currency + " " + Utilities.numberToString(Utilities.homeToForeign(this.rt, this.currencyRate), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
                graphics.drawString(string, this.amountPosition + this.numberWidth - this.font.stringWidth(string), n, 20);
            }
        } else {
            graphics.setColor(this.parent.colorMessage);
            graphics.fillRect(0, 0, this.width, this.lineHeight);
            graphics.setColor(this.parent.colorFont);
            graphics.drawString(this.msg, this.parent.widthAdjustment, n, 20);
        }
    }

    void showFooter(Graphics graphics) {
        String string;
        int n = this.height - this.lineHeight + this.parent.lineSpacing + this.parent.fontAdjustment;
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.lineHeight, this.width, this.lineHeight);
        int n2 = this.a.current;
        int n3 = this.a.today;
        int n4 = this.a.reconciled;
        String string2 = "";
        if (!this.a.currency.equals(this.parent.homeCurrency)) {
            n2 = Utilities.homeToForeign(n2, this.currencyRate);
            n3 = Utilities.homeToForeign(n3, this.currencyRate);
            n4 = Utilities.homeToForeign(n4, this.currencyRate);
            string2 = "* ";
        }
        if (this.font.stringWidth(string = string2 + "C:" + Utilities.numberToString(n2, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + " T:" + Utilities.numberToString(n3, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + " R:" + Utilities.numberToString(n4, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed)) > this.width - this.parent.widthAdjustment * 2) {
            string = this.parent.showBalanceType ? string2 + "C:" + Utilities.numberToString(n2, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) : string2 + "T:" + Utilities.numberToString(n3, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
            string = string + " R:" + Utilities.numberToString(n4, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        }
        graphics.setColor(this.parent.colorFont);
        graphics.drawString(string, this.parent.widthAdjustment, n, 20);
    }

    void drawUp() {
        if (this.startPos + this.currentPos > 0) {
            int n = this.startPos + this.currentPos;
            this.oldY = this.currentY;
            this.currentY -= this.lineHeight;
            this.previousPos = this.currentPos--;
            if (this.currentY < this.lineHeight) {
                this.currentY = this.lineHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
            } else {
                this.paintWholeScreen = false;
            }
            int n2 = this.startPos + this.currentPos;
            this.adjustRunningTotal(n, n2);
            this.repaint();
            this.serviceRepaints();
            return;
        }
    }

    void drawDown() {
        if (this.startPos + this.currentPos < this.numItems - 1) {
            int n = this.startPos + this.currentPos;
            this.oldY = this.currentY;
            this.currentY += this.lineHeight;
            this.previousPos = this.currentPos++;
            if (this.currentY + this.lineHeight * 2 > this.height) {
                this.currentY -= this.lineHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
            } else {
                this.paintWholeScreen = false;
            }
            int n2 = this.startPos + this.currentPos;
            this.adjustRunningTotal(n, n2);
            this.repaint();
            this.serviceRepaints();
            return;
        }
    }

    String setReconciled(boolean bl) {
        if (bl) {
            return "r";
        }
        return "";
    }

    void buildLine(Graphics graphics, Transaction transaction, int n) {
        int n2;
        int n3;
        int n4 = n + this.parent.lineSpacing + this.parent.fontAdjustment;
        graphics.drawString(this.setPageDate(transaction.longDate), this.parent.widthAdjustment, n4, 20);
        int n5 = transaction.description.length();
        int n6 = this.descriptionWidth;
        if (this.referenceWidth > 0 && transaction.reference.equals("")) {
            n6 += this.referenceWidth + this.spacing;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = n5 - n3;
            if (this.font.stringWidth(transaction.description.substring(0, n2)) > n6) continue;
            graphics.drawString(transaction.description.substring(0, n2), this.descriptionPosition, n4, 20);
            break;
        }
        if (this.referenceWidth > 0) {
            n5 = transaction.reference.length();
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = n5 - n3;
                if (this.font.stringWidth(transaction.reference.substring(0, n2)) > this.referenceWidth) continue;
                graphics.drawString(transaction.reference.substring(0, n2), this.referencePosition, n4, 20);
                break;
            }
        }
        if (this.categoryWidth > 0) {
            String string = transaction.category;
            if (transaction.transferFlag) {
                string = "[Transfer]";
            }
            if (transaction.splitFlag) {
                string = "[Split]";
            }
            n5 = string.length();
            for (n2 = 0; n2 < n5; ++n2) {
                int n7 = n5 - n2;
                if (this.font.stringWidth(string.substring(0, n7)) > this.categoryWidth) continue;
                graphics.drawString(string.substring(0, n7), this.categoryPosition, n4, 20);
                break;
            }
        }
        String string = Utilities.numberToString(transaction.amount, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        graphics.drawString(string, this.amountPosition + this.numberWidth - this.font.stringWidth(string), n4, 20);
        graphics.drawString(this.setReconciled(transaction.reconciled), this.width - this.reconciledWidth - this.parent.widthAdjustment, n4, 20);
    }

    String setPageDate(long l) {
        this.parent.genericDate.setTime(l + 3600000L);
        this.parent.cal.setTime(this.parent.genericDate);
        String string = "" + this.parent.cal.get(5);
        if (string.length() < 2) {
            string = "0" + string;
        }
        int n = this.parent.cal.get(2) + 1;
        String string2 = "" + n;
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (this.parent.dateFormat == 0) {
            return string + "/" + string2;
        }
        if (this.parent.dateFormat == 1) {
            return string2 + "/" + string;
        }
        String string3 = ("" + this.parent.cal.get(1)).substring(2, 4);
        if (this.parent.dateFormat == 2) {
            return string + "/" + string2 + "/" + string3;
        }
        if (this.parent.dateFormat == 3) {
            return string2 + "/" + string + "/" + string3;
        }
        return "";
    }

    void setPositions() {
        this.fs = 8;
        if (this.parent.mediumSize) {
            this.fs = 0;
        }
        if (this.parent.largeSize) {
            this.fs = 16;
        }
        this.font = Font.getFont((int)0, (int)0, (int)this.fs);
        this.fontHeight = this.font.getHeight();
        this.lineHeight = this.fontHeight + this.parent.lineSpacing * 2;
        this.numberWidth = this.parent.isGroupingUsed ? this.font.stringWidth("999,999.99") : this.font.stringWidth("999999.99");
        this.dateWidth = this.font.stringWidth("99/99");
        if (this.parent.dateFormat > 1) {
            this.dateWidth = this.font.stringWidth("99/99/99");
        }
        this.reconciledWidth = this.font.stringWidth("r");
        this.minDescriptionWidth = this.font.stringWidth("Long Description");
        this.numItemsPage = this.height / this.lineHeight - 2;
        this.spacing = 10;
        this.referenceWidth = 100;
        this.categoryWidth = 100;
        if (this.width > 500) {
            this.spacing = 20;
        }
        if (this.width > 640) {
            this.spacing = 30;
        }
        this.descriptionWidth = this.width - this.parent.widthAdjustment * 2 - this.numberWidth - this.dateWidth - this.reconciledWidth - this.referenceWidth - this.categoryWidth - this.spacing * 5;
        if (this.parent.preferCategoryInTransactionView) {
            if (this.descriptionWidth < this.minDescriptionWidth || this.referenceWidth == 0) {
                this.descriptionWidth += this.referenceWidth + this.spacing;
                this.referenceWidth = 0;
            }
            if (this.descriptionWidth < this.minDescriptionWidth || this.categoryWidth == 0) {
                this.descriptionWidth += this.categoryWidth + this.spacing;
                this.categoryWidth = 0;
            }
        } else {
            if (this.descriptionWidth < this.minDescriptionWidth || this.categoryWidth == 0) {
                this.descriptionWidth += this.categoryWidth + this.spacing;
                this.categoryWidth = 0;
            }
            if (this.descriptionWidth < this.minDescriptionWidth || this.referenceWidth == 0) {
                this.descriptionWidth += this.referenceWidth + this.spacing;
                this.referenceWidth = 0;
            }
        }
        this.descriptionPosition = this.dateWidth + this.parent.widthAdjustment + this.spacing;
        this.referencePosition = this.descriptionPosition + this.descriptionWidth + this.spacing;
        this.categoryPosition = this.referencePosition + this.referenceWidth;
        if (this.referenceWidth > 0) {
            this.categoryPosition += this.spacing;
        }
        this.amountPosition = this.categoryPosition + this.categoryWidth;
        if (this.categoryWidth > 0) {
            this.amountPosition += this.spacing;
        }
    }

    void show(String string) {
        this.msg = string;
        this.repaint();
        this.serviceRepaints();
    }

    Transaction showTransaction() {
        this.oldT = new Transaction();
        this.oldT.clone(this.t);
        return this.t;
    }

    int newTransaction(Transaction transaction) {
        this.t1 = transaction;
        if (this.t1.description.equals("")) {
            return 0;
        }
        if (this.t1.account.equals("")) {
            this.t1.account = this.a.name;
        }
        if (this.ts.getSizeAvailable() <= 1000) {
            this.showedOutOfSpaceMessage = false;
            return 0;
        }
        this.t1.id = this.ts.saveNewTransaction(this.t1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.ts.toByteArray(this.t1), 7);
        }
        if (this.t == null) {
            this.t = this.t1;
        }
        this.updateAccountTotal1(this.a);
        this.a.updateBalance(this.t1, null, this.parent.todayDays);
        this.updateAccountTotal2(this.a);
        this.parent.av.as.saveExistingAccount(this.a);
        if (!this.t1.transferFlag) {
            CategoryStore categoryStore = null;
            categoryStore = this.parent.cv == null ? new CategoryStore(this.parent) : this.parent.cv.cs;
            if (this.t1.splitFlag) {
                for (int i = 0; i < this.t1.ss.size(); ++i) {
                    Split split = this.t1.ss.getSplit(i);
                    Category category = categoryStore.getCategoryFromName(split.category);
                    this.updateCategoryTotal1(category);
                    category.updateBalance(split, null);
                    this.updateCategoryTotal2(category);
                    categoryStore.saveExistingCategory(category);
                }
            } else {
                Category category = categoryStore.getCategoryFromName(this.t1.category);
                this.updateCategoryTotal1(category);
                category.updateBalance(this.t1, null);
                this.updateCategoryTotal2(category);
                categoryStore.saveExistingCategory(category);
            }
            if (this.parent.cv == null) {
                categoryStore.closeCategoryStore();
                categoryStore = null;
            }
        }
        ++this.numItems;
        this.rt = this.a.current;
        this.adjustRunningTotal(0, this.startPos + this.currentPos);
        this.repaint();
        return this.t1.id;
    }

    void editTransaction(Transaction transaction) {
        Category category;
        Object object;
        int n;
        if (transaction.description.equals("")) {
            return;
        }
        this.t1 = transaction;
        if (this.t1.account.equals("")) {
            this.t1.account = this.a.name;
        }
        int n2 = this.ts.findIndex(this.t1);
        this.ts.deleteTransaction(this.t1);
        this.t1.id = this.ts.saveNewTransactionWithoutIndex(this.t1);
        this.ts.updateIndex(n2, this.t1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.ts.toByteArray(this.oldT), -7);
            this.parent.sync.saveSyncRecord(this.ts.toByteArray(this.t1), 7);
        }
        this.updateAccountTotal1(this.a);
        this.a.updateBalance(this.t1, this.oldT, this.parent.todayDays);
        this.updateAccountTotal2(this.a);
        this.parent.av.as.saveExistingAccount(this.a);
        if (Utilities.longToDays(this.t1.longDate) != Utilities.longToDays(this.oldT.longDate)) {
            this.ts.deleteIndex(this.startPos + this.currentPos);
            this.ts.addIndex(this.t1);
        }
        CategoryStore categoryStore = null;
        categoryStore = this.parent.cv == null ? new CategoryStore(this.parent) : this.parent.cv.cs;
        if (!this.oldT.transferFlag) {
            if (this.oldT.splitFlag) {
                for (n = 0; n < this.oldT.ss.size(); ++n) {
                    object = this.oldT.ss.getSplit(n);
                    category = categoryStore.getCategoryFromName(((Split)object).category);
                    this.updateCategoryTotal1(category);
                    category.updateBalance(null, (Split)object);
                    this.updateCategoryTotal2(category);
                    categoryStore.saveExistingCategory(category);
                }
            } else {
                category = categoryStore.getCategoryFromName(this.oldT.category);
                this.updateCategoryTotal1(category);
                category.updateBalance(null, this.oldT);
                this.updateCategoryTotal2(category);
                categoryStore.saveExistingCategory(category);
            }
        }
        if (this.t1.transferFlag) {
            if (!this.t1.transferAccount.equals(this.t.account) && !this.t1.transferAccount.equals("")) {
                n = 0;
                object = this.parent.av.as.getAccountFromName(this.t1.transferAccount);
                this.ts.setIndex(this.a);
                this.ts.getIndex((Account)object);
                int n3 = this.t1.transferAccountId;
                Transaction transaction2 = this.ts.getTransaction(n3);
                if (transaction2 == null) {
                    int n4 = this.ts.getNumTransactions();
                    long l = Utilities.longToDays(this.oldT.longDate);
                    for (int i = 0; i < n4; ++i) {
                        transaction2 = this.ts.getTransactionFromIndex(i);
                        long l2 = Utilities.longToDays(transaction2.longDate);
                        if (l2 >= l) {
                            if (l2 != l || !transaction2.transferFlag || !transaction2.description.equals(this.oldT.description) || transaction2.amount != -this.oldT.amount) continue;
                            n = 1;
                        }
                        break;
                    }
                } else {
                    n = 1;
                }
                if (n != 0) {
                    this.oldT = new Transaction();
                    this.oldT.clone(transaction2);
                    transaction2.description = this.t1.description;
                    transaction2.amount = -this.t1.amount;
                    transaction2.longDate = this.t1.longDate;
                    transaction2.reference = this.t1.reference;
                    transaction2.transferAccountId = this.t1.id;
                    this.ts.saveExistingTransaction(transaction2);
                    if (this.parent.syncMode) {
                        this.parent.sync.saveSyncRecord(this.ts.toByteArray(this.oldT), -7);
                        this.parent.sync.saveSyncRecord(this.ts.toByteArray(transaction2), 7);
                    }
                    if (Utilities.longToDays(transaction2.longDate) != Utilities.longToDays(this.oldT.longDate)) {
                        this.ts.deleteIndex(this.oldT);
                        this.ts.addIndex(transaction2);
                    }
                    this.updateAccountTotal1((Account)object);
                    ((Account)object).updateBalance(transaction2, this.oldT, this.parent.todayDays);
                    this.updateAccountTotal2((Account)object);
                    this.parent.av.as.saveExistingAccount((Account)object);
                }
                this.ts.setIndex((Account)object);
                this.ts.getIndex(this.a);
                object = null;
            }
        } else if (this.t1.splitFlag) {
            for (n = 0; n < this.t1.ss.size(); ++n) {
                object = this.t1.ss.getSplit(n);
                category = categoryStore.getCategoryFromName(((Split)object).category);
                this.updateCategoryTotal1(category);
                category.updateBalance((Split)object, null);
                this.updateCategoryTotal2(category);
                categoryStore.saveExistingCategory(category);
            }
        } else {
            category = categoryStore.getCategoryFromName(this.t1.category);
            this.updateCategoryTotal1(category);
            category.updateBalance(this.t1, null);
            this.updateCategoryTotal2(category);
            categoryStore.saveExistingCategory(category);
        }
        if (this.parent.cv == null) {
            categoryStore.closeCategoryStore();
            categoryStore = null;
        }
        this.oldY = this.currentY;
        this.rt = this.a.current;
        this.adjustRunningTotal(0, this.startPos + this.currentPos);
        this.repaint();
    }

    void deleteTransaction(Transaction transaction) {
        this.t1 = transaction;
        this.updateAccountTotal1(this.a);
        this.a.updateBalance(null, this.t1, this.parent.todayDays);
        this.updateAccountTotal2(this.a);
        this.parent.av.as.saveExistingAccount(this.a);
        CategoryStore categoryStore = null;
        categoryStore = this.parent.cv == null ? new CategoryStore(this.parent) : this.parent.cv.cs;
        if (this.t1.transferFlag) {
            if (!this.t1.transferAccount.equals(this.t1.account) && !this.t1.transferAccount.equals("")) {
                boolean bl = false;
                Account account = this.parent.av.as.getAccountFromName(this.t1.transferAccount);
                this.ts.setIndex(this.a);
                this.ts.getIndex(account);
                int n = this.t1.transferAccountId;
                Transaction transaction2 = this.ts.getTransaction(n);
                if (transaction2 == null) {
                    int n2 = this.ts.getNumTransactions();
                    long l = Utilities.longToDays(this.t1.longDate);
                    for (int i = 0; i < n2; ++i) {
                        transaction2 = this.ts.getTransactionFromIndex(i);
                        long l2 = Utilities.longToDays(transaction2.longDate);
                        if (l2 >= l) {
                            if (l2 != l || !transaction2.transferFlag || !transaction2.description.equals(this.t1.description) || transaction2.amount != -this.t1.amount) continue;
                            bl = true;
                        }
                        break;
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.ts.deleteTransaction(transaction2);
                    if (this.parent.syncMode) {
                        this.parent.sync.saveSyncRecord(this.ts.toByteArray(transaction2), -7);
                    }
                    this.ts.deleteIndex(transaction2);
                    this.updateAccountTotal1(account);
                    account.updateBalance(null, transaction2, this.parent.todayDays);
                    this.updateAccountTotal2(account);
                    this.parent.av.as.saveExistingAccount(account);
                }
                this.ts.setIndex(account);
                this.ts.getIndex(this.a);
                account = null;
            }
        } else if (this.t1.splitFlag) {
            for (int i = 0; i < this.t1.ss.size(); ++i) {
                Split split = this.t1.ss.getSplit(i);
                Category category = categoryStore.getCategoryFromName(split.category);
                this.updateCategoryTotal1(category);
                category.updateBalance(null, split);
                this.updateCategoryTotal2(category);
                categoryStore.saveExistingCategory(category);
            }
        } else {
            Category category = categoryStore.getCategoryFromName(this.t1.category);
            this.updateCategoryTotal1(category);
            category.updateBalance(null, this.t1);
            this.updateCategoryTotal2(category);
            categoryStore.saveExistingCategory(category);
        }
        if (this.parent.cv == null) {
            categoryStore.closeCategoryStore();
            categoryStore = null;
        }
        this.ts.deleteTransaction(this.t1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.ts.toByteArray(this.t1), -7);
        }
        this.ts.deleteIndex(this.startPos + this.currentPos);
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.lineHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.rt = this.a.current;
        this.adjustRunningTotal(0, this.startPos + this.currentPos);
        this.repaint();
    }

    void reconcileTransaction(Transaction transaction) {
        this.t1 = transaction;
        this.oldT = new Transaction();
        this.oldT.clone(this.t1);
        this.t1.reconciled = !this.t1.reconciled;
        this.editTransaction(this.t1);
    }

    void moveTransaction(Transaction transaction, String string) {
        int n;
        Transaction transaction2;
        Account account = this.parent.av.as.getAccountFromName(string);
        if (account == null) {
            return;
        }
        this.t1 = transaction;
        if (this.t1.account.equals("")) {
            this.t1.account = this.a.name;
        }
        this.updateAccountTotal1(this.a);
        this.a.updateBalance(null, this.t1, this.parent.todayDays);
        this.updateAccountTotal2(this.a);
        this.parent.av.as.saveExistingAccount(this.a);
        this.ts.deleteTransaction(this.t1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.ts.toByteArray(this.t1), -7);
        }
        this.ts.deleteIndex(this.startPos + this.currentPos);
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.lineHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.rt = this.a.current;
        this.adjustRunningTotal(0, this.startPos + this.currentPos);
        this.t1.account = string;
        this.ts.setIndex(this.a);
        this.ts.getIndex(account);
        this.t1.id = this.ts.saveNewTransaction(this.t1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.ts.toByteArray(this.t1), 7);
        }
        this.ts.setIndex(account);
        this.ts.getIndex(this.a);
        this.updateAccountTotal1(account);
        account.updateBalance(this.t1, null, this.parent.todayDays);
        this.updateAccountTotal2(account);
        this.parent.av.as.saveExistingAccount(account);
        if (this.t1.transferFlag && !this.t1.transferAccount.equals(this.t1.account) && !this.t1.transferAccount.equals("") && (transaction2 = this.ts.getTransaction(n = this.t1.transferAccountId)) != null) {
            Account account2 = this.parent.av.as.getAccountFromName(transaction2.account);
            this.ts.setIndex(this.a);
            this.ts.getIndex(account2);
            if (this.parent.syncMode) {
                this.parent.sync.saveSyncRecord(this.ts.toByteArray(transaction2), -7);
            }
            transaction2.transferAccount = string;
            transaction2.transferAccountId = this.t1.id;
            this.ts.saveExistingTransaction(transaction2);
            if (this.parent.syncMode) {
                this.parent.sync.saveSyncRecord(this.ts.toByteArray(transaction2), 7);
            }
            this.ts.setIndex(account2);
            this.ts.getIndex(this.a);
            account2 = null;
        }
        this.repaint();
    }

    void updateAccountTotal1(Account account) {
        this.parent.av.totalCurrent -= account.current;
        this.parent.av.totalToday -= account.today;
        this.parent.av.totalReconciled -= account.reconciled;
    }

    void updateAccountTotal2(Account account) {
        this.parent.av.totalCurrent += account.current;
        this.parent.av.totalToday += account.today;
        this.parent.av.totalReconciled += account.reconciled;
        this.parent.av.checkMinMax(account);
    }

    void updateCategoryTotal1(Category category) {
        if (this.parent.cv != null) {
            this.parent.cv.totalCurrent -= category.current;
        }
    }

    void updateCategoryTotal2(Category category) {
        if (this.parent.cv != null) {
            this.parent.cv.totalCurrent += category.current;
            this.parent.cv.checkMinMax(category);
        }
    }

    void saveAsRegular() {
        int n;
        this.r = new Regular();
        this.r = this.r.createFromTransaction(this.t1);
        if (this.saveAsRegularFlag == 1) {
            this.r.amount = 0;
        }
        if (this.r.splitFlag) {
            this.r.ss = new SplitStore();
            for (n = 0; n < this.r.ss.size(); ++n) {
                Split split = new Split();
                split = this.r.ss.getSplit(n);
                if (this.saveAsRegularFlag == 1) {
                    split.amount = 0;
                }
                this.r.ss.setSplit(split, n);
            }
        }
        if ((n = this.rs.lookUpId(this.r)) == 0) {
            this.r.id = this.rs.saveNewRegular(this.r);
            if (this.parent.syncMode) {
                this.parent.sync.saveSyncRecord(this.rs.toByteArray(this.r), 5);
            }
        } else {
            this.rs.saveExistingRegular(this.r);
            if (this.parent.syncMode) {
                this.parent.sync.saveSyncRecord(this.rs.toByteArray(this.r), -5);
                this.parent.sync.saveSyncRecord(this.rs.toByteArray(this.r), 5);
            }
        }
        this.saveAsRegularFlag = 0;
    }

    protected void showNotify() {
        this.repaint();
    }

    void adjustRunningTotal(int n, int n2) {
        if (!this.parent.runningTotal) {
            return;
        }
        if (n == n2) {
            return;
        }
        int n3 = 0;
        if (n < n2) {
            for (int i = n; i < n2; ++i) {
                this.t = this.ts.getTransactionFromIndex(i);
                n3 -= this.t.amount;
            }
        } else {
            for (int i = n2; i < n; ++i) {
                this.t = this.ts.getTransactionFromIndex(i);
                n3 += this.t.amount;
            }
        }
        this.rt += n3;
    }

    protected void keyPressed(int n) {
        if (this.getGameAction(n) == 2) {
            int n2 = this.startPos + this.currentPos;
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.lineHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            int n3 = this.startPos + this.currentPos;
            this.adjustRunningTotal(n2, n3);
            this.repaint();
            return;
        }
        if (this.getGameAction(n) == 5) {
            int n4 = this.startPos + this.currentPos;
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
            int n5 = this.startPos + this.currentPos;
            this.adjustRunningTotal(n4, n5);
            this.repaint();
            return;
        }
        if (this.getGameAction(n) == 8) {
            if (this.parent.showMenuTransactionView) {
                this.displayTouchScreenMenu();
            } else {
                if (this.numItems == 0) {
                    return;
                }
                this.reconcileTransaction(this.t);
            }
            return;
        }
        if (this.getGameAction(n) == 1) {
            this.drawUp();
            return;
        }
        if (this.getGameAction(n) == 6) {
            this.drawDown();
            return;
        }
        if (n == 48) {
            int n6 = this.startPos + this.currentPos;
            this.debug = new Form("Record Properties");
            this.debug.append("Position " + n6 + " of " + this.numItems + " of " + this.ts.getNumAllTransactions() + "\n");
            this.t = this.ts.getTransactionFromIndex(n6);
            this.debug.append("Record ID " + this.t.id + "\n");
            this.debug.append("Record length " + this.ts.getRecordSize(this.t.id) + "\n");
            if (this.t.transferFlag) {
                this.debug.append("Transfer record ID " + this.t.transferAccountId + "\n");
            }
            this.debug.append("RecordStore size " + this.ts.getSize() + "\n");
            this.debug.addCommand(this.parent.okCommand);
            this.debug.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.debug);
        }
    }

    protected void pointerPressed(int n, int n2) {
        this.pointerExecute = false;
        this.timePointerOnScreen = System.currentTimeMillis();
        if (n2 < this.lineHeight) {
            this.keyPressed(this.getKeyCode(2));
            return;
        }
        if (n2 > this.height - this.lineHeight) {
            this.keyPressed(this.getKeyCode(5));
            return;
        }
        int n3 = (n2 - this.lineHeight) / this.lineHeight;
        if (n3 >= this.numItems) {
            return;
        }
        this.pointerExecute = true;
        int n4 = this.startPos + this.currentPos;
        int n5 = this.startPos + n3;
        this.adjustRunningTotal(n4, n5);
        this.previousPos = this.currentPos;
        this.currentPos = n3;
        this.currentY = (this.currentPos + 1) * this.lineHeight;
        this.paintWholeScreen = true;
        this.repaint();
    }

    protected void pointerReleased(int n, int n2) {
        this.timePointerOnScreen = System.currentTimeMillis() - this.timePointerOnScreen;
        if (this.timePointerOnScreen > 1000L) {
            this.displayTouchScreenMenu();
            return;
        }
        if (!this.pointerExecute) {
            return;
        }
        if (this.parent.showMenuTransactionView) {
            this.displayTouchScreenMenu();
            return;
        }
        this.t = this.ts.getTransactionFromIndex(this.startPos + this.currentPos);
        this.reconcileTransaction(this.t);
    }

    void displayTouchScreenMenu() {
        this.touchScreenMenu = new Form("Transaction Menu");
        this.cgtsm = new ChoiceGroup("Choose an option", 1);
        this.cgtsm.append("New", null);
        this.cgtsm.append("New Trans (Regular)", null);
        this.cgtsm.append("New Trans (sel. Cat)", null);
        this.cgtsm.append("New Split", null);
        this.cgtsm.append("Edit", null);
        this.cgtsm.append("Save As Regular", null);
        this.cgtsm.append("Save As Standing Order", null);
        this.cgtsm.append("Delete", null);
        this.cgtsm.append("Reconcile", null);
        this.cgtsm.append("Show", null);
        this.cgtsm.append("Move", null);
        this.cgtsm.append("Toggle Reference/Category", null);
        this.cgtsm.append("Toggle Default Action", null);
        this.cgtsm.append("Main", null);
        this.cgtsm.append("Switch Views", null);
        this.cgtsm.append("Go To Date", null);
        this.cgtsm.append("Exit", null);
        this.touchScreenMenu.append((Item)this.cgtsm);
        this.touchScreenMenu.addCommand(this.parent.okCommand);
        this.touchScreenMenu.addCommand(this.parent.cancelCommand);
        this.touchScreenMenu.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.touchScreenMenu);
    }

    void removeAllCommands() {
        this.parent.tf2.removeCommand(this.parent.createCommand);
        this.parent.tf2.removeCommand(this.parent.matchCommand);
        this.parent.tf2.removeCommand(this.parent.saveAsRegularCommand);
        this.parent.tf2.removeCommand(this.parent.newCategoryCommand);
        this.parent.tf2.removeCommand(this.parent.cancelCommand);
        this.parent.tf2.removeCommand(this.parent.deleteCommand);
        this.parent.tf2.removeCommand(this.parent.updateCommand);
        this.parent.tf2.removeCommand(this.parent.exitCommand);
    }

    void checkForm() {
        if (this.parent.isAndroid) {
            this.parent.tf2a.ready = false;
            this.parent.tf2b.ready = false;
            return;
        }
        if (this.parent.reuseForm) {
            return;
        }
        this.runMode = 2;
        if (this.parent.createFormsInBackground) {
            this.runThread();
        } else {
            this.run();
        }
    }

    void goToDate() {
        int n;
        int n2 = this.startPos + this.currentPos;
        long l = Utilities.longToDays(this.date.getTime());
        int n3 = this.numItems - 1;
        for (n = 0; n < this.numItems; ++n) {
            LongId longId = (LongId)this.ts.ht.get(new Short((short)n));
            if (l < Utilities.longToDays(longId.lo)) continue;
            n3 = n;
            break;
        }
        this.startPos = n3;
        this.currentPos = 0;
        this.currentY = this.lineHeight;
        n = this.startPos + this.currentPos;
        this.adjustRunningTotal(n2, n);
        this.msg = "";
        this.repaint();
    }

    void goToTransaction(Transaction transaction) {
        int n;
        int n2 = this.startPos + this.currentPos;
        long l = Utilities.longToDays(transaction.longDate);
        int n3 = this.numItems - 1;
        for (n = 0; n < this.numItems; ++n) {
            LongId longId = (LongId)this.ts.ht.get(new Short((short)n));
            if (l == Utilities.longToDays(longId.lo) && transaction.id == longId.id) {
                n3 = n;
                break;
            }
            if (l <= Utilities.longToDays(longId.lo)) continue;
            n3 = n;
            break;
        }
        this.startPos = n3;
        this.currentPos = 0;
        this.currentY = this.lineHeight;
        n = this.startPos + this.currentPos;
        this.adjustRunningTotal(n2, n);
        this.msg = "";
        this.repaint();
    }

    void androidDelay() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void run() {
        if (this.runMode == 0) {
            this.androidDelay();
        }
        if (this.runMode == 1) {
            this.goToDate();
        }
        if (this.runMode == 2) {
            this.setUpForm1();
        }
    }

    void setUpForm1() {
        if (this.isSplit) {
            this.parent.tf2b = new TransactionForm(this.parent);
            this.parent.tf2b.build(false, this.showMatchedCategories, true);
            this.parent.tf2b.setCommandListener(this);
        } else {
            this.parent.tf2a = new TransactionForm(this.parent);
            this.parent.tf2a.build(false, this.showMatchedCategories, false);
            this.parent.tf2a.setCommandListener(this);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        int n;
        Object object;
        int n2;
        Object object2;
        if (command == this.parent.exitCommand) {
            this.ts.setIndex(this.a);
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this) {
            if (command == this.parent.newStarCommand) {
                this.newStar = new Form("Match Categories");
                this.tf = new TextField("First few letters", "", 10, 0);
                this.newStar.append((Item)this.tf);
                this.newStar.addCommand(this.parent.okCommand);
                this.newStar.addCommand(this.parent.cancelCommand);
                this.newStar.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.newStar);
            }
            if (command == this.parent.newCommand || command == this.parent.newSplitCommand) {
                if (command == this.parent.newSplitCommand) {
                    this.isSplit = true;
                    if (!this.parent.tf2b.ready) {
                        this.setUpForm1();
                    }
                    this.parent.tf2 = this.parent.tf2b;
                } else {
                    this.isSplit = false;
                    if (!this.parent.tf2a.ready) {
                        this.setUpForm1();
                    }
                    this.parent.tf2 = this.parent.tf2a;
                }
                if (!this.parent.tf2.ready) {
                    this.display.setCurrent((Displayable)this.parent.tf2);
                }
                object2 = new Transaction();
                ((Transaction)object2).account = this.a.name;
                ((Transaction)object2).longDate = this.parent.todayDate.getTime();
                this.removeAllCommands();
                this.parent.tf2.addCommand(this.parent.createCommand);
                this.parent.tf2.addCommand(this.parent.matchCommand);
                this.parent.tf2.addCommand(this.parent.saveAsRegularCommand);
                this.parent.tf2.addCommand(this.parent.newCategoryCommand);
                this.parent.tf2.addCommand(this.parent.cancelCommand);
                this.parent.tf2.addCommand(this.parent.exitCommand);
                this.parent.tf2.setCommandListener(this);
                this.parent.tf2.set((Transaction)object2, "New");
                this.display.setCurrent((Displayable)this.parent.tf2);
            }
            if (command == this.parent.regularCommand) {
                int n3 = this.rs.getNumRegulars();
                if (n3 == 0) {
                    this.alert.setString("No regular transactions set up");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.rf = new RegularForm(this.parent, this.rs);
                this.rf.addCommand(this.parent.okCommand);
                this.rf.addCommand(this.parent.newCommand);
                this.rf.addCommand(this.parent.editCommand);
                this.rf.addCommand(this.parent.deleteCommand);
                this.rf.addCommand(this.parent.showCommand);
                this.rf.addCommand(this.parent.cancelCommand);
                this.rf.addCommand(this.parent.exitCommand);
                this.rf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.rf);
            }
            if (command == this.parent.saveAsRegularCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("No transactions set up");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                object2 = new Regular();
                object2 = ((Regular)object2).createFromTransaction(this.t);
                this.rf2 = new RegularForm2(this.parent);
                this.rf2.addCommand(this.parent.createCommand);
                this.rf2.addCommand(this.parent.cancelCommand);
                this.rf2.setCommandListener(this);
                this.rf2.build((Regular)object2);
                this.display.setCurrent((Displayable)this.rf2);
            }
            if (command == this.parent.saveAsStandingOrderCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("No transactions set up");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                if (this.t.splitFlag) {
                    this.alert.setString("Cannot use split transaction");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                object2 = new StandingOrder();
                object2 = ((StandingOrder)object2).createFromTransaction(this.t);
                this.sof = new StandingOrderForm(this.parent);
                this.sof.addCommand(this.parent.createCommand);
                this.sof.addCommand(this.parent.cancelCommand);
                this.sof.addCommand(this.parent.exitCommand);
                this.sof.setCommandListener(this);
                this.sof.build();
                this.sof.set((StandingOrder)object2, "Save");
                this.display.setCurrent((Displayable)this.sof);
            }
            if (command == this.parent.editCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("No transactions set up");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.isSplit = true;
                if (!this.parent.tf2b.ready) {
                    this.setUpForm1();
                }
                this.parent.tf2 = this.parent.tf2b;
                if (!this.parent.tf2.ready) {
                    this.display.setCurrent((Displayable)this.parent.tf2);
                }
                this.removeAllCommands();
                this.parent.tf2.addCommand(this.parent.updateCommand);
                this.parent.tf2.addCommand(this.parent.cancelCommand);
                this.parent.tf2.addCommand(this.parent.exitCommand);
                this.parent.tf2.set(this.showTransaction(), "Edit");
                this.parent.tf2.setCommandListener(this);
                this.display.setCurrent((Displayable)this.parent.tf2);
            }
            if (command == this.parent.deleteCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("No transactions set up");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.tf3 = new TransactionForm(this.parent);
                this.tf3.show(this.t, "Delete");
                this.tf3.addCommand(this.parent.deleteCommand);
                this.tf3.addCommand(this.parent.cancelCommand);
                this.tf3.addCommand(this.parent.exitCommand);
                this.tf3.setCommandListener(this);
                this.display.setCurrent((Displayable)this.tf3);
            }
            if (command == this.parent.moveCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("No transactions set up");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.mf = new MoveForm(this.parent);
                this.mf.addCommand(this.parent.moveCommand);
                this.mf.addCommand(this.parent.cancelCommand);
                this.mf.addCommand(this.parent.exitCommand);
                this.mf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.mf);
            }
            if (command == this.parent.reconcileCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("No transactions set up");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.reconcileTransaction(this.t);
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.showCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("No transactions set up");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.tf3 = new TransactionForm(this.parent);
                this.tf3.show(this.t, "Show");
                this.tf3.addCommand(this.parent.okCommand);
                this.tf3.addCommand(this.parent.exitCommand);
                this.tf3.setCommandListener(this);
                this.display.setCurrent((Displayable)this.tf3);
            }
            if (command == this.parent.mainCommand) {
                this.ts.setIndex(this.a);
                this.display.setCurrent((Displayable)this.parent.av);
            }
            if (command == this.parent.viewCommand) {
                this.vl = new ViewForm();
                this.vl.addCommand(this.parent.okCommand);
                this.vl.addCommand(this.parent.cancelCommand);
                this.vl.addCommand(this.parent.exitCommand);
                this.vl.setCommandListener(this);
                this.display.setCurrent((Displayable)this.vl);
            }
            if (command == this.parent.toggleRCCommand) {
                if (this.parent.preferCategoryInTransactionView) {
                    this.parent.preferCategoryInTransactionView = false;
                    this.alert.setString("Preferred column is Reference");
                } else {
                    this.parent.preferCategoryInTransactionView = true;
                    this.alert.setString("Preferred column is Category");
                }
                this.setPositions();
                this.display.setCurrent(this.alert, (Displayable)this);
                this.repaint();
            }
            if (command == this.parent.toggleDefaultActionCommand) {
                if (this.parent.showMenuTransactionView) {
                    this.parent.showMenuTransactionView = false;
                    this.alert.setString("Default action: reconcile");
                } else {
                    this.parent.showMenuTransactionView = true;
                    this.alert.setString("Default action: show menu");
                }
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.goToDateCommand) {
                this.gtdf = new GoToDateForm(this.parent);
                this.gtdf.addCommand(this.parent.okCommand);
                this.gtdf.addCommand(this.parent.cancelCommand);
                this.gtdf.addCommand(this.parent.exitCommand);
                this.gtdf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.gtdf);
            }
        }
        if (displayable == this.newStar) {
            if (command == this.parent.okCommand) {
                this.showMatchedCategories = this.tf.getString();
                this.isSplit = false;
                this.setUpForm1();
                this.parent.tf2 = this.parent.tf2a;
                if (!this.parent.tf2.ready) {
                    this.display.setCurrent((Displayable)this.parent.tf2);
                }
                object2 = new Transaction();
                ((Transaction)object2).account = this.a.name;
                ((Transaction)object2).longDate = this.parent.todayDate.getTime();
                this.removeAllCommands();
                this.parent.tf2.addCommand(this.parent.createCommand);
                this.parent.tf2.addCommand(this.parent.saveAsRegularCommand);
                this.parent.tf2.addCommand(this.parent.newCategoryCommand);
                this.parent.tf2.addCommand(this.parent.cancelCommand);
                this.parent.tf2.addCommand(this.parent.exitCommand);
                this.parent.tf2.set((Transaction)object2, "New");
                this.display.setCurrent((Displayable)this.parent.tf2);
            }
            if (command == this.parent.cancelCommand) {
                this.showMatchedCategories = "";
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
        }
        if (displayable == this.parent.tf2) {
            if (command == this.parent.createCommand) {
                this.t1 = this.parent.tf2.update();
                if (this.t1.description.equals("")) {
                    this.alert.setString("Blank description");
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    return;
                }
                if (this.t1.category.equals("") && !this.t1.splitFlag && !this.t1.transferFlag) {
                    this.alert.setString("No category supplied");
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    return;
                }
                if (this.t1.transferFlag) {
                    this.trf = new TransferForm(this.parent, this.t1, null, null, "Transfer");
                    this.trf.addCommand(this.parent.okCommand);
                    this.trf.addCommand(this.parent.exitCommand);
                    this.trf.setCommandListener(this);
                    this.display.setCurrent((Displayable)this.trf);
                    return;
                }
                if (this.t1.splitFlag) {
                    this.isSplit = true;
                    this.sf = new SplitForm(this.parent, this.t1, "New");
                    this.sf.addCommand(this.parent.okCommand);
                    this.sf.addCommand(this.parent.exitCommand);
                    this.sf.setCommandListener(this);
                    this.display.setCurrent((Displayable)this.sf);
                    return;
                }
                this.newTransaction(this.t1);
                if (this.saveAsRegularFlag > 0) {
                    this.saveAsRegular();
                }
                this.saveAsRegularFlag = 0;
                this.showMatchedCategories = "";
                this.storeMatchedPosition = 0;
                this.matchedString = "";
                this.checkForm();
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.matchCommand) {
                this.t1 = this.parent.tf2.update();
                if (this.t1.description.equals("")) {
                    this.alert.setString("Blank description");
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    return;
                }
                this.removeAllCommands();
                if (this.storeMatchedPosition == 0) {
                    this.matchedString = this.t1.description.toUpperCase();
                }
                int n4 = Math.min(this.numItems, this.storeMatchedPosition + this.parent.matchDescriptionNumber);
                n2 = 0;
                object = new Transaction();
                if (this.storeMatchedPosition <= this.numItems) {
                    for (n = this.storeMatchedPosition; n < n4; ++n) {
                        object = this.ts.getTransactionFromIndex(n);
                        if (this.matchedString.length() > ((Transaction)object).description.length() || !((Transaction)object).description.toUpperCase().substring(0, this.matchedString.length()).equals(this.matchedString)) continue;
                        ((Transaction)object).longDate = this.parent.todayDate.getTime();
                        ((Transaction)object).reconciled = false;
                        if (this.a.type.equals("Cash")) {
                            ((Transaction)object).reconciled = true;
                        }
                        this.storeMatchedPosition = n + 1;
                        n2 = 1;
                        break;
                    }
                }
                if (n2 == 0) {
                    this.storeMatchedPosition += this.parent.matchDescriptionNumber;
                    if (this.storeMatchedPosition >= this.numItems) {
                        this.storeMatchedPosition = 0;
                        this.matchedString = "";
                        this.alert.setString("Not matched in this account");
                    } else {
                        this.alert.setString("Not matched in " + this.storeMatchedPosition + " entries");
                    }
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    this.parent.tf2.addCommand(this.parent.createCommand);
                    this.parent.tf2.addCommand(this.parent.matchCommand);
                    this.parent.tf2.addCommand(this.parent.saveAsRegularCommand);
                    this.parent.tf2.addCommand(this.parent.newCategoryCommand);
                    this.parent.tf2.addCommand(this.parent.cancelCommand);
                    this.parent.tf2.addCommand(this.parent.exitCommand);
                    return;
                }
                this.parent.tf2.addCommand(this.parent.createCommand);
                this.parent.tf2.addCommand(this.parent.matchCommand);
                this.parent.tf2.addCommand(this.parent.saveAsRegularCommand);
                this.parent.tf2.addCommand(this.parent.newCategoryCommand);
                this.parent.tf2.addCommand(this.parent.cancelCommand);
                this.parent.tf2.addCommand(this.parent.exitCommand);
                this.parent.tf2.setCommandListener(this);
                this.parent.tf2.set((Transaction)object, "Matched");
                this.display.setCurrent((Displayable)this.parent.tf2);
            }
            if (command == this.parent.updateCommand) {
                this.t1 = this.parent.tf2.update();
                if (this.t1.description.equals("")) {
                    this.alert.setString("Blank description");
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    return;
                }
                if (this.t1.category.equals("") && !this.t1.splitFlag && !this.t1.transferFlag) {
                    this.alert.setString("No category supplied");
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    return;
                }
                if (!this.oldT.transferFlag && this.t1.transferFlag) {
                    this.alert.setString("Cannot change to transfer - delete then re-enter");
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    return;
                }
                if (this.oldT.transferFlag && !this.t1.transferFlag) {
                    this.alert.setString("Cannot change from transfer - delete then re-enter");
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    return;
                }
                if (this.t1.splitFlag) {
                    this.isSplit = true;
                    this.sf = new SplitForm(this.parent, this.t1, "New");
                    this.sf.addCommand(this.parent.updateCommand);
                    this.sf.addCommand(this.parent.exitCommand);
                    this.sf.setCommandListener(this);
                    this.display.setCurrent((Displayable)this.sf);
                } else {
                    this.editTransaction(this.t1);
                    this.checkForm();
                    this.display.setCurrent((Displayable)this);
                }
            }
            if (command == this.parent.newCategoryCommand) {
                this.cf = new CategoryForm(this.parent, new Category(), "New");
                this.cf.addCommand(this.parent.createCommand);
                this.cf.addCommand(this.parent.cancelCommand);
                this.cf.addCommand(this.parent.exitCommand);
                this.cf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.cf);
            }
            if (command == this.parent.saveAsRegularCommand) {
                this.saveAsRegularFlag = 1;
                if (this.parent.tf2.checkAmount() != 0) {
                    this.saveAsRegularFlag = 2;
                }
                this.alert.setString("Will be saved as Regular");
                this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                return;
            }
            if (command == this.parent.cancelCommand) {
                this.parent.tf2.clearCategories();
                this.storeMatchedPosition = 0;
                this.matchedString = "";
                this.showMatchedCategories = "";
                this.checkForm();
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
        }
        if (displayable == this.tf3) {
            if (command == this.parent.okCommand) {
                this.tf3 = null;
                this.display.setCurrent((Displayable)this);
                return;
            }
            if (command == this.parent.deleteCommand) {
                this.deleteTransaction(this.t);
                this.tf3 = null;
                this.display.setCurrent((Displayable)this);
                return;
            }
            if (command == this.parent.cancelCommand) {
                this.tf3 = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
        }
        if (displayable == this.mf) {
            if (command == this.parent.moveCommand) {
                String string = this.mf.getMoveAccount();
                if (string.equals(this.t.account)) {
                    this.mf = null;
                    this.alert.setString("Choose another account");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                if (this.t.transferFlag && string.equals(this.t.transferAccount)) {
                    this.mf = null;
                    this.alert.setString("Account being used for Transfer");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.moveTransaction(this.t, string);
                this.mf = null;
                this.display.setCurrent((Displayable)this);
                return;
            }
            if (command == this.parent.cancelCommand) {
                this.mf = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
        }
        if (displayable == this.trf) {
            if (command == this.parent.okCommand) {
                Transaction transaction = this.trf.updateTransferTransaction();
                if (transaction.account.equals(this.a.name)) {
                    this.alert.setString("Choose a different account");
                    this.display.setCurrent(this.alert, (Displayable)this.trf);
                    return;
                }
                this.t1.transferAccount = transaction.account;
                transaction.transferAccountId = n2 = this.newTransaction(this.t1);
                object = this.parent.av.as.getAccountFromName(transaction.account);
                this.ts.setIndex(this.a);
                this.ts.getIndex((Account)object);
                n = this.ts.saveNewTransactionWithoutIndex(transaction);
                this.ts.addIndex(transaction);
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(this.ts.toByteArray(transaction), 7);
                }
                this.ts.setIndex((Account)object);
                this.ts.getIndex(this.a);
                this.updateAccountTotal1((Account)object);
                ((Account)object).updateBalance(transaction, null, this.parent.todayDays);
                this.updateAccountTotal2((Account)object);
                this.parent.av.as.saveExistingAccount((Account)object);
                object = null;
                this.t1 = this.ts.getTransaction(n2);
                this.t1.transferAccountId = n;
                this.ts.saveExistingTransaction(this.t1);
                if (this.saveAsRegularFlag > 0) {
                    this.saveAsRegular();
                }
                this.saveAsRegularFlag = 0;
                this.showMatchedCategories = "";
                this.storeMatchedPosition = 0;
                this.matchedString = "";
                this.checkForm();
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.createCommand) {
                Regular regular = this.trf.updateTransferRegular();
                n2 = this.rs.lookUpId(regular);
                if (n2 == 0) {
                    regular.id = this.rs.saveNewRegular(regular);
                    if (this.parent.syncMode) {
                        this.parent.sync.saveSyncRecord(this.rs.toByteArray(regular), 5);
                    }
                    this.alert.setString("Created: " + regular.description);
                } else {
                    this.alert.setString("Already exists: " + regular.description);
                }
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.sf) {
            if (command == this.parent.okCommand) {
                this.t1 = this.sf.updateSplitAmounts();
                if (this.t1.splitFlag) {
                    int n5 = 0;
                    for (n2 = 0; n2 < this.t1.ss.size(); ++n2) {
                        n5 += this.t1.ss.getSplit((int)n2).amount;
                    }
                    if (this.t1.amount != n5) {
                        this.alert.setString("Split total is incorrect");
                        this.display.setCurrent(this.alert, (Displayable)this.sf);
                        return;
                    }
                }
                this.sf = null;
                if (this.t1.description.equals("")) {
                    this.alert.setString("Blank description");
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    return;
                }
                this.newTransaction(this.t1);
                if (this.saveAsRegularFlag > 0) {
                    this.saveAsRegular();
                }
                this.saveAsRegularFlag = 0;
                this.checkForm();
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.updateCommand) {
                this.t1 = this.sf.updateSplitAmounts();
                if (this.t1.splitFlag) {
                    int n6 = 0;
                    for (n2 = 0; n2 < this.t1.ss.size(); ++n2) {
                        n6 += this.t1.ss.getSplit((int)n2).amount;
                    }
                    if (this.t1.amount != n6) {
                        this.alert.setString("Split total is incorrect");
                        this.display.setCurrent(this.alert, (Displayable)this.sf);
                        return;
                    }
                }
                this.sf = null;
                if (this.t1.description.equals("")) {
                    this.alert.setString("Blank description");
                    this.display.setCurrent(this.alert, (Displayable)this.parent.tf2);
                    return;
                }
                this.editTransaction(this.t1);
                this.checkForm();
                this.display.setCurrent((Displayable)this);
            }
        }
        if (displayable == this.cf) {
            if (command == this.parent.createCommand) {
                Category category = this.cf.update();
                if (category.name.equals("")) {
                    this.alert.setString("Blank category name");
                    this.display.setCurrent(this.alert, (Displayable)this.cf);
                    return;
                }
                for (n2 = 0; n2 < this.parent.categoryHt.size(); ++n2) {
                    object = (NameId)this.parent.categoryHt.get(new Short((short)n2));
                    if (!category.name.equals(((NameId)object).name)) continue;
                    this.alert.setString("Category already exists");
                    this.display.setCurrent(this.alert, (Displayable)this.cf);
                    return;
                }
                this.cf = null;
                if (this.parent.cv == null) {
                    this.parent.cv = new CategoryView(this.parent, this.display);
                }
                this.parent.cv.newCategory(category);
                n2 = 0;
                for (int i = 0; i < this.parent.categoryHt.size(); ++i) {
                    NameId nameId = (NameId)this.parent.categoryHt.get(new Short((short)i));
                    if (!category.name.equals(nameId.name)) continue;
                    n2 = i;
                    break;
                }
                this.t1 = this.parent.tf2.update();
                this.parent.tf2.cgCategory.insert(n2, category.name, null);
                this.parent.tf2.cgCategory.setSelectedIndex(n2, true);
                this.parent.tf2.set(this.t1, "New");
                this.display.setCurrent((Displayable)this.parent.tf2);
            }
            if (command == this.parent.cancelCommand) {
                this.cf = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
        }
        if (displayable == this.rf) {
            if (command == this.parent.okCommand) {
                this.rf.removeCommand(this.parent.okCommand);
                this.rf.removeCommand(this.parent.newCommand);
                this.rf.removeCommand(this.parent.editCommand);
                this.rf.removeCommand(this.parent.deleteCommand);
                this.rf.removeCommand(this.parent.showCommand);
                this.rf.removeCommand(this.parent.cancelCommand);
                this.rf.removeCommand(this.parent.exitCommand);
                Regular regular = this.rf.update();
                this.rf = null;
                if (regular.splitFlag) {
                    this.isSplit = true;
                    if (!this.parent.tf2b.ready) {
                        this.setUpForm1();
                    }
                    this.parent.tf2 = this.parent.tf2b;
                } else {
                    this.isSplit = false;
                    if (!this.parent.tf2a.ready) {
                        this.setUpForm1();
                    }
                    this.parent.tf2 = this.parent.tf2a;
                }
                this.t1 = new Transaction();
                this.t1.account = this.a.name;
                this.t1.description = regular.description;
                this.t1.amount = regular.amount;
                this.t1.longDate = this.parent.todayDate.getTime();
                this.t1.reference = regular.reference;
                this.t1.category = regular.category;
                this.t1.transferFlag = regular.transferFlag;
                this.t1.transferAccount = regular.transferAccount;
                this.t1.splitFlag = regular.splitFlag;
                if (this.t1.splitFlag) {
                    this.t1.ss = new SplitStore();
                    for (n2 = 0; n2 < regular.ss.size(); ++n2) {
                        Split split = new Split();
                        split = regular.ss.getSplit(n2);
                        this.t1.ss.addSplit(split);
                    }
                }
                this.parent.tf2.set(this.t1, " New");
                this.removeAllCommands();
                this.parent.tf2.addCommand(this.parent.createCommand);
                this.parent.tf2.addCommand(this.parent.saveAsRegularCommand);
                this.parent.tf2.addCommand(this.parent.newCategoryCommand);
                this.parent.tf2.addCommand(this.parent.cancelCommand);
                this.parent.tf2.addCommand(this.parent.exitCommand);
                this.display.setCurrent((Displayable)this.parent.tf2);
            }
            if (command == this.parent.newCommand) {
                Regular regular = new Regular();
                this.rf2 = new RegularForm2(this.parent);
                this.rf2.addCommand(this.parent.createCommand);
                this.rf2.addCommand(this.parent.cancelCommand);
                this.rf2.setCommandListener(this);
                this.rf2.build(regular);
                this.display.setCurrent((Displayable)this.rf2);
            }
            if (command == this.parent.editCommand) {
                this.r1 = this.rf.update();
                this.rf = null;
                this.rf2 = new RegularForm2(this.parent);
                this.rf2.addCommand(this.parent.updateCommand);
                this.rf2.addCommand(this.parent.cancelCommand);
                this.rf2.setCommandListener(this);
                this.rf2.build(this.r1);
                this.display.setCurrent((Displayable)this.rf2);
            }
            if (command == this.parent.deleteCommand) {
                this.r1 = this.rf.update();
                this.rf = null;
                this.rf2 = new RegularForm2(this.parent);
                this.rf2.addCommand(this.parent.deleteCommand);
                this.rf2.addCommand(this.parent.cancelCommand);
                this.rf2.setCommandListener(this);
                this.rf2.show(this.r1, "Delete");
                this.display.setCurrent((Displayable)this.rf2);
            }
            if (command == this.parent.showCommand) {
                this.r1 = this.rf.update();
                this.rf = null;
                this.rf2 = new RegularForm2(this.parent);
                this.rf2.addCommand(this.parent.okCommand);
                this.rf2.addCommand(this.parent.cancelCommand);
                this.rf2.setCommandListener(this);
                this.rf2.show(this.r1, "Show");
                this.display.setCurrent((Displayable)this.rf2);
            }
            if (command == this.parent.cancelCommand) {
                this.rf = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
        }
        if (displayable == this.rf2) {
            if (command == this.parent.createCommand) {
                Regular regular = this.rf2.update();
                if (regular.description.equals("")) {
                    this.alert.setString("No description supplied");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                if (regular.transferFlag) {
                    this.trf = new TransferForm(this.parent, null, null, regular, "Transfer");
                    this.trf.addCommand(this.parent.createCommand);
                    this.trf.addCommand(this.parent.exitCommand);
                    this.trf.setCommandListener(this);
                    this.display.setCurrent((Displayable)this.trf);
                    return;
                }
                n2 = this.rs.lookUpId(regular);
                if (n2 == 0) {
                    regular.id = this.rs.saveNewRegular(regular);
                    if (this.parent.syncMode) {
                        this.parent.sync.saveSyncRecord(this.rs.toByteArray(regular), 5);
                    }
                    this.alert.setString("Created: " + regular.description);
                } else {
                    this.alert.setString("Already exists: " + regular.description);
                }
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
            if (command == this.parent.updateCommand) {
                Regular regular = this.rf2.update();
                if (regular.description.equals("")) {
                    this.alert.setString("No description supplied");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                n2 = this.rs.lookUpId(regular);
                if (n2 == 0) {
                    regular.id = this.rs.saveNewRegular(regular);
                    if (this.parent.syncMode) {
                        this.parent.sync.saveSyncRecord(this.rs.toByteArray(regular), 5);
                    }
                    this.alert.setString("Created: " + regular.description);
                } else {
                    this.rs.saveExistingRegular(regular);
                    if (this.parent.syncMode) {
                        this.parent.sync.saveSyncRecord(this.rs.toByteArray(this.r1), -5);
                        this.parent.sync.saveSyncRecord(this.rs.toByteArray(regular), 5);
                    }
                    this.alert.setString("Updated: " + regular.description);
                }
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
            if (command == this.parent.deleteCommand) {
                int n7 = this.rs.lookUpIndex(this.r1);
                this.r1.id = this.rs.lookUpId(this.r1);
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(this.rs.toByteArray(this.r1), -5);
                }
                this.rs.deleteRegular(this.r1);
                this.rs.deleteIndex(n7);
                this.alert.setString("Deleted: " + this.r1.description);
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
            if (command == this.parent.okCommand) {
                this.rf = null;
                this.display.setCurrent((Displayable)this);
                return;
            }
            if (command == this.parent.cancelCommand) {
                this.rf = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
        }
        if (displayable == this.sof) {
            if (command == this.parent.createCommand) {
                StandingOrderStore standingOrderStore = null;
                standingOrderStore = this.parent.sov == null ? new StandingOrderStore(this.parent) : this.parent.sov.sos;
                StandingOrder standingOrder = this.sof.update();
                if (standingOrder.description.equals("")) {
                    this.alert.setString("Blank description");
                    this.display.setCurrent(this.alert, (Displayable)this.sof);
                    standingOrderStore.closeStandingOrderStore();
                    return;
                }
                if (standingOrderStore.getStandingOrderFromName(standingOrder.description) != null) {
                    this.alert.setString(standingOrder.description + " already exists");
                    this.display.setCurrent(this.alert, (Displayable)this.sof);
                    standingOrderStore.closeStandingOrderStore();
                    return;
                }
                standingOrder.id = standingOrderStore.saveNewStandingOrder(standingOrder);
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(standingOrderStore.toByteArray(standingOrder), 6);
                }
                if (this.parent.sov == null) {
                    standingOrderStore.closeStandingOrderStore();
                    standingOrderStore = null;
                } else {
                    ++this.parent.sov.numItems;
                }
                this.alert.setString("Saved as Standing Order");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.cancelCommand) {
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
        }
        if (displayable == this.vl) {
            if (command == this.parent.cancelCommand) {
                this.vl = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                this.ts.setIndex(this.a);
                if (this.vl.update() == 0) {
                    this.display.setCurrent((Displayable)this.parent.av);
                }
                if (this.vl.update() == 1) {
                    this.display.setCurrent((Displayable)this);
                }
                if (this.vl.update() == 2) {
                    if (this.parent.cv == null) {
                        this.parent.cv = new CategoryView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.cv);
                }
                if (this.vl.update() == 3) {
                    if (this.parent.sov == null) {
                        this.parent.sov = new StandingOrderView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.sov);
                }
                if (this.vl.update() == 4) {
                    if (this.parent.iv == null) {
                        this.parent.iv = new InvestmentView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.iv);
                }
                if (this.vl.update() == 5) {
                    if (this.parent.ccyv == null) {
                        this.parent.ccyv = new CurrencyView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.ccyv);
                }
            }
        }
        if (displayable == this.gtdf) {
            if (command == this.parent.cancelCommand) {
                this.gtdf = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                this.msg = "Processing, please wait...";
                this.repaint();
                this.serviceRepaints();
                this.display.setCurrent((Displayable)this);
                this.date = this.gtdf.getDate();
                this.runMode = 1;
                this.display.callSerially((Runnable)this);
            }
        }
        if (displayable == this.touchScreenMenu) {
            if (command == this.parent.okCommand) {
                int n8 = this.cgtsm.getSelectedIndex();
                if (n8 == 0) {
                    this.commandAction(this.parent.newCommand, (Displayable)this);
                }
                if (n8 == 1) {
                    this.commandAction(this.parent.regularCommand, (Displayable)this);
                }
                if (n8 == 2) {
                    this.commandAction(this.parent.newStarCommand, (Displayable)this);
                }
                if (n8 == 3) {
                    this.commandAction(this.parent.newSplitCommand, (Displayable)this);
                }
                if (n8 == 4) {
                    this.commandAction(this.parent.editCommand, (Displayable)this);
                }
                if (n8 == 5) {
                    this.commandAction(this.parent.saveAsRegularCommand, (Displayable)this);
                }
                if (n8 == 6) {
                    this.commandAction(this.parent.saveAsStandingOrderCommand, (Displayable)this);
                }
                if (n8 == 7) {
                    this.commandAction(this.parent.deleteCommand, (Displayable)this);
                }
                if (n8 == 8) {
                    this.commandAction(this.parent.reconcileCommand, (Displayable)this);
                }
                if (n8 == 9) {
                    this.commandAction(this.parent.showCommand, (Displayable)this);
                }
                if (n8 == 10) {
                    this.commandAction(this.parent.moveCommand, (Displayable)this);
                }
                if (n8 == 11) {
                    this.commandAction(this.parent.toggleRCCommand, (Displayable)this);
                }
                if (n8 == 12) {
                    this.commandAction(this.parent.toggleDefaultActionCommand, (Displayable)this);
                }
                if (n8 == 13) {
                    this.commandAction(this.parent.mainCommand, (Displayable)this);
                }
                if (n8 == 14) {
                    this.commandAction(this.parent.viewCommand, (Displayable)this);
                }
                if (n8 == 15) {
                    this.commandAction(this.parent.goToDateCommand, (Displayable)this);
                }
                if (n8 == 16) {
                    this.parent.destroyApp(true);
                }
            } else {
                this.touchScreenMenu = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.debug) {
            this.debug = null;
            this.display.setCurrent((Displayable)this);
        }
    }
}

