/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.AccountStore;
import JabpLite.Category;
import JabpLite.CategoryStore;
import JabpLite.CategoryView;
import JabpLite.Currency;
import JabpLite.CurrencyForm;
import JabpLite.CurrencyStore;
import JabpLite.Investment;
import JabpLite.InvestmentStore;
import JabpLite.InvestmentView;
import JabpLite.JabpLite;
import JabpLite.NameId;
import JabpLite.StandingOrderView;
import JabpLite.Transaction;
import JabpLite.TransactionStore;
import JabpLite.Utilities;
import JabpLite.ViewForm;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStoreException;

public class CurrencyView
extends Canvas
implements CommandListener,
Runnable {
    Currency ccy;
    Currency ccy1;
    Currency oldCcy;
    CurrencyForm ccyf;
    Form debug;
    Form touchScreenMenu;
    ChoiceGroup cgtsm;
    CurrencyStore ccys;
    Alert alert;
    Display display;
    Font font;
    JabpLite parent;
    ViewForm vl;
    String oldName = "";
    String msg = "";
    boolean paintWholeScreen = true;
    int fs;
    int width;
    int height;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int numItems;
    int numItemsPage;
    int lineHeight;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int previousPos;
    int oldId;
    int startPos;
    int spacing;
    int numberWidth;
    int currencyWidth;
    int ratePosition;
    int runMode;
    long timePointerOnScreen;
    boolean pointerExecute;

    public CurrencyView(JabpLite jabpLite, Display display) {
        this.parent = jabpLite;
        this.display = display;
        this.setFullScreenMode(this.parent.showFullCanvas);
        this.addCommand(this.parent.exitCommand);
        this.addCommand(this.parent.newCommand);
        this.addCommand(this.parent.editCommand);
        this.addCommand(this.parent.deleteCommand);
        this.addCommand(this.parent.showCommand);
        this.addCommand(this.parent.mainCommand);
        this.addCommand(this.parent.viewCommand);
        this.addCommand(this.parent.cancelCommand);
        this.setCommandListener(this);
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.alert.setTimeout(1500);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.setPositions();
        this.ccys = new CurrencyStore(this.parent);
        this.numItems = this.ccys.getNumCurrencies();
        this.currentX = 0;
        this.currentY = this.lineHeight;
        this.currentPos = 0;
        this.runMode = 0;
        if (this.parent.isAndroid) {
            this.display.callSerially((Runnable)this);
        }
    }

    public void paint(Graphics graphics) {
        if (this.width != this.getWidth() || this.height != this.getHeight() - this.parent.heightAdjustment) {
            this.width = this.getWidth();
            this.height = this.getHeight() - this.parent.heightAdjustment;
            this.setPositions();
            this.paintWholeScreen = true;
        }
        graphics.setFont(this.font);
        if (this.paintWholeScreen || this.parent.isBlackberry) {
            this.showHeader(graphics);
            this.showPage(graphics);
            this.showFooter(graphics);
        } else {
            this.showLines(graphics);
        }
        this.paintWholeScreen = true;
    }

    void showPage(Graphics graphics) {
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        graphics.setColor(this.parent.colorFont);
        if (this.numItems == 0) {
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                graphics.setColor(this.parent.colorCursor);
                graphics.fillRect(0, this.lineHeight * i + this.lineHeight, this.width, this.lineHeight);
                graphics.setColor(this.parent.colorFont);
            }
            this.ccy = this.ccys.getCurrencyFromIndex(i + this.startPos);
            this.buildLine(graphics, this.ccy, this.lineHeight * i + this.lineHeight);
        }
        this.ccy = this.ccys.getCurrencyFromIndex(this.startPos + this.currentPos);
    }

    void showLines(Graphics graphics) {
        if (this.numItems == 0) {
            return;
        }
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.lineHeight * this.previousPos + this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        this.ccy = this.ccys.getCurrencyFromIndex(this.previousPos + this.startPos);
        this.buildLine(graphics, this.ccy, this.lineHeight * this.previousPos + this.lineHeight);
        graphics.setColor(this.parent.colorCursor);
        graphics.fillRect(0, this.lineHeight * this.currentPos + this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        this.ccy = this.ccys.getCurrencyFromIndex(this.currentPos + this.startPos);
        this.buildLine(graphics, this.ccy, this.lineHeight * this.currentPos + this.lineHeight);
    }

    void showHeader(Graphics graphics) {
        int n = this.parent.lineSpacing + this.parent.fontAdjustment;
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, 0, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        if (this.msg.equals("")) {
            graphics.drawString("\u0412\u0430\u043b\u044e\u0442\u044b", this.parent.widthAdjustment, n, 20);
            graphics.drawString("\u041a\u0443\u0440\u0441", this.ratePosition + this.numberWidth - this.font.stringWidth("\u041a\u0443\u0440\u0441"), n, 20);
        } else {
            graphics.drawString(this.msg, this.parent.widthAdjustment, n, 20);
        }
    }

    void showFooter(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
    }

    void drawUp() {
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.lineHeight;
            this.previousPos = this.currentPos--;
            if (this.currentY < this.lineHeight) {
                this.currentY = this.lineHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
            } else {
                this.paintWholeScreen = false;
            }
            this.repaint();
            this.serviceRepaints();
            return;
        }
    }

    void drawDown() {
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.lineHeight;
            this.previousPos = this.currentPos++;
            if (this.currentY + this.lineHeight * 2 > this.height) {
                this.currentY -= this.lineHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
            } else {
                this.paintWholeScreen = false;
            }
            this.repaint();
            this.serviceRepaints();
            return;
        }
    }

    void buildLine(Graphics graphics, Currency currency, int n) {
        int n2 = n + this.parent.lineSpacing + this.parent.fontAdjustment;
        int n3 = currency.code.length();
        for (int i = 0; i < n3; ++i) {
            int n4 = n3 - i;
            if (this.font.stringWidth(currency.code.substring(0, n4)) > this.currencyWidth) continue;
            graphics.drawString(currency.code.substring(0, n4), this.parent.widthAdjustment, n2, 20);
            break;
        }
        String string = Utilities.rateToString(currency.rate, false, this.parent.isEuropeanNumberFormat);
        graphics.drawString(string, this.ratePosition + this.numberWidth - this.font.stringWidth(string), n2, 20);
    }

    void setPositions() {
        this.fs = 8;
        if (this.parent.mediumSize) {
            this.fs = 0;
        }
        if (this.parent.largeSize) {
            this.fs = 16;
        }
        this.font = Font.getFont((int)0, (int)0, (int)this.fs);
        this.fontHeight = this.font.getHeight();
        this.lineHeight = this.fontHeight + this.parent.lineSpacing * 2;
        this.numberWidth = this.parent.isGroupingUsed ? this.font.stringWidth("999,999.99") : this.font.stringWidth("999999.99");
        this.numItemsPage = this.height / this.lineHeight - 2;
        this.spacing = 10;
        if (this.width > 500) {
            this.spacing = 20;
        }
        if (this.width > 640) {
            this.spacing = 30;
        }
        this.currencyWidth = this.width - this.numberWidth - this.parent.widthAdjustment * 2 - this.spacing;
        this.ratePosition = this.width > 400 ? 400 : this.currencyWidth + this.parent.widthAdjustment;
    }

    Currency showCurrency() {
        this.oldCcy = new Currency();
        this.oldCcy.clone(this.ccy);
        return this.ccy;
    }

    int newCurrency(Currency currency) {
        this.ccy1 = currency;
        this.ccy1.id = this.ccys.saveNewCurrency(this.ccy1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.ccys.toByteArray(this.ccy1), 3);
        }
        if (this.ccy == null) {
            this.ccy = this.ccy1;
        }
        ++this.numItems;
        this.repaint();
        return this.ccy1.id;
    }

    void editCurrency(Currency currency) {
        this.ccy1 = currency;
        this.ccys.saveExistingCurrency(this.ccy1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.ccys.toByteArray(this.oldCcy), -3);
            this.parent.sync.saveSyncRecord(this.ccys.toByteArray(this.ccy1), 3);
        }
        if (!this.ccy1.code.equals(this.oldCcy.code)) {
            this.runMode = 1;
            this.display.callSerially((Runnable)this);
        } else {
            this.msg = "";
        }
        if (this.ccy1.rate != this.oldCcy.rate) {
            this.runMode = 2;
            this.display.callSerially((Runnable)this);
        } else {
            this.msg = "";
        }
        this.repaint();
    }

    void deleteCurrency(Currency currency) {
        this.ccy1 = currency;
        this.ccys.deleteCurrency(this.ccy1);
        if (this.parent.syncMode) {
            this.parent.sync.saveSyncRecord(this.ccys.toByteArray(this.ccy1), -3);
        }
        this.ccys.deleteIndex(this.startPos + this.currentPos);
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.lineHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.repaint();
    }

    void updateCurrencyName() {
        this.ccys.deleteIndex(this.startPos + this.currentPos);
        this.ccys.addIndex(this.ccy1);
        AccountStore accountStore = new AccountStore(this.parent);
        RecordEnumeration recordEnumeration = accountStore.getAccounts();
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                Account account = accountStore.getAccount(n);
                if (!account.currency.equals(this.oldCcy.code)) continue;
                account.currency = this.ccy1.code;
                accountStore.saveExistingAccount(account);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ccyv5");
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        accountStore.closeAccountStore();
        accountStore = null;
        InvestmentStore investmentStore = null;
        investmentStore = this.parent.iv == null ? new InvestmentStore(this.parent) : this.parent.iv.is;
        recordEnumeration = investmentStore.getInvestments();
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                Investment investment = investmentStore.getInvestment(n);
                if (!investment.currency.equals(this.oldCcy.code)) continue;
                investment.currency = this.ccy1.code;
                investmentStore.saveExistingInvestment(investment);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ccyv5a");
        }
        recordEnumeration = null;
        if (this.parent.iv == null) {
            investmentStore.closeInvestmentStore();
            investmentStore = null;
        }
        this.msg = "";
        this.repaint();
    }

    void updateCurrencyTransactions() {
        AccountStore accountStore = null;
        accountStore = this.parent.av == null ? new AccountStore(this.parent) : this.parent.av.as;
        CategoryStore categoryStore = null;
        categoryStore = this.parent.cv == null ? new CategoryStore(this.parent) : this.parent.cv.cs;
        TransactionStore transactionStore = null;
        if (this.parent.tv == null) {
            transactionStore = new TransactionStore(this.parent, new Account());
        } else {
            transactionStore = this.parent.tv.ts;
            transactionStore.setIndex(this.parent.tv.a);
        }
        RecordEnumeration recordEnumeration = accountStore.getAccounts();
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                Account account = accountStore.getAccount(n);
                if (!account.currency.equals(this.ccy1.code)) continue;
                Category category = categoryStore.getCategoryFromName("FX \u0420\u0435\u0433\u0443\u043b\u0438\u0440\u043e\u0432\u043a\u0430");
                transactionStore.getIndex(account);
                Transaction transaction = new Transaction();
                transaction.longDate = this.parent.todayDate.getTime();
                transaction.account = account.name;
                transaction.description = "FX \u0420\u0435\u0433\u0443\u043b\u0438\u0440\u043e\u0432\u043a\u0430";
                long l = account.current;
                long l2 = this.oldCcy.rate;
                long l3 = this.ccy1.rate;
                long l4 = l * l2 / l3;
                transaction.amount = (int)l4 - account.current;
                transaction.category = category.name;
                transaction.reconciled = true;
                transaction.id = transactionStore.saveNewTransaction(transaction);
                if (this.parent.syncMode) {
                    this.parent.sync.saveSyncRecord(transactionStore.toByteArray(transaction), 7);
                }
                transactionStore.setIndex(account);
                if (this.parent.tv != null && this.parent.tv.a.name.equals(account.name)) {
                    ++this.parent.tv.numItems;
                }
                this.parent.av.totalToday -= account.today;
                this.parent.av.totalReconciled -= account.reconciled;
                account.updateBalance(transaction, null, this.parent.todayDays);
                this.parent.av.totalToday += account.today;
                this.parent.av.totalReconciled += account.reconciled;
                accountStore.saveExistingAccount(account);
                category = categoryStore.getCategoryFromName(category.name);
                if (this.parent.cv != null) {
                    this.parent.cv.totalCurrent -= category.current;
                }
                category.updateBalance(transaction, null);
                if (this.parent.cv != null) {
                    this.parent.cv.totalCurrent += category.current;
                }
                categoryStore.saveExistingCategory(category);
                category = null;
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " ccyv5b");
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        if (this.parent.tv == null) {
            transactionStore.closeTransactionStore();
            transactionStore = null;
        } else {
            transactionStore.getIndex(this.parent.tv.a);
        }
        if (this.parent.cv == null) {
            categoryStore.closeCategoryStore();
            categoryStore = null;
        }
        if (this.parent.av == null) {
            accountStore.closeAccountStore();
            accountStore = null;
        }
    }

    protected void showNotify() {
        this.repaint();
    }

    void androidDelay() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void run() {
        if (this.runMode == 0) {
            this.androidDelay();
        }
        if (this.runMode == 1) {
            this.updateCurrencyName();
        }
        if (this.runMode == 2) {
            this.updateCurrencyTransactions();
        }
    }

    protected void keyPressed(int n) {
        if (this.getGameAction(n) == 2) {
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.lineHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (this.getGameAction(n) == 5) {
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
            this.repaint();
            return;
        }
        if (this.getGameAction(n) == 8) {
            this.displayTouchScreenMenu();
            return;
        }
        if (this.getGameAction(n) == 1) {
            this.drawUp();
            return;
        }
        if (this.getGameAction(n) == 6) {
            this.drawDown();
            return;
        }
        if (n == 48) {
            int n2 = this.startPos + this.currentPos;
            this.debug = new Form("Record Properties");
            this.debug.append("Position " + n2 + " of " + this.numItems + "\n");
            short s = (short)n2;
            int n3 = ((NameId)this.ccys.ht.get((Object)new Short((short)s))).id;
            this.debug.append("Record ID " + n3 + "\n");
            this.debug.append("Record length " + this.ccys.getRecordSize(n3) + "\n");
            this.debug.append("RecordStore size " + this.ccys.getSize() + "\n");
            this.debug.addCommand(this.parent.okCommand);
            this.debug.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.debug);
        }
    }

    protected void pointerPressed(int n, int n2) {
        this.pointerExecute = false;
        this.timePointerOnScreen = System.currentTimeMillis();
        if (n2 < this.lineHeight) {
            this.keyPressed(this.getKeyCode(2));
            return;
        }
        if (n2 > this.height - this.lineHeight) {
            this.keyPressed(this.getKeyCode(5));
            return;
        }
        this.pointerExecute = true;
        int n3 = (n2 - this.lineHeight) / this.lineHeight;
        if (n3 >= this.numItems) {
            return;
        }
        this.previousPos = this.currentPos;
        this.currentPos = n3;
        this.currentY = (this.currentPos + 1) * this.lineHeight;
        this.paintWholeScreen = false;
        this.repaint();
    }

    protected void pointerReleased(int n, int n2) {
        this.timePointerOnScreen = System.currentTimeMillis() - this.timePointerOnScreen;
        if (this.timePointerOnScreen > 1000L) {
            this.displayTouchScreenMenu();
            return;
        }
        if (!this.pointerExecute) {
            return;
        }
        this.displayTouchScreenMenu();
    }

    void displayTouchScreenMenu() {
        this.touchScreenMenu = new Form("\u0412\u0430\u043b\u044e\u0442\u044b");
        this.cgtsm = new ChoiceGroup("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e", 1);
        this.cgtsm.append("\u041d\u043e\u0432\u0430\u044f", null);
        this.cgtsm.append("\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c", null);
        this.cgtsm.append("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", null);
        this.cgtsm.append("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c", null);
        this.cgtsm.append("\u0413\u043b\u0430\u0432\u043d\u043e\u0435 \u043e\u043a\u043d\u043e", null);
        this.cgtsm.append("\u041f\u0435\u0440\u0435\u043a\u043b. \u043e\u043a\u043d\u043e", null);
        this.cgtsm.append("\u0412\u044b\u0445\u043e\u0434", null);
        this.touchScreenMenu.append((Item)this.cgtsm);
        this.touchScreenMenu.addCommand(this.parent.okCommand);
        this.touchScreenMenu.addCommand(this.parent.cancelCommand);
        this.touchScreenMenu.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.touchScreenMenu);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.parent.exitCommand) {
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this) {
            if (command == this.parent.newCommand) {
                this.ccyf = new CurrencyForm(this.parent, new Currency(), "\u041d\u043e\u0432\u0430\u044f");
                this.ccyf.addCommand(this.parent.createCommand);
                this.ccyf.addCommand(this.parent.cancelCommand);
                this.ccyf.addCommand(this.parent.exitCommand);
                this.ccyf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.ccyf);
            }
            if (command == this.parent.editCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0432\u0430\u043b\u044e\u0442");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.msg = "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0432\u0430\u043b\u044e\u0442\u044b...";
                this.repaint();
                this.ccyf = new CurrencyForm(this.parent, this.showCurrency(), "\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c");
                this.ccyf.addCommand(this.parent.updateCommand);
                this.ccyf.addCommand(this.parent.cancelCommand);
                this.ccyf.addCommand(this.parent.exitCommand);
                this.ccyf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.ccyf);
            }
            if (command == this.parent.deleteCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0432\u0430\u043b\u044e\u0442");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.ccyf = new CurrencyForm(this.parent, this.showCurrency(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
                this.ccyf.addCommand(this.parent.deleteCommand);
                this.ccyf.addCommand(this.parent.cancelCommand);
                this.ccyf.addCommand(this.parent.exitCommand);
                this.ccyf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.ccyf);
            }
            if (command == this.parent.showCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435\u0442 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0432\u0430\u043b\u044e\u0442");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.ccyf = new CurrencyForm(this.parent, this.showCurrency(), "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c");
                this.ccyf.addCommand(this.parent.okCommand);
                this.ccyf.addCommand(this.parent.exitCommand);
                this.ccyf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.ccyf);
            }
            if (command == this.parent.mainCommand) {
                this.display.setCurrent((Displayable)this.parent.av);
            }
            if (command == this.parent.viewCommand) {
                this.vl = new ViewForm();
                this.vl.addCommand(this.parent.okCommand);
                this.vl.addCommand(this.parent.cancelCommand);
                this.vl.addCommand(this.parent.exitCommand);
                this.vl.setCommandListener(this);
                this.display.setCurrent((Displayable)this.vl);
            }
        }
        if (displayable == this.ccyf) {
            if (command == this.parent.deleteCommand) {
                this.ccyf = null;
                AccountStore accountStore = new AccountStore(this.parent);
                RecordEnumeration recordEnumeration = accountStore.getAccounts();
                try {
                    while (recordEnumeration.hasNextElement()) {
                        int n = recordEnumeration.nextRecordId();
                        Account account = accountStore.getAccount(n);
                        if (!account.currency.equals(this.ccy.code)) continue;
                        this.alert.setString("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0442 \u0443\u0447. \u0437\u0430\u043f\u0438\u0441\u0438");
                        this.display.setCurrent(this.alert, (Displayable)this);
                        recordEnumeration.destroy();
                        recordEnumeration = null;
                        accountStore.closeAccountStore();
                        accountStore = null;
                        return;
                    }
                }
                catch (RecordStoreException recordStoreException) {
                    System.err.println((Object)((Object)recordStoreException) + " ccyv9");
                }
                recordEnumeration.destroy();
                recordEnumeration = null;
                accountStore.closeAccountStore();
                accountStore = null;
                InvestmentStore investmentStore = new InvestmentStore(this.parent);
                recordEnumeration = investmentStore.getInvestments();
                try {
                    while (recordEnumeration.hasNextElement()) {
                        int n = recordEnumeration.nextRecordId();
                        Investment investment = investmentStore.getInvestment(n);
                        if (!investment.currency.equals(this.ccy.code)) continue;
                        this.alert.setString("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0434\u0430\u043b\u0438\u0442\u044c");
                        this.display.setCurrent(this.alert, (Displayable)this);
                        recordEnumeration.destroy();
                        recordEnumeration = null;
                        investmentStore.closeInvestmentStore();
                        investmentStore = null;
                        return;
                    }
                }
                catch (RecordStoreException recordStoreException) {
                    System.err.println((Object)((Object)recordStoreException) + " ccyv9a");
                }
                recordEnumeration.destroy();
                recordEnumeration = null;
                investmentStore.closeInvestmentStore();
                investmentStore = null;
                if (this.ccy.code.equals(this.parent.homeCurrency)) {
                    this.alert.setString("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0434\u0430\u043b\u0438\u0442\u044c ");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.deleteCurrency(this.ccy);
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.okCommand) {
                this.msg = "";
                this.ccyf = null;
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.createCommand) {
                this.ccy1 = this.ccyf.update();
                if (this.ccy1.code.equals("")) {
                    this.alert.setString("\u041d\u0435\u0442 \u043a\u043e\u0434\u0430 \u0432\u0430\u043b\u044e\u0442\u044b");
                    this.display.setCurrent(this.alert, (Displayable)this.ccyf);
                    return;
                }
                if (this.ccys.lookUpId(this.ccy1) != 0) {
                    this.alert.setString(this.ccy1.code + " already exists");
                    this.display.setCurrent(this.alert, (Displayable)this.ccyf);
                    return;
                }
                this.display.setCurrent((Displayable)this);
                this.newCurrency(this.ccy1);
                this.ccyf = null;
            }
            if (command == this.parent.updateCommand) {
                boolean bl = false;
                if (this.ccy.code.equals(this.parent.homeCurrency)) {
                    bl = true;
                }
                this.ccy1 = this.ccyf.update();
                if (this.ccy1.code.equals("")) {
                    this.alert.setString("\u041d\u0435\u0442 \u043a\u043e\u0434\u0430 \u0432\u0430\u043b\u044e\u0442\u044b");
                    this.display.setCurrent(this.alert, (Displayable)this.ccyf);
                    return;
                }
                int n = this.ccy1.id;
                if (!this.ccy1.code.equals(this.oldCcy.code) && this.ccys.lookUpId(this.ccy1) != 0) {
                    this.alert.setString(this.ccy1.code + " already exists");
                    this.display.setCurrent(this.alert, (Displayable)this.ccyf);
                    return;
                }
                this.ccy1.id = n;
                if (bl && this.ccy1.rate != 100000) {
                    this.alert.setString("\u041a\u0443\u0440\u0441 \u0434\u043e\u043c\u0430\u0448\u043d\u0435\u0439 \u0432\u0430\u043b\u044e\u0442\u044b \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c 1.00");
                    this.display.setCurrent(this.alert, (Displayable)this.ccyf);
                    return;
                }
                this.ccyf = null;
                this.display.setCurrent((Displayable)this);
                this.editCurrency(this.ccy1);
                if (bl) {
                    this.parent.homeCurrency = this.ccy1.code;
                }
            }
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.ccyf = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.vl) {
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.vl = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                if (this.vl.update() == 0) {
                    this.display.setCurrent((Displayable)this.parent.av);
                }
                if (this.vl.update() == 1) {
                    if (this.parent.tv == null) {
                        this.alert.setString("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0443\u0447. \u0437\u0430\u043f\u0438\u0441\u044c");
                        this.display.setCurrent(this.alert, (Displayable)this);
                    } else {
                        this.display.setCurrent((Displayable)this.parent.tv);
                    }
                }
                if (this.vl.update() == 2) {
                    if (this.parent.cv == null) {
                        this.parent.cv = new CategoryView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.cv);
                }
                if (this.vl.update() == 3) {
                    if (this.parent.sov == null) {
                        this.parent.sov = new StandingOrderView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.sov);
                }
                if (this.vl.update() == 4) {
                    if (this.parent.iv == null) {
                        this.parent.iv = new InvestmentView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.iv);
                }
                if (this.vl.update() == 5) {
                    this.display.setCurrent((Displayable)this);
                }
            }
        }
        if (displayable == this.debug) {
            this.debug = null;
            this.display.setCurrent((Displayable)this);
        }
        if (displayable == this.touchScreenMenu) {
            if (command == this.parent.okCommand) {
                int n = this.cgtsm.getSelectedIndex();
                if (n == 0) {
                    this.commandAction(this.parent.newCommand, (Displayable)this);
                }
                if (n == 1) {
                    this.commandAction(this.parent.editCommand, (Displayable)this);
                }
                if (n == 2) {
                    this.commandAction(this.parent.deleteCommand, (Displayable)this);
                }
                if (n == 3) {
                    this.commandAction(this.parent.showCommand, (Displayable)this);
                }
                if (n == 4) {
                    this.commandAction(this.parent.mainCommand, (Displayable)this);
                }
                if (n == 5) {
                    this.commandAction(this.parent.viewCommand, (Displayable)this);
                }
                if (n == 6) {
                    this.parent.destroyApp(true);
                }
            } else {
                this.touchScreenMenu = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
    }
}

