/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.Currency;
import JabpLite.CurrencyStore;
import JabpLite.JabpLite;
import JabpLite.Utilities;
import java.util.Hashtable;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class AccountForm
extends Form {
    Account a;
    JabpLite parent;
    TextField tfName;
    TextField tfDescription;
    TextField tfOpen;
    ChoiceGroup cgCurrency;
    ChoiceGroup cgType;
    ChoiceGroup cgDRCR;

    public AccountForm(JabpLite jabpLite, Account account, String string) {
        super(string + " \u0423\u0447. \u0437\u0430\u043f\u0438\u0441\u044c");
        this.parent = jabpLite;
        this.a = account;
        if (string.equals("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c") || string.equals("\u0423\u0434\u0430\u043b\u0438\u0442\u044c")) {
            this.append("\u0418\u043c\u044f: " + this.a.name + "\n");
            this.append("Desc: " + this.a.description + "\n");
            String string2 = " DR";
            if (this.a.open >= 0) {
                string2 = " CR";
            }
            this.append("\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u0431\u0430\u043b\u0430\u043d\u0441\u0430: " + Utilities.numberToString(Math.abs(this.a.open), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + string2 + "\n");
            string2 = " DR";
            if (this.a.current >= 0) {
                string2 = " CR";
            }
            this.append("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0431\u0430\u043b\u0430\u043d\u0441: " + Utilities.numberToString(Math.abs(this.a.current), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + string2 + "\n");
            string2 = " DR";
            if (this.a.today >= 0) {
                string2 = " CR";
            }
            this.append("\u0421\u0435\u0433\u043e\u0434\u043d. \u0431\u0430\u043b\u0430\u043d\u0441: " + Utilities.numberToString(Math.abs(this.a.today), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + string2 + "\n");
            string2 = " DR";
            if (this.a.reconciled >= 0) {
                string2 = " CR";
            }
            this.append("\u041f\u0440\u0438\u043c\u0438\u0440\u0435\u043d\u043d\u044b\u0439 \u0431\u0430\u043b\u0430\u043d\u0441: " + Utilities.numberToString(Math.abs(this.a.reconciled), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + string2 + "\n");
            if (!this.a.currency.equals(this.parent.homeCurrency)) {
                this.append("\u0412\u0441\u0435 \u0441\u0443\u043c\u043c\u044b \u0441\u0432\u044b\u0448\u0435 " + this.parent.homeCurrency + "\n");
            }
            this.append("\u0412\u0430\u043b\u044e\u0442\u0430: " + this.a.currency + "\n");
            this.append("\u0422\u0438\u043f: " + this.a.type + "\n");
            Hashtable hashtable = null;
            hashtable = this.parent.transactionHt.containsKey(this.a.name) ? (Hashtable)this.parent.transactionHt.get(this.a.name) : new Hashtable();
            this.append("\u0417\u0430\u043f\u0438\u0441\u0438: " + hashtable.size());
            return;
        }
        this.tfName = new TextField("\u0418\u043c\u044f", this.a.name, 30, 0);
        this.append((Item)this.tfName);
        this.tfDescription = new TextField("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", this.a.description, 64, 0);
        this.append((Item)this.tfDescription);
        int n = 2;
        if (!this.parent.numericEntry) {
            n = 0;
        }
        this.tfOpen = string.equals("\u041d\u043e\u0432\u044b\u0439") ? new TextField("\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u0431\u0430\u043b\u0430\u043d\u0441\u0430", "", 20, n) : new TextField("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0431\u0430\u043b. \u0432 " + this.parent.homeCurrency, "", 20, n);
        String string3 = "";
        if (this.a.open != 0) {
            string3 = Utilities.numberToString(Math.abs(this.a.open), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false);
        }
        this.tfOpen.setString(string3);
        this.append((Item)this.tfOpen);
        int n2 = 4;
        if (this.parent.oldStyleChoice) {
            n2 = 1;
        }
        this.cgDRCR = new ChoiceGroup("DR/CR", n2);
        this.cgDRCR.append("\u0414\u0435\u0431\u0435\u0442", null);
        this.cgDRCR.append("\u041a\u0440\u0435\u0434\u0438\u0442", null);
        if (this.a.open < 0) {
            this.cgDRCR.setSelectedIndex(0, true);
        } else {
            this.cgDRCR.setSelectedIndex(1, true);
        }
        this.append((Item)this.cgDRCR);
        this.cgCurrency = new ChoiceGroup("\u0412\u0430\u043b\u044e\u0442\u0430", n2);
        CurrencyStore currencyStore = new CurrencyStore(this.parent);
        int n3 = currencyStore.getNumCurrencies();
        for (int i = 0; i < n3; ++i) {
            Currency currency = currencyStore.getCurrencyFromIndex(i);
            this.cgCurrency.append(currency.code, null);
            if (string.equals("\u041d\u043e\u0432\u044b\u0439") && currency.code.equals(this.parent.homeCurrency)) {
                this.cgCurrency.setSelectedIndex(i, true);
            }
            if (!string.equals("\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c") || !currency.code.equals(this.a.currency)) continue;
            this.cgCurrency.setSelectedIndex(i, true);
        }
        this.append((Item)this.cgCurrency);
        currencyStore.closeCurrencyStore();
        currencyStore = null;
        this.cgType = new ChoiceGroup("\u0422\u0438\u043f", n2);
        this.cgType.append("\u0411\u0430\u043d\u043a", null);
        this.cgType.append("\u041d\u0430\u043b\u0438\u0447\u043d\u044b\u0435", null);
        this.cgType.append("\u041a\u0440\u0435\u0434\u0438\u0442. \u043a\u0430\u0440\u0442\u0430", null);
        this.cgType.append("Asset", null);
        this.cgType.append("Liability", null);
        if (this.a.type.equals("\u0411\u0430\u043d\u043a")) {
            this.cgType.setSelectedIndex(0, true);
        }
        if (this.a.type.equals("\u041d\u0430\u043b\u0438\u0447\u043d\u044b\u0435")) {
            this.cgType.setSelectedIndex(1, true);
        }
        if (this.a.type.equals("\u041a\u0440\u0435\u0434\u0438\u0442. \u043a\u0430\u0440\u0442\u0430")) {
            this.cgType.setSelectedIndex(2, true);
        }
        if (this.a.type.equals("Asset")) {
            this.cgType.setSelectedIndex(3, true);
        }
        if (this.a.type.equals("Liability")) {
            this.cgType.setSelectedIndex(4, true);
        }
        this.append((Item)this.cgType);
        n3 = 0;
        if (this.parent.transactionHt.containsKey(this.a.name)) {
            n3 = ((Hashtable)this.parent.transactionHt.get(this.a.name)).size();
        }
        this.append("Contains " + n3 + " transactions");
    }

    Account update(boolean bl) {
        this.a.name = this.tfName.getString();
        this.a.description = this.tfDescription.getString();
        this.a.currency = this.cgCurrency.getString(this.cgCurrency.getSelectedIndex());
        int n = this.a.open;
        this.a.open = Utilities.stringToNumber(this.tfOpen.getString(), n, this.parent.numericEntry, this.parent.isEuropeanNumberFormat);
        if (this.cgDRCR.getSelectedIndex() == 0) {
            this.a.open = -this.a.open;
        }
        if (bl && !this.a.currency.equals(this.parent.homeCurrency)) {
            CurrencyStore currencyStore = new CurrencyStore(this.parent);
            Currency currency = currencyStore.getCurrencyFromName(this.a.currency);
            this.a.open = Utilities.foreignToHome(this.a.open, currency.rate);
            currency = null;
            currencyStore.closeCurrencyStore();
            currencyStore = null;
        }
        this.a.current += this.a.open - n;
        this.a.today += this.a.open - n;
        this.a.reconciled += this.a.open - n;
        switch (this.cgType.getSelectedIndex()) {
            case 0: {
                this.a.type = "\u0411\u0430\u043d\u043a";
                break;
            }
            case 1: {
                this.a.type = "\u041d\u0430\u043b\u0438\u0447\u043d\u044b\u0435";
                break;
            }
            case 2: {
                this.a.type = "\u041a\u0440\u0435\u0434\u0438\u0442. \u043a\u0430\u0440\u0442\u0430";
                break;
            }
            case 3: {
                this.a.type = "Asset";
                break;
            }
            case 4: {
                this.a.type = "Liability";
            }
        }
        return this.a;
    }
}

