/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.DateId;
import JabpLite.JabpLite;
import JabpLite.NameId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class IndexStore {
    RecordStore rs;
    JabpLite parent;
    String name1;

    public IndexStore(JabpLite jabpLite) {
        this.parent = jabpLite;
        try {
            this.rs = RecordStore.openRecordStore((String)"\u0418\u043d\u0434\u0435\u043a\u0441\u044b", (boolean)true, (int)1, (boolean)true);
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " in1");
        }
    }

    void closeIndexStore() {
        if (this.rs == null) {
            return;
        }
        try {
            this.rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " in2");
        }
    }

    void selfDestruct() {
        try {
            RecordStore.deleteRecordStore((String)"\u0418\u043d\u0434\u0435\u043a\u0441\u044b");
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " in4");
        }
    }

    int getNumIndices() {
        if (this.rs == null) {
            return 0;
        }
        try {
            return this.rs.getNumRecords();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " in3");
            return 0;
        }
    }

    byte[] ht1ToByteArray(Hashtable hashtable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(hashtable.size());
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Short s = (Short)enumeration.nextElement();
                short s2 = s;
                dataOutputStream.writeShort(s2);
                NameId nameId = (NameId)hashtable.get(s);
                dataOutputStream.writeUTF(nameId.name);
                dataOutputStream.writeInt(nameId.id);
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException + " in8a");
        }
        return byteArrayOutputStream.toByteArray();
    }

    byte[] ht2ToByteArray(Hashtable hashtable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(hashtable.size());
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Short s = (Short)enumeration.nextElement();
                short s2 = s;
                dataOutputStream.writeShort(s2);
                DateId dateId = (DateId)hashtable.get(s);
                dataOutputStream.writeLong(dateId.date.getTime());
                dataOutputStream.writeInt(dateId.id);
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException + " in8b");
        }
        return byteArrayOutputStream.toByteArray();
    }

    byte[] ht3ToByteArray(Hashtable hashtable, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeInt(hashtable.size());
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Short s = (Short)enumeration.nextElement();
                short s2 = s;
                dataOutputStream.writeShort(s2);
                DateId dateId = (DateId)hashtable.get(s);
                dataOutputStream.writeLong(dateId.date.getTime());
                dataOutputStream.writeInt(dateId.id);
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException + " in8c");
        }
        return byteArrayOutputStream.toByteArray();
    }

    Hashtable ht1FromByteArray(byte[] byArray) {
        Hashtable<Short, NameId> hashtable = new Hashtable<Short, NameId>();
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                short s = dataInputStream.readShort();
                String string = dataInputStream.readUTF();
                int n2 = dataInputStream.readInt();
                hashtable.put(new Short(s), new NameId(string, n2));
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " in9a");
        }
        return hashtable;
    }

    Hashtable ht2FromByteArray(byte[] byArray) {
        Hashtable<Short, DateId> hashtable = new Hashtable<Short, DateId>();
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                short s = dataInputStream.readShort();
                Date date = new Date(dataInputStream.readLong());
                int n2 = dataInputStream.readInt();
                hashtable.put(new Short(s), new DateId(date, n2));
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " in9a");
        }
        return hashtable;
    }

    Hashtable ht3FromByteArray(byte[] byArray) {
        Hashtable<Short, DateId> hashtable = new Hashtable<Short, DateId>();
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.name1 = dataInputStream.readUTF();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                short s = dataInputStream.readShort();
                Date date = new Date(dataInputStream.readLong());
                int n2 = dataInputStream.readInt();
                hashtable.put(new Short(s), new DateId(date, n2));
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " in9a");
        }
        return hashtable;
    }

    boolean getIndices() {
        try {
            byte[] byArray = this.rs.getRecord(1);
            this.parent.accountHt = this.ht1FromByteArray(byArray);
            byArray = this.rs.getRecord(2);
            this.parent.categoryHt = this.ht1FromByteArray(byArray);
            byArray = this.rs.getRecord(3);
            this.parent.currencyHt = this.ht1FromByteArray(byArray);
            byArray = this.rs.getRecord(4);
            this.parent.standingOrderHt = this.ht2FromByteArray(byArray);
            byArray = this.rs.getRecord(5);
            this.parent.regularHt = this.ht1FromByteArray(byArray);
            byArray = this.rs.getRecord(6);
            this.parent.investmentHt = this.ht1FromByteArray(byArray);
            for (int i = 0; i < this.parent.accountHt.size(); ++i) {
                byArray = this.rs.getRecord(7 + i);
                short s = (short)i;
                String string = ((NameId)this.parent.accountHt.get((Object)new Short((short)s))).name;
                Hashtable hashtable = this.ht3FromByteArray(byArray);
                if (!string.equals(this.name1)) {
                    System.out.println("\u0418\u043c\u044f \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 getIndices()");
                }
                this.parent.transactionHt.put(this.name1, hashtable);
            }
            return true;
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " in5");
            return false;
        }
    }

    void saveIndices() {
        if (this.rs == null) {
            return;
        }
        try {
            boolean bl = false;
            int n = this.rs.getNumRecords();
            if (n > 0) {
                bl = true;
            }
            if (bl) {
                byte[] byArray = this.ht1ToByteArray(this.parent.accountHt);
                this.rs.setRecord(1, byArray, 0, byArray.length);
                byArray = this.ht1ToByteArray(this.parent.categoryHt);
                this.rs.setRecord(2, byArray, 0, byArray.length);
                byArray = this.ht1ToByteArray(this.parent.currencyHt);
                this.rs.setRecord(3, byArray, 0, byArray.length);
                byArray = this.ht2ToByteArray(this.parent.standingOrderHt);
                this.rs.setRecord(4, byArray, 0, byArray.length);
                byArray = this.ht1ToByteArray(this.parent.regularHt);
                this.rs.setRecord(5, byArray, 0, byArray.length);
                byArray = this.ht1ToByteArray(this.parent.investmentHt);
                this.rs.setRecord(6, byArray, 0, byArray.length);
                for (int i = 0; i < this.parent.accountHt.size(); ++i) {
                    short s = (short)i;
                    String string = ((NameId)this.parent.accountHt.get((Object)new Short((short)s))).name;
                    Hashtable hashtable = new Hashtable();
                    hashtable = (Hashtable)this.parent.transactionHt.get(string);
                    byArray = this.ht3ToByteArray(hashtable, string);
                    if (7 + i > n) {
                        this.rs.addRecord(byArray, 0, byArray.length);
                        continue;
                    }
                    this.rs.setRecord(7 + i, byArray, 0, byArray.length);
                }
            } else {
                byte[] byArray = this.ht1ToByteArray(this.parent.accountHt);
                this.rs.addRecord(byArray, 0, byArray.length);
                byArray = this.ht1ToByteArray(this.parent.categoryHt);
                this.rs.addRecord(byArray, 0, byArray.length);
                byArray = this.ht1ToByteArray(this.parent.currencyHt);
                this.rs.addRecord(byArray, 0, byArray.length);
                byArray = this.ht2ToByteArray(this.parent.standingOrderHt);
                this.rs.addRecord(byArray, 0, byArray.length);
                byArray = this.ht1ToByteArray(this.parent.regularHt);
                this.rs.addRecord(byArray, 0, byArray.length);
                byArray = this.ht1ToByteArray(this.parent.investmentHt);
                this.rs.addRecord(byArray, 0, byArray.length);
                for (int i = 0; i < this.parent.accountHt.size(); ++i) {
                    short s = (short)i;
                    String string = ((NameId)this.parent.accountHt.get((Object)new Short((short)s))).name;
                    Hashtable hashtable = new Hashtable();
                    hashtable = (Hashtable)this.parent.transactionHt.get(string);
                    byArray = this.ht3ToByteArray(hashtable, string);
                    this.rs.addRecord(byArray, 0, byArray.length);
                }
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " in7");
        }
    }

    int getSize() {
        try {
            return this.rs.getSize();
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " in9");
            return 0;
        }
    }
}

