/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.CategoryView;
import JabpLite.CurrencyView;
import JabpLite.Investment;
import JabpLite.InvestmentForm;
import JabpLite.InvestmentStore;
import JabpLite.JabpLite;
import JabpLite.NameId;
import JabpLite.PreferenceForm;
import JabpLite.StandingOrderView;
import JabpLite.Utilities;
import JabpLite.ViewForm;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;

public class InvestmentView
extends Canvas
implements CommandListener {
    Investment inv;
    Investment inv1;
    Investment oldInv;
    Investment previousInv;
    InvestmentForm invf;
    Form debug;
    InvestmentStore is;
    Alert alert;
    Display display;
    Font font;
    PreferenceForm pf;
    JabpLite parent;
    ViewForm vl;
    int width;
    int height;
    int actionKey;
    int upKey;
    int downKey;
    int leftKey;
    int rightKey;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int numItems;
    int numItemsPage;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int oldPos;
    int oldId;
    int startPos;
    int totalValue;
    int numberWidth;
    int priceWidth;
    int investmentWidth;
    int holdingsPosition;
    int pricePosition;
    int valuePosition;
    boolean showPrice;
    boolean reducedHeading;

    public InvestmentView(JabpLite jabpLite, Display display) {
        this.parent = jabpLite;
        this.display = display;
        this.addCommand(this.parent.exitCommand);
        this.addCommand(this.parent.newCommand);
        this.addCommand(this.parent.editCommand);
        this.addCommand(this.parent.deleteCommand);
        this.addCommand(this.parent.mainCommand);
        this.addCommand(this.parent.viewCommand);
        this.addCommand(this.parent.cancelCommand);
        this.setCommandListener(this);
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.alert.setTimeout(1500);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        int n = 8;
        if (this.parent.mediumSize) {
            n = 0;
        }
        this.font = Font.getFont((int)0, (int)0, (int)n);
        this.fontHeight = this.font.getHeight();
        this.numberWidth = this.font.stringWidth("999999.99");
        this.priceWidth = this.font.stringWidth("999.99");
        this.setPositions();
        this.numItemsPage = this.height / this.fontHeight - 2;
        this.actionKey = this.getKeyCode(8);
        this.upKey = this.getKeyCode(1);
        this.downKey = this.getKeyCode(6);
        this.leftKey = this.getKeyCode(2);
        this.rightKey = this.getKeyCode(5);
        this.is = new InvestmentStore(this.parent);
        this.numItems = this.is.getNumInvestments();
        if (this.numItems > 0) {
            this.setTotals();
        }
        this.currentX = 0;
        this.currentY = this.fontHeight;
        this.currentPos = 0;
        this.startPos = 0;
    }

    public void paint(Graphics graphics) {
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.numItemsPage = this.height / this.fontHeight - 2;
        graphics.setFont(this.font);
        this.showHeader(graphics);
        this.showPage(graphics);
        this.showFooter(graphics);
    }

    void showPage(Graphics graphics) {
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.fontHeight, this.width, this.height - this.fontHeight * 2);
        graphics.setColor(0);
        if (this.numItems == 0) {
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                graphics.setColor(this.parent.colorCursor);
                graphics.fillRect(0, this.fontHeight * i + this.fontHeight, this.width, this.fontHeight);
                graphics.setColor(0);
            }
            this.inv = this.is.getInvestmentFromIndex(i + this.startPos);
            this.buildLine(graphics, this.inv, this.fontHeight * i + this.fontHeight);
        }
        this.inv = this.is.getInvestmentFromIndex(this.startPos + this.currentPos);
    }

    void showHeader(Graphics graphics) {
        String string = "\u0418\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0438";
        String string2 = "\u0412\u043a\u043b\u0430\u0434\u044b";
        if (this.reducedHeading) {
            string = "\u0418\u043d\u0432\u0435\u0441\u0442";
            string2 = "\u0412\u043a\u043b\u0430\u0434";
        }
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, 0, this.width, this.fontHeight);
        graphics.setColor(0);
        graphics.drawString(string, this.parent.widthAdjustment, this.parent.fontAdjustment, 20);
        graphics.drawString(string2, this.holdingsPosition + this.numberWidth - this.font.stringWidth(string2), this.parent.fontAdjustment, 20);
        if (this.showPrice) {
            graphics.drawString("\u0426\u0435\u043d\u0430", this.pricePosition + this.priceWidth - this.font.stringWidth("\u0426\u0435\u043d\u0430"), this.parent.fontAdjustment, 20);
        }
        graphics.drawString("\u0417\u043d\u0430\u0447.", this.valuePosition + this.numberWidth - this.font.stringWidth("\u0417\u043d\u0430\u0447."), this.parent.fontAdjustment, 20);
    }

    void showFooter(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.fontHeight, this.width, this.fontHeight);
        graphics.setColor(0);
        graphics.drawString("\u0418\u0442\u043e\u0433\u043e", this.parent.widthAdjustment, this.height - this.fontHeight + this.parent.fontAdjustment, 20);
        String string = Utilities.numberToString(this.totalValue, false);
        graphics.drawString(string, this.valuePosition + this.numberWidth - this.font.stringWidth(string), this.height - this.fontHeight + this.parent.fontAdjustment, 20);
    }

    void drawUp() {
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.fontHeight;
            --this.currentPos;
            this.previousInv = new Investment(this.parent);
            this.previousInv.clone(this.inv);
            this.inv = this.is.getInvestmentFromIndex(this.startPos + this.currentPos);
            if (this.currentY < this.fontHeight) {
                this.currentY = this.fontHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
            }
            this.repaint();
            return;
        }
    }

    void drawDown() {
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.fontHeight;
            ++this.currentPos;
            this.previousInv = new Investment(this.parent);
            this.previousInv.clone(this.inv);
            this.inv = this.is.getInvestmentFromIndex(this.startPos + this.currentPos);
            if (this.currentY + this.fontHeight * 2 > this.height) {
                this.currentY -= this.fontHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
            }
            this.repaint();
            return;
        }
    }

    void buildLine(Graphics graphics, Investment investment, int n) {
        int n2;
        int n3 = investment.name.length();
        for (int i = 0; i < n3; ++i) {
            n2 = n3 - i;
            if (this.font.stringWidth(investment.name.substring(0, n2)) > this.investmentWidth) continue;
            graphics.drawString(investment.name.substring(0, n2), this.parent.widthAdjustment, n + this.parent.fontAdjustment, 20);
            break;
        }
        String string = Utilities.holdingToString(investment.holding);
        graphics.drawString(string, this.holdingsPosition + this.numberWidth - this.font.stringWidth(string), n + this.parent.fontAdjustment, 20);
        if (this.showPrice) {
            string = Utilities.numberToString(investment.price, false);
            graphics.drawString(string, this.pricePosition + this.priceWidth - this.font.stringWidth(string), n + this.parent.fontAdjustment, 20);
        }
        n2 = investment.calcValue(investment);
        string = Utilities.numberToString(n2, false);
        graphics.drawString(string, this.valuePosition + this.numberWidth - this.font.stringWidth(string), n + this.parent.fontAdjustment, 20);
    }

    void setPositions() {
        this.showPrice = true;
        this.reducedHeading = false;
        this.investmentWidth = this.width - this.priceWidth - this.numberWidth * 2 - this.parent.widthAdjustment * 2 - 30;
        if (this.investmentWidth > this.font.stringWidth("\u0418\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0438") + 10) {
            this.holdingsPosition = this.investmentWidth + this.parent.widthAdjustment + 10;
            this.pricePosition = this.holdingsPosition + this.numberWidth + 10;
            this.valuePosition = this.pricePosition + this.priceWidth + 10;
        } else {
            this.investmentWidth = this.width - this.numberWidth * 2 - this.parent.widthAdjustment * 2 - 20;
            this.holdingsPosition = this.investmentWidth + this.parent.widthAdjustment + 10;
            this.valuePosition = this.holdingsPosition + this.numberWidth + 10;
            this.showPrice = false;
        }
        if (this.font.stringWidth("\u0418\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0438") + this.parent.widthAdjustment + 10 > this.holdingsPosition + this.numberWidth - this.font.stringWidth("\u0412\u043a\u043b\u0430\u0434\u044b")) {
            this.reducedHeading = true;
        }
    }

    Investment showInvestment() {
        this.oldInv = new Investment(this.parent);
        this.oldInv.clone(this.inv);
        return this.inv;
    }

    void newInvestment(Investment investment) {
        this.inv1 = investment;
        this.inv1.id = this.is.saveNewInvestment(this.inv1);
        if (this.inv == null) {
            this.inv = this.inv1;
        }
        ++this.numItems;
        this.totalValue += this.inv1.calcValue(this.inv1);
        this.repaint();
    }

    void editInvestment(Investment investment) {
        this.inv1 = investment;
        this.is.saveExistingInvestment(this.inv1);
        this.totalValue += this.inv1.calcValue(this.inv1) - this.oldInv.calcValue(this.oldInv);
        if (!this.inv1.name.equals(this.oldInv.name)) {
            this.is.deleteIndex(this.startPos + this.currentPos);
            this.is.addIndex(this.inv1);
        }
        this.repaint();
    }

    void deleteInvestment(Investment investment) {
        this.inv1 = investment;
        this.is.deleteInvestment(this.inv1);
        this.is.deleteIndex(this.startPos + this.currentPos);
        this.totalValue -= this.inv1.calcValue(this.inv1);
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.fontHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.repaint();
    }

    void setTotals() {
        this.totalValue = 0;
        for (int i = 0; i < this.numItems; ++i) {
            this.inv = this.is.getInvestmentFromIndex(i);
            this.totalValue += this.inv.calcValue(this.inv);
        }
        this.inv = this.is.getInvestmentFromIndex(0);
    }

    protected void showNotify() {
        this.repaint();
    }

    protected void keyPressed(int n) {
        if (n == this.leftKey || n == -3) {
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.fontHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (n == this.rightKey || n == -4) {
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.fontHeight + this.fontHeight;
            }
            this.repaint();
            return;
        }
        if (n == this.actionKey) {
            // empty if block
        }
        if (n == this.upKey) {
            this.drawUp();
            return;
        }
        if (n == this.downKey) {
            this.drawDown();
            return;
        }
        if (n == 48) {
            int n2 = this.startPos + this.currentPos;
            this.debug = new Form("\u0417\u0430\u043f\u0438\u0441\u044c \u0421\u0432\u043e\u0439\u0441\u0442\u0432");
            this.debug.append("\u041f\u043e\u0437\u0438\u0446\u0438\u044f" + n2 + "\u0438\u0437" + this.numItems + "\n");
            short s = (short)n2;
            int n3 = ((NameId)this.is.ht.get((Object)new Short((short)s))).id;
            this.debug.append("\u0417\u0430\u043f\u0438\u0441\u044c ID " + n3 + "\n");
            this.debug.append("\u0417\u0430\u043f\u0438\u0441\u044c \u0414\u043b\u0438\u043d\u044b" + this.is.getRecordSize(n3) + "\n");
            this.debug.append("\u0420\u0430\u0437\u043c\u0435\u0440 \u0417\u0430\u043f\u0438\u0441\u0438 \u0418\u0441\u0442\u043e\u0440\u0438\u0438" + this.is.getSize() + "\n");
            this.debug.addCommand(this.parent.okCommand);
            this.debug.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.debug);
        }
    }

    protected void pointerPressed(int n, int n2) {
        if (n2 < this.fontHeight) {
            this.keyPressed(this.leftKey);
            return;
        }
        if (n2 > this.height - this.fontHeight) {
            this.keyPressed(this.rightKey);
            return;
        }
        int n3 = (n2 - this.fontHeight) / this.fontHeight;
        while (n3 > this.currentPos) {
            this.drawDown();
        }
        while (n3 < this.currentPos) {
            this.drawUp();
        }
        this.repaint();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.parent.exitCommand) {
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this) {
            if (command == this.parent.newCommand) {
                this.invf = new InvestmentForm(this.parent, new Investment(this.parent), "\u041d\u043e\u0432\u044b\u0439");
                this.invf.addCommand(this.parent.createCommand);
                this.invf.addCommand(this.parent.cancelCommand);
                this.invf.addCommand(this.parent.exitCommand);
                this.invf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.invf);
            }
            if (command == this.parent.editCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0418\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u044f");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.invf = new InvestmentForm(this.parent, this.showInvestment(), "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
                this.invf.addCommand(this.parent.updateCommand);
                this.invf.addCommand(this.parent.cancelCommand);
                this.invf.addCommand(this.parent.exitCommand);
                this.invf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.invf);
            }
            if (command == this.parent.deleteCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0418\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u044f");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.invf = new InvestmentForm(this.parent, this.showInvestment(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
                this.invf.addCommand(this.parent.deleteCommand);
                this.invf.addCommand(this.parent.cancelCommand);
                this.invf.addCommand(this.parent.exitCommand);
                this.invf.setCommandListener(this);
                this.display.setCurrent((Displayable)this.invf);
            }
            if (command == this.parent.mainCommand) {
                this.display.setCurrent((Displayable)this.parent.av);
            }
            if (command == this.parent.viewCommand) {
                this.vl = new ViewForm();
                this.vl.addCommand(this.parent.okCommand);
                this.vl.addCommand(this.parent.cancelCommand);
                this.vl.addCommand(this.parent.exitCommand);
                this.vl.setCommandListener(this);
                this.display.setCurrent((Displayable)this.vl);
            }
        }
        if (displayable == this.invf) {
            if (command == this.parent.deleteCommand) {
                this.invf = null;
                this.deleteInvestment(this.inv);
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.createCommand) {
                this.inv1 = this.invf.update();
                if (this.inv1.name.equals("")) {
                    this.alert.setString("\u041f\u0443\u0441\u0442\u043e\u0435 \u0438\u043c\u044f \u0418\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0438");
                    this.display.setCurrent(this.alert, (Displayable)this.invf);
                    return;
                }
                if (this.is.lookUpId(this.inv1) != 0) {
                    this.alert.setString(this.inv1.name + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
                    this.display.setCurrent(this.alert, (Displayable)this.invf);
                    return;
                }
                this.newInvestment(this.inv1);
                this.display.setCurrent((Displayable)this);
                this.invf = null;
            }
            if (command == this.parent.updateCommand) {
                this.inv1 = this.invf.update();
                if (this.inv1.name.equals("")) {
                    this.alert.setString("\u041f\u0443\u0441\u0442\u043e\u0435 \u0438\u043c\u044f \u0418\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0438");
                    this.display.setCurrent(this.alert, (Displayable)this.invf);
                    return;
                }
                int n = this.inv.id;
                if (!this.inv1.name.equals(this.oldInv.name) && this.is.lookUpId(this.inv1) != 0) {
                    this.alert.setString(this.inv1.name + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
                    this.display.setCurrent(this.alert, (Displayable)this.invf);
                    return;
                }
                this.inv.id = n;
                this.editInvestment(this.inv1);
                this.display.setCurrent((Displayable)this);
                this.invf = null;
            }
            if (command == this.parent.cancelCommand) {
                this.invf = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.vl) {
            if (command == this.parent.cancelCommand) {
                this.vl = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                if (this.vl.update() == 0) {
                    this.display.setCurrent((Displayable)this.parent.av);
                }
                if (this.vl.update() == 1) {
                    if (this.parent.tv == null) {
                        this.alert.setString("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0423\u0447\u0435\u0442\u043d.\u0417\u0430\u043f\u0438\u0441\u044c");
                        this.display.setCurrent(this.alert, (Displayable)this);
                    } else {
                        this.display.setCurrent((Displayable)this.parent.tv);
                    }
                }
                if (this.vl.update() == 2) {
                    if (this.parent.cv == null) {
                        this.parent.cv = new CategoryView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.cv);
                }
                if (this.vl.update() == 3) {
                    if (this.parent.sov == null) {
                        this.parent.sov = new StandingOrderView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.sov);
                }
                if (this.vl.update() == 4) {
                    this.display.setCurrent((Displayable)this);
                }
                if (this.vl.update() == 5) {
                    if (this.parent.ccyv == null) {
                        this.parent.ccyv = new CurrencyView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.ccyv);
                }
            }
        }
        if (displayable == this.debug) {
            this.debug = null;
            this.display.setCurrent((Displayable)this);
        }
    }
}

