/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.AccountForm;
import JabpLite.AccountStore;
import JabpLite.CategoryStore;
import JabpLite.CategoryView;
import JabpLite.CurrencyStore;
import JabpLite.CurrencyView;
import JabpLite.FindForm;
import JabpLite.FindView;
import JabpLite.FutureBalance;
import JabpLite.InvestmentStore;
import JabpLite.InvestmentView;
import JabpLite.JabpLite;
import JabpLite.NameId;
import JabpLite.NetWorth;
import JabpLite.OptionForm;
import JabpLite.PreferenceForm;
import JabpLite.PreferenceStore;
import JabpLite.PurgeForm;
import JabpLite.RegularStore;
import JabpLite.StandingOrder;
import JabpLite.StandingOrderStore;
import JabpLite.StandingOrderView;
import JabpLite.Transaction;
import JabpLite.TransactionStore;
import JabpLite.TransactionView;
import JabpLite.Utilities;
import JabpLite.ViewForm;
import java.util.Hashtable;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStoreException;

public class AccountView
extends Canvas
implements CommandListener,
Runnable {
    Account a;
    Account a1;
    Account oldA;
    Account previousA;
    AccountForm af;
    Form debug;
    AccountStore as;
    Alert alert;
    Display display;
    Font font;
    Form cmf;
    Form rbf;
    Form about;
    Form info;
    Form cad;
    FindForm ff;
    OptionForm ol;
    ViewForm vl;
    PreferenceForm pf;
    PurgeForm puf;
    JabpLite parent;
    String msg = "";
    int width;
    int height;
    int actionKey;
    int upKey;
    int downKey;
    int leftKey;
    int rightKey;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int numItems;
    int numItemsPage;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int oldPos;
    int oldId;
    int startPos;
    int numberWidth;
    int accountWidth;
    int todayPosition;
    int reconciledPosition;
    int runMode;
    int totalToday;
    int totalReconciled;

    public AccountView(JabpLite jabpLite, Display display) {
        this.parent = jabpLite;
        this.display = display;
        this.addCommand(this.parent.exitCommand);
        this.addCommand(this.parent.newCommand);
        this.addCommand(this.parent.editCommand);
        this.addCommand(this.parent.deleteCommand);
        this.addCommand(this.parent.viewCommand);
        this.addCommand(this.parent.extraCommand);
        this.addCommand(this.parent.findCommand);
        this.addCommand(this.parent.aboutCommand);
        this.addCommand(this.parent.cancelCommand);
        this.setCommandListener(this);
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.alert.setTimeout(1500);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        int n = 8;
        if (this.parent.mediumSize) {
            n = 0;
        }
        this.font = Font.getFont((int)0, (int)0, (int)n);
        this.fontHeight = this.font.getHeight();
        this.numberWidth = this.font.stringWidth("999999.99");
        this.setPositions();
        this.numItemsPage = this.height / this.fontHeight - 2;
        this.actionKey = this.getKeyCode(8);
        this.upKey = this.getKeyCode(1);
        this.downKey = this.getKeyCode(6);
        this.leftKey = this.getKeyCode(2);
        this.rightKey = this.getKeyCode(5);
        this.as = new AccountStore(this.parent);
        int n2 = this.as.getSizeAvailable();
        this.numItems = this.as.getNumAccounts();
        this.setTotals();
        this.currentX = 0;
        this.currentY = this.fontHeight;
        this.currentPos = 0;
        this.startPos = 0;
    }

    public void paint(Graphics graphics) {
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.numItemsPage = this.height / this.fontHeight - 2;
        graphics.setFont(this.font);
        this.showHeader(graphics);
        this.showPage(graphics);
        this.showFooter(graphics);
    }

    void showPage(Graphics graphics) {
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.fontHeight, this.width, this.height - this.fontHeight * 2);
        graphics.setColor(0);
        if (this.numItems == 0) {
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                graphics.setColor(this.parent.colorCursor);
                graphics.fillRect(0, this.fontHeight * i + this.fontHeight, this.width, this.fontHeight);
                graphics.setColor(0);
            }
            this.a = this.as.getAccountFromIndex(i + this.startPos);
            this.buildLine(graphics, this.a, this.fontHeight * i + this.fontHeight);
        }
        this.a = this.as.getAccountFromIndex(this.startPos + this.currentPos);
    }

    void showHeader(Graphics graphics) {
        if (this.msg.equals("")) {
            graphics.setColor(this.parent.colorHeading);
            graphics.fillRect(0, 0, this.width, this.fontHeight);
            graphics.setColor(0);
            graphics.drawString("\u0423\u0447.\u0417\u0430\u043f\u0438\u0441\u0438", this.parent.widthAdjustment, this.parent.fontAdjustment, 20);
            graphics.drawString("\u0421\u0435\u0439\u0447\u0430\u0441", this.todayPosition + this.numberWidth - this.font.stringWidth("\u0421\u0435\u0439\u0447\u0430\u0441"), this.parent.fontAdjustment, 20);
            graphics.drawString("Rec.", this.reconciledPosition + this.numberWidth - this.font.stringWidth("Rec."), this.parent.fontAdjustment, 20);
        } else {
            graphics.setColor(this.parent.colorRed);
            graphics.fillRect(0, 0, this.width, this.fontHeight);
            graphics.setColor(0);
            graphics.drawString(this.msg, this.parent.widthAdjustment, this.parent.fontAdjustment, 20);
        }
    }

    void showFooter(Graphics graphics) {
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.fontHeight, this.width, this.fontHeight);
        graphics.setColor(0);
        graphics.drawString("\u0418\u0442\u043e\u0433\u043e", this.parent.widthAdjustment, this.height - this.fontHeight + this.parent.fontAdjustment, 20);
        String string = Utilities.numberToString(this.totalToday, false);
        graphics.drawString(string, this.todayPosition + this.numberWidth - this.font.stringWidth(string), this.height - this.fontHeight + this.parent.fontAdjustment, 20);
        string = Utilities.numberToString(this.totalReconciled, false);
        graphics.drawString(string, this.reconciledPosition + this.numberWidth - this.font.stringWidth(string), this.height - this.fontHeight + this.parent.fontAdjustment, 20);
    }

    void drawUp() {
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.fontHeight;
            --this.currentPos;
            this.previousA = new Account();
            this.previousA.clone(this.a);
            this.a = this.as.getAccountFromIndex(this.startPos + this.currentPos);
            if (this.currentY < this.fontHeight) {
                this.currentY = this.fontHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
            }
            this.repaint();
            return;
        }
    }

    void drawDown() {
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.fontHeight;
            ++this.currentPos;
            this.previousA = new Account();
            this.previousA.clone(this.a);
            this.a = this.as.getAccountFromIndex(this.startPos + this.currentPos);
            if (this.currentY + this.fontHeight * 2 > this.height) {
                this.currentY -= this.fontHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
            }
            this.repaint();
            return;
        }
    }

    void buildLine(Graphics graphics, Account account, int n) {
        int n2 = account.name.length();
        for (int i = 0; i < n2; ++i) {
            int n3 = n2 - i;
            if (this.font.stringWidth(account.name.substring(0, n3)) > this.accountWidth) continue;
            graphics.drawString(account.name.substring(0, n3), this.parent.widthAdjustment, n + this.parent.fontAdjustment, 20);
            break;
        }
        String string = Utilities.numberToString(account.today, false);
        graphics.drawString(string, this.todayPosition + this.numberWidth - this.font.stringWidth(string), n + this.parent.fontAdjustment, 20);
        string = Utilities.numberToString(account.reconciled, false);
        graphics.drawString(string, this.reconciledPosition + this.numberWidth - this.font.stringWidth(string), n + this.parent.fontAdjustment, 20);
    }

    void setPositions() {
        this.accountWidth = this.width - this.numberWidth * 2 - this.parent.widthAdjustment * 2 - 20;
        this.todayPosition = this.accountWidth + this.parent.widthAdjustment + 10;
        this.reconciledPosition = this.todayPosition + this.numberWidth + 10;
    }

    Account showAccount() {
        this.oldA = new Account();
        this.oldA.clone(this.a);
        return this.a;
    }

    void newAccount(Account account) {
        this.a1 = account;
        this.a1.id = this.as.saveNewAccount(this.a1);
        if (this.a == null) {
            this.a = this.a1;
        }
        ++this.numItems;
        this.totalToday += account.today;
        this.totalReconciled += account.reconciled;
        this.repaint();
    }

    void editAccount(Account account) {
        this.a1 = account;
        this.as.saveExistingAccount(this.a1);
        this.totalToday += this.a1.today - this.oldA.today;
        this.totalReconciled += this.a1.reconciled - this.oldA.reconciled;
        if (!this.a1.name.equals(this.oldA.name)) {
            this.runMode = 1;
            this.display.callSerially((Runnable)this);
        } else {
            this.msg = "";
        }
        this.repaint();
    }

    void deleteAccount(Account account) {
        this.a1 = account;
        this.as.deleteAccount(this.a1);
        this.as.deleteIndex(this.startPos + this.currentPos);
        this.parent.transactionHt.remove(this.a1.name);
        this.totalToday -= this.a1.today;
        this.totalReconciled -= this.a1.reconciled;
        --this.numItems;
        if (this.numItems > 0 && this.startPos + this.currentPos > this.numItems - 1) {
            if (this.currentPos > 0) {
                this.currentY -= this.fontHeight;
                --this.currentPos;
            } else {
                --this.startPos;
            }
        }
        this.repaint();
    }

    void setTotals() {
        this.totalToday = 0;
        this.totalReconciled = 0;
        if (this.numItems > 0) {
            for (int i = 0; i < this.numItems; ++i) {
                this.a = this.as.getAccountFromIndex(i);
                this.totalToday += this.a.today;
                this.totalReconciled += this.a.reconciled;
            }
            this.a = this.as.getAccountFromIndex(0);
        }
    }

    void updateAccountName() {
        Object object;
        this.as.deleteIndex(this.startPos + this.currentPos);
        this.as.addIndex(this.a1);
        TransactionStore transactionStore = new TransactionStore(this.parent, this.oldA);
        RecordEnumeration recordEnumeration = transactionStore.getTransactions();
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                object = transactionStore.getTransaction(n);
                if (((Transaction)object).account.equals(this.oldA.name)) {
                    ((Transaction)object).account = this.a1.name;
                    transactionStore.saveExistingTransaction((Transaction)object);
                }
                if (!((Transaction)object).transferFlag || !((Transaction)object).transferAccount.equals(this.oldA.name)) continue;
                ((Transaction)object).transferAccount = this.a1.name;
                transactionStore.saveExistingTransaction((Transaction)object);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " av5");
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        transactionStore.closeTransactionStore();
        transactionStore = null;
        Hashtable hashtable = (Hashtable)this.parent.transactionHt.get(this.oldA.name);
        this.parent.transactionHt.remove(this.oldA.name);
        this.parent.transactionHt.put(this.a1.name, hashtable);
        object = new StandingOrderStore(this.parent);
        recordEnumeration = ((StandingOrderStore)object).getStandingOrders();
        try {
            while (recordEnumeration.hasNextElement()) {
                int n = recordEnumeration.nextRecordId();
                StandingOrder standingOrder = ((StandingOrderStore)object).getStandingOrder(n);
                if (standingOrder.account.equals(this.oldA.name)) {
                    standingOrder.account = this.a1.name;
                    ((StandingOrderStore)object).saveExistingStandingOrder(standingOrder);
                }
                if (!standingOrder.transferFlag || !standingOrder.transferAccount.equals(this.oldA.name)) continue;
                standingOrder.transferAccount = this.a1.name;
                ((StandingOrderStore)object).saveExistingStandingOrder(standingOrder);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.err.println((Object)((Object)recordStoreException) + " av5a");
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        ((StandingOrderStore)object).closeStandingOrderStore();
        object = null;
        if (this.parent.sov != null) {
            this.parent.sov.runThread();
        }
        this.msg = "";
        this.repaint();
    }

    protected void showNotify() {
        this.repaint();
    }

    void purgeTransactions() {
        this.puf.processPurge();
        this.puf = null;
        this.msg = "";
        this.repaint();
    }

    void compressFiles() {
        Object object;
        int n = this.as.getSizeAvailable() - this.parent.indexSize;
        this.show("\u0421\u0436\u0430\u0442\u0438\u0435 \u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439...");
        if (this.parent.tv == null) {
            object = new TransactionStore(this.parent, new Account());
            if (((TransactionStore)object).getSize() + 1500 > n) {
                ((TransactionStore)object).closeTransactionStore();
                this.cmf = null;
                this.msg = "";
                this.repaint();
                this.alert.setString("\u041c\u0430\u043b\u043e \u043c\u0435\u0441\u0442\u0430 \u0434\u043b\u044f \u0441\u0436\u0430\u0442\u0438\u044f");
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
            ((TransactionStore)object).compressTransactions();
            ((TransactionStore)object).closeTransactionStore();
            object = null;
            RegularStore regularStore = new RegularStore(this.parent);
            this.show("\u0421\u0436\u0430\u0442\u0438\u0435 regulars...");
            regularStore.compressRegulars();
            regularStore.closeRegularStore();
            regularStore = null;
        } else {
            if (this.parent.tv.ts.getSize() + 1500 > n) {
                this.cmf = null;
                this.msg = "";
                this.repaint();
                this.alert.setString("\u041c\u0430\u043b\u043e \u043c\u0435\u0441\u0442\u0430 \u0434\u043b\u044f \u0441\u0436\u0430\u0442\u0438\u044f");
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
            this.parent.tv.ts.compressTransactions();
            this.show("\u0421\u0436\u0430\u0442\u0438\u0435 regulars...");
            this.parent.tv.rs.compressRegulars();
        }
        this.show("\u0421\u0436\u0430\u0442\u0438\u0435 \u0423\u0447\u0435\u0442\u043d\u044b\u0445 \u0417\u0430\u043f\u0438\u0441\u0435\u0439...");
        this.as.compressAccounts();
        this.show("\u0421\u0436\u0430\u0442\u0438\u0435 \u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0439");
        if (this.parent.cv == null) {
            object = new CategoryStore(this.parent);
            ((CategoryStore)object).compressCategories();
            ((CategoryStore)object).closeCategoryStore();
            object = null;
        } else {
            this.parent.cv.cs.compressCategories();
        }
        this.show("\u0421\u0436\u0430\u0442\u0438\u0435 \u0412\u0430\u043b\u044e\u0442...");
        if (this.parent.ccyv == null) {
            object = new CurrencyStore(this.parent);
            ((CurrencyStore)object).compressCurrencies();
            ((CurrencyStore)object).closeCurrencyStore();
            object = null;
        } else {
            this.parent.ccyv.ccys.compressCurrencies();
        }
        this.show("\u0421\u0436\u0430\u0442\u0438\u0435 \u0418\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0439...");
        if (this.parent.iv == null) {
            object = new InvestmentStore(this.parent);
            ((InvestmentStore)object).compressInvestments();
            ((InvestmentStore)object).closeInvestmentStore();
            object = null;
        } else {
            this.parent.iv.is.compressInvestments();
        }
        this.show("\u0421\u0436\u0430\u0442\u0438\u0435 \u041f\u043e\u0441\u0442.\u041f\u043e\u0440\u0443\u0447\u0435\u043d\u0438\u0439...");
        if (this.parent.sov == null) {
            object = new StandingOrderStore(this.parent);
            ((StandingOrderStore)object).compressStandingOrders();
            ((StandingOrderStore)object).closeStandingOrderStore();
            object = null;
        } else {
            this.parent.sov.sos.compressStandingOrders();
        }
        this.cmf = null;
        this.msg = "";
        this.repaint();
    }

    void show(String string) {
        this.msg = string;
        this.repaint();
        this.serviceRepaints();
    }

    void processFind() {
        String string = this.ff.execute();
        this.ff = null;
        this.msg = "";
        FindView findView = new FindView(this.parent, this.display, string, false);
        this.display.setCurrent((Displayable)findView);
    }

    public void run() {
        if (this.runMode == 1) {
            this.updateAccountName();
        }
        if (this.runMode == 2) {
            this.purgeTransactions();
        }
        if (this.runMode == 3) {
            this.compressFiles();
        }
        if (this.runMode == 4) {
            this.processFind();
        }
        if (this.runMode == 5) {
            this.parent.recreateIndices(true);
        }
    }

    protected void keyPressed(int n) {
        if (n == this.leftKey || n == -3) {
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.fontHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (n == this.rightKey || n == -4) {
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.fontHeight + this.fontHeight;
            }
            this.repaint();
            return;
        }
        if (n == this.actionKey || n == -5) {
            if (this.parent.tv != null) {
                this.parent.tv.ts.closeTransactionStore();
                this.parent.tv.rs.closeRegularStore();
            }
            this.parent.tv = new TransactionView(this.parent, this.display, this.a);
            this.display.setCurrent((Displayable)this.parent.tv);
            return;
        }
        if (n == this.upKey) {
            this.drawUp();
            return;
        }
        if (n == this.downKey) {
            this.drawDown();
            return;
        }
        if (n == 48) {
            int n2 = this.startPos + this.currentPos;
            this.debug = new Form("\u0417\u0430\u043f\u0438\u0441\u044c \u0421\u0432\u043e\u0439\u0441\u0442\u0432");
            this.debug.append("\u041f\u043e\u0437\u0438\u0446\u0438\u044f" + n2 + "\u0438\u0437" + this.numItems + "\n");
            short s = (short)n2;
            int n3 = ((NameId)this.as.ht.get((Object)new Short((short)s))).id;
            this.debug.append("\u0417\u0430\u043f\u0438\u0441\u044c ID " + n3 + "\n");
            this.debug.append("\u0417\u0430\u043f\u0438\u0441\u044c \u0414\u043b\u0438\u043d\u044b" + this.as.getRecordSize(n3) + "\n");
            this.debug.append("\u0420\u0430\u0437\u043c\u0435\u0440 \u0417\u0430\u043f\u0438\u0441\u0438 \u0418\u0441\u0442\u043e\u0440\u0438\u0438" + this.as.getSize() + "\n");
            this.debug.addCommand(this.parent.okCommand);
            this.debug.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.debug);
        }
    }

    protected void pointerPressed(int n, int n2) {
        if (n2 < this.fontHeight) {
            this.keyPressed(this.leftKey);
            return;
        }
        if (n2 > this.height - this.fontHeight) {
            this.keyPressed(this.rightKey);
            return;
        }
        int n3 = (n2 - this.fontHeight) / this.fontHeight;
        while (n3 > this.currentPos) {
            this.drawDown();
        }
        while (n3 < this.currentPos) {
            this.drawUp();
        }
        this.repaint();
        if (this.parent.tv != null) {
            this.parent.tv.ts.closeTransactionStore();
            this.parent.tv.rs.closeRegularStore();
        }
        this.parent.tv = new TransactionView(this.parent, this.display, this.a);
        this.display.setCurrent((Displayable)this.parent.tv);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.parent.exitCommand) {
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this) {
            if (command == this.parent.newCommand) {
                this.af = new AccountForm(this.parent, new Account(), "\u041d\u043e\u0432\u044b\u0439");
                this.af.addCommand(this.parent.createCommand);
                this.af.addCommand(this.parent.cancelCommand);
                this.af.addCommand(this.parent.exitCommand);
                this.af.setCommandListener(this);
                this.display.setCurrent((Displayable)this.af);
            }
            if (command == this.parent.editCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435\u0442 \u0423\u0447\u0435\u0442\u043d.\u0417\u0430\u043f\u0438\u0441\u0435\u0439");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.msg = "\u041e\u0431\u043d\u043e\u0432\u043b\u044f\u044e \u0423\u0447\u0435\u0442\u043d.\u0417\u0430\u043f\u0438\u0441\u044c, \u0436\u0434\u0438\u0442\u0435...";
                this.repaint();
                this.af = new AccountForm(this.parent, this.showAccount(), "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
                this.af.addCommand(this.parent.updateCommand);
                this.af.addCommand(this.parent.cancelCommand);
                this.af.addCommand(this.parent.exitCommand);
                this.af.setCommandListener(this);
                this.display.setCurrent((Displayable)this.af);
            }
            if (command == this.parent.deleteCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("\u041d\u0435\u0442 \u0423\u0447\u0435\u0442\u043d.\u0417\u0430\u043f\u0438\u0441\u0435\u0439");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.af = new AccountForm(this.parent, this.showAccount(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
                this.af.addCommand(this.parent.deleteCommand);
                this.af.addCommand(this.parent.cancelCommand);
                this.af.addCommand(this.parent.exitCommand);
                this.af.setCommandListener(this);
                this.display.setCurrent((Displayable)this.af);
            }
            if (command == this.parent.viewCommand) {
                this.vl = new ViewForm();
                this.vl.addCommand(this.parent.okCommand);
                this.vl.addCommand(this.parent.cancelCommand);
                this.vl.addCommand(this.parent.exitCommand);
                this.vl.setCommandListener(this);
                this.display.setCurrent((Displayable)this.vl);
            }
            if (command == this.parent.extraCommand) {
                this.msg = "\u0414\u0443\u043c\u0430\u044e, \u0436\u0434\u0438\u0442\u0435...";
                this.repaint();
                this.ol = new OptionForm();
                this.ol.addCommand(this.parent.okCommand);
                this.ol.addCommand(this.parent.cancelCommand);
                this.ol.addCommand(this.parent.exitCommand);
                this.ol.setCommandListener(this);
                this.display.setCurrent((Displayable)this.ol);
            }
            if (command == this.parent.findCommand) {
                this.msg = "\u0414\u0443\u043c\u0430\u044e, \u0436\u0434\u0438\u0442\u0435...";
                this.repaint();
                this.ff = new FindForm(this.parent, true);
                this.ff.addCommand(this.parent.okCommand);
                this.ff.addCommand(this.parent.cancelCommand);
                this.ff.addCommand(this.parent.exitCommand);
                this.ff.setCommandListener(this);
                this.display.setCurrent((Displayable)this.ff);
            }
            if (command == this.parent.aboutCommand) {
                this.about = new Form("\u041e JabpLite");
                this.about.append("\nJabpLite Version 1.13  \u043f\u0435\u0440\u0435\u0432\u043e\u0434 niknak");
                this.about.append("\n\n(c) Malcolm Bryant & FreEPOC, 2004-2006");
                this.about.append("\nwww.freepoc.org");
                this.about.append("\nmalcolm@freepoc.org");
                this.about.addCommand(this.parent.okCommand);
                this.about.addCommand(this.parent.exitCommand);
                this.about.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.about);
            }
        }
        if (displayable == this.af) {
            if (command == this.parent.deleteCommand) {
                this.af = null;
                if (((Hashtable)this.parent.transactionHt.get(this.a.name)).size() != 0) {
                    this.alert.setString("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0435\u0441\u0442\u044c \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                StandingOrderStore standingOrderStore = new StandingOrderStore(this.parent);
                RecordEnumeration recordEnumeration = standingOrderStore.getStandingOrders();
                try {
                    while (recordEnumeration.hasNextElement()) {
                        int n = recordEnumeration.nextRecordId();
                        StandingOrder standingOrder = standingOrderStore.getStandingOrder(n);
                        if (!standingOrder.account.equals(this.a.name)) continue;
                        this.alert.setString("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0435\u0441\u0442\u044c \u041f\u043e\u0441\u0442.\u041f\u043e\u0440\u0443\u0447\u0435\u043d\u0438\u044f");
                        this.display.setCurrent(this.alert, (Displayable)this);
                        recordEnumeration.destroy();
                        recordEnumeration = null;
                        standingOrderStore.closeStandingOrderStore();
                        standingOrderStore = null;
                        return;
                    }
                }
                catch (RecordStoreException recordStoreException) {
                    System.err.println((Object)((Object)recordStoreException) + " cv5a");
                }
                recordEnumeration.destroy();
                recordEnumeration = null;
                standingOrderStore.closeStandingOrderStore();
                standingOrderStore = null;
                this.deleteAccount(this.a);
                this.display.setCurrent((Displayable)this);
            }
            if (command == this.parent.createCommand) {
                this.a1 = this.af.update();
                if (this.a1.name.equals("")) {
                    this.alert.setString("\u041f\u0443\u0441\u0442\u043e\u0435 \u0418\u043c\u044f \u0423\u0447\u0435\u0442\u043d.\u0417\u0430\u043f\u0438\u0441\u0438");
                    this.display.setCurrent(this.alert, (Displayable)this.af);
                    return;
                }
                if (this.as.lookUpId(this.a1) != 0) {
                    this.alert.setString(this.a1.name + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
                    this.display.setCurrent(this.alert, (Displayable)this.af);
                    return;
                }
                this.display.setCurrent((Displayable)this);
                this.newAccount(this.a1);
                this.af = null;
            }
            if (command == this.parent.updateCommand) {
                this.a1 = this.af.update();
                if (this.a1.name.equals("")) {
                    this.alert.setString("\u041f\u0443\u0441\u0442\u043e\u0435 \u0418\u043c\u044f \u0423\u0447\u0435\u0442\u043d.\u0417\u0430\u043f\u0438\u0441\u0438");
                    this.display.setCurrent(this.alert, (Displayable)this.af);
                    return;
                }
                int n = this.a1.id;
                if (!this.a1.name.equals(this.oldA.name) && this.as.lookUpId(this.a1) != 0) {
                    this.alert.setString(this.a1.name + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
                    this.display.setCurrent(this.alert, (Displayable)this.af);
                    return;
                }
                this.a1.id = n;
                this.display.setCurrent((Displayable)this);
                this.editAccount(this.a1);
                this.af = null;
            }
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.af = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.pf) {
            if (command == this.parent.okCommand) {
                if (this.pf.update()) {
                    this.setPositions();
                    if (this.parent.cv != null) {
                        this.parent.cv.setPositions();
                    }
                    if (this.parent.ccyv != null) {
                        this.parent.ccyv.setPositions();
                    }
                    if (this.parent.tv != null) {
                        this.parent.tv.setPositions();
                    }
                    if (this.parent.sov != null) {
                        this.parent.sov.setPositions();
                    }
                } else {
                    this.alert.setString("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
                    this.display.setCurrent(this.alert, (Displayable)this.pf);
                    return;
                }
                this.display.setCurrent((Displayable)this);
                this.pf = null;
            }
            if (command == this.parent.cancelCommand) {
                this.pf = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.puf) {
            if (command == this.parent.okCommand) {
                this.display.setCurrent((Displayable)this);
                this.runMode = 2;
                this.display.callSerially((Runnable)this);
                this.repaint();
            }
            if (command == this.parent.deleteAllDataCommand) {
                this.msg = "";
                this.cad = new Form("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435 \u0434\u0430\u043d\u043d\u044b\u0435");
                this.cad.append("\u042d\u0442\u043e \u0423\u0414\u0410\u041b\u0418\u0422 \u0412\u0421\u0415 \u0414\u0410\u041d\u041d\u042b\u0415!\n");
                this.cad.append("\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0449\u0435\u043d\u0430\n");
                this.cad.append("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \"\u0423\u0434\u0430\u043b\u0438\u0442\u044c\" \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f  \u0434\u0430\u043d\u043d\u044b\u0445\n");
                this.cad.append("\u0418\u043b\u0438 \"\u041e\u0442\u043c\u0435\u043d\u0430\" \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f  \u0434\u0430\u043d\u043d\u044b\u0445\n");
                this.cad.addCommand(this.parent.deleteCommand);
                this.cad.addCommand(this.parent.cancelCommand);
                this.cad.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.cad);
            }
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.puf = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.cmf) {
            if (command == this.parent.okCommand) {
                this.display.setCurrent((Displayable)this);
                this.runMode = 3;
                this.display.callSerially((Runnable)this);
                this.repaint();
            }
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.cmf = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.rbf) {
            if (command == this.parent.okCommand) {
                this.display.setCurrent((Displayable)this);
                this.runMode = 5;
                this.display.callSerially((Runnable)this);
                this.repaint();
            }
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.rbf = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
        if (displayable == this.vl) {
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.vl = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                if (this.vl.update() == 0) {
                    this.display.setCurrent((Displayable)this);
                }
                if (this.vl.update() == 1) {
                    if (this.parent.tv != null) {
                        this.parent.tv.ts.closeTransactionStore();
                        this.parent.tv.rs.closeRegularStore();
                    }
                    this.parent.tv = new TransactionView(this.parent, this.display, this.a);
                    this.display.setCurrent((Displayable)this.parent.tv);
                }
                if (this.vl.update() == 2) {
                    if (this.parent.cv == null) {
                        this.parent.cv = new CategoryView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.cv);
                }
                if (this.vl.update() == 3) {
                    if (this.parent.sov == null) {
                        this.parent.sov = new StandingOrderView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.sov);
                }
                if (this.vl.update() == 4) {
                    if (this.parent.iv == null) {
                        this.parent.iv = new InvestmentView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.iv);
                }
                if (this.vl.update() == 5) {
                    if (this.parent.ccyv == null) {
                        this.parent.ccyv = new CurrencyView(this.parent, this.display);
                    }
                    this.display.setCurrent((Displayable)this.parent.ccyv);
                }
            }
        }
        if (displayable == this.ol) {
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.ol = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                if (this.ol.update() == 0) {
                    this.msg = "";
                    this.pf = new PreferenceForm(this.parent);
                    this.pf.addCommand(this.parent.okCommand);
                    this.pf.addCommand(this.parent.cancelCommand);
                    this.pf.addCommand(this.parent.exitCommand);
                    this.pf.setCommandListener(this);
                    this.display.setCurrent((Displayable)this.pf);
                }
                if (this.ol.update() == 1) {
                    this.msg = "";
                    NetWorth netWorth = new NetWorth(this.parent, this.display);
                    this.display.setCurrent((Displayable)netWorth);
                }
                if (this.ol.update() == 2) {
                    this.msg = "";
                    FutureBalance futureBalance = new FutureBalance(this.parent, this.display);
                    this.display.setCurrent((Displayable)futureBalance);
                }
                if (this.ol.update() == 3) {
                    this.display.setCurrent((Displayable)this);
                    this.puf = new PurgeForm(this.parent);
                    this.puf.addCommand(this.parent.okCommand);
                    this.puf.addCommand(this.parent.deleteAllDataCommand);
                    this.puf.addCommand(this.parent.cancelCommand);
                    this.puf.addCommand(this.parent.exitCommand);
                    this.puf.setCommandListener(this);
                    this.display.setCurrent((Displayable)this.puf);
                }
                if (this.ol.update() == 4) {
                    this.display.setCurrent((Displayable)this);
                    this.cmf = new Form("\u0421\u0436\u0430\u0442\u0438\u0435 \u0444\u0430\u0439\u043b\u043e\u0432");
                    this.cmf.append("\n\u042d\u0442\u0430 \u043e\u043f\u0446\u0438\u044f \u0441\u0436\u0438\u043c\u0430\u0435\u0442 \u0432\u0441\u0435 \u0444\u0430\u0439\u043b\u044b \u0434\u0430\u043d\u043d\u044b\u0445. \u0417\u0430\u0439\u043c\u0435\u0442 \u043d\u0435\u0441\u043a. \u043c\u0438\u043d\u0443\u0442 \u0434\u043b\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f.");
                    this.cmf.addCommand(this.parent.okCommand);
                    this.cmf.addCommand(this.parent.cancelCommand);
                    this.cmf.addCommand(this.parent.exitCommand);
                    this.cmf.setCommandListener((CommandListener)this);
                    this.display.setCurrent((Displayable)this.cmf);
                }
                if (this.ol.update() == 5) {
                    this.display.setCurrent((Displayable)this);
                    this.rbf = new Form("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0411\u0430\u043b\u0430\u043d\u0441");
                    this.rbf.append("\n\u042d\u0442\u0430 \u043e\u043f\u0446\u0438\u044f \u043e\u0431\u043d\u043e\u0432\u043b\u044f\u0435\u0442 \u0423\u0447\u0435\u0442\u043d.\u0417\u0430\u043f\u0438\u0441\u0438 \u0438 \u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u0432. \u0417\u0430\u0439\u043c\u0435\u0442 \u043d\u0435\u0441\u043a. \u043c\u0438\u043d\u0443\u0442 \u0434\u043b\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f.");
                    this.rbf.addCommand(this.parent.okCommand);
                    this.rbf.addCommand(this.parent.cancelCommand);
                    this.rbf.addCommand(this.parent.exitCommand);
                    this.rbf.setCommandListener((CommandListener)this);
                    this.display.setCurrent((Displayable)this.rbf);
                }
                if (this.ol.update() == 6) {
                    this.msg = "";
                    this.info = new Form("JabpLite \u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f");
                    this.info.append("\n" + this.numItems + "\u0423\u0447\u0435\u0442\u043d.\u0417\u0430\u043f\u0438\u0441\u0438");
                    int n = this.as.getSize();
                    int n2 = this.as.getSizeAvailable() - this.parent.indexSize;
                    TransactionStore transactionStore = new TransactionStore(this.parent, this.a);
                    this.info.append("\n" + transactionStore.getNumAllTransactions() + "\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438");
                    int n3 = transactionStore.getSize();
                    transactionStore.closeTransactionStore();
                    transactionStore = null;
                    CategoryStore categoryStore = new CategoryStore(this.parent);
                    this.info.append("\n" + categoryStore.getNumCategories() + "\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438");
                    int n4 = categoryStore.getSize();
                    categoryStore.closeCategoryStore();
                    categoryStore = null;
                    StandingOrderStore standingOrderStore = new StandingOrderStore(this.parent);
                    this.info.append("\n" + standingOrderStore.getNumStandingOrders() + " \u041f\u043e\u0441\u0442.\u043f\u043e\u0440\u0443\u0447\u0435\u043d\u0438\u044f");
                    int n5 = standingOrderStore.getSize();
                    standingOrderStore.closeStandingOrderStore();
                    standingOrderStore = null;
                    InvestmentStore investmentStore = new InvestmentStore(this.parent);
                    this.info.append("\n" + investmentStore.getNumInvestments() + " \u0418\u043d\u0432\u0435\u0441\u0442\u0438\u0446\u0438\u0438");
                    int n6 = investmentStore.getSize();
                    investmentStore.closeInvestmentStore();
                    investmentStore = null;
                    CurrencyStore currencyStore = new CurrencyStore(this.parent);
                    this.info.append("\n" + currencyStore.getNumCurrencies() + " \u0412\u0430\u043b\u044e\u0442\u044b");
                    int n7 = currencyStore.getSize();
                    currencyStore.closeCurrencyStore();
                    currencyStore = null;
                    RegularStore regularStore = new RegularStore(this.parent);
                    int n8 = regularStore.getSize();
                    regularStore.closeRegularStore();
                    regularStore = null;
                    PreferenceStore preferenceStore = new PreferenceStore(this.parent);
                    int n9 = preferenceStore.getSize();
                    preferenceStore.closePreferenceStore();
                    preferenceStore = null;
                    int n10 = n + n3 + n4 + n5 + n6 + n7 + n8 + n9 + this.parent.indexSize;
                    this.info.append("\n" + n10 + " \u0431\u0430\u0439\u0442, \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e \u0434\u0430\u043d\u043d\u044b\u0445");
                    this.info.append("\n" + n2 + " \u0431\u0430\u0439\u0442, \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u044b\u0445");
                    this.info.addCommand(this.parent.okCommand);
                    this.info.addCommand(this.parent.exitCommand);
                    this.info.setCommandListener((CommandListener)this);
                    this.display.setCurrent((Displayable)this.info);
                }
            }
        }
        if (displayable == this.ff) {
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.ff = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.okCommand) {
                this.display.setCurrent((Displayable)this);
                this.runMode = 4;
                this.display.callSerially((Runnable)this);
                this.repaint();
            }
        }
        if (displayable == this.cad) {
            if (command == this.parent.cancelCommand) {
                this.msg = "";
                this.cad = null;
                this.alert.setString("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
            if (command == this.parent.deleteCommand) {
                this.parent.deleteAllData = true;
                this.parent.destroyApp(true);
            }
        }
        if (displayable == this.about && command == this.parent.okCommand) {
            this.display.setCurrent((Displayable)this);
        }
        if (displayable == this.info && command == this.parent.okCommand) {
            this.display.setCurrent((Displayable)this);
        }
        if (displayable == this.debug) {
            this.debug = null;
            this.display.setCurrent((Displayable)this);
        }
    }
}

