/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import sk.inlogic.Collisions;
import sk.inlogic.GridItemTypes;
import sk.inlogic.MainCanvas;
import sk.inlogic.PointerController;
import sk.inlogic.Projectile;
import sk.inlogic.ScreenGame;
import sk.inlogic.util.Particles;
import sk.inlogic.util.RandomNum;

public class GridController {
    public static final int MAIN_RATIO = 86;
    public static int xOffset = 0;
    public static int yOffset = 0;
    private static int itemInGridW = 0;
    private static int itemInGridH = 0;
    private static int itemInGridW2 = 0;
    private static int itemInGridH2 = 0;
    public static int[] grid = null;
    private static int gridWidth = 0;
    private static int gridHeight = 0;
    private static int CANVAS_WIDTH = 0;
    private static int CANVAS_HEIGHT = 0;
    private static int PLAYABLE_AREA_WIDTH = 0;
    private static int PLAYABLE_AREA_HEIGHT = 0;
    private static boolean recalcGrid = false;
    public static int bouncedItem = -1;
    public static int honeyItem = -1;

    public static final void setCanvasSize(int _w, int _h) {
        CANVAS_WIDTH = _w;
        CANVAS_HEIGHT = _h;
        GridController.initGrid(12, 14);
    }

    public static final int getGridPixelWidth() {
        return gridWidth * itemInGridW;
    }

    public static final int getGridWidth() {
        return gridWidth;
    }

    public static final int getGridHeight() {
        return gridHeight;
    }

    public static final void resetGrid() {
        if (grid == null) {
            grid = new int[gridWidth * gridHeight];
        }
        for (int y = 0; y < gridHeight; ++y) {
            for (int x = 0; x < gridWidth; ++x) {
                int idx = y * gridWidth + x;
                GridController.grid[idx] = 0;
            }
        }
        Collisions.initCollisions(gridWidth, gridHeight, itemInGridW, itemInGridH, xOffset, yOffset);
        for (int i = 0; i < grid.length; ++i) {
            int y = i / gridWidth;
            int x = i - y * gridWidth;
            if (grid[i] != 0) {
                Collisions.setCollision(x, y, true);
                continue;
            }
            Collisions.setCollision(x, y, false);
        }
    }

    public static final void initGrid(int _w, int _h) {
        int i;
        gridWidth = _w;
        gridHeight = _h;
        GridController.tr("gridWidth: " + gridWidth);
        GridController.tr("gridHeight: " + gridHeight);
        if (MainCanvas.WIDTH_FROM_DC == 480 && MainCanvas.HEIGHT_FROM_DC < 400) {
            PLAYABLE_AREA_WIDTH = 240 / gridWidth * gridWidth;
            PLAYABLE_AREA_HEIGHT = 279;
            xOffset = CANVAS_WIDTH - PLAYABLE_AREA_WIDTH >> 1;
            yOffset = CANVAS_HEIGHT - PLAYABLE_AREA_HEIGHT >> 1;
        } else if (MainCanvas.WIDTH_FROM_DC == 320 && MainCanvas.HEIGHT_FROM_DC == 240) {
            PLAYABLE_AREA_WIDTH = 176 / gridWidth * gridWidth;
            PLAYABLE_AREA_HEIGHT = 204;
            xOffset = CANVAS_WIDTH - PLAYABLE_AREA_WIDTH >> 1;
            yOffset = CANVAS_HEIGHT - PLAYABLE_AREA_HEIGHT >> 1;
        } else if (MainCanvas.WIDTH_FROM_DC == 220 && MainCanvas.HEIGHT_FROM_DC < 230) {
            PLAYABLE_AREA_WIDTH = 128 / gridWidth * gridWidth;
            PLAYABLE_AREA_HEIGHT = 148;
            xOffset = CANVAS_WIDTH - PLAYABLE_AREA_WIDTH >> 1;
            yOffset = CANVAS_HEIGHT - PLAYABLE_AREA_HEIGHT >> 1;
        } else {
            PLAYABLE_AREA_WIDTH = CANVAS_WIDTH / gridWidth * gridWidth;
            PLAYABLE_AREA_HEIGHT = CANVAS_WIDTH * 100 / 86;
            xOffset = CANVAS_WIDTH - PLAYABLE_AREA_WIDTH >> 1;
            yOffset = CANVAS_HEIGHT - PLAYABLE_AREA_HEIGHT >> 1;
        }
        GridController.tr("xOffset: " + xOffset);
        GridController.tr("yOffset: " + yOffset);
        GridController.tr("PLAYABLE_AREA_WIDTH: " + PLAYABLE_AREA_WIDTH);
        GridController.tr("PLAYABLE_AREA_HEIGHT: " + PLAYABLE_AREA_HEIGHT);
        GridController.tr("CANVAS_WIDTH: " + CANVAS_WIDTH);
        GridController.tr("CANVAS_HEIGHT: " + CANVAS_HEIGHT);
        itemInGridH = itemInGridW = PLAYABLE_AREA_WIDTH / gridWidth;
        itemInGridW2 = itemInGridW >> 1;
        itemInGridH2 = itemInGridH >> 1;
        if (grid != null) {
            grid = null;
            System.gc();
        }
        grid = new int[gridWidth * gridHeight];
        for (i = 0; i < grid.length; ++i) {
            GridController.grid[i] = 0;
        }
        Collisions.initCollisions(gridWidth, gridHeight, itemInGridW, itemInGridH, xOffset, yOffset);
        for (i = 0; i < grid.length; ++i) {
            int y = i / gridWidth;
            int x = i - y * gridWidth;
            if (grid[i] != 0) {
                Collisions.setCollision(x, y, true);
                continue;
            }
            Collisions.setCollision(x, y, false);
        }
    }

    public static final void setGridItemOn(int _type, int _x, int _y) {
        GridController.grid[_x * GridController.gridWidth + _y] = _type;
    }

    public static final void setGridItemOn(int _type, int _idx) {
        GridController.grid[_idx] = _type;
    }

    public static final boolean shouldBounceOn(int _x, int _y) {
        if (_x >= gridWidth || _x < 0) {
            return false;
        }
        if (_y >= gridHeight || _y < 0) {
            return false;
        }
        int itemPositionInGrid = _y * gridWidth + _x;
        int itemType = grid[itemPositionInGrid];
        if (itemType == 0) {
            return false;
        }
        int effectOfAffectedItem = GridItemTypes.getEffectOfItem(itemType);
        if (GridController.flagIsPresent(effectOfAffectedItem, 256)) {
            bouncedItem = itemPositionInGrid;
            return true;
        }
        return false;
    }

    public static final boolean shouldStopOn(int _x, int _y) {
        if (_x >= gridWidth || _x < 0) {
            return false;
        }
        if (_y >= gridHeight || _y < 0) {
            return false;
        }
        int itemPositionInGrid = _y * gridWidth + _x;
        int itemType = grid[itemPositionInGrid];
        if (itemType == 0) {
            return false;
        }
        int effectOfAffectedItem = GridItemTypes.getEffectOfItem(itemType);
        return GridController.flagIsPresent(effectOfAffectedItem, 64);
    }

    public static final boolean hitGridItemOn(int _x, int _y, Projectile _projectile) {
        int tmpItemPositionInGrid;
        int j;
        int i;
        recalcGrid = false;
        if (_x >= gridWidth || _x < 0) {
            return false;
        }
        if (_y >= gridHeight || _y < 0) {
            return false;
        }
        int itemPositionInGrid = _y * gridWidth + _x;
        int itemType = grid[itemPositionInGrid];
        int gridLen = grid.length;
        if (itemType == 0) {
            return false;
        }
        int effectOfAffectedItem = GridItemTypes.getEffectOfItem(itemType);
        GridController.tr("effectOfAffectedItem: " + effectOfAffectedItem);
        GridController.tr("itemType: " + itemType);
        ScreenGame.repaintBuffer = true;
        if (GridController.flagIsPresent(effectOfAffectedItem, 256)) {
            GridController.tr("GITE_BOUNCE");
        }
        if (GridController.flagIsPresent(effectOfAffectedItem, 64)) {
            GridController.tr("GITE_STOP_PROJECTILE");
            honeyItem = itemPositionInGrid;
            _projectile.stop();
            return true;
        }
        if (GridController.flagIsPresent(effectOfAffectedItem, 128)) {
            GridController.tr("GITE_DESTROY_PROJECTILE");
            _projectile.destroy();
        }
        if (GridController.flagIsPresent(effectOfAffectedItem, 1024)) {
            PointerController.nextShotTriple = true;
            --ScreenGame.projectilesFired;
            ScreenGame.refreshProjectileCountText();
            ScreenGame.repaintTopHUD = true;
        }
        if (GridController.flagIsPresent(effectOfAffectedItem, 512)) {
            GridController.tr("GITE_RELEASE_SPIKED_BALL");
            PointerController.fireAt(0, 3, xOffset + _x * itemInGridW + itemInGridW2, yOffset + _y * itemInGridH + itemInGridH2);
        }
        if (GridController.flagIsPresent(effectOfAffectedItem, 32)) {
            GridController.tr("GITE_DECREMENT_LIFE_OF_ITEM");
            GridController.grid[itemPositionInGrid] = GridItemTypes.GIT_DAMAGED_STRONG_WOOD;
            for (i = 0; i < 5; ++i) {
                Particles.createParticle(xOffset + _x * itemInGridW + itemInGridW2, yOffset + _y * itemInGridH + itemInGridH2, 15 + RandomNum.getRandomInt(15), 50 + RandomNum.getRandomInt(7), 0, 3, 0, 0, 20, ScreenGame.stone_particles, RandomNum.getRandomUInt(6));
            }
        }
        if (GridController.flagIsPresent(effectOfAffectedItem, 2)) {
            GridController.tr("GITE_DISAPPEAR");
            Collisions.setCollision(_x, _y, false);
            if (GridController.flagIsPresent(grid[itemPositionInGrid], GridItemTypes.GIT_DAMAGED_STRONG_WOOD)) {
                ScreenGame.crackedStoneFrameCounter[itemPositionInGrid] = 0;
                for (i = 0; i < 5; ++i) {
                    Particles.createParticle(xOffset + _x * itemInGridW + itemInGridW2, yOffset + _y * itemInGridH + itemInGridH2, 15 + RandomNum.getRandomInt(15), 50 + RandomNum.getRandomInt(7), 0, 3, 0, 0, 20, ScreenGame.stone_particles, RandomNum.getRandomUInt(6));
                }
            } else if (GridController.flagIsPresent(grid[itemPositionInGrid], GridItemTypes.GIT_WOOD)) {
                ScreenGame.crackedWoodFrameCounter[itemPositionInGrid] = 0;
                for (i = 0; i < 5; ++i) {
                    Particles.createParticle(xOffset + _x * itemInGridW + itemInGridW2, yOffset + _y * itemInGridH + itemInGridH2, 15 + RandomNum.getRandomInt(15), 50 + RandomNum.getRandomInt(7), 0, 3, 0, 0, 20, ScreenGame.wood_particles, RandomNum.getRandomUInt(6));
                }
            } else if (!GridController.flagIsPresent(grid[itemPositionInGrid], GridItemTypes.GIT_BOMB)) {
                ScreenGame.smokeFrames[itemPositionInGrid] = 0;
            }
            GridController.grid[itemPositionInGrid] = 0;
        }
        if (GridController.flagIsPresent(effectOfAffectedItem, 4)) {
            GridController.tr("GITE_INCREMENT_SUCCESS");
            ++ScreenGame.importantItemsShooted;
            ScreenGame.repaintTopHUD = true;
        }
        if (GridController.flagIsPresent(effectOfAffectedItem, 8)) {
            GridController.tr("GITE_BOOM");
            for (i = -1; i < 2; ++i) {
                for (j = -1; j < 2; ++j) {
                    tmpItemPositionInGrid = (_y + i) * gridWidth + (_x + j);
                    if (tmpItemPositionInGrid < 0 || tmpItemPositionInGrid >= gridLen || grid[tmpItemPositionInGrid] == 0) continue;
                    int n = tmpItemPositionInGrid;
                    grid[n] = grid[n] | GridItemTypes.GIT_ABOUT_TO_EXPLODE;
                }
            }
            ScreenGame.smokeBombFrames[itemPositionInGrid] = 0;
            recalcGrid = true;
        }
        if (GridController.flagIsPresent(effectOfAffectedItem, 16)) {
            GridController.tr("GITE_FREEZE");
            for (i = -1; i < 2; ++i) {
                for (j = -1; j < 2; ++j) {
                    tmpItemPositionInGrid = (_y + i) * gridWidth + (_x + j);
                    if (tmpItemPositionInGrid < 0 || tmpItemPositionInGrid >= gridLen || grid[tmpItemPositionInGrid] == 0) continue;
                    int n = tmpItemPositionInGrid;
                    grid[n] = grid[n] | GridItemTypes.GIT_ABOUT_TO_FREEZE;
                }
            }
            recalcGrid = true;
        }
        if (recalcGrid) {
            for (int y = 0; y < gridHeight; ++y) {
                for (int x = 0; x < gridWidth; ++x) {
                    int idx = y * gridWidth + x;
                    if (GridController.flagIsPresent(grid[idx], GridItemTypes.GIT_ABOUT_TO_EXPLODE | GridItemTypes.GIT_BOMB) || GridController.flagIsPresent(grid[idx], GridItemTypes.GIT_BOMB | GridItemTypes.GIT_ABOUT_TO_EXPLODE | GridItemTypes.GIT_ABOUT_TO_FREEZE)) {
                        GridController.hitGridItemOn(x, y, _projectile);
                    }
                    if (GridController.flagIsPresent(grid[idx], GridItemTypes.GIT_ABOUT_TO_FREEZE) && !GridController.flagIsPresent(grid[idx], GridItemTypes.GIT_ABOUT_TO_EXPLODE) && !GridController.flagIsPresent(grid[idx], GridItemTypes.GIT_FREEZE)) {
                        int n = idx;
                        grid[n] = grid[n] - GridItemTypes.GIT_ABOUT_TO_FREEZE;
                        int n2 = idx;
                        grid[n2] = grid[n2] | GridItemTypes.GIT_FREEZED;
                    }
                    if (GridController.flagIsPresent(grid[idx], GridItemTypes.GIT_ABOUT_TO_EXPLODE | GridItemTypes.GIT_FREEZE)) {
                        GridController.hitGridItemOn(x, y, _projectile);
                    }
                    if (GridController.flagIsPresent(grid[idx], GridItemTypes.GIT_ABOUT_TO_EXPLODE | GridItemTypes.GIT_FRUIT)) {
                        GridController.hitGridItemOn(x, y, _projectile);
                    }
                    if (GridController.flagIsPresent(grid[idx], GridItemTypes.GIT_ABOUT_TO_EXPLODE | GridItemTypes.GIT_BONUS_TRIPLE_SHOT)) {
                        GridController.hitGridItemOn(x, y, _projectile);
                    }
                    if (GridController.flagIsPresent(grid[idx], GridItemTypes.GIT_ABOUT_TO_EXPLODE | GridItemTypes.GIT_WOOD)) {
                        Collisions.setCollision(_x, _y, false);
                        GridController.grid[idx] = 0;
                        ScreenGame.smokeFrames[idx] = 0;
                    }
                    if (GridController.flagIsPresent(grid[idx], GridItemTypes.GIT_ABOUT_TO_EXPLODE | GridItemTypes.GIT_STRONG_WOOD)) {
                        Collisions.setCollision(_x, _y, false);
                        GridController.grid[idx] = 0;
                        ScreenGame.smokeFrames[idx] = 0;
                    }
                    if (GridController.flagIsPresent(grid[idx], GridItemTypes.GIT_ABOUT_TO_EXPLODE | GridItemTypes.GIT_DAMAGED_STRONG_WOOD)) {
                        Collisions.setCollision(_x, _y, false);
                        GridController.grid[idx] = 0;
                        ScreenGame.smokeFrames[idx] = 0;
                    }
                    if (GridController.flagIsPresent(grid[idx], GridItemTypes.GIT_ABOUT_TO_EXPLODE | GridItemTypes.GIT_IRON)) {
                        Collisions.setCollision(_x, _y, false);
                        GridController.grid[idx] = 0;
                        ScreenGame.smokeFrames[idx] = 0;
                    }
                    if (GridController.flagIsPresent(grid[idx], GridItemTypes.GIT_ABOUT_TO_EXPLODE | GridItemTypes.GIT_SPIKED_BALL)) {
                        GridController.hitGridItemOn(x, y, _projectile);
                    }
                    if (GridController.flagIsPresent(grid[idx], GridItemTypes.GIT_ABOUT_TO_EXPLODE | GridItemTypes.GIT_GLUE)) {
                        Collisions.setCollision(_x, _y, false);
                        GridController.grid[idx] = 0;
                        ScreenGame.smokeFrames[idx] = 0;
                    }
                    if (!GridController.flagIsPresent(grid[idx], GridItemTypes.GIT_FRUIT | GridItemTypes.GIT_ABOUT_TO_EXPLODE | GridItemTypes.GIT_FREEZED)) continue;
                    GridController.hitGridItemOn(x, y, _projectile);
                }
            }
        }
        return false;
    }

    public static final int getImportantItemsCount() {
        int len = grid.length;
        int res = 0;
        int effectOfAffectedItem = 0;
        for (int i = 0; i < len; ++i) {
            effectOfAffectedItem = GridItemTypes.getEffectOfItem(grid[i]);
            if (!GridController.flagIsPresent(effectOfAffectedItem, 4)) continue;
            ++res;
        }
        GridController.tr("wat: " + res);
        return res;
    }

    public static final boolean flagIsPresent(int _mask, int _flags) {
        return (_mask & _flags) == _flags;
    }

    public static final int getGridSizeW() {
        return itemInGridW;
    }

    public static final int getGridSizeH() {
        return itemInGridH;
    }

    public static final int getGridSizeW2() {
        return itemInGridW2;
    }

    public static final int getGridSizeH2() {
        return itemInGridH2;
    }

    public static final void tr(String _s) {
    }
}

