/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import sk.inlogic.Collisions;
import sk.inlogic.GridController;
import sk.inlogic.MainCanvas;
import sk.inlogic.PointerController;
import sk.inlogic.util.MathFP;

public class Projectile {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_STRONG = 1;
    public static final int TYPE_SPIKED_BALL = 3;
    private boolean dirUp = false;
    private boolean dirDown = false;
    private boolean dirLeft = false;
    private boolean dirRight = false;
    private boolean live = false;
    private int type = 0;
    private int positionX = 0;
    private int positionY = 0;
    private int gridPositionX = -1;
    private int gridPositionY = -1;
    public int prevStepPositionX = 0;
    public int prevStepPositionY = 0;
    private int xBuffer = 0;
    private int yBuffer = 0;
    private int xAngle = 0;
    private int yAngle = 0;
    public int ratio = 2;
    public int radius = 10;
    private int G = 4;
    private int worldW = 0;
    private int worldH = 0;
    private boolean stopped = false;
    private long stoppedStartedOn = 0L;
    private long stoppedDuration = 0L;
    private int angle = 0;
    public static int frameCount = 0;
    public int frame = 0;
    int x = this.positionX;
    int y = this.positionY;
    long a;
    long b = 0L;
    int i = 0;
    private boolean shouldBounce = false;
    public static boolean showPrevSteps = true;

    public Projectile(int _type, int _worldWidth, int _worldHeight) {
        if (MainCanvas.WIDTH_FROM_DC == 480 && MainCanvas.HEIGHT_FROM_DC < 400) {
            this.ratio = 3;
            this.radius = 10;
        } else if (MainCanvas.WIDTH_FROM_DC == 320 && MainCanvas.HEIGHT_FROM_DC < 320) {
            this.ratio = 4;
            this.radius = 10;
        } else if (MainCanvas.WIDTH == 480) {
            this.ratio = 2;
            this.radius = 10;
        } else if (MainCanvas.WIDTH == 360) {
            this.ratio = 2;
            this.radius = 10;
        } else if (MainCanvas.WIDTH == 240 || MainCanvas.WIDTH == 320) {
            this.ratio = 3;
            this.radius = 10;
        } else if (MainCanvas.WIDTH == 176) {
            this.ratio = 4;
            this.radius = 10;
        } else if (MainCanvas.WIDTH == 128) {
            this.ratio = 5;
            this.radius = 10;
        } else if (MainCanvas.WIDTH_FROM_DC == 220 && MainCanvas.HEIGHT_FROM_DC < 230) {
            this.ratio = 5;
            this.radius = 10;
        }
        this.type = _type;
        this.live = false;
        this.worldW = _worldWidth;
        this.worldH = _worldHeight;
    }

    private final long now() {
        return System.currentTimeMillis();
    }

    public final int getType() {
        return this.type;
    }

    public final int getGridPositionX() {
        return this.positionX / GridController.getGridSizeW();
    }

    public final int getGridPositionY() {
        return this.positionY / GridController.getGridSizeH();
    }

    public final int getGridPositionOnX(int _x) {
        return _x / GridController.getGridSizeW();
    }

    public final int getGridPositionOnY(int _y) {
        return _y / GridController.getGridSizeH();
    }

    public final int getPositionX() {
        return this.positionX;
    }

    public final int getPositionY() {
        return this.positionY;
    }

    public final void setPositionX(int _x) {
        this.positionX = _x;
    }

    public final void setPositionY(int _y) {
        this.positionY = _y;
    }

    public final void invertXmotion() {
        this.xAngle *= -1;
        this.xBuffer += this.xAngle;
        this.xBuffer %= this.ratio;
    }

    public final void invertYmotion() {
        this.yAngle *= -1;
        this.yBuffer += this.yAngle;
        this.yBuffer %= this.ratio;
    }

    public final void update(boolean withCollisions) {
        if (!this.live) {
            return;
        }
        if (this.stopped) {
            if (this.stoppedStartedOn != 0L) {
                this.stoppedDuration += this.now() - this.stoppedStartedOn;
                this.stoppedStartedOn = this.now();
            }
            if (this.stoppedStartedOn == 0L) {
                this.stoppedStartedOn = this.now();
            }
            if (this.stoppedDuration >> 10 >= 1L) {
                GridController.honeyItem = -1;
                this.destroy();
            }
            return;
        }
        ++this.frame;
        if (this.frame >= frameCount) {
            this.frame = 0;
        }
        switch (this.type) {
            case 0: 
            case 1: 
            case 3: {
                this.prevStepPositionX = this.positionX;
                this.prevStepPositionY = this.positionY;
                this.xBuffer += this.xAngle;
                this.positionX += this.xBuffer / this.ratio;
                this.xBuffer %= this.ratio;
                this.yBuffer += this.yAngle;
                this.positionY += this.yBuffer / this.ratio;
                this.yBuffer %= this.ratio;
                this.yAngle += this.G;
                this.gridPositionX = this.positionX / Collisions.CD_GRID_SIZE_W;
                this.gridPositionY = this.positionY / Collisions.CD_GRID_SIZE_H;
            }
        }
        if (withCollisions) {
            this.checkCollisionOnWay();
        }
        if (this.positionX != this.x && this.positionY != this.y) {
            this.x = this.positionX;
            this.y = this.positionY;
            this.a = System.currentTimeMillis();
        } else if (this.live) {
            if (this.i == 0) {
                ++this.i;
            }
            MainCanvas.tr("som tu 1 a:" + this.a + " b: " + this.b + " b-a= " + (this.b - this.a));
            if (this.b - this.a > 1400L) {
                if (this.type != 3) {
                    this.destroy();
                    MainCanvas.tr("som tu 2");
                    this.b = 0L;
                    this.i = 0;
                }
            } else {
                this.b = System.currentTimeMillis();
            }
        }
        if (this.positionY > this.worldH) {
            this.destroy();
        }
    }

    private final void forcePosition(int _x, int _y) {
        this.prevStepPositionX = _x;
        this.prevStepPositionY = _y;
        this.positionX = _x;
        this.positionY = _y;
        this.gridPositionX = this.positionX / Collisions.CD_GRID_SIZE_W;
        this.gridPositionY = this.positionY / Collisions.CD_GRID_SIZE_H;
        this.xBuffer += this.xAngle;
        this.xBuffer %= this.ratio;
        this.yBuffer += this.yAngle;
        this.yBuffer %= this.ratio;
        this.yAngle += this.G;
    }

    public final void checkCollisionOnWay() {
        int deltax = this.positionX - this.prevStepPositionX;
        int deltay = this.positionY - this.prevStepPositionY;
        int count = Math.abs(deltax) > Math.abs(deltay) ? Math.abs(deltax) / 2 : Math.abs(deltay) / 2;
        if (count <= 0) {
            count = 1;
        }
        int xAdd = (deltax << 8 << 8) / (count << 8);
        int yAdd = (deltay << 8 << 8) / (count << 8);
        int x = this.prevStepPositionX << 8;
        int y = this.prevStepPositionY << 8;
        --count;
        int colX = -1;
        int colY = -1;
        int lastPositionInGridX = -1;
        int lastPositionInGridY = -1;
        this.shouldBounce = false;
        int tmpBackShiftedX = 0;
        int tmpBackShiftedY = 0;
        for (int k = count; k >= 0; --k) {
            if (lastPositionInGridX == Collisions.getPositionOnGridX((x += xAdd) >> 8) && lastPositionInGridY == Collisions.getPositionOnGridY((y += yAdd) >> 8)) continue;
            lastPositionInGridX = Collisions.getPositionOnGridX(x >> 8);
            lastPositionInGridY = Collisions.getPositionOnGridY(y >> 8);
            if (!Collisions.inCollision(x >> 8, y >> 8)) continue;
            tmpBackShiftedX = x >> 8;
            tmpBackShiftedY = y >> 8;
            colX = Collisions.getPositionOnGridX(tmpBackShiftedX);
            if (GridController.shouldBounceOn(colX, colY = Collisions.getPositionOnGridY(tmpBackShiftedY))) {
                this.shouldBounce = true;
                GridController.hitGridItemOn(colX, colY, this);
                this.doBounceOnItem(colX, colY, x - xAdd >> 8, y - yAdd >> 8);
                this.forcePosition(x - xAdd >> 8, y - yAdd >> 8);
                break;
            }
            GridController.hitGridItemOn(colX, colY, this);
        }
        this.dirUp = this.prevStepPositionY < this.positionY;
        this.dirDown = this.prevStepPositionY >= this.positionY;
        this.dirRight = this.prevStepPositionX > this.positionX;
        this.dirLeft = this.prevStepPositionX <= this.positionX;
    }

    private void doBounceOnItem(int _x, int _y, int _projectileX, int _projectileY) {
        Projectile.tr("som tu jak panko 0101001");
        int itemCenterX = GridController.xOffset + _x * Collisions.CD_GRID_SIZE_W + (Collisions.CD_GRID_SIZE_W >> 1);
        int itemCenterY = GridController.yOffset + _y * Collisions.CD_GRID_SIZE_H + (Collisions.CD_GRID_SIZE_H >> 1);
        int dX = MathFP.abs(itemCenterX - _projectileX);
        int dY = MathFP.abs(itemCenterY - _projectileY);
        if (dX <= dY || dX >= dY) {
            Projectile.tr("som tu jak pan 0");
            if (dX < dY) {
                Projectile.tr("som tu jak pan 1");
                this.invertYmotion();
            } else {
                Projectile.tr("som tu jak pan 2");
                this.invertXmotion();
            }
        } else {
            Projectile.tr("som tu jak pan 3");
            if (GridController.shouldBounceOn(_x, _y) && GridController.shouldBounceOn(_x + 1, _y) && GridController.shouldBounceOn(_x, _y + 1)) {
                this.invertYmotion();
                this.invertXmotion();
            } else if (GridController.shouldBounceOn(_x, _y) && GridController.shouldBounceOn(_x - 1, _y) && GridController.shouldBounceOn(_x, _y + 1)) {
                this.invertYmotion();
                this.invertXmotion();
            } else if (GridController.shouldBounceOn(_x, _y) && GridController.shouldBounceOn(_x + 1, _y) && !Collisions.getCollision(_x, _y + 1)) {
                this.invertYmotion();
            } else if (GridController.shouldBounceOn(_x, _y) && GridController.shouldBounceOn(_x - 1, _y) && !Collisions.getCollision(_x, _y + 1)) {
                this.invertYmotion();
            } else if (GridController.shouldBounceOn(_x, _y) && GridController.shouldBounceOn(_x, _y + 1) && !Collisions.getCollision(_x + 1, _y)) {
                this.invertXmotion();
            } else if (GridController.shouldBounceOn(_x, _y) && GridController.shouldBounceOn(_x, _y - 1) && !Collisions.getCollision(_x + 1, _y)) {
                this.invertXmotion();
            } else {
                this.invertYmotion();
            }
        }
    }

    public final void destroy() {
        this.live = false;
    }

    public final boolean isDestroyed() {
        return !this.live;
    }

    public final void stop() {
        this.stopped = true;
    }

    public final void fire(int _strength, int _x, int _y) {
        if (this.live) {
            return;
        }
        this.radius = _strength;
        this.live = true;
        this.positionX = _x;
        this.positionY = _y;
        this.xBuffer = 0;
        this.yBuffer = 0;
        this.angle = PointerController.getAngle();
        if (this.type != 3) {
            this.xAngle = PointerController.getArcX(PointerController.getPositionX(), this.angle, this.radius) - PointerController.getPositionX();
        }
        this.yAngle = PointerController.getArcY(PointerController.getPositionY(), this.angle, this.radius) - PointerController.getPositionY();
    }

    public final void fireWithAngle(int _strength, int _x, int _y, int _angle) {
        if (this.live) {
            return;
        }
        this.radius = _strength;
        this.live = true;
        this.positionX = _x;
        this.positionY = _y;
        this.xBuffer = 0;
        this.yBuffer = 0;
        this.angle = _angle;
        if (this.type != 3) {
            this.xAngle = PointerController.getArcX(PointerController.getPositionX(), this.angle, this.radius) - PointerController.getPositionX();
        }
        this.yAngle = PointerController.getArcY(PointerController.getPositionY(), this.angle, this.radius) - PointerController.getPositionY();
    }

    public final void reset() {
        this.xBuffer = 0;
        this.yBuffer = 0;
        this.positionX = PointerController.getPositionX();
        this.positionY = PointerController.getPositionY();
        this.xAngle = PointerController.getArcX(PointerController.getPositionX(), this.angle, this.radius) - PointerController.getPositionX();
        this.yAngle = PointerController.getArcY(PointerController.getPositionY(), this.angle, this.radius) - PointerController.getPositionY();
    }

    public final void paintNextSteps(Graphics g) {
        int deltax = this.positionX - this.prevStepPositionX;
        int deltay = this.positionY - this.prevStepPositionY;
        int count = Math.abs(deltax) > Math.abs(deltay) ? Math.abs(deltax) : Math.abs(deltay);
        if (count <= 0) {
            count = 1;
        }
        int xAdd = (deltax << 8 << 8) / (count << 8);
        int yAdd = (deltay << 8 << 8) / (count << 8);
        int x = this.prevStepPositionX << 8;
        int y = this.prevStepPositionY << 8;
        g.setColor(0);
        int lastPositionInGridX = -1;
        int lastPositionInGridY = -1;
        for (int k = --count; k >= 0; --k) {
            if (lastPositionInGridX == Collisions.getPositionOnGridX((x += xAdd) >> 8) && lastPositionInGridY == Collisions.getPositionOnGridY((y += yAdd) >> 8)) continue;
            lastPositionInGridX = Collisions.getPositionOnGridX(x >> 8);
            lastPositionInGridY = Collisions.getPositionOnGridY(y >> 8);
            g.drawRect(x >> 8, y >> 8, 1, 1);
            if (Collisions.inCollision(x >> 8, y >> 8)) break;
        }
    }

    public final void paint(Graphics g) {
        if (this.type == 3) {
            g.setColor(0);
        } else {
            g.setColor(0xFF0000);
        }
        g.fillRect(this.positionX - 1, this.positionY - 1, 3, 3);
        if (showPrevSteps) {
            g.setColor(0xFFFFFF);
            g.fillRect(this.prevStepPositionX - 1, this.prevStepPositionY - 1, 3, 3);
            g.setColor(0);
            g.drawRect(this.prevStepPositionX - 1, this.prevStepPositionY - 1, 3, 3);
            this.paintNextSteps(g);
        }
    }

    public static final boolean flagIsPresent(int _mask, int _flags) {
        return (_mask & _flags) == _flags;
    }

    public static void tr(String _s) {
        System.out.println(_s);
    }
}

