/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.graphics.Rendering2D;
import sk.inlogic.screen.IScreen;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenSounds
implements IScreen {
    MainCanvas mc;
    int mode;
    long modeDelay;
    private static final int ITEM_YES = 0;
    private static final int ITEM_NO = 1;
    Rectangle centeredItem = null;
    Rectangle[] menuItems = new Rectangle[2];
    Rectangle textQuetions;
    PreparedText pt = null;
    private int holdingItemIndex = -1;
    char[] enableSoundsCharArr;

    public ScreenSounds(MainCanvas mainCanvas) {
        this.mc = mainCanvas;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{13, 12});
        Resources.loadSprites(new int[]{13});
        Resources.loadText(0);
        this.holdingItemIndex = -1;
        this.enableSoundsCharArr = Resources.resTexts[0].getHashedString(4).toCharArray();
        this.centeredItem = new Rectangle(MainCanvas.WIDTH - MainCanvas.mainTableSize >> 1, MainCanvas.HEIGHT - (MainCanvas.arrowBackgroundSize + MainCanvas.mainUIOffset), MainCanvas.mainTableSize, MainCanvas.arrowBackgroundSize);
        this.textQuetions = new Rectangle(1, 0, MainCanvas.WIDTH - 1, MainCanvas.HEIGHT);
        this.pt = new PreparedText(this.mc.mainFont);
        this.pt.prepareText(Resources.resTexts[0].getHashedString(4), this.textQuetions.width);
        this.menuItems[1] = new Rectangle(this.centeredItem.x - MainCanvas.emptySpaceOnSides4 - (MainCanvas.arrowBackgroundSize >> 1), this.centeredItem.getCenterY() - (MainCanvas.arrowBackgroundSize >> 1), MainCanvas.arrowBackgroundSize, MainCanvas.arrowBackgroundSize);
        this.menuItems[0] = new Rectangle(this.centeredItem.getRight() + MainCanvas.emptySpaceOnSides4 - (MainCanvas.arrowBackgroundSize >> 1), this.centeredItem.getCenterY() - (MainCanvas.arrowBackgroundSize >> 1), MainCanvas.arrowBackgroundSize, MainCanvas.arrowBackgroundSize);
    }

    public void afterHide() {
        Resources.freeImages(new int[]{13, 12});
        Resources.freeSprites(new int[]{13});
        Resources.freeText(0);
    }

    public void tr(String str) {
        System.out.println(str);
    }

    public void update(long lastRunLenght) {
        this.repaint();
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        if (Keys.isFKLeft(keyCode)) {
            MainCanvas.soundManager.SetSoundOn(true);
            this.mc.setActiveScreen(2, null);
        } else if (Keys.isFKRight(keyCode)) {
            MainCanvas.soundManager.SetSoundOn(false);
            this.mc.setActiveScreen(2, null);
        }
        MainCanvas.mlog("ScreenSound keyReleased() - OUT " + MainCanvas.soundManager.IsSoundOn());
    }

    public void paint(Graphics g) {
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.setColor(0);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        this.pt.drawText(g, this.textQuetions, 0, 3);
        for (int i = 0; i < this.menuItems.length; ++i) {
            if (this.holdingItemIndex == i) {
                Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[14], this.menuItems[i]);
                continue;
            }
            Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.menuItems[i]);
        }
        g.drawImage(Resources.resImgs[12], this.menuItems[0].x + (this.menuItems[0].width / 2 - Resources.resImgs[13].getWidth() / 2), this.menuItems[0].y + (this.menuItems[0].height / 2 - Resources.resImgs[13].getHeight() / 2), 0);
        g.drawImage(Resources.resImgs[13], this.menuItems[1].x + (this.menuItems[1].width / 2 - Resources.resImgs[12].getWidth() / 2), this.menuItems[1].y + (this.menuItems[1].height / 2 - Resources.resImgs[12].getHeight() / 2), 0);
    }

    public void repaint() {
        this.mc.paint();
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this.menuItems.length; ++i) {
            if (this.menuItems[i].contains(x, y)) {
                this.holdingItemIndex = i;
            }
            this.repaint();
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        for (int i = 0; i < this.menuItems.length; ++i) {
            if (this.menuItems[i].contains(x, y)) {
                this.holdingItemIndex = -1;
                this.mc.repaint();
            }
            if (this.menuItems[1].contains(x, y)) {
                MainCanvas.soundManager.SetSoundOn(true);
                this.mc.setActiveScreen(2, null);
                continue;
            }
            if (!this.menuItems[0].contains(x, y)) continue;
            MainCanvas.soundManager.SetSoundOn(false);
            this.mc.setActiveScreen(2, null);
        }
    }
}

