/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.util;

public class Rectangle {
    public int x = 0;
    public int y = 0;
    public int width = 0;
    public int height = 0;
    private static Rectangle tmpIntersect = new Rectangle();

    public Rectangle() {
    }

    public Rectangle(Rectangle r, int offsetX, int offsetY) {
        this.x = r.x + offsetX;
        this.y = r.y + offsetY;
        this.width = r.width;
        this.height = r.height;
    }

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(Rectangle r) {
        this.copyFrom(r);
    }

    public void copyFrom(Rectangle r) {
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
    }

    public void intersectWith(Rectangle r) {
        if (r == null) {
            return;
        }
        int right = Math.max(this.getRight(), r.getRight());
        int bottom = Math.max(this.getBottom(), r.getBottom());
        this.x = Math.min(this.x, r.x);
        this.y = Math.min(this.y, r.y);
        this.width = right - this.x;
        this.height = bottom - this.y;
    }

    public int getRight() {
        return this.x + this.width;
    }

    public int getBottom() {
        return this.y + this.height;
    }

    public int getCenterX() {
        return this.x + this.width / 2;
    }

    public int getCenterY() {
        return this.y + this.height / 2;
    }

    public boolean contains(int x, int y) {
        return x >= this.x && x <= this.getRight() && y >= this.y && y <= this.getBottom();
    }

    public boolean intersects(Rectangle r) {
        if (r == null) {
            return false;
        }
        if (this.getBottom() <= r.y) {
            return false;
        }
        if (this.y >= r.getBottom()) {
            return false;
        }
        if (this.getRight() <= r.x) {
            return false;
        }
        return this.x < r.getRight();
    }

    public Rectangle getIntersectsRectangle(Rectangle r) {
        if (!this.intersects(r)) {
            return null;
        }
        Rectangle.tmpIntersect.x = Math.max(this.x, r.x);
        Rectangle.tmpIntersect.y = Math.max(this.y, r.y);
        Rectangle.tmpIntersect.width = Math.min(this.getRight(), r.getRight()) - Rectangle.tmpIntersect.x;
        Rectangle.tmpIntersect.height = Math.min(this.getBottom(), r.getBottom()) - Rectangle.tmpIntersect.y;
        return tmpIntersect;
    }

    public boolean equals(Rectangle r) {
        return r != null && this.x == r.x && this.y == r.y && this.width == r.width && this.height == r.height;
    }

    public void reset() {
        this.x = -1;
        this.y = -1;
        this.width = -1;
        this.height = -1;
    }
}

