/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import sk.inlogic.MainCanvas;
import sk.inlogic.Projectile;
import sk.inlogic.Resources;
import sk.inlogic.ScreenGame;
import sk.inlogic.util.MathFP;

public class PointerController {
    public static final int POINTER_ON_LEFT_SIDE = 1;
    public static final int POINTER_ON_CENTER = 2;
    public static final int POINTER_ON_RIGHT_SIDE = 3;
    public static int POINTER_ROTATION_SPEED_DEFAULT = 5;
    public static int POINTER_ROTATION_SPEED = 5;
    private static int POINTER_LENGTH = 100;
    private static int positionX = 0;
    private static int positionY = 0;
    public static int angle = 270;
    private static int numberOfGraphicElements = 6;
    private static int worldW = 0;
    private static int worldH = 0;
    public static final int MAX_PROJECTILES = 50;
    public static Projectile[] projectiles = new Projectile[50];
    public static int strength = 10;
    public static int strengthOffset = 10;
    public static boolean nextShotTriple = false;
    public static int projCount = 0;
    public static int projCounter = 0;
    public static boolean selectingStrength = false;
    private static int cr;
    private static int cg;
    private static int cb;
    private static int range;
    private static int wormSpriteW;
    private static int wormSpriteH;
    private static int wormSpriteW2;
    private static int wormSpriteH2;
    private static int pointerDotW;
    private static int pointerDotH;
    private static int pointerDotW2;
    private static int pointerDotH2;
    private static int pointerRotationIntBuffer;
    private static int pointerRotationIntBufferRatio;
    private static int pointerRotationPixelUpdate;
    static int ratio;
    static int bufferX;
    static int updateX;
    static int bufferY;
    static int updateY;
    static int rotationAcc;
    static int strengthSelectorPhaseCounter;
    static int strengthSelectorPhase;
    static boolean strengthRising;
    static int pointerRadius;
    static int aimX;
    static int aimY;
    static int dx;
    static int dy;
    static int tmpRadius;
    static int pointerDotsOffset;
    static int pointerDotsCenterOffset;

    public static final void setWormSprite() {
        wormSpriteW = Resources.resSprs[15].getWidth();
        wormSpriteH = Resources.resSprs[15].getHeight();
        wormSpriteW2 = wormSpriteW >> 1;
        wormSpriteH2 = wormSpriteH >> 1;
    }

    public static final void setPointerDotImage() {
        pointerDotW = Resources.resImgs[26].getWidth();
        pointerDotH = Resources.resImgs[26].getHeight();
        pointerDotW2 = pointerDotW >> 1;
        pointerDotH2 = pointerDotH >> 1;
    }

    public static final void setNumberOfElements(int _numberOfElements) {
        numberOfGraphicElements = _numberOfElements;
    }

    public static final void setBounds(int _x, int _y, int _w, int _h) {
        positionX = _x;
        positionY = _y;
        worldW = _w;
        worldH = _h;
    }

    public static final int getPositionX() {
        return positionX;
    }

    public static final int getPositionY() {
        return positionY;
    }

    public static final void setPosition(int _x, int _y) {
        angle = 270;
        if (MainCanvas.WIDTH_FROM_DC == 480 && MainCanvas.HEIGHT_FROM_DC < 400) {
            strengthOffset = 5;
            POINTER_ROTATION_SPEED_DEFAULT = 5;
            POINTER_ROTATION_SPEED = 5;
            rotationAcc = 5;
            pointerDotsOffset = 2;
            pointerDotsCenterOffset = 4;
        } else if (MainCanvas.WIDTH_FROM_DC == 320 && MainCanvas.HEIGHT_FROM_DC < 320) {
            strengthOffset = 5;
            POINTER_ROTATION_SPEED_DEFAULT = 5;
            POINTER_ROTATION_SPEED = 5;
            rotationAcc = 5;
            pointerDotsOffset = 2;
            pointerDotsCenterOffset = 2;
        } else if (MainCanvas.WIDTH == 480) {
            strengthOffset = 10;
            POINTER_ROTATION_SPEED_DEFAULT = 5;
            POINTER_ROTATION_SPEED = 5;
            rotationAcc = 5;
            pointerDotsOffset = 4;
            pointerDotsCenterOffset = 4;
        } else if (MainCanvas.WIDTH == 360) {
            strengthOffset = 7;
            POINTER_ROTATION_SPEED_DEFAULT = 5;
            POINTER_ROTATION_SPEED = 5;
            rotationAcc = 5;
            pointerDotsOffset = 4;
            pointerDotsCenterOffset = 4;
        } else if (MainCanvas.WIDTH == 240 || MainCanvas.WIDTH == 320) {
            strengthOffset = 5;
            POINTER_ROTATION_SPEED_DEFAULT = 5;
            POINTER_ROTATION_SPEED = 5;
            rotationAcc = 5;
            pointerDotsOffset = 2;
            pointerDotsCenterOffset = 4;
        } else if (MainCanvas.WIDTH == 176) {
            strengthOffset = 5;
            POINTER_ROTATION_SPEED_DEFAULT = 5;
            POINTER_ROTATION_SPEED = 5;
            rotationAcc = 5;
            pointerDotsOffset = 2;
            pointerDotsCenterOffset = 2;
        } else if (MainCanvas.WIDTH == 128) {
            strengthOffset = 5;
            POINTER_ROTATION_SPEED_DEFAULT = 5;
            POINTER_ROTATION_SPEED = 5;
            rotationAcc = 4;
            pointerDotsOffset = 1;
            pointerDotsCenterOffset = 2;
        } else if (MainCanvas.WIDTH_FROM_DC == 220 && MainCanvas.HEIGHT_FROM_DC < 230) {
            strengthOffset = 5;
            POINTER_ROTATION_SPEED_DEFAULT = 5;
            POINTER_ROTATION_SPEED = 5;
            rotationAcc = 4;
            pointerDotsOffset = 1;
            pointerDotsCenterOffset = 2;
        }
        positionX = _x;
        positionY = _y;
    }

    private static final void updateMovingSpeed() {
        if (POINTER_ROTATION_SPEED <= 145) {
            POINTER_ROTATION_SPEED += rotationAcc;
        }
        pointerRotationPixelUpdate = (pointerRotationIntBuffer += POINTER_ROTATION_SPEED) / pointerRotationIntBufferRatio;
        pointerRotationIntBuffer %= pointerRotationIntBufferRatio;
    }

    public static final void resetMovingSpeed() {
        POINTER_ROTATION_SPEED = POINTER_ROTATION_SPEED_DEFAULT;
    }

    public static final void moveToLeft() {
        PointerController.updateMovingSpeed();
        angle -= pointerRotationPixelUpdate;
        PointerController.resetAngleIfNeeded();
    }

    public static final void moveToRight() {
        PointerController.updateMovingSpeed();
        angle += pointerRotationPixelUpdate;
        PointerController.resetAngleIfNeeded();
    }

    public static final void resetAngleIfNeeded() {
        if (angle > 360) {
            angle -= 360;
        }
        if (angle < 0) {
            angle += 360;
        }
    }

    public static final boolean isCollisionOnDDA(int sx1, int sy1, int sx2, int sy2, int tx, int ty, int tw, int th) {
        int deltax = sx2 - sx1;
        int deltay = sy2 - sy1;
        if (deltay == 0 && deltax == 0) {
            PointerController.tr("ano je to true");
            return true;
        }
        int count = Math.abs(deltax) > Math.abs(deltay) ? Math.abs(deltax) : Math.abs(deltay);
        int xAdd = (deltax << 8 << 8) / (count << 8);
        int yAdd = (deltay << 8 << 8) / (count << 8);
        int x = sx1 << 8;
        int y = sy1 << 8;
        if (PointerController.rectContainsPoint(tx, ty, tw, th, sx1, sy1)) {
            PointerController.tr("ano je to true");
            return true;
        }
        for (int k = --count; k >= 0; --k) {
            if (!PointerController.rectContainsPoint(tx, ty, tw, th, (x += xAdd) >> 8, (y += yAdd) >> 8)) continue;
            PointerController.tr("ano je to true");
            System.out.println("ano je to true");
            return true;
        }
        return false;
    }

    public static final boolean rectContainsPoint(int x, int y, int w, int h, int px, int py) {
        return px >= x && px <= x + w && py >= y && py <= y + h;
    }

    public static final int getAngle() {
        return angle;
    }

    public static final int getArcX(int _posX, int _angle, int _r) {
        return _posX + (MathFP.COS(_angle) * _r >> 6);
    }

    public static final int getArcY(int _posY, int _angle, int _r) {
        return _posY + (MathFP.SIN(_angle) * _r >> 6);
    }

    public static final boolean fire(int _type) {
        if (projCount != 0) {
            return false;
        }
        if (!nextShotTriple) {
            PointerController.fireAt(strength, _type, PointerController.getPositionX(), PointerController.getPositionY());
            ++projCount;
        } else {
            PointerController.fireTripleAt(_type, PointerController.getPositionX(), PointerController.getPositionY());
            nextShotTriple = false;
            projCount += 3;
        }
        return true;
    }

    public static final void fireAt(int _strength, int _type, int _x, int _y) {
        PointerController.tr("firing with str: " + _strength);
        PointerController.projectiles[PointerController.projCounter] = new Projectile(_type, worldW, worldH);
        projectiles[projCounter].fire(_strength, _x, _y);
        PointerController.incProjCounter();
    }

    private static final void incProjCounter() {
        if (++projCounter >= projectiles.length) {
            projCounter = 0;
        }
    }

    public static final void fireTripleAt(int _type, int _x, int _y) {
        PointerController.projectiles[PointerController.projCounter] = new Projectile(_type, worldW, worldH);
        projectiles[projCounter].fireWithAngle(strength, _x, _y, angle);
        PointerController.incProjCounter();
        PointerController.projectiles[PointerController.projCounter] = new Projectile(_type, worldW, worldH);
        projectiles[projCounter].fireWithAngle(strength, _x, _y, angle - 10);
        PointerController.incProjCounter();
        PointerController.projectiles[PointerController.projCounter] = new Projectile(_type, worldW, worldH);
        projectiles[projCounter].fireWithAngle(strength, _x, _y, angle + 10);
        PointerController.incProjCounter();
    }

    public static final void resetStrength() {
        strength = strengthOffset;
        strengthSelectorPhaseCounter = 0;
        strengthSelectorPhase = 0;
        strengthRising = true;
    }

    public static final void raiseStrengthCounter() {
        ++strengthSelectorPhaseCounter;
    }

    public static final void update() {
        if (selectingStrength && strengthSelectorPhaseCounter >= 1) {
            strengthSelectorPhaseCounter = 0;
            if (++strength > 15 + strengthOffset) {
                strength = 15 + strengthOffset;
            }
        }
        projCount = 0;
        for (int i = 0; i < 50; ++i) {
            if (projectiles[i] == null) continue;
            projectiles[i].update(true);
            ++projCount;
            if (!projectiles[i].isDestroyed()) continue;
            PointerController.projectiles[i] = null;
            ScreenGame.forceLevelEndIfNeeded();
        }
    }

    public static final void destroyAllProjectiles() {
        for (int i = 0; i < 50; ++i) {
            PointerController.projectiles[i] = null;
        }
        projCount = 0;
        projCounter = 0;
    }

    public static final void paint(Graphics g) {
        if (!nextShotTriple) {
            for (int i = 0; i < numberOfGraphicElements; ++i) {
                tmpRadius = i * pointerDotsOffset + pointerDotsCenterOffset;
                int aimX = PointerController.getArcX(positionX, angle, tmpRadius);
                int aimY = PointerController.getArcY(positionY, angle, tmpRadius);
                g.drawImage(Resources.resImgs[26], aimX - pointerDotW2, aimY - pointerDotH2, 0);
            }
        } else {
            for (int ang = -10; ang <= 10; ang += 10) {
                for (int i = 0; i < numberOfGraphicElements; ++i) {
                    tmpRadius = i * pointerDotsOffset + pointerDotsCenterOffset;
                    int aimX = PointerController.getArcX(positionX, angle + ang, tmpRadius);
                    int aimY = PointerController.getArcY(positionY, angle + ang, tmpRadius);
                    g.drawImage(Resources.resImgs[26], aimX - pointerDotW2, aimY - pointerDotH2, 0);
                }
            }
        }
        if (projCount == 0) {
            Resources.resSprs[15].setFrame(0);
            Resources.resSprs[15].setPosition(positionX - wormSpriteW2, positionY - wormSpriteH2);
            Resources.resSprs[15].paint(g);
            System.gc();
        }
    }

    public static void tr(String _s) {
        System.out.println(_s);
    }

    static {
        cb = 0;
        range = 15;
        wormSpriteW = -1;
        wormSpriteH = -1;
        wormSpriteW2 = -1;
        wormSpriteH2 = -1;
        pointerDotW = -1;
        pointerDotH = -1;
        pointerDotW2 = -1;
        pointerDotH2 = -1;
        pointerRotationIntBuffer = 0;
        pointerRotationIntBufferRatio = 7;
        pointerRotationPixelUpdate = 0;
        ratio = 10;
        bufferX = 0;
        updateX = 0;
        bufferY = 0;
        updateY = 0;
        rotationAcc = 5;
        strengthSelectorPhaseCounter = 0;
        strengthSelectorPhase = 0;
        strengthRising = true;
        pointerRadius = -1;
        aimX = -1;
        aimY = -1;
        dx = -1;
        dy = -1;
        tmpRadius = 0;
        pointerDotsOffset = 0;
        pointerDotsCenterOffset = 0;
    }
}

