/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.graphics.Rendering2D;
import sk.inlogic.screen.IScreen;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;
import sk.inlogic.util.Tools;

public class ScreenInstructions
implements IScreen {
    MainCanvas mc;
    int mode;
    long modeDelay;
    private static final int ITEM_TABLE = 0;
    private static final int ITEM_BACK = 1;
    private static final int ITEM_UP = 2;
    private static final int ITEM_DOWN = 3;
    Rectangle[] rectItems = new Rectangle[4];
    Rectangle rectText = null;
    private int holdingItemIndex = -1;
    PreparedText pt = null;
    private int ptYOffset = 0;
    public static boolean arrowUP = false;
    public static boolean arrowDOWN = true;
    boolean allMissed = true;

    public ScreenInstructions(MainCanvas mainCanvas) {
        this.mc = mainCanvas;
        this.ptYOffset = 0;
    }

    public void beforeShow() {
        Resources.loadText(0);
        Resources.loadImages(new int[]{40, 8});
        Resources.loadSprite(23);
        this.rectItems[2] = new Rectangle(MainCanvas.WIDTH - MainCanvas.arrowBackgroundSize >> 1, MainCanvas.mainUIOffset, MainCanvas.arrowBackgroundSize, MainCanvas.arrowBackgroundSize);
        this.rectItems[3] = new Rectangle(MainCanvas.WIDTH - MainCanvas.arrowBackgroundSize >> 1, MainCanvas.HEIGHT - MainCanvas.mainUIOffset - MainCanvas.arrowBackgroundSize, MainCanvas.arrowBackgroundSize, MainCanvas.arrowBackgroundSize);
        this.rectItems[1] = new Rectangle(MainCanvas.WIDTH - (MainCanvas.mainUIOffset + 3 * Resources.resImgsW[8] / 2), MainCanvas.HEIGHT - (MainCanvas.mainUIOffset + MainCanvas.arrowBackgroundSize), 3 * Resources.resImgsW[8] / 2, MainCanvas.arrowBackgroundSize);
        this.rectItems[0] = new Rectangle(MainCanvas.mainUIOffset, this.rectItems[2].getBottom() + MainCanvas.mainUIOffset, MainCanvas.WIDTH - (MainCanvas.mainUIOffset << 1), MainCanvas.HEIGHT - MainCanvas.mainUIOffset * 4 - this.rectItems[1].height - this.rectItems[2].height);
        this.rectText = MainCanvas.WIDTH == 480 || MainCanvas.WIDTH == 360 ? new Rectangle(this.rectItems[0].x + MainCanvas.mainUIOffset, this.rectItems[0].y + MainCanvas.mainUIOffset, this.rectItems[0].width - (MainCanvas.mainUIOffset << 1), this.rectItems[0].height - (MainCanvas.mainUIOffset << 1)) : new Rectangle(this.rectItems[0].x + (MainCanvas.mainUIOffset << 1), this.rectItems[0].y + (MainCanvas.mainUIOffset << 1), this.rectItems[0].width - (MainCanvas.mainUIOffset << 2), this.rectItems[0].height - (MainCanvas.mainUIOffset << 2));
        this.pt = new PreparedText(this.mc.mainFont);
        String controls = "";
        controls = Resources.resTexts[0].getHashedString(15);
        this.pt.prepareText(Resources.resTexts[0].getHashedString(2) + "\n\n" + controls + "\n\n" + Resources.resTexts[0].getHashedString(16), this.rectText.width);
    }

    public void afterHide() {
        Resources.freeImages(new int[]{40, 8});
        Resources.freeText(0);
        Resources.freeSprite(23);
    }

    public void tr(String str) {
        System.out.println(str);
    }

    public void update(long lastRunLenght) {
    }

    public void keyPressed(int keyCode) {
        this.repaint();
    }

    public void keyReleased(int keyCode) {
        if (Keys.isFKRight(keyCode)) {
            this.mc.setActiveScreen(3, null);
            this.ptYOffset = 0;
            arrowUP = false;
            arrowDOWN = true;
        } else if (Keys.isActionGeneratedByKey(1, keyCode)) {
            this.ptYOffset -= this.mc.mainFont.getHeight();
            arrowDOWN = true;
            if (this.ptYOffset < 0) {
                this.ptYOffset = 0;
                arrowUP = false;
                arrowDOWN = true;
            }
        } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
            int maxOffsetY = this.pt.getTextHeight() - this.rectText.height;
            this.ptYOffset += this.mc.mainFont.getHeight();
            arrowUP = true;
            if (maxOffsetY > 0 && this.ptYOffset > maxOffsetY) {
                this.ptYOffset = maxOffsetY;
                arrowUP = true;
                arrowDOWN = false;
            }
            if (this.pt.getTextHeight() <= this.rectText.height) {
                this.ptYOffset = 0;
            }
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        Tools.setFullClip(g);
        g.drawImage(Resources.resImgs[40], 0, 0, 20);
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (this.holdingItemIndex == i) {
                if (i == 2 && !arrowUP || i == 3 && !arrowDOWN) continue;
                Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[14], this.rectItems[i]);
                continue;
            }
            if (i == 2 && !arrowUP || i == 3 && !arrowDOWN) continue;
            Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.rectItems[i]);
        }
        this.pt.drawText(g, this.rectText, this.ptYOffset, 20);
        g.drawImage(Resources.resImgs[8], this.rectItems[1].getCenterX() - (Resources.resImgsW[8] >> 1), this.rectItems[1].getCenterY() - (Resources.resImgsH[8] >> 1), 20);
        if (arrowUP) {
            Resources.resSprs[23].setPosition(this.rectItems[2].getCenterX() - (Resources.resSprsW[23] >> 1), this.rectItems[2].getCenterY() - (Resources.resSprsH[23] >> 1));
            Resources.resSprs[23].setFrame(0);
            Resources.resSprs[23].paint(g);
        }
        if (arrowDOWN) {
            Resources.resSprs[23].setPosition(this.rectItems[3].getCenterX() - (Resources.resSprsW[23] >> 1), this.rectItems[3].getCenterY() - (Resources.resSprsH[23] >> 1));
            Resources.resSprs[23].setFrame(1);
            Resources.resSprs[23].paint(g);
        }
    }

    public void repaint() {
        this.mc.paint();
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (i == 0 || !this.rectItems[i].contains(x, y)) continue;
            this.holdingItemIndex = i;
        }
        this.repaint();
    }

    public void pointerDragged(int x, int y) {
        if (y > MainCanvas.HEIGHT / 2 && y < MainCanvas.HEIGHT) {
            if (x >= this.rectItems[0].x && x <= this.rectItems[0].x + this.rectItems[0].width) {
                this.dragDown();
            }
        } else if (y < MainCanvas.HEIGHT / 2 && y > 0 + Resources.resSprs[23].getHeight() && x >= this.rectItems[0].x && x <= this.rectItems[0].x + this.rectItems[0].width) {
            this.dragUp();
        }
    }

    public void pointerReleased(int x, int y) {
        this.allMissed = true;
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.rectItems[i].contains(x, y)) continue;
            if (this.holdingItemIndex != i) break;
            this.allMissed = false;
            break;
        }
        this.holdingItemIndex = -1;
        if (this.allMissed) {
            this.tr("all missed");
            return;
        }
        if (this.rectItems[1].contains(x, y)) {
            this.mc.setActiveScreen(3, null);
            this.ptYOffset = 0;
            arrowUP = false;
            arrowDOWN = true;
        } else if (this.rectItems[2].contains(x, y)) {
            this.ptYOffset -= this.mc.mainFont.getHeight();
            arrowDOWN = true;
            if (this.ptYOffset < 0) {
                this.ptYOffset = 0;
                arrowUP = false;
                arrowDOWN = true;
            }
        } else if (this.rectItems[3].contains(x, y)) {
            int maxOffsetY = this.pt.getTextHeight() - this.rectText.height;
            this.ptYOffset += this.mc.mainFont.getHeight();
            arrowUP = true;
            if (maxOffsetY > 0 && this.ptYOffset > maxOffsetY) {
                this.ptYOffset = maxOffsetY;
                arrowUP = true;
                arrowDOWN = false;
            }
            if (this.pt.getTextHeight() <= this.rectText.height) {
                this.ptYOffset = 0;
            }
            this.repaint();
        }
        this.holdingItemIndex = -1;
        this.repaint();
    }

    public void dragUp() {
        this.ptYOffset -= this.mc.mainFont.getHeight();
        arrowDOWN = true;
        if (this.ptYOffset < 0) {
            this.ptYOffset = 0;
            arrowUP = false;
            arrowDOWN = true;
        }
        this.repaint();
    }

    public void dragDown() {
        int maxOffsetY = this.pt.getTextHeight() - this.rectText.height;
        this.ptYOffset += this.mc.mainFont.getHeight();
        arrowUP = true;
        if (maxOffsetY > 0 && this.ptYOffset > maxOffsetY) {
            this.ptYOffset = maxOffsetY;
            arrowUP = true;
            arrowDOWN = false;
        }
        if (this.pt.getTextHeight() <= this.rectText.height) {
            this.ptYOffset = 0;
        }
        this.repaint();
    }
}

