/*
 * Decompiled with CFR 0.152.
 */
package CrazyLiquid.screen;

import CrazyLiquid.main.CrazyLiquid;
import CrazyLiquid.main.Global;
import CrazyLiquid.object.Button;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class AboutScreen
extends GameCanvas
implements Runnable {
    private Image bg;
    private Button btnBack;
    private long sleepTime = 0L;
    private Thread runner;
    private boolean nextScreen;

    public AboutScreen() throws IOException {
        super(false);
        this.setFullScreenMode(true);
        this.initComponents();
    }

    public void Reset() throws IOException {
        this.initComponents();
        System.gc();
    }

    private void initComponents() throws IOException {
        Button.Listener buttonListener = new Button.Listener(){

            public void onClick(Button b) {
                if (b == AboutScreen.this.btnBack) {
                    try {
                        CrazyLiquid.getInstance().showStart();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    AboutScreen.this.nextScreen = true;
                }
            }
        };
        this.bg = Image.createImage((String)"/img/BG/about.png");
        this.btnBack = new Button(Image.createImage((String)"/img/buttons/back.png"), Global.SMALLBTN_W, Global.SMALLBTN_H, buttonListener);
        this.btnBack.X = 15;
        this.btnBack.Y = 30;
    }

    public void start() throws InterruptedException {
        if (this.runner == null) {
            this.runner = new Thread(this);
        }
        if (!this.runner.isAlive()) {
            this.runner.start();
        }
    }

    public void stop() {
        this.runner = null;
    }

    public void run() {
        while (!this.nextScreen) {
            this.updateScreen(this.getGraphics());
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (Exception exception) {}
        }
        this.stop();
    }

    public void updateScreen(Graphics g) {
        this.render(g);
        this.flushGraphics();
    }

    protected void render(Graphics g) {
        g.drawImage(this.bg, 0, 0, 0);
        this.btnBack.render(g);
    }

    protected void pointerPressed(int x, int y) {
        this.btnBack.TouchEvent(Global.POINTER_PRESS, x, y);
    }

    protected void pointerReleased(int x, int y) {
        this.btnBack.TouchEvent(Global.POINTER_RELEASE, x, y);
    }

    protected void pointerDragged(int x, int y) {
        this.btnBack.TouchEvent(Global.POINTER_DRAGGED, x, y);
    }
}

