/*
 * Decompiled with CFR 0.152.
 */
package CrazyLiquid.screen;

import CrazyLiquid.main.CrazyLiquid;
import CrazyLiquid.main.Global;
import CrazyLiquid.object.Button;
import CrazyLiquid.object.Drop;
import CrazyLiquid.object.Number;
import CrazyLiquid.object.Trickle;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class GameScreen
extends GameCanvas
implements Runnable {
    private int sleepTime = 2;
    private Image bg;
    private Image combobg;
    private Vector trickles;
    private int[][] Map;
    private Vector drops;
    private Vector rocks;
    private Vector shields;
    private Vector pipes;
    private Trickle t;
    private Drop d;
    private Number number;
    private Number combonum;
    private Number levelnum;
    private boolean isCombo;
    public boolean nextScreen;
    private Button btnBack;
    Thread runner;

    public GameScreen() throws IOException {
        super(false);
        this.setFullScreenMode(true);
    }

    public void Reset() throws IOException {
        this.trickles = new Vector();
        this.drops = new Vector();
        this.Map = new int[Global.MAP_SIZE][Global.MAP_SIZE];
        this.isCombo = false;
        this.nextScreen = false;
        System.gc();
        this.initComponents();
    }

    private void initMap() throws IOException {
        Random random = new Random();
        for (int i = 0; i < Global.MAP_SIZE; ++i) {
            for (int j = 0; j < Global.MAP_SIZE; ++j) {
                if (Global.level < 15) {
                    this.Map[i][j] = random.nextInt(7);
                }
                if (Global.level >= 15 && Global.level < 20) {
                    this.Map[i][j] = random.nextInt(6);
                }
                if (Global.level >= 20 && Global.level < 30) {
                    this.Map[i][j] = random.nextInt(5);
                }
                if (Global.level >= 30 && Global.level < 40) {
                    this.Map[i][j] = random.nextInt(4);
                }
                if (Global.level >= 40) {
                    this.Map[i][j] = random.nextInt(3);
                }
                if (this.Map[i][j] == 0 || this.Map[i][j] > 4) continue;
                this.t = new Trickle(Image.createImage((String)"/img/sprite/trickleframe.png"));
                this.t.Type = this.Map[i][j] - 1;
                this.t.X = 10 + i * Global.SQUARE_SIZE;
                this.t.Y = 10 + j * Global.SQUARE_SIZE;
                this.trickles.addElement(this.t);
            }
        }
    }

    private void initComponents() throws IOException {
        Button.Listener buttonListener = new Button.Listener(){

            public void onClick(Button b) {
                if (b == GameScreen.this.btnBack) {
                    GameScreen.this.nextScreen = true;
                    try {
                        CrazyLiquid.getInstance().showStart();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        this.bg = Image.createImage((String)"/img/BG/mainbg.png");
        this.combobg = Image.createImage((String)"/img/BG/combobg.png");
        this.number = new Number(Image.createImage((String)"/img/sprite/numberframe.png"), Global.NUMBER_W, Global.NUMBER_H);
        this.number.X = 209;
        this.number.Y = 305;
        this.combonum = new Number(Image.createImage((String)"/img/sprite/numcombo.png"), Global.COMBONUMBER_W, Global.COMBONUMBER_H);
        this.levelnum = new Number(Image.createImage((String)"/img/sprite/numberframe.png"), Global.NUMBER_W, Global.NUMBER_H);
        this.levelnum.X = 82;
        this.levelnum.Y = 305;
        this.btnBack = new Button(Image.createImage((String)"/img/buttons/back.png"), Global.SMALLBTN_W, Global.SMALLBTN_H, buttonListener);
        this.btnBack.X = 10;
        this.btnBack.Y = 330;
        this.initMap();
    }

    public void start() throws InterruptedException {
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.join();
        }
        if (!this.runner.isAlive()) {
            this.runner.start();
        }
    }

    public void stop() {
        this.runner = null;
    }

    public void run() {
        while (!this.nextScreen) {
            this.updateScreen(this.getGraphics());
            try {
                this.updateMap();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (Exception exception) {}
        }
        this.stop();
    }

    public void updateScreen(Graphics g) {
        this.render(g);
        this.flushGraphics();
    }

    protected void render(Graphics g) {
        int i;
        g.drawImage(this.bg, 0, 0, 0);
        for (i = 0; i < this.trickles.size(); ++i) {
            this.t = (Trickle)this.trickles.elementAt(i);
            this.t.render(g);
        }
        for (i = 0; i < this.drops.size(); ++i) {
            this.d = (Drop)this.drops.elementAt(i);
            this.d.render(g);
        }
        this.btnBack.render(g);
        if (Global.numOfDrop < 100) {
            this.number.render2(Global.numOfDrop, g);
        } else {
            this.number.Y = 285;
            this.number.render3(Global.numOfDrop, g);
        }
        if (Global.level < 10) {
            this.levelnum.render1(Global.level, g);
        } else if (Global.level >= 10 && Global.level < 100) {
            this.levelnum.render2(Global.level, g);
        } else {
            this.levelnum.render3(Global.level, g);
        }
        if (this.isCombo) {
            g.drawImage(this.combobg, 80, 40, 0);
            if (Global.comboHit < 10) {
                this.combonum.X = 140;
                this.combonum.Y = 65;
                this.combonum.render1(Global.comboHit, g);
            } else {
                this.combonum.X = 140;
                this.combonum.Y = 69;
                this.combonum.render2(Global.comboHit, g);
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        if (this.drops.size() == 0) {
            for (int i = 0; i < this.trickles.size(); ++i) {
                this.t = (Trickle)this.trickles.elementAt(i);
                this.t.TouchEvent(Global.POINTER_PRESS, x, y);
            }
        }
        this.btnBack.TouchEvent(Global.POINTER_PRESS, x, y);
    }

    protected void pointerReleased(int x, int y) {
        if (this.drops.size() == 0) {
            Global.comboHit = 0;
            for (int i = 0; i < this.trickles.size(); ++i) {
                this.t = (Trickle)this.trickles.elementAt(i);
                this.t.TouchEvent(Global.POINTER_RELEASE, x, y);
            }
        }
        this.btnBack.TouchEvent(Global.POINTER_RELEASE, x, y);
    }

    protected void pointerDragged(int x, int y) {
        for (int i = 0; i < this.trickles.size(); ++i) {
            this.t = (Trickle)this.trickles.elementAt(i);
            this.t.TouchEvent(Global.POINTER_DRAGGED, x, y);
        }
        this.btnBack.TouchEvent(Global.POINTER_DRAGGED, x, y);
    }

    private void updateMap() throws IOException, InterruptedException {
        if (!this.checkWin()) {
            int i;
            for (i = 0; i < this.trickles.size(); ++i) {
                this.t = (Trickle)this.trickles.elementAt(i);
                if (!this.t.isVisible) {
                    this.Map[this.t.X / 44][this.t.Y / 44] = 0;
                    this.trickles.removeElement(this.t);
                    this.d = new Drop(Image.createImage((String)"/img/sprite/smalltrickleframe.png"));
                    this.d.X = this.t.X + Global.SQUARE_SIZE / 2 - Global.DROP_SIZE / 2;
                    this.d.Y = this.t.Y + Global.SQUARE_SIZE / 2 - Global.DROP_SIZE / 2;
                    this.d.Type = 0;
                    this.drops.addElement(this.d);
                    this.d = new Drop(Image.createImage((String)"/img/sprite/smalltrickleframe.png"));
                    this.d.X = this.t.X + Global.SQUARE_SIZE / 2 - Global.DROP_SIZE / 2;
                    this.d.Y = this.t.Y + Global.SQUARE_SIZE / 2 - Global.DROP_SIZE / 2;
                    this.d.Type = 1;
                    this.drops.addElement(this.d);
                    this.d = new Drop(Image.createImage((String)"/img/sprite/smalltrickleframe.png"));
                    this.d.X = this.t.X + Global.SQUARE_SIZE / 2 - Global.DROP_SIZE / 2;
                    this.d.Y = this.t.Y + Global.SQUARE_SIZE / 2 - Global.DROP_SIZE / 2;
                    this.d.Type = 2;
                    this.drops.addElement(this.d);
                    this.d = new Drop(Image.createImage((String)"/img/sprite/smalltrickleframe.png"));
                    this.d.X = this.t.X + Global.SQUARE_SIZE / 2 - Global.DROP_SIZE / 2;
                    this.d.Y = this.t.Y + Global.SQUARE_SIZE / 2 - Global.DROP_SIZE / 2;
                    this.d.Type = 3;
                    this.drops.addElement(this.d);
                    continue;
                }
                for (int j = 0; j < this.drops.size(); ++j) {
                    this.d = (Drop)this.drops.elementAt(j);
                    if (!this.t.checkContains(this.d.X + Global.DROP_SIZE / 2, this.d.Y + Global.DROP_SIZE / 2)) continue;
                    this.drops.removeElementAt(j);
                    if (this.t.Type < 3) {
                        ++this.t.Type;
                        continue;
                    }
                    if (++Global.comboHit >= 2) {
                        this.isCombo = true;
                        ++Global.numOfDrop;
                    }
                    this.t.isVisible = false;
                }
            }
            for (i = 0; i < this.drops.size(); ++i) {
                this.d = (Drop)this.drops.elementAt(i);
                if (!this.d.isVisible) {
                    this.drops.removeElementAt(i);
                    continue;
                }
                this.d.update();
            }
        } else {
            Global.winGame = true;
            this.nextScreen = true;
            CrazyLiquid.getInstance().showResult();
        }
        if (Global.numOfDrop > Global.BestDrop) {
            Global.BestDrop = Global.numOfDrop;
            CrazyLiquid.getInstance().saveRec();
        }
        if (Global.level > Global.BestLevel) {
            Global.BestLevel = Global.level;
            CrazyLiquid.getInstance().saveRec();
        }
        if (Global.numOfDrop <= 0 && this.drops.isEmpty()) {
            Global.finishGame = true;
            this.nextScreen = true;
            CrazyLiquid.getInstance().showLose();
        }
        if (this.drops.isEmpty()) {
            this.isCombo = false;
            Global.comboHit = 0;
        }
    }

    public boolean checkWin() {
        return this.trickles.size() <= 0 && this.drops.size() <= 0;
    }
}

