/*
 * Decompiled with CFR 0.152.
 */
package CrazyLiquid.screen;

import CrazyLiquid.main.CrazyLiquid;
import CrazyLiquid.main.Global;
import CrazyLiquid.object.Button;
import CrazyLiquid.object.Number;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class LoseScreen
extends GameCanvas
implements Runnable {
    private Image bg;
    private Number number;
    private Button btnOK;
    private long sleepTime = 0L;
    private boolean nextScreen;
    Thread runner;

    public LoseScreen() throws IOException {
        super(false);
        this.setFullScreenMode(true);
        this.initComponents();
    }

    private void initComponents() throws IOException {
        Button.Listener buttonListener = new Button.Listener(){

            public void onClick(Button b) {
                if (b == LoseScreen.this.btnOK) {
                    LoseScreen.this.nextScreen = true;
                    Global.isPlaying = false;
                    Global.finishGame = true;
                    try {
                        CrazyLiquid.getInstance().showStart();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        this.bg = Image.createImage((String)"/img/BG/lose.png");
        this.number = new Number(Image.createImage((String)"/img/sprite/numberframe.png"), Global.NUMBER_W, Global.NUMBER_H);
        this.number.X = 116;
        this.number.Y = 180;
        this.btnOK = new Button(Image.createImage((String)"/img/buttons/ok.png"), Global.SMALLBTN_W, Global.SMALLBTN_H, buttonListener);
        this.btnOK.X = 20;
        this.btnOK.Y = 170;
        this.nextScreen = false;
    }

    public void start() throws InterruptedException {
        if (this.runner == null) {
            this.runner = new Thread(this);
        }
        if (!this.runner.isAlive()) {
            this.runner.start();
        }
    }

    public void stop() {
        this.runner = null;
    }

    public void run() {
        while (!this.nextScreen) {
            this.updateScreen(this.getGraphics());
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (Exception exception) {}
        }
        this.stop();
    }

    public void updateScreen(Graphics g) {
        this.render(g);
        this.flushGraphics();
    }

    protected void render(Graphics g) {
        g.drawImage(this.bg, 0, 0, 0);
        this.btnOK.render(g);
        if (Global.numOfDrop < 100) {
            this.number.render2(Global.level, g);
        } else {
            this.number.render3(Global.level, g);
        }
    }

    protected void pointerPressed(int x, int y) {
        this.btnOK.TouchEvent(Global.POINTER_PRESS, x, y);
    }

    protected void pointerReleased(int x, int y) {
        this.btnOK.TouchEvent(Global.POINTER_RELEASE, x, y);
    }

    protected void pointerDragged(int x, int y) {
        this.btnOK.TouchEvent(Global.POINTER_DRAGGED, x, y);
    }
}

