/*
 * Decompiled with CFR 0.152.
 */
package com.pim.model;

import java.util.Random;

public class Maze {
    private static final int UP = 0;
    private static final int DOWN = 1;
    private static final int LEFT = 2;
    private static final int RIGHT = 3;
    private static final int MAX_SIZE = 31;
    private long[] _maze = null;
    private final float _sideLength;
    private final float _height;
    private final float _origin;
    private float _spaceBetweenPlanes = 0.0f;
    private int _startX = -1;
    private int _endX = -1;

    public Maze(int corridorCount, float mazeSideLength, float mazeHeight) {
        if (corridorCount > 31) {
            throw new IllegalArgumentException("Maze is too big!");
        }
        this._sideLength = mazeSideLength;
        this._height = mazeHeight;
        this._origin = -this._sideLength / 2.0f;
    }

    public final float height() {
        return this._height;
    }

    public final float origin() {
        return this._origin;
    }

    public final float spaceBetweenPlanes() {
        return this._spaceBetweenPlanes;
    }

    public final long[] array() {
        return this._maze;
    }

    public final int startX() {
        return this._startX;
    }

    public final int goalX() {
        return this._endX;
    }

    public float[] startPosition() {
        float[] position = new float[]{this._origin + (float)this._startX * this._spaceBetweenPlanes, this._height / 2.0f, this._origin + this._spaceBetweenPlanes};
        return position;
    }

    public final boolean isAtTheEnd(float x, float z, float tolerance) {
        return Math.abs(x - (this._origin + (float)this._endX * this._spaceBetweenPlanes)) < tolerance && Math.abs(z + this._origin) < tolerance;
    }

    public void createNew(int mazeSize) {
        this._startX = -1;
        this._endX = -1;
        Random random = new Random();
        int totalSize = mazeSize * 2 + 1;
        this._maze = new long[totalSize];
        int i = 0;
        while (i < this._maze.length) {
            this._maze[i] = -1L;
            ++i;
        }
        int[] backtrack = new int[mazeSize * mazeSize];
        int backtrackIndex = 0;
        int x = 1;
        int y = 1;
        while (true) {
            int n = x;
            this._maze[n] = this._maze[n] & (long)(~(1 << y));
            int[] directions = new int[4];
            int availableSpaces = 0;
            if (y - 2 > 0 && (this._maze[x] & (long)(1 << y - 2)) != 0L) {
                directions[availableSpaces++] = 0;
            }
            if (y + 2 < totalSize && (this._maze[x] & (long)(1 << y + 2)) != 0L) {
                directions[availableSpaces++] = 1;
            }
            if (x + 2 < totalSize && (this._maze[x + 2] & (long)(1 << y)) != 0L) {
                directions[availableSpaces++] = 2;
            }
            if (x - 2 > 0 && (this._maze[x - 2] & (long)(1 << y)) != 0L) {
                directions[availableSpaces++] = 3;
            }
            if (availableSpaces > 0) {
                int chosenDirection = directions[(random.nextInt() >>> 1) % availableSpaces];
                backtrack[backtrackIndex++] = chosenDirection;
                if (chosenDirection == 0) {
                    int n2 = x;
                    this._maze[n2] = this._maze[n2] & (long)(~(1 << y - 1));
                    y -= 2;
                    continue;
                }
                if (chosenDirection == 1) {
                    int n3 = x;
                    this._maze[n3] = this._maze[n3] & (long)(~(1 << y + 1));
                    y += 2;
                    continue;
                }
                if (chosenDirection == 2) {
                    int n4 = x + 1;
                    this._maze[n4] = this._maze[n4] & (long)(~(1 << y));
                    x += 2;
                    continue;
                }
                if (chosenDirection != 3) continue;
                int n5 = x - 1;
                this._maze[n5] = this._maze[n5] & (long)(~(1 << y));
                x -= 2;
                continue;
            }
            if (backtrackIndex == 0) break;
            if (backtrack[--backtrackIndex] == 0) {
                y += 2;
                continue;
            }
            if (backtrack[backtrackIndex] == 1) {
                y -= 2;
                continue;
            }
            if (backtrack[backtrackIndex] == 2) {
                x -= 2;
                continue;
            }
            if (backtrack[backtrackIndex] != 3) continue;
            x += 2;
        }
        do {
            int pos = (random.nextInt() >>> 1) % totalSize;
            if (this._startX < 0 && (this._maze[1] & (long)(1 << pos)) == 0L) {
                this._startX = pos;
            }
            if (this._endX >= 0 || (this._maze[this._maze.length - 2] & (long)(1 << pos)) != 0L) continue;
            this._endX = pos;
            int n = this._maze.length - 1;
            this._maze[n] = this._maze[n] & (long)(~(1 << pos));
        } while (this._endX < 0 || this._startX < 0);
        this._spaceBetweenPlanes = this._sideLength / (float)(this._maze.length - 1);
    }

    public void clear() {
        this._maze = null;
    }
}

