/*
 * Decompiled with CFR 0.152.
 */
package com.pim.ui;

import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.World;

public class CameraAnimator {
    private static final float NUM_OF_TRANSITION_STEPS = 30.0f;
    private static final float MIN_TRANSITION_STEP = 0.01f;
    private static final float PAUSE_ANIMATION_ROTATION_SPEED = 0.2f;
    public static final int PAUSE_ANIMATION = 0;
    public static final int TRANSITION_ANIMATION_TO_POV = 1;
    public static final int TRANSITION_ANIMATION_TO_TOP = 2;
    public static final int LEVEL_RESET_ANIMATION_STEP = 3;
    private Listener _listener = null;
    private World _world = null;
    private Camera _camera = null;
    private Transform _currentTransform = null;
    private Transform _targetTransform = null;
    private float[] _currentMatrix = null;
    private float[] _targetMatrix = null;
    private float[] _transitionMatrix = null;
    private float[] _currentOrientation = null;
    private float[] _targetOrientation = null;
    private int _animationType = -1;
    private int _stepCount = 0;
    private boolean _running = false;

    public CameraAnimator(Listener listener, World world, Camera camera) {
        if (listener == null || world == null || camera == null) {
            throw new IllegalArgumentException("None of the arguments can be null!");
        }
        this._listener = listener;
        this._world = world;
        this._camera = camera;
    }

    public void startAnimation(int type, Transform targetTransform, float[] targetOrientation) {
        System.out.println("CameraAnimator::startAnimation(): " + type);
        if (this._running) {
            this.releaseResources();
            this._running = false;
        }
        this._animationType = type;
        this._stepCount = 0;
        if (targetTransform != null) {
            this._targetTransform = targetTransform;
            this._targetMatrix = new float[16];
            this._targetTransform.get(this._targetMatrix);
        }
        this._currentTransform = new Transform();
        Camera activeCamera = this._world.getActiveCamera();
        if (activeCamera == null) {
            System.out.println("CameraAnimator::startAnimation(): No active camera set.");
            this._world.setActiveCamera(this._camera);
            this._camera.getTransform(this._currentTransform);
        } else {
            activeCamera.getTransform(this._currentTransform);
            if (this._camera != activeCamera) {
                System.out.println("CameraAnimator::startAnimation(): Switching the camera.");
                this._camera.setTransform(this._currentTransform);
                this._world.setActiveCamera(this._camera);
            }
        }
        if (targetOrientation != null) {
            this._targetOrientation = targetOrientation;
            this._currentOrientation = new float[4];
            this._camera.getOrientation(this._currentOrientation);
        }
        if (targetTransform != null) {
            this._currentMatrix = new float[16];
            this._currentTransform.get(this._currentMatrix);
            this._transitionMatrix = this.calculateTransitionMatrix(this._currentMatrix, this._targetMatrix);
        }
        this._running = true;
    }

    public void startAnimation(int type, Camera targetCamera) {
        if (targetCamera == null) {
            return;
        }
        Transform transform = new Transform();
        targetCamera.getTransform(transform);
        float[] orientation = new float[4];
        targetCamera.getOrientation(orientation);
        this.startAnimation(type, transform, orientation);
    }

    public void startAnimation(int type) {
        this.startAnimation(type, null, null);
    }

    public void stopAnimation() {
        System.out.println("CameraAnimator::stopAnimation()");
        this.releaseResources();
        this._running = false;
        this._listener.onAnimationFinished(this._animationType);
    }

    public final boolean running() {
        return this._running;
    }

    public final int animationType() {
        return this._animationType;
    }

    public void update() {
        if (this._targetTransform != null) {
            if (!this.takeTransitionStepTowardsTarget()) {
                System.out.println("CameraAnimator::update(): No more transition steps required.");
                if (this._animationType == 1 || this._animationType == 2) {
                    this._running = false;
                    this.stopAnimation();
                } else {
                    this.releaseResources();
                }
            }
            if (this._currentTransform != null) {
                this._camera.setTransform(this._currentTransform);
            }
            if (this._targetOrientation != null) {
                this._camera.setOrientation(this._currentOrientation[0], this._currentOrientation[1], this._currentOrientation[2], this._currentOrientation[3]);
            }
        } else if (this._animationType == 0) {
            this._camera.postRotate(0.2f, 0.0f, 1.0f, 0.0f);
        } else if (this._animationType == 3) {
            this._camera.translate(0.0f, 12.0f, 12.0f);
            ++this._stepCount;
            if (this._stepCount > 60) {
                this.stopAnimation();
            }
        } else {
            this.stopAnimation();
        }
    }

    public static final void printTransform(Transform transform) {
        if (transform == null) {
            return;
        }
        float[] matrix = new float[16];
        transform.get(matrix);
        int i = 0;
        while (i < 16) {
            if ((i + 1) % 4 == 0) {
                System.out.println(matrix[i]);
            } else {
                System.out.print(String.valueOf(matrix[i]) + "\t");
            }
            ++i;
        }
    }

    public static final void printCameraValues(Camera camera) {
        if (camera != null) {
            Transform transform = new Transform();
            camera.getTransform(transform);
            CameraAnimator.printTransform(transform);
            float[] orientation = new float[4];
            camera.getOrientation(orientation);
            System.out.print("Orientation: [");
            System.out.println(String.valueOf(orientation[0]) + ", " + orientation[1] + ", " + orientation[2] + ", " + orientation[3] + "]");
        }
    }

    private final float newValue(float current, float target, float diff) {
        if (diff < 0.0f) {
            diff = Math.abs(diff);
        }
        if (Math.abs(current - target) < diff) {
            return target;
        }
        if (target > current) {
            return current + diff;
        }
        return current - diff;
    }

    private boolean takeTransitionStepTowardsTarget() {
        int matrixLength = this._currentMatrix.length;
        int maxChangesCount = this._targetOrientation == null ? matrixLength : this._transitionMatrix.length;
        int noChangesCount = 0;
        int i = 0;
        while (i < matrixLength) {
            if (this._currentMatrix[i] == this._targetMatrix[i]) {
                ++noChangesCount;
            } else {
                this._currentMatrix[i] = this.newValue(this._currentMatrix[i], this._targetMatrix[i], this._transitionMatrix[i]);
            }
            ++i;
        }
        if (this._targetOrientation != null) {
            i = 0;
            while (i < 4) {
                if (this._currentOrientation[i] == this._targetOrientation[i]) {
                    ++noChangesCount;
                } else {
                    this._currentOrientation[i] = this.newValue(this._currentOrientation[i], this._targetOrientation[i], this._transitionMatrix[i + matrixLength]);
                }
                ++i;
            }
        }
        this._currentTransform.set(this._currentMatrix);
        return noChangesCount != maxChangesCount;
    }

    private float[] calculateTransitionMatrix(float[] from, float[] to) {
        if (from == null || to == null || from.length != to.length) {
            return null;
        }
        int length = from.length;
        float[] transitionMatrix = new float[length + 4];
        int i = 0;
        while (i < length) {
            if (to[i] != from[i]) {
                transitionMatrix[i] = (to[i] - from[i]) / 30.0f;
                if (transitionMatrix[i] == 0.0f) {
                    transitionMatrix[i] = 0.01f;
                }
            }
            ++i;
        }
        if (this._targetOrientation != null) {
            i = 0;
            while (i < 4) {
                transitionMatrix[i + length] = (this._targetOrientation[i] - this._currentOrientation[i]) / 30.0f;
                if (transitionMatrix[i + length] == 0.0f) {
                    transitionMatrix[i + length] = 0.01f;
                }
                ++i;
            }
        }
        return transitionMatrix;
    }

    private void releaseResources() {
        this._currentTransform = null;
        this._targetTransform = null;
        this._targetMatrix = null;
        this._currentMatrix = null;
        this._currentOrientation = null;
        this._targetOrientation = null;
        this._transitionMatrix = null;
    }

    public static interface Listener {
        public void onAnimationFinished(int var1);
    }
}

