/*
 * Decompiled with CFR 0.152.
 */
package com.pim.ui;

import com.pim.Main;
import com.pim.ui.MenuItem;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Menu {
    private static final int MAX_MENU_ITEM_COUNT = 4;
    private Listener _listener = null;
    private Object[] _items = null;
    private Font _font = null;
    private final Image _itemBackgroundImage = Main.makeImage("/graphics/menu-item-bg.png");
    private int _width;
    private int _height;
    private int _fontHeight;
    private int _pressedIndex = -1;

    public Menu(Listener listener, int width, int height) {
        this._items = new Object[4];
        this.setSize(width, height);
        this._listener = listener;
        this._font = Font.getDefaultFont();
        this._fontHeight = this._font.getHeight();
    }

    public void setSize(int width, int height) {
        this._width = width;
        this._height = height;
    }

    public boolean addItem(String text) {
        int i = 0;
        while (i < 4) {
            if (this._items[i] == null) {
                MenuItem item = new MenuItem(text);
                this._items[i] = item;
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean addItem(MenuItem item) {
        int i = 0;
        while (i < 4) {
            if (this._items[i] == null) {
                this._items[i] = item;
                return true;
            }
            ++i;
        }
        return false;
    }

    public MenuItem itemAt(int index) {
        if (this._items != null && index >= 0 && index < this.menuItemCount()) {
            return (MenuItem)this._items[index];
        }
        return null;
    }

    public void clear() {
        int i = 0;
        while (i < 4) {
            this._items[i] = null;
            ++i;
        }
    }

    public void onPressed(int x, int y) {
        int count = this.menuItemCount();
        int startY = this._height / 2 - count * 50 / 2;
        if (y < startY || y > count * 50 + startY) {
            this.setPressed(this._pressedIndex, false);
            this._pressedIndex = -1;
            return;
        }
        int prevPressedIndex = this._pressedIndex;
        this._pressedIndex = (y - startY) / 50;
        if (prevPressedIndex != this._pressedIndex) {
            this.setPressed(prevPressedIndex, false);
        }
        if (!this.setPressed(this._pressedIndex, true)) {
            this._pressedIndex = -1;
        }
    }

    public void onReleased(int x, int y) {
        int count = this.menuItemCount();
        int startY = this._height / 2 - count * 50 / 2;
        if (y < startY || y > count * 50 + startY) {
            this.setPressed(this._pressedIndex, false);
            this._pressedIndex = -1;
            return;
        }
        if (this._listener != null && this._pressedIndex == (y - startY) / 50) {
            System.out.println("Menu::onReleased(): " + this._pressedIndex);
            this._listener.onMenuItemSelected(this._pressedIndex);
        }
        this.setPressed(this._pressedIndex, false);
        this._pressedIndex = -1;
    }

    public void paint(Graphics graphics) {
        int count = this.menuItemCount();
        MenuItem item = null;
        String text = null;
        int y = this._height / 2 - count * 50 / 2;
        int i = 0;
        while (i < count) {
            item = (MenuItem)this._items[i];
            text = item.text();
            if (text != null) {
                if (item.pressed()) {
                    graphics.setColor(-8267009);
                    graphics.fillRect(0, y, this._width, 50);
                    graphics.setColor(0);
                } else {
                    graphics.drawImage(this._itemBackgroundImage, 0, y, 20);
                    graphics.setColor(-8267009);
                }
                graphics.drawString(text, (this._width - this._font.stringWidth(text)) / 2, y + 25 - this._fontHeight / 2, 20);
                y += 50;
            }
            ++i;
        }
    }

    private final int menuItemCount() {
        int retval = 0;
        int i = 0;
        while (i < 4) {
            if (this._items[i] == null) break;
            ++retval;
            ++i;
        }
        return retval;
    }

    private boolean setPressed(int index, boolean pressed) {
        MenuItem item;
        if (index >= 0 && index < this.menuItemCount() && (item = (MenuItem)this._items[index]) != null && !item.disabled()) {
            item.setPressed(pressed);
            return true;
        }
        return false;
    }

    public static interface Listener {
        public void onMenuItemSelected(int var1);
    }
}

