/*
 * Decompiled with CFR 0.152.
 */
package com.pim.ui;

import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class Plane {
    private static final short[] POINTS;
    private static final short[] TEXTCOORDINATES;
    private static final int[] INDICES;
    private static final int[] LENGTHS;
    private static final VertexArray POSITIONS_ARRAY;
    private static final VertexArray TEXTURE_ARRAY;
    private static final IndexBuffer INDEX_BUFFER;
    private Transform wallTransform = new Transform();
    private float textureRepeat;

    static {
        short[] sArray = new short[12];
        sArray[0] = 1;
        sArray[1] = 1;
        sArray[3] = 1;
        sArray[4] = -1;
        sArray[6] = -1;
        sArray[7] = 1;
        sArray[9] = -1;
        sArray[10] = -1;
        POINTS = sArray;
        short[] sArray2 = new short[8];
        sArray2[0] = 1;
        sArray2[1] = 1;
        sArray2[3] = 1;
        sArray2[4] = 1;
        TEXTCOORDINATES = sArray2;
        int[] nArray = new int[12];
        nArray[0] = 2;
        nArray[1] = 3;
        nArray[3] = 1;
        nArray[5] = 3;
        nArray[7] = 3;
        nArray[8] = 2;
        nArray[9] = 3;
        nArray[11] = 1;
        INDICES = nArray;
        LENGTHS = new int[]{3, 3, 3, 3};
        POSITIONS_ARRAY = new VertexArray(POINTS.length / 3, 3, 2);
        POSITIONS_ARRAY.set(0, POINTS.length / 3, POINTS);
        TEXTURE_ARRAY = new VertexArray(TEXTCOORDINATES.length / 2, 2, 2);
        TEXTURE_ARRAY.set(0, TEXTCOORDINATES.length / 2, TEXTCOORDINATES);
        INDEX_BUFFER = new TriangleStripArray(INDICES, LENGTHS);
    }

    public Plane(Transform wallTransform, float textureRepeat) {
        this.wallTransform = wallTransform;
        this.textureRepeat = textureRepeat;
    }

    Mesh createMesh() {
        VertexBuffer vertexBuffer = new VertexBuffer();
        vertexBuffer.setPositions(POSITIONS_ARRAY, 1.0f, null);
        vertexBuffer.setTexCoords(0, TEXTURE_ARRAY, this.textureRepeat, null);
        Mesh mesh = new Mesh(vertexBuffer, INDEX_BUFFER, null);
        mesh.setTransform(this.wallTransform);
        return mesh;
    }
}

