/*
 * Decompiled with CFR 0.152.
 */
package com.pim.ui;

import com.pim.Main;
import com.pim.model.MyTimer;
import com.pim.ui.TextWrapper;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TipBox
implements MyTimer.Listener {
    private static final int WIDTH = 220;
    private static final int TEXT_WIDTH = 180;
    private static final int TEXT_HEIGHT = 100;
    private static final int TEXT_X_MARGIN = 20;
    private static final int TEXT_Y_TOP_MARGIN = 40;
    private static final int X_POSITION = 10;
    private static final int Y_POSITION = 190;
    private static final int TIMEOUT = 8000;
    private static TipBox _instance = null;
    private final Image _backgroundImage = Main.makeImage("/graphics/tip-box-bg.png");
    private TextWrapper _textWrapper = TextWrapper.instance(Font.getDefaultFont(), 180);
    private String _text = null;
    private boolean _visible = false;
    private int _textY = 0;
    private static final int TIP_INTERVAL = 8000;
    private static final String[] TIPS = new String[]{"Tip: To recalibrate the accelerometer sensor pause and resume the game.", "Tip: Douple tap the screen to toggle between the set and the default zoom.", "Tip: Pinch the screen to zoom in and out."};
    private static int tipsToShow = TIPS.length;

    private TipBox() {
    }

    public static void show(String text) {
        if (_instance == null) {
            _instance = new TipBox();
        }
        if (text != null && text.length() > 0) {
            TipBox._instance._text = text;
            TipBox._instance._visible = true;
            TipBox._instance._textWrapper.setText(TipBox._instance._text);
            TipBox._instance._textY = (100 - TipBox._instance._textWrapper.lineCount() * TipBox._instance._textWrapper.lineHeight()) / 2;
            MyTimer.instance().addListener(_instance, false, 8000);
        }
    }

    public static void hide() {
        if (tipsToShow > 0) {
            TipBox._instance._visible = false;
            TipBox._instance._text = null;
            return;
        }
        if (_instance != null) {
            MyTimer.instance().removeListener(_instance);
            TipBox._instance._visible = false;
            TipBox._instance._text = null;
            TipBox.free();
        }
    }

    public static boolean visible() {
        if (_instance != null) {
            return TipBox._instance._visible;
        }
        return false;
    }

    public static void free() {
        if (_instance != null) {
            System.out.println("TipBox::free(): Releasing the instance.");
            _instance = null;
        }
    }

    public static void showTips() {
        if (_instance == null) {
            _instance = new TipBox();
        }
        MyTimer.instance().addListener(_instance, true, 8000);
    }

    public static void paint(Graphics graphics) {
        if (_instance != null) {
            _instance.doPaint(graphics);
        }
    }

    public void onTimeout() {
        System.out.println("TipBox::onTimeout()");
        if (tipsToShow > 0) {
            if (this._text == null) {
                TipBox.show(TIPS[tipsToShow - 1]);
                --tipsToShow;
            } else {
                this._visible = false;
                this._text = null;
            }
            return;
        }
        TipBox.hide();
    }

    private void doPaint(Graphics graphics) {
        if (!this._visible || this._text == null || this._text.length() == 0) {
            return;
        }
        int topLeft = 20;
        graphics.drawImage(this._backgroundImage, 10, 190, 20);
        graphics.setColor(-8267009);
        this._textWrapper.setWidth(180);
        int y = 230 + this._textY;
        try {
            this._textWrapper.setText(this._text);
            String line = null;
            while (this._textWrapper.hasMoreLines()) {
                line = this._textWrapper.nextLine();
                graphics.drawString(line, 30 + (180 - this._textWrapper.lineWidth(line)) / 2, y, 20);
                y += this._textWrapper.lineHeight();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

