/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core;

public class MathExt {
    static final double sq2p1 = 2.414213562373095;
    static final double sq2m1 = 0.41421356237309503;
    static final double p4 = 16.15364129822302;
    static final double p3 = 268.42548195503974;
    static final double p2 = 1153.029351540485;
    static final double p1 = 1780.406316433197;
    static final double p0 = 896.7859740366387;
    static final double q4 = 58.95697050844462;
    static final double q3 = 536.2653740312153;
    static final double q2 = 1666.7838148816338;
    static final double q1 = 2079.33497444541;
    static final double q0 = 896.7859740366387;
    static final double PIO2 = 1.5707963267948966;
    static final double nan = Double.NaN;

    private static double mxatan(double arg) {
        double argsq = arg * arg;
        double value = (((16.15364129822302 * argsq + 268.42548195503974) * argsq + 1153.029351540485) * argsq + 1780.406316433197) * argsq + 896.7859740366387;
        return (value /= ((((argsq + 58.95697050844462) * argsq + 536.2653740312153) * argsq + 1666.7838148816338) * argsq + 2079.33497444541) * argsq + 896.7859740366387) * arg;
    }

    private static double msatan(double arg) {
        if (arg < 0.41421356237309503) {
            return MathExt.mxatan(arg);
        }
        if (arg > 2.414213562373095) {
            return 1.5707963267948966 - MathExt.mxatan(1.0 / arg);
        }
        return 0.7853981633974483 + MathExt.mxatan((arg - 1.0) / (arg + 1.0));
    }

    public static double atan(double arg) {
        if (arg > 0.0) {
            return MathExt.msatan(arg);
        }
        return -MathExt.msatan(-arg);
    }

    public static double atan2(double arg1, double arg2) {
        if (arg1 + arg2 == arg1) {
            if (arg1 >= 0.0) {
                return 1.5707963267948966;
            }
            return -1.5707963267948966;
        }
        arg1 = MathExt.atan(arg1 / arg2);
        if (arg2 < 0.0) {
            if (arg1 <= 0.0) {
                return arg1 + Math.PI;
            }
            return arg1 - Math.PI;
        }
        return arg1;
    }

    public static double asin(double arg) {
        int sign = 0;
        if (arg < 0.0) {
            arg = -arg;
            ++sign;
        }
        if (arg > 1.0) {
            return Double.NaN;
        }
        double temp = Math.sqrt(1.0 - arg * arg);
        temp = arg > 0.7 ? 1.5707963267948966 - MathExt.atan(temp / arg) : MathExt.atan(arg / temp);
        if (sign > 0) {
            temp = -temp;
        }
        return temp;
    }

    public static double acos(double arg) {
        if (arg > 1.0 || arg < -1.0) {
            return Double.NaN;
        }
        return 1.5707963267948966 - MathExt.asin(arg);
    }

    public static float Min(float v1, float v2) {
        if (v1 < v2) {
            return v1;
        }
        return v2;
    }

    public static float Max(float v1, float v2) {
        if (v1 > v2) {
            return v1;
        }
        return v2;
    }

    private static float Check_PointViaSection(float Ax, float Ay, float Bx, float By, float Px, float Py) {
        return Ax * By * 1.0f + Bx * Py * 1.0f + Ay * 1.0f * Px - 1.0f * By * Px - 1.0f * Py * Ax - 1.0f * Ay * Bx;
    }

    private static boolean Check_PointInSection(float Ax, float Ay, float Bx, float By, float Px, float Py) {
        return Px >= MathExt.Min(Ax, Bx) && Px <= MathExt.Max(Ax, Bx) && Py >= MathExt.Min(Ay, By) && Py <= MathExt.Max(Ay, By) && MathExt.Check_PointViaSection(Ax, Ay, Bx, By, Px, Py) == 0.0f;
    }

    private static boolean Check_QuickPointInSection(float Ax, float Ay, float Bx, float By, float Px, float Py) {
        return Px >= MathExt.Min(Ax, Bx) && Px <= MathExt.Max(Ax, Bx) && Py >= MathExt.Min(Ay, By) && Py <= MathExt.Max(Ay, By);
    }

    public static float CheckSections(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        float A1 = y2 - y1;
        float B1 = x1 - x2;
        float C1 = -(A1 * x1 + B1 * y1);
        float A2 = y4 - y3;
        float B2 = x3 - x4;
        float C2 = -(A2 * x3 + B2 * y3);
        float W = A1 * B2 - A2 * B1;
        if (W == 0.0f) {
            return -1.0f;
        }
        float Wx = -C1 * B2 - -C2 * B1;
        float Wy = A1 * -C2 - A2 * -C1;
        float fCrossX = Wx / W;
        float fCrossY = Wy / W;
        if (x3 == x4) {
            fCrossX = x3;
        }
        if (y3 == y4) {
            fCrossY = y3;
        }
        if (x1 == x2) {
            fCrossX = x1;
        }
        if (y1 == y2) {
            fCrossY = y1;
        }
        if (!MathExt.Check_QuickPointInSection(x1, y1, x2, y2, fCrossX, fCrossY)) {
            return -1.0f;
        }
        if (!MathExt.Check_QuickPointInSection(x3, y3, x4, y4, fCrossX, fCrossY)) {
            return -1.0f;
        }
        System.out.println("Collision!!!");
        if (x1 != x2) {
            return (fCrossX - x1) / (x2 - x1);
        }
        return (fCrossY - y1) / (y2 - y1);
    }

    public static float GetBezierValueX(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, float fParam) {
        float v1_x = x1;
        float v1_y = y1;
        float v4_x = x4;
        float v4_y = y4;
        float v2_x = x2;
        float v2_y = y2;
        float v3_x = x3;
        float v3_y = y3;
        if (fParam <= 0.0f) {
            return v1_x;
        }
        if (fParam >= 1.0f) {
            return v4_x;
        }
        float t = fParam;
        float f_t2 = t * t;
        float f_t3 = t * f_t2;
        float f_1_t = 1.0f - t;
        float f_1_t2 = f_1_t * f_1_t;
        float f_1_t3 = f_1_t * f_1_t2;
        return f_1_t3 * v1_x + 3.0f * t * f_1_t2 * v2_x + 3.0f * f_t2 * f_1_t * v3_x + f_t3 * v4_x;
    }

    public static float GetBezierValueY(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, float fParam) {
        float v1_x = x1;
        float v1_y = y1;
        float v4_x = x4;
        float v4_y = y4;
        float v2_x = x2;
        float v2_y = y2;
        float v3_x = x3;
        float v3_y = y3;
        if (fParam <= 0.0f) {
            return v1_y;
        }
        if (fParam >= 1.0f) {
            return v4_y;
        }
        float t = fParam;
        float f_t2 = t * t;
        float f_t3 = t * f_t2;
        float f_1_t = 1.0f - t;
        float f_1_t2 = f_1_t * f_1_t;
        float f_1_t3 = f_1_t * f_1_t2;
        return f_1_t3 * v1_y + 3.0f * t * f_1_t2 * v2_y + 3.0f * f_t2 * f_1_t * v3_y + f_t3 * v4_y;
    }
}

