/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.VectorF2;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserLevelStats;
import baltorogames.system.BGStore;
import baltorogames.system.FileManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class CGUserCareer {
    public static final int eNumStarsToUnlockEnv2 = 20;
    public static final int eNumStarsToUnlockEnv3 = 65;
    public static final int[] arrSurvivalStars = new int[]{2, 2, 3, 3, 4, 4, 5, 6, 7};
    public static final int ePowerup_Freeze = 0;
    public static final int ePowerup_Reverse = 1;
    public static final int ePowerup_Bomb = 2;
    public static final int ePowerup_Color = 3;
    public static final int ePowerup_Swap = 4;
    public static final int ePowerup_LaserBall = 5;
    public static final int ePowerup_UniBall = 6;
    public static final int ePowerup_Money = 7;
    public static final int ePowerup_Multi = 8;
    public static final int eMaxLevels = 45;
    public static final int eMaxSurvivalLevels = 3;
    public static final int[] survivalLevelReq = new int[]{0, 10, 20};
    public static final int[] timedLevelReq = new int[]{0, 100, 200};
    public static final int[] zenLevelReq = new int[]{0, 200, 400};
    public static int[][] m_arrPowerupPrice = new int[][]{{0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}};
    public static int[][] m_arrPowerupTime = new int[][]{{5, 7, 9, 11, 13}, {5, 7, 9, 11, 13}, {8, 10, 12, 14, 16}, {5, 7, 9, 11, 13}, {8, 10, 12, 14, 16}, {5, 7, 9, 11, 13}, {5, 7, 9, 11, 13}, {5, 7, 9, 11, 13}, {5, 7, 9, 11, 13}, {5, 7, 9, 11, 13}};
    public static int[][] m_arrBestForSurvival = new int[][]{{1, 2}, {3, 4}, {5, 6}};
    public static int[][] m_arrBestForTimed = new int[][]{{1, 2}, {3, 4}, {5, 6}};
    public static int[][] m_arrBestForZen = new int[][]{{1, 2}, {3, 4}, {5, 6}};
    public static CGUserLevelStats[] arrLevelStats = new CGUserLevelStats[45];
    protected static String m_szNick;
    protected static String m_szDevicePlatform;
    protected static int m_nAdventureLevel;
    protected static int m_nPoints;
    protected static int m_nStars;
    protected static int m_nSurvivalTime;
    protected static int m_nSurvivalScore;
    protected static int[] m_nSpecialPowerups;
    protected static int[] m_nPowerupLevel;
    public static int[] m_arrSpecialPowerupsPrice;
    public static int m_nPowerupSlowDownTime;
    public static float m_fPowerupSlowDownFactor;
    public static int m_nPowerupTimeWarpTime;
    public static float m_fPowerupTimeWarpFactor;
    public static int m_nExplosionBallPoints;
    public static int m_nComboBallPoints;
    public static int m_nChainBallPoints;
    public static int m_nLostBallPoints;
    public static boolean[][] m_bSurvivalLevel;

    public static int GetTotalNumberOfStars() {
        int stars = 0;
        for (int i = 0; i < 45; ++i) {
            stars += CGUserCareer.arrLevelStats[i].m_nStars;
        }
        return stars;
    }

    public static boolean IsEnvironmentCompleted(int level) {
        if (level == 0) {
            return CGUserCareer.arrLevelStats[14].m_nStars >= 1;
        }
        if (level == 1) {
            return CGUserCareer.arrLevelStats[29].m_nStars >= 1;
        }
        return CGUserCareer.arrLevelStats[44].m_nStars >= 1;
    }

    public static boolean IsLevelUnlocked(int mode, int level) {
        switch (mode) {
            case 2: {
                return m_arrBestForSurvival[0][1] / 1000 >= survivalLevelReq[level];
            }
            case 3: {
                return m_arrBestForTimed[0][0] >= timedLevelReq[level];
            }
            case 4: {
                return m_arrBestForZen[0][0] >= zenLevelReq[level];
            }
        }
        return false;
    }

    public static boolean IsEnvironmentAvailable(int level) {
        if (level == 0) {
            return true;
        }
        int totalStars = CGUserCareer.GetTotalNumberOfStars();
        if (level == 1) {
            return totalStars >= 20;
        }
        if (level == 2) {
            return totalStars >= 65;
        }
        return false;
    }

    public static void Reset() {
        int j;
        int i;
        m_nPoints = 0;
        CGUserCareer.m_nSpecialPowerups[2] = 0;
        CGUserCareer.m_nSpecialPowerups[1] = 0;
        CGUserCareer.m_nSpecialPowerups[0] = 0;
        if (arrLevelStats != null) {
            for (i = 0; i < 45; ++i) {
                CGUserCareer.arrLevelStats[i] = new CGUserLevelStats();
            }
        }
        for (i = 0; i < 10; ++i) {
            CGUserCareer.m_nPowerupLevel[i] = -1;
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 2; ++j) {
                CGUserCareer.m_arrBestForSurvival[i][j] = 0;
            }
            for (j = 0; j < 2; ++j) {
                CGUserCareer.m_arrBestForTimed[i][j] = 0;
            }
            for (j = 0; j < 2; ++j) {
                CGUserCareer.m_arrBestForZen[i][j] = 0;
            }
        }
        m_nAdventureLevel = 0;
        m_szNick = "";
        m_szDevicePlatform = "";
        if (arrLevelStats == null) {
            arrLevelStats = new CGUserLevelStats[45];
        }
        VectorF2 v = new VectorF2();
        for (int i2 = 0; i2 < 45; ++i2) {
            CGUserCareer.arrLevelStats[i2] = new CGUserLevelStats();
            int nGalaxy = i2 / 15;
            int nLevel = i2 % 15;
            CGEngine.ReadDefaultLevelStats(nGalaxy + 1, nLevel + 1, v);
            CGUserCareer.arrLevelStats[i2].m_nDefaultScore = (int)v.y;
            CGUserCareer.arrLevelStats[i2].m_nDefaultTime = (int)v.x;
            System.out.println("LEVEL " + i2 + ": Score=" + (int)v.y + "  Time=" + (int)v.x);
        }
        for (j = 0; j < 3; ++j) {
            for (int i3 = 0; i3 < 3; ++i3) {
                CGUserCareer.m_bSurvivalLevel[j][i3] = i3 == 0;
            }
        }
    }

    public static int GetLevelTime(int nLevelIndex) {
        if (nLevelIndex >= 0 && nLevelIndex < 45) {
            return CGUserCareer.arrLevelStats[nLevelIndex].m_nTime;
        }
        return 0;
    }

    public static void SetLevelTime(int nLevelIndex, int nT) {
        if (nLevelIndex >= 0 && nLevelIndex < 45 && nT < CGUserCareer.arrLevelStats[nLevelIndex].m_nTime) {
            CGUserCareer.arrLevelStats[nLevelIndex].m_nTime = nT;
        }
    }

    public static int GetLevelDefaultTime(int nLevelIndex) {
        if (nLevelIndex >= 0 && nLevelIndex < 45) {
            return CGUserCareer.arrLevelStats[nLevelIndex].m_nDefaultTime;
        }
        return 0;
    }

    public static int GetLevelScore(int nLevelIndex) {
        if (nLevelIndex >= 0 && nLevelIndex < 45) {
            return CGUserCareer.arrLevelStats[nLevelIndex].m_nScore;
        }
        return 0;
    }

    public static void SetLevelScore(int nLevelIndex, int nS) {
        if (nLevelIndex >= 0 && nLevelIndex < 45 && nS > CGUserCareer.arrLevelStats[nLevelIndex].m_nScore) {
            CGUserCareer.arrLevelStats[nLevelIndex].m_nScore = nS;
        }
    }

    public static int GetLevelDefaultScore(int nLevelIndex) {
        if (nLevelIndex >= 0 && nLevelIndex < 45) {
            return CGUserCareer.arrLevelStats[nLevelIndex].m_nDefaultScore;
        }
        return 0;
    }

    public static int GetLevelStars(int nLevelIndex, int nS) {
        if (nLevelIndex >= 0 && nLevelIndex < 45) {
            return CGUserCareer.arrLevelStats[nLevelIndex].m_nStars;
        }
        return 0;
    }

    public static void SetLevelStars(int nLevelIndex, int nS, int nV) {
        if (nLevelIndex >= 0 && nLevelIndex < 45 && CGUserCareer.arrLevelStats[nLevelIndex].m_nStars == 0) {
            CGUserCareer.arrLevelStats[nLevelIndex].m_nStars = nV;
        }
    }

    public static int GetNextUpgradePrice(int nPowerupIndex) {
        if (m_nPowerupLevel[nPowerupIndex] >= 4) {
            return 1000000;
        }
        if (m_nPowerupLevel[nPowerupIndex] < 0) {
            return 0;
        }
        return m_arrPowerupPrice[nPowerupIndex][m_nPowerupLevel[nPowerupIndex] + 1];
    }

    public static int GetCurrentUpgradeParam(int nPowerupIndex) {
        if (m_nPowerupLevel[nPowerupIndex] > 4) {
            return 1000000;
        }
        if (m_nPowerupLevel[nPowerupIndex] < 0) {
            return -1;
        }
        return m_arrPowerupTime[nPowerupIndex][m_nPowerupLevel[nPowerupIndex]];
    }

    public static int GetNextUpgradeParam(int nPowerupIndex) {
        if (m_nPowerupLevel[nPowerupIndex] >= 4) {
            return 1000000;
        }
        if (m_nPowerupLevel[nPowerupIndex] < 0) {
            return -1;
        }
        return m_arrPowerupTime[nPowerupIndex][m_nPowerupLevel[nPowerupIndex] + 1];
    }

    public static void UnlockPowerup(int nIndex) {
        if (m_nPowerupLevel[nIndex] < 0) {
            CGUserCareer.m_nPowerupLevel[nIndex] = 0;
        }
    }

    public static void UnlockAllPowerups() {
        for (int i = 0; i < m_nPowerupLevel.length; ++i) {
            CGUserCareer.m_nPowerupLevel[i] = 0;
        }
    }

    public static boolean IsPowerupUnlocked(int nIndex) {
        return m_nPowerupLevel[nIndex] >= 0;
    }

    public static void Load() {
        BGStore store = BGStore.openStoreToRead("UserCareer");
        if (store == null) {
            return;
        }
        try {
            DataInputStream inputStream = store.getInStream();
            if (inputStream != null && inputStream.available() > 0) {
                int i;
                m_nAdventureLevel = inputStream.readInt();
                m_nPoints = inputStream.readInt();
                for (i = 0; i < 3; ++i) {
                    CGUserCareer.m_nSpecialPowerups[i] = inputStream.readInt();
                }
                for (i = 0; i < 10; ++i) {
                    CGUserCareer.m_nPowerupLevel[i] = inputStream.readInt();
                }
                for (i = 0; i < 45; ++i) {
                    CGUserCareer.arrLevelStats[i].m_nScore = inputStream.readInt();
                    CGUserCareer.arrLevelStats[i].m_nTime = inputStream.readInt();
                    CGUserCareer.arrLevelStats[i].m_nStars = inputStream.readInt();
                }
                for (i = 0; i < 3; ++i) {
                    int j;
                    for (j = 0; j < 2; ++j) {
                        CGUserCareer.m_arrBestForSurvival[i][j] = inputStream.readInt();
                    }
                    for (j = 0; j < 2; ++j) {
                        CGUserCareer.m_arrBestForTimed[i][j] = inputStream.readInt();
                    }
                    for (j = 0; j < 2; ++j) {
                        CGUserCareer.m_arrBestForZen[i][j] = inputStream.readInt();
                    }
                }
                m_szNick = inputStream.readUTF();
                m_szDevicePlatform = inputStream.readUTF();
                for (int j = 0; j < 3; ++j) {
                    for (int i2 = 0; i2 < 3; ++i2) {
                        CGUserCareer.m_bSurvivalLevel[j][i2] = inputStream.readBoolean();
                    }
                }
            }
            store.close();
        }
        catch (Exception e) {
            CGUserCareer.Reset();
            return;
        }
    }

    public static void Save() {
        if (arrLevelStats == null || arrLevelStats[0] == null) {
            return;
        }
        BGStore store = BGStore.openStoreToWrite("UserCareer");
        if (store == null) {
            return;
        }
        try {
            int i;
            DataOutputStream outputStream = store.getOutStream();
            outputStream.writeInt(m_nAdventureLevel);
            outputStream.writeInt(m_nPoints);
            for (i = 0; i < 3; ++i) {
                outputStream.writeInt(m_nSpecialPowerups[i]);
            }
            for (i = 0; i < 10; ++i) {
                outputStream.writeInt(m_nPowerupLevel[i]);
            }
            for (i = 0; i < 45; ++i) {
                outputStream.writeInt(CGUserCareer.arrLevelStats[i].m_nScore);
                outputStream.writeInt(CGUserCareer.arrLevelStats[i].m_nTime);
                outputStream.writeInt(CGUserCareer.arrLevelStats[i].m_nStars);
            }
            for (i = 0; i < 3; ++i) {
                int j;
                for (j = 0; j < 2; ++j) {
                    outputStream.writeInt(m_arrBestForSurvival[i][j]);
                }
                for (j = 0; j < 2; ++j) {
                    outputStream.writeInt(m_arrBestForTimed[i][j]);
                }
                for (j = 0; j < 2; ++j) {
                    outputStream.writeInt(m_arrBestForZen[i][j]);
                }
            }
            outputStream.writeUTF(m_szNick);
            outputStream.writeUTF(m_szDevicePlatform);
            for (int j = 0; j < 3; ++j) {
                for (int i2 = 0; i2 < 3; ++i2) {
                    outputStream.writeBoolean(m_bSurvivalLevel[j][i2]);
                }
            }
            store.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void Actualize(int nLevelIndex, int nInitScore, int m_nInitTime) {
        if (nLevelIndex >= 1 && nLevelIndex <= 45 && CGUserCareer.arrLevelStats[nLevelIndex - 1].m_nScore == 0 && CGUserCareer.arrLevelStats[nLevelIndex - 1].m_nScore == 0) {
            CGUserCareer.arrLevelStats[nLevelIndex - 1].m_nScore = nInitScore;
            CGUserCareer.arrLevelStats[nLevelIndex - 1].m_nTime = m_nInitTime;
        }
    }

    public static int GetPoints() {
        return m_nPoints;
    }

    public static void AddPoints(int n) {
        m_nPoints += n;
    }

    public static void SetAdventureLevel(int i) {
        m_nAdventureLevel = i;
    }

    public static int GetAdventureLevel() {
        return m_nAdventureLevel;
    }

    public static int GetSpecialPowerupNr(int nPowerupIndex) {
        return m_nSpecialPowerups[nPowerupIndex];
    }

    public static void AddSpecialPowerupNr(int nPowerupIndex, int nNr) {
        int n = nPowerupIndex;
        m_nSpecialPowerups[n] = m_nSpecialPowerups[n] + nNr;
    }

    public static void SubSpecialPowerupNr(int nPowerupIndex) {
        if (m_nSpecialPowerups[nPowerupIndex] > 0) {
            int n = nPowerupIndex;
            m_nSpecialPowerups[n] = m_nSpecialPowerups[n] - 1;
        }
    }

    public static int GetPowerupLevel(int nPowerupIndex) {
        return m_nPowerupLevel[nPowerupIndex];
    }

    public static void AddPowerupLevel(int nPowerupIndex) {
        if (m_nPowerupLevel[nPowerupIndex] < 4) {
            int n = nPowerupIndex;
            m_nPowerupLevel[n] = m_nPowerupLevel[n] + 1;
        }
    }

    public static void SetNick(String s) {
        m_szNick = s;
    }

    public static String GetNick() {
        return m_szNick;
    }

    public static void SetDevicePlatform(String s) {
        m_szDevicePlatform = s;
    }

    public static String GetDevicePlatform() {
        return m_szDevicePlatform;
    }

    public static void LoadGlobalParams() {
        InputStream is = null;
        try {
            is = FileManager.OpenFile("/Powerups.aaa");
            if (is == null && (is = FileManager.OpenURLFile("/Powerups.aaa")) == null) {
                return;
            }
            DataInputStream dis = new DataInputStream(is);
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < 5; ++j) {
                    CGUserCareer.m_arrPowerupTime[i][j] = dis.readInt();
                    CGUserCareer.m_arrPowerupPrice[i][j] = dis.readInt();
                }
            }
            CGUserCareer.m_arrSpecialPowerupsPrice[0] = dis.readInt();
            CGUserCareer.m_arrSpecialPowerupsPrice[1] = dis.readInt();
            m_nPowerupSlowDownTime = dis.readInt();
            m_fPowerupSlowDownFactor = dis.readFloat();
            CGUserCareer.m_arrSpecialPowerupsPrice[2] = dis.readInt();
            m_nPowerupTimeWarpTime = dis.readInt();
            m_fPowerupTimeWarpFactor = dis.readFloat();
            m_nExplosionBallPoints = dis.readInt();
            m_nComboBallPoints = dis.readInt();
            m_nChainBallPoints = dis.readInt();
            m_nLostBallPoints = dis.readInt();
        }
        catch (Exception e2) {
            System.out.println("Error reading GlobalParams.sts");
            e2.printStackTrace();
            return;
        }
    }

    public static void UnlockAllLevels() {
        m_nAdventureLevel = 100;
    }

    public static void UnlockAllSurvivals() {
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 3; ++i) {
                CGUserCareer.m_bSurvivalLevel[j][i] = true;
            }
        }
    }

    static {
        m_nSpecialPowerups = new int[3];
        m_nPowerupLevel = new int[10];
        m_arrSpecialPowerupsPrice = new int[3];
        m_nExplosionBallPoints = 10;
        m_nComboBallPoints = 30;
        m_nChainBallPoints = 20;
        m_nLostBallPoints = -50;
        m_bSurvivalLevel = new boolean[3][3];
    }
}

