/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.WorldLayerPiece;
import baltorogames.project_gameplay.WorldObject;
import java.io.DataInputStream;
import java.io.IOException;

public class WorldLayer {
    protected WorldLayerPiece[] m_arrLayerPieces = null;
    protected int m_nPiecesSize = 0;

    public int Load(DataInputStream dis) throws IOException {
        this.Destroy();
        this.m_nPiecesSize = dis.readInt();
        this.m_arrLayerPieces = new WorldLayerPiece[this.m_nPiecesSize];
        for (int i = 0; i < this.m_nPiecesSize; ++i) {
            this.m_arrLayerPieces[i] = new WorldLayerPiece();
            this.m_arrLayerPieces[i].Load(dis);
        }
        return 1;
    }

    public WorldLayerPiece GetLayerPiece(int nIndex) {
        return this.m_arrLayerPieces[nIndex];
    }

    public int GetPiecesSize() {
        return this.m_nPiecesSize;
    }

    public void ActiveAllObjects() {
        for (int i = 0; i < this.m_nPiecesSize; ++i) {
            this.m_arrLayerPieces[i].ActiveAllObjects();
        }
    }

    public void Render(int nMinPiece, int nMaxPiece) {
        if (nMinPiece < 0) {
            nMinPiece = 0;
        }
        if (nMaxPiece >= this.m_nPiecesSize) {
            nMaxPiece = this.m_nPiecesSize - 1;
        }
        for (int i = nMinPiece; i <= nMaxPiece; ++i) {
            this.m_arrLayerPieces[i].Render();
        }
    }

    public void Destroy() {
        if (this.m_arrLayerPieces != null) {
            for (int i = 0; i < this.m_nPiecesSize; ++i) {
                if (this.m_arrLayerPieces[i] == null) continue;
                this.m_arrLayerPieces[i].Destroy();
                this.m_arrLayerPieces[i] = null;
            }
            this.m_arrLayerPieces = null;
        }
        this.m_nPiecesSize = 0;
    }

    WorldObject FindByTextureName(String name) {
        int nS = this.m_arrLayerPieces.length;
        for (int i = 0; i < nS; ++i) {
            WorldObject pO = this.m_arrLayerPieces[i].FindByTextureName(name);
            if (pO == null) continue;
            return pO;
        }
        return null;
    }

    WorldObject FindByCollisionID(int nID) {
        int nS = this.m_arrLayerPieces.length;
        for (int i = 0; i < nS; ++i) {
            WorldObject pO = this.m_arrLayerPieces[i].FindByCollisionID(nID);
            if (pO == null) continue;
            return pO;
        }
        return null;
    }
}

