/*
 * Decompiled with CFR 0.152.
 */
package com.menu;

import com.Main;
import com.Resources;
import com.menu.Menu;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.TiledLayer;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class Highscore
extends Canvas {
    private Main midlet;
    private Menu menu;
    private Number number;
    private int width;
    private int height;
    private int highscore_width;
    private int hightscore_height;
    private int highscore_x;
    private int highscore_y;
    private int back_width;
    private int back_height;
    private int back_x;
    private int back_y;
    private RecordStore rs = null;
    static final String REC_STORE = "db_1";

    public Highscore(Main midlet) {
        this.midlet = midlet;
        this.setFullScreenMode(true);
        this.readStream();
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.highscore_width = Resources.highscore.getWidth();
        this.hightscore_height = Resources.highscore.getHeight();
        this.highscore_x = (this.width - this.highscore_width) / 2;
        this.highscore_y = (this.height - this.hightscore_height) / 2;
        this.back_width = Resources.back.getWidth();
        this.back_height = Resources.back.getHeight();
        this.back_x = this.getWidth() - this.back_width;
        this.back_y = this.getHeight() - this.back_height;
    }

    protected void paint(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.width, this.height);
        g.drawImage(Resources.logo, 0, 0, 20);
        g.drawImage(Resources.highscore, this.highscore_x, this.highscore_y, 20);
        g.drawImage(Resources.back, this.back_x, this.back_y, 20);
        this.drawNumber(g, this.readStream());
    }

    public void drawNumber(Graphics g, int n) {
        int i = 5;
        while (i >= 0) {
            int number_mod = n % 10;
            n /= 10;
            this.number = new Number(Resources.number, number_mod + 1);
            this.number.x = (this.getWidth() - this.number.width * 6) / 2 + this.number.width * i;
            this.number.y = this.highscore_y + this.hightscore_height;
            this.number.draw(g);
            --i;
        }
    }

    protected void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        if (x >= this.back_x && x <= this.back_x + this.back_width && y >= this.back_y && y <= this.back_y + this.back_height) {
            if (this.menu == null) {
                this.menu = new Menu(this.midlet);
            }
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.menu);
        }
    }

    public final int readStream() {
        int temp = 0;
        try {
            this.rs = RecordStore.openRecordStore((String)REC_STORE, (boolean)true);
            if (this.rs.getRecord(1) == null) {
                this.writeStream(0);
            }
            byte[] data = this.rs.getRecord(1);
            ByteArrayInputStream strmBytes = new ByteArrayInputStream(data);
            DataInputStream strmDataType = new DataInputStream(strmBytes);
            if (this.rs.getNumRecords() != 0) {
                temp = strmDataType.readInt();
                strmDataType.close();
            }
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("Exception readStream: " + e);
        }
        return temp;
    }

    public void writeStream(int iData) {
        try {
            this.rs = RecordStore.openRecordStore((String)REC_STORE, (boolean)true);
            ByteArrayOutputStream strmBytes = new ByteArrayOutputStream();
            DataOutputStream strmDataType = new DataOutputStream(strmBytes);
            strmDataType.writeInt(iData);
            strmDataType.flush();
            byte[] record = strmBytes.toByteArray();
            if (this.rs.getNumRecords() != 0) {
                this.rs.setRecord(1, record, 0, record.length);
            } else {
                this.rs.addRecord(record, 0, record.length);
            }
        }
        catch (Exception e) {
            System.out.println("Exception writeStream: " + e);
        }
    }

    private class Number {
        public int x;
        public int y;
        public int width;
        private TiledLayer tiledLayer;
        public int postion;

        public Number(Image image, int position) {
            this.postion = position;
            this.width = image.getWidth() / 10;
            this.tiledLayer = new TiledLayer(10, 1, image, 9, 23);
        }

        public void draw(Graphics g) {
            this.tiledLayer.setPosition(this.x, this.y);
            this.tiledLayer.setCell(0, 0, this.postion);
            this.tiledLayer.paint(g);
        }
    }
}

