/*
 * Decompiled with CFR 0.152.
 */
package com.menu;

import com.Main;
import com.MainGame;
import com.Resources;
import com.menu.About;
import com.menu.Help;
import com.menu.Highscore;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.TiledLayer;
import javax.microedition.midlet.MIDlet;

public class Menu
extends Canvas {
    private MainGame gameCanvas;
    private Highscore highscore;
    private Help help;
    private About about;
    private Main midlet;
    private Button button;
    private Vector buttons;

    public Menu(Main midlet) {
        this.midlet = midlet;
        this.setFullScreenMode(true);
        this.init();
    }

    public void init() {
        this.buttons = new Vector();
        int i = 0;
        while (i <= 4) {
            int row = i % 5;
            this.button = new Button(Resources.menu, i + 1);
            this.button.x = (this.getWidth() - this.button.width) / 2;
            this.button.y = Resources.logo.getHeight() + row * Resources.menu.getHeight();
            this.buttons.addElement(this.button);
            ++i;
        }
    }

    protected void paint(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(Resources.logo, 0, 0, 20);
        int i = 0;
        while (i <= 4) {
            ((Button)this.buttons.elementAt(i)).draw(g);
            g.setColor(255, 0, 0);
            ++i;
        }
    }

    protected void pointerReleased(int x, int y) {
        int i = 0;
        while (i <= 4) {
            int button_x = ((Button)this.buttons.elementAt((int)i)).x;
            int button_y = ((Button)this.buttons.elementAt((int)i)).y;
            if (x >= button_x && x <= this.button.width + button_x && y >= button_y && y <= this.button.height + button_y) {
                this.checkButton(i);
            }
            ++i;
        }
    }

    private void checkButton(int index) {
        switch (index) {
            case 0: {
                this.scnNewGame();
                break;
            }
            case 1: {
                this.scnHighscore();
                break;
            }
            case 2: {
                this.scnHelp();
                break;
            }
            case 3: {
                this.scnAbout();
                break;
            }
            case 4: {
                this.midlet.destroyApp(true);
            }
        }
    }

    public void scnNewGame() {
        if (this.gameCanvas == null) {
            this.gameCanvas = new MainGame(this.midlet);
        }
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.gameCanvas);
        this.gameCanvas.start();
    }

    public void scnHighscore() {
        if (this.highscore == null) {
            this.highscore = new Highscore(this.midlet);
        }
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.highscore);
    }

    public void scnHelp() {
        if (this.help == null) {
            this.help = new Help(this.midlet);
        }
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.help);
    }

    public void scnAbout() {
        if (this.about == null) {
            this.about = new About(this.midlet);
        }
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.about);
    }

    private class Button {
        public int x;
        public int y;
        public int width;
        public int height;
        private TiledLayer tiledLayer;
        public int position;

        public Button(Image image, int position) {
            this.position = position;
            this.width = image.getWidth() / 5;
            this.height = image.getHeight();
            this.tiledLayer = new TiledLayer(5, 1, image, 128, 30);
        }

        public void draw(Graphics g) {
            this.tiledLayer.setPosition(this.x, this.y);
            this.tiledLayer.setCell(0, 0, this.position);
            this.tiledLayer.paint(g);
        }
    }
}

