/*
 * Decompiled with CFR 0.152.
 */
package com.bgate.Algorithm;

import com.bgate.GameLevel.EndLess;
import com.bgate.GameLevel.GameLevel;
import com.bgate.GameLevel.GameWin;
import com.bgate.ItemBom.ItemBomb;
import com.bgate.ItemColumn.ItemColumn;
import com.bgate.ItemDButton.ItemButton;
import com.bgate.ItemEgg.ItemBrokenEgg;
import com.bgate.ItemEgg.ItemEgg;
import com.bgate.ItemEgg.ItemEggFall;
import com.bgate.ItemEgg.ItemPiece;
import com.bgate.ItemEgg.ItemScramblEgg;
import com.bgate.ItemEgg.Pair;
import com.bgate.ItemFireWork.ItemFireCracker;
import com.bgate.ItemFireWork.ItemFireWork;
import com.bgate.ItemFoot.ItemFoot;
import com.bgate.ItemMulti.ItemMulti;
import com.bgate.ItemScore.ItemScore;
import com.bgate.ItemStruct.StructPair;
import com.bgate.ItemTimer.ItemTimer;
import com.bgate.ListItem.Arrow;
import com.bgate.screen.GameScreen;
import com.bgate.screen.MenuScreen;
import com.bgate.utils.Function;
import com.bgate.utils.Source;
import com.bgate.utils.SourceState;
import java.util.Random;
import java.util.Vector;

public class CheckColisonEgg {
    public static Random random;
    private ItemFoot itemFoot;
    private GameWin gameWin;
    private GameLevel gameLevel;
    private ItemTimer itemTimer;
    public boolean[][] freex;
    public boolean[][] mark;
    private static int[] aColor;
    public static int numberEggMark;
    public static int nColor;
    public double beta;
    public double gamma;
    public double speed;
    public static int nEggRow;
    private int uRow;
    private int uColumn;
    public static int colorEgg;
    public static int countFootDown;
    public static boolean stateIsRunning;
    public static boolean stateCollisonUpWall;
    public static boolean stateCollsionWall;
    public static boolean stateRunningNextEgg;
    public static boolean stateRunningNewNextEgg;
    public static boolean stateColisonWallLeft;
    public static boolean stateColisonWallRight;
    public static boolean statePaint;
    public static boolean stateFootDown;
    private Vector vectorPairEgg;
    private Vector vSaveNext;
    private Vector vectorSaveXY;
    private Vector vectorSaveEgg;
    private double XCurrent;
    private double YCurrent;
    private int rowBoard;
    private int columnBoard;
    private double valueMin;
    private double valueMax;

    public CheckColisonEgg() {
        aColor = new int[100];
        for (int i = 0; i < 10; ++i) {
            CheckColisonEgg.aColor[i] = 0;
        }
    }

    public void init() {
        this.initObject();
        this.initArray();
        this.initItem();
    }

    public void initObject() {
        this.gameWin = new GameWin();
        this.itemTimer = new ItemTimer();
        this.freex = new boolean[Source.ROW_MAX][Source.COLUMN_MAX];
        this.mark = new boolean[Source.ROW_MAX][Source.COLUMN_MAX];
        random = new Random();
        this.vectorPairEgg = new Vector();
        this.vSaveNext = new Vector();
        this.vectorSaveXY = new Vector();
        this.vectorSaveEgg = new Vector();
    }

    public void initArray() {
        for (int i = 0; i < Source.ROW_MAX; ++i) {
            for (int j = 0; j < Source.COLUMN_MAX; ++j) {
                this.freex[i][j] = false;
                this.mark[i][j] = false;
            }
        }
    }

    public void initItem() {
        stateIsRunning = false;
        stateCollsionWall = false;
        stateColisonWallLeft = false;
        stateRunningNextEgg = false;
        stateRunningNewNextEgg = false;
        stateFootDown = false;
        countFootDown = 0;
        this.uRow = 18;
        this.uColumn = 18;
        nColor = 0;
        colorEgg = 0;
    }

    public void initLevel() {
        this.initItem();
    }

    public void dispose() {
        this.freex = null;
        this.mark = null;
        this.vectorPairEgg = null;
        aColor = null;
        random = null;
    }

    public int getTab(int x, int y) {
        if (x >= 0 && y >= 0 && x < Source.COLUMN_MAX && y < Source.ROW_MAX) {
            return ItemEgg.tab[y][x];
        }
        return 0;
    }

    public void update(int keyState) {
        if (ItemBomb.isVisible) {
            this.checkCollisonBomb();
        }
        if (!ItemBomb.isVisible) {
            if (MenuScreen.stateLevel && !ItemEgg.stateInitEgg) {
                ItemEgg.updateInitTab();
            }
            if (this.vectorSaveXY.size() >= 2) {
                StructPair structPair = (StructPair)this.vectorSaveXY.elementAt(this.vectorSaveXY.size() - 2);
                this.XCurrent = structPair.first;
                this.YCurrent = structPair.second;
            }
            this.updateCurrent(keyState);
            this.updateNext();
            if (this.getPair(ItemEgg.currentX, ItemEgg.currentY) != null && stateIsRunning) {
                this.checkColisonEgg();
            }
            this.updateCheckColison();
            if (ItemEgg.currentEgg == 0) {
                stateRunningNextEgg = true;
            }
            if (stateFootDown) {
                if ((countFootDown += 3) >= 24) {
                    ItemFoot.footY += 3;
                    ItemFoot.update();
                    stateFootDown = false;
                    countFootDown = 0;
                } else {
                    ItemFoot.footY += 3;
                }
            }
        }
    }

    public void updateListEgg() {
        int j;
        int i;
        for (i = 0; i < Source.ROW_MAX; ++i) {
            for (j = 0; j < Source.COLUMN_MAX; ++j) {
                int v;
                int u;
                if (this.getTab(j, i) == 0 || this.mark[i][j]) continue;
                this.freex[i][j] = true;
                boolean booleanUpdateListEgg = false;
                do {
                    booleanUpdateListEgg = false;
                    for (int u2 = 0; u2 < Source.ROW_MAX; ++u2) {
                        for (int v2 = 0; v2 < Source.COLUMN_MAX; ++v2) {
                            if (!this.freex[u2][v2] || !this.checkRemoveListEgg(v2, u2)) continue;
                            booleanUpdateListEgg = true;
                        }
                    }
                } while (booleanUpdateListEgg);
                boolean booleanCheckLimitEgg = false;
                for (u = 0; u < Source.COLUMN_MAX; ++u) {
                    if (!this.freex[0][u]) continue;
                    booleanCheckLimitEgg = true;
                }
                if (!booleanCheckLimitEgg) {
                    for (u = 0; u < Source.ROW_MAX; ++u) {
                        for (v = 0; v < Source.COLUMN_MAX; ++v) {
                            if (!this.freex[u][v]) continue;
                            if (ItemEgg.tab[u][v] == 8) {
                                ItemButton.fButton[u][v] = 1;
                            }
                            if (ItemEgg.tab[u][v] > 0) {
                                ItemEggFall.fFall[u][v] = ItemEgg.tab[u][v];
                                if (ItemFireWork.fFireWork[u][v] > 0) {
                                    ItemFireWork.fFireWork[u][v] = 0;
                                    ItemFireCracker.fFireCracker[u][v] = ItemEgg.tab[u][v];
                                }
                            }
                            ItemEgg.tab[u][v] = 0;
                            this.freex[u][v] = false;
                        }
                    }
                } else {
                    for (u = 0; u < Source.ROW_MAX; ++u) {
                        for (v = 0; v < Source.COLUMN_MAX; ++v) {
                            if (!this.freex[u][v]) continue;
                            this.mark[u][v] = true;
                        }
                    }
                }
                for (u = 0; u < Source.ROW_MAX; ++u) {
                    for (v = 0; v < Source.COLUMN_MAX; ++v) {
                        this.freex[u][v] = false;
                    }
                }
            }
        }
        for (i = 0; i < Source.ROW_MAX; ++i) {
            for (j = 0; j < Source.COLUMN_MAX; ++j) {
                this.mark[i][j] = false;
            }
        }
    }

    public void countEggMark(int mx, int my) {
        int color = 0;
        if (!ItemBomb.stateBomIsRunning) {
            color = this.getTab(mx, my);
        }
        if (ItemBomb.isVisible) {
            if (color == 0) {
                if (this.getTab(mx - 1, my) > color && !this.freex[my][mx - 1]) {
                    ++numberEggMark;
                    this.freex[my][mx] = true;
                    this.freex[my][mx - 1] = true;
                }
                if (this.getTab(mx + 1, my) > color && !this.freex[my][mx + 1]) {
                    ++numberEggMark;
                    this.freex[my][mx] = true;
                    this.freex[my][mx + 1] = true;
                }
                if (this.getTab(mx, my - 1) > color && !this.freex[my - 1][mx]) {
                    ++numberEggMark;
                    this.freex[my][mx] = true;
                    this.freex[my - 1][mx] = true;
                }
                if (this.getTab(mx, my + 1) > color && !this.freex[my + 1][mx]) {
                    ++numberEggMark;
                    this.freex[my][mx] = true;
                    this.freex[my + 1][mx] = true;
                }
                if (my % 2 == ItemEgg.remainder) {
                    if (this.getTab(mx - 1, my - 1) > color && !this.freex[my - 1][mx - 1]) {
                        ++numberEggMark;
                        this.freex[my][mx] = true;
                        this.freex[my - 1][mx - 1] = true;
                    }
                    if (this.getTab(mx - 1, my + 1) > color && !this.freex[my + 1][mx - 1]) {
                        ++numberEggMark;
                        this.freex[my][mx] = true;
                        this.freex[my + 1][mx - 1] = true;
                    }
                }
                if (my % 2 != ItemEgg.remainder) {
                    if (this.getTab(mx + 1, my - 1) > color && !this.freex[my - 1][mx + 1]) {
                        ++numberEggMark;
                        this.freex[my][mx] = true;
                        this.freex[my - 1][mx + 1] = true;
                    }
                    if (this.getTab(mx + 1, my + 1) > color && !this.freex[my + 1][mx + 1]) {
                        ++numberEggMark;
                        this.freex[my][mx] = true;
                        this.freex[my + 1][mx + 1] = true;
                    }
                }
            }
        } else if (color != 0) {
            if (color == this.getTab(mx - 1, my) && !this.freex[my][mx - 1]) {
                ++numberEggMark;
                this.freex[my][mx] = true;
                this.freex[my][mx - 1] = true;
                this.countEggMark(mx - 1, my);
            }
            if (color == this.getTab(mx + 1, my) && !this.freex[my][mx + 1]) {
                ++numberEggMark;
                this.freex[my][mx] = true;
                this.freex[my][mx + 1] = true;
                this.countEggMark(mx + 1, my);
            }
            if (color == this.getTab(mx, my - 1) && !this.freex[my - 1][mx]) {
                ++numberEggMark;
                this.freex[my][mx] = true;
                this.freex[my - 1][mx] = true;
                this.countEggMark(mx, my - 1);
            }
            if (color == this.getTab(mx, my + 1) && !this.freex[my + 1][mx]) {
                ++numberEggMark;
                this.freex[my][mx] = true;
                this.freex[my + 1][mx] = true;
                this.countEggMark(mx, my + 1);
            }
            if (my % 2 == ItemEgg.remainder) {
                if (color == this.getTab(mx - 1, my - 1) && !this.freex[my - 1][mx - 1]) {
                    ++numberEggMark;
                    this.freex[my][mx] = true;
                    this.freex[my - 1][mx - 1] = true;
                    this.countEggMark(mx - 1, my - 1);
                }
                if (color == this.getTab(mx - 1, my + 1) && !this.freex[my + 1][mx - 1]) {
                    ++numberEggMark;
                    this.freex[my][mx] = true;
                    this.freex[my + 1][mx - 1] = true;
                    this.countEggMark(mx - 1, my + 1);
                }
            }
            if (my % 2 != ItemEgg.remainder) {
                if (color == this.getTab(mx + 1, my - 1) && !this.freex[my - 1][mx + 1]) {
                    ++numberEggMark;
                    this.freex[my][mx] = true;
                    this.freex[my - 1][mx + 1] = true;
                    this.countEggMark(mx + 1, my - 1);
                }
                if (color == this.getTab(mx + 1, my + 1) && !this.freex[my + 1][mx + 1]) {
                    ++numberEggMark;
                    this.freex[my][mx] = true;
                    this.freex[my + 1][mx + 1] = true;
                    this.countEggMark(mx + 1, my + 1);
                }
            }
        }
    }

    public boolean checkRemoveListEgg(int mx, int my) {
        int COLOR = 0;
        boolean booleanRemoveListEgg = false;
        if (COLOR != this.getTab(mx - 1, my) && !this.freex[my][mx - 1]) {
            this.freex[my][mx - 1] = true;
            booleanRemoveListEgg = true;
        }
        if (COLOR != this.getTab(mx + 1, my) && !this.freex[my][mx + 1]) {
            this.freex[my][mx + 1] = true;
            booleanRemoveListEgg = true;
        }
        if (COLOR != this.getTab(mx, my - 1) && !this.freex[my - 1][mx]) {
            this.freex[my - 1][mx] = true;
            booleanRemoveListEgg = true;
        }
        if (COLOR != this.getTab(mx, my + 1) && !this.freex[my + 1][mx]) {
            this.freex[my + 1][mx] = true;
            booleanRemoveListEgg = true;
        }
        if (my % 2 == ItemEgg.remainder) {
            if (COLOR != this.getTab(mx - 1, my - 1) && !this.freex[my - 1][mx - 1]) {
                this.freex[my - 1][mx - 1] = true;
                booleanRemoveListEgg = true;
            }
            if (COLOR != this.getTab(mx - 1, my + 1) && !this.freex[my + 1][mx - 1]) {
                this.freex[my + 1][mx - 1] = true;
                booleanRemoveListEgg = true;
            }
        }
        if (my % 2 != ItemEgg.remainder) {
            if (COLOR != this.getTab(mx + 1, my - 1) && !this.freex[my - 1][mx + 1]) {
                this.freex[my - 1][mx + 1] = true;
                booleanRemoveListEgg = true;
            }
            if (COLOR != this.getTab(mx + 1, my + 1) && !this.freex[my + 1][mx + 1]) {
                this.freex[my + 1][mx + 1] = true;
                booleanRemoveListEgg = true;
            }
        }
        return booleanRemoveListEgg;
    }

    public boolean checkExitEgg(int mx, int my) {
        int COLOR = 0;
        boolean booleanExitEgg = false;
        if (this.getTab(mx - 1, my) != COLOR) {
            booleanExitEgg = true;
        }
        if (this.getTab(mx + 1, my) != COLOR) {
            booleanExitEgg = true;
        }
        if (this.getTab(mx, my - 1) != COLOR) {
            booleanExitEgg = true;
        }
        if (this.getTab(mx, my + 1) != COLOR) {
            booleanExitEgg = true;
        }
        if (my % 2 == ItemEgg.remainder) {
            if (this.getTab(mx - 1, my - 1) != COLOR) {
                booleanExitEgg = true;
            }
            if (this.getTab(mx - 1, my + 1) != COLOR) {
                booleanExitEgg = true;
            }
        }
        if (my % 2 != ItemEgg.remainder) {
            if (this.getTab(mx + 1, my - 1) != COLOR) {
                booleanExitEgg = true;
            }
            if (this.getTab(mx + 1, my + 1) != COLOR) {
                booleanExitEgg = true;
            }
        }
        return booleanExitEgg;
    }

    public void checkColisonListEgg(int h, int n) {
        int j;
        int i;
        numberEggMark = 1;
        colorEgg = 0;
        this.countEggMark(h, n);
        if (numberEggMark >= 2 && ItemBomb.isVisible) {
            for (i = 0; i < Source.ROW_MAX; ++i) {
                for (j = 0; j < Source.COLUMN_MAX; ++j) {
                    if (!this.freex[i][j]) continue;
                    this.freex[i][j] = false;
                    ItemScramblEgg.fScrambl[i][j] = ItemEgg.tab[i][j];
                    ItemPiece.fPiece[i][j] = ItemEgg.tab[i][j];
                    ItemBrokenEgg.fBroken[i][j] = ItemEgg.tab[i][j];
                    ItemFireCracker.fFireCracker[i][j] = 1;
                    ItemEgg.tab[i][j] = 0;
                    ItemFireWork.fFireWork[i][j] = 0;
                }
            }
        }
        if (numberEggMark == 2) {
            for (i = 0; i < Source.ROW_MAX; ++i) {
                for (j = 0; j < Source.COLUMN_MAX; ++j) {
                    if (!this.freex[i][j] || ItemFireWork.rowFire == -1 || ItemFireWork.columnFire == -1) continue;
                    int row = ItemFireWork.rowFire;
                    int column = ItemFireWork.columnFire;
                    if (row == i && column == j || ItemFireWork.fFireWork[i][j] != 0) continue;
                    ItemFireWork.fFireWork[ItemFireWork.rowFire][ItemFireWork.columnFire] = 1;
                    ItemFireWork.markFireWork[ItemFireWork.rowFire][ItemFireWork.columnFire] = 1;
                    ItemFireWork.rowFire = -1;
                    ItemFireWork.columnFire = -1;
                }
            }
        }
        if (numberEggMark >= 3) {
            for (i = 0; i < Source.ROW_MAX; ++i) {
                for (j = 0; j < Source.COLUMN_MAX; ++j) {
                    if (!this.freex[i][j] || ItemEgg.tab[i][j] == 9 || ItemEgg.tab[i][j] == 10) continue;
                    if (ItemEgg.checkEggAutomatic(i, j)) {
                        ItemMulti.stateItemMulti = true;
                    }
                    if (ItemEgg.tab[i][j] > 0) {
                        ItemScramblEgg.fScrambl[i][j] = ItemEgg.tab[i][j];
                        ItemPiece.fPiece[i][j] = ItemEgg.tab[i][j];
                        ItemBrokenEgg.fBroken[i][j] = ItemEgg.tab[i][j];
                        if (ItemFireWork.fFireWork[i][j] > 0) {
                            ItemFireCracker.fFireCracker[i][j] = ItemEgg.tab[i][j];
                            ItemFireWork.fFireWork[i][j] = 0;
                        }
                    }
                    if (ItemMulti.fItemMulti[i][j] == 0) {
                        ItemScore.score += 10 * numberEggMark;
                    }
                    if (ItemMulti.fItemMulti[i][j] > 0) {
                        switch (ItemMulti.fItemMulti[i][j]) {
                            case 1: {
                                ItemScore.score += 20 * numberEggMark;
                                break;
                            }
                            case 2: {
                                ItemScore.score += 30 * numberEggMark;
                                break;
                            }
                            case 3: {
                                ItemScore.score += 40 * numberEggMark;
                                break;
                            }
                            case 4: {
                                ItemScore.score += 50 * numberEggMark;
                                break;
                            }
                            case 5: {
                                ItemScore.score += 10 + 10 * numberEggMark;
                                break;
                            }
                            case 6: {
                                ItemScore.score += 20 + 10 * numberEggMark;
                                break;
                            }
                            case 7: {
                                ItemScore.score += 30 + 10 * numberEggMark;
                            }
                        }
                        ItemMulti.fItemMulti[i][j] = 0;
                    }
                    ItemEgg.tab[i][j] = 0;
                    this.freex[i][j] = false;
                }
            }
        }
        for (i = 0; i < Source.ROW_MAX; ++i) {
            for (j = 0; j < Source.COLUMN_MAX; ++j) {
                this.freex[i][j] = false;
            }
        }
        this.updateListEgg();
    }

    public void checkColisonEgg() {
        double temp = 0.0;
        int tempRow = -10;
        int tempColumn = -10;
        int tempInitTab = ItemEgg.countInitTab;
        if (ItemEgg.countInitTab >= 8 * Source.SIZE_EGG) {
            tempInitTab = 0;
        }
        if (MenuScreen.stateLevel) {
            ItemEgg.eggDownY = 0;
        }
        int row = this.getPair((double)ItemEgg.currentX, (double)ItemEgg.currentY).first;
        int column = this.getPair((double)ItemEgg.currentX, (double)ItemEgg.currentY).second;
        if (this.checkVector(this.getPair(ItemEgg.currentX, ItemEgg.currentY), this.vectorPairEgg)) {
            this.vectorPairEgg.addElement(new Pair(row, column));
        }
        if (stateIsRunning) {
            this.vectorSaveXY.addElement(new StructPair(ItemEgg.currentX, ItemEgg.currentY));
        }
        for (int n = 1; n >= -1; --n) {
            for (int m = 1; m >= -1; --m) {
                if (!this.checkRowColumn(row + n, column + m)) continue;
                temp = 0.0;
                if ((row + n) % 2 == 0 && ItemEgg.stateEggChange || (row + n) % 2 == 1 && !ItemEgg.stateEggChange) {
                    temp = Source.SIZE_EGG / 2;
                }
                if (this.getTab(column + m, row + n) == 0 || !this.checkExitEgg(column, row) || !(this.getDistance(row + n, column + m) < 11.5 && row <= 7 || this.getDistance(row + n, column + m) < 9.0 && row >= 8) && (Arrow.indexArrow != 15 || !(this.getDistance(row, column) < 13.0))) continue;
                tempRow = 0;
                tempColumn = 0;
                if (this.getTab(column, row) > 0) {
                    int newRow = -1;
                    int newColumn = -1;
                    if (this.getRadius(row, column) != null) {
                        newRow = this.getRadius((int)row, (int)column).first;
                        newColumn = this.getRadius((int)row, (int)column).second;
                    }
                    if (newRow != -1 && newColumn != -1) {
                        if (this.getTab(newColumn, newRow) == 0) {
                            tempRow = newRow - row;
                            tempColumn = newColumn - column;
                        }
                    } else {
                        tempRow = 1;
                        tempColumn = 0;
                        if (row % 2 == 0 && ItemEgg.stateEggChange || row % 2 == 1 && !ItemEgg.stateEggChange && this.getTab(column + 1, row + 1) == 0) {
                            tempColumn = 1;
                        } else {
                            tempRow = 0;
                            tempColumn = 0;
                            if (this.getTab(column, row + 1) == 0) {
                                tempColumn = 0;
                            } else if (this.XCurrent < ItemEgg.currentX) {
                                if (this.getTab(column - 1, row + 1) == 0) {
                                    tempRow = 1;
                                    tempColumn = -1;
                                }
                            } else if (this.getTab(column + 1, row + 1) == 0) {
                                tempRow = 1;
                                tempColumn = 1;
                            }
                        }
                    }
                }
                System.out.println("speed: " + this.speed);
                System.out.println("state: " + ItemEgg.stateEggChange);
                System.out.println("tempRow: " + tempRow + ", tempColumn: " + tempColumn);
                System.out.println("row + n: " + (row + n) + ", column + m: " + (column + m) + ", tab: " + this.getTab(column + m, row + n));
                System.out.println("row: " + row + ", column: " + column + ", tab: " + this.getTab(column, row));
                System.out.println("======================================================================");
                if (ItemFireWork.stateCheckFire || (Arrow.indexArrow == 15 || ItemEgg.currentX == Source.START_CURRENT_EGG_X) && Arrow.indexArrow != 15) continue;
                ItemEgg.tab[row + tempRow][column + tempColumn] = ItemEgg.currentEgg;
                ItemMulti.fItemMulti[row + tempRow][column + tempColumn] = ItemMulti.currentItemMulti;
                if (!ItemFireWork.stateCheckFire) {
                    ItemFireWork.rowFire = row + tempRow;
                    ItemFireWork.columnFire = column + tempColumn;
                    ItemColumn.stateCheckColison = true;
                }
                if (this.uColumn != 18 && this.uRow != 18) {
                    this.checkColisonListEgg(this.uColumn, this.uRow);
                }
                if (MenuScreen.stateEndLess || MenuScreen.stateLevel && !ItemFireWork.stateCheckFire && ItemColumn.stateCheckColison) {
                    this.checkColisonListEgg(column + tempColumn, row + tempRow);
                }
                if (MenuScreen.stateLevel) {
                    if (this.uRow == 18 && this.uColumn == 18) {
                        ++ItemColumn.countColumn;
                    }
                    if (ItemColumn.countColumn >= 10 && !this.gameWin.checkWin() && !stateFootDown) {
                        ++ItemFoot.countAppearDown;
                        stateFootDown = true;
                    }
                }
                stateIsRunning = false;
                stateRunningNextEgg = true;
                ItemEgg.stateUpdateBomb = true;
                stateCollsionWall = false;
                stateColisonWallLeft = false;
                ItemEgg.currentEgg = 0;
                ItemMulti.currentItemMulti = 0;
                CheckColisonEgg.updateEggFixed();
                this.vectorPairEgg.removeAllElements();
                this.vectorSaveXY.removeAllElements();
                break;
            }
            if (ItemEgg.currentEgg == 0) break;
        }
    }

    public void updateCheckColison() {
        this.uRow = 18;
        this.uColumn = 18;
        if (ItemEgg.stateUpdateBomb && MenuScreen.stateEndLess) {
            ItemEgg.currentEgg = 0;
        }
        if (!(ItemEgg.nextX == Source.START_NEXT_EGG_X && ItemEgg.nextY == Source.START_NEXT_EGG_Y || stateRunningNewNextEgg)) {
            if (MenuScreen.stateEndLess) {
                ItemEgg.newNext = 1 + random.nextInt(EndLess.type_number_egg);
            } else if (MenuScreen.stateLevel && ItemEgg.newNext == 0) {
                this.updateRandom();
            }
            ItemEgg.currentEgg = 0;
            ItemMulti.currentItemMulti = 0;
            stateRunningNewNextEgg = true;
        }
        if (ItemEgg.currentX == Source.START_CURRENT_EGG_X && ItemEgg.currentY == Source.START_CURRENT_EGG_Y) {
            stateCollsionWall = false;
        }
    }

    public void checkCollisonBomb() {
        double temp = 0.0;
        boolean rowExit = false;
        boolean tempRow = false;
        boolean tempColumn = false;
        int limitRow = 2;
        for (int n = 1; n >= -1; --n) {
            for (int m = -2; m < 2; ++m) {
                temp = 0.0;
                int row = (int)((ItemBomb.bombY - (double)Source.INIT_ABOVE - (double)ItemEgg.eggDownY) / (double)Source.SIZE_EGG);
                int column = (int)((ItemBomb.bombX + temp - (double)Source.INIT_ROW) / (double)Source.SIZE_EGG);
                if (ItemEgg.stateEggChange != SourceState.STATE_EGG_DOWN) {
                    if ((row + n) % 2 == 1) {
                        temp = -Source.SIZE_EGG / 2;
                    }
                } else if ((row + n) % 2 == 0) {
                    temp = -Source.SIZE_EGG / 2;
                }
                if (this.getTab(column + m, row + n) == 0 || column + m < 0 || row + n < 0 || column + m >= Source.COLUMN_MAX || row + n >= Source.ROW_MAX || !((ItemBomb.bombX - ((double)(Source.SIZE_EGG * ((int)(ItemBomb.bombX / (double)Source.SIZE_EGG) + m) + Source.SIZE_EGG / 2) + temp)) * (ItemBomb.bombX - ((double)(Source.SIZE_EGG * ((int)(ItemBomb.bombX / (double)Source.SIZE_EGG) + m) + Source.SIZE_EGG / 2) + temp)) + (ItemBomb.bombY - (double)(Source.SIZE_EGG * ((int)(ItemBomb.bombY / (double)Source.SIZE_EGG) + n) + Source.SIZE_EGG / 2)) * (ItemBomb.bombY - (double)(Source.SIZE_EGG * ((int)(ItemBomb.bombY / (double)Source.SIZE_EGG) + n) + Source.SIZE_EGG / 2)) < (double)(Source.SIZE_EGG * Source.SIZE_EGG * 4 / 5)) || !this.checkExitEgg(column, row) || row < 0 || row >= Source.ROW_MAX || column < 0 || column >= Source.COLUMN_MAX) continue;
                ItemEgg.tab[row][column] = 0;
                this.checkColisonListEgg(column, row);
                ItemBomb.stateBomIsRunning = false;
                stateRunningNextEgg = true;
                ItemBomb.isVisible = false;
                ItemBomb.stateCollisonWall = false;
                ItemBomb.stateUpEgg = true;
                ItemBomb.spriteBomb.setPosition(120, -500);
                CheckColisonEgg.updateEggFixed();
            }
        }
    }

    public static void resetCorrdinates() {
        ItemEgg.nextX = Source.START_NEXT_EGG_X;
        ItemEgg.nextY = Source.START_NEXT_EGG_Y;
        ItemEgg.newNextX = Source.START_NEXT_EGG_X;
        ItemEgg.newNextY = Source.START_NEXT_EGG_Y + 13.0;
    }

    public void updateCurrent(int keyState) {
        double tempLeftX = 0.0;
        double tempRightX = 0.0;
        switch (GameLevel.level) {
            case 5: 
            case 7: 
            case 13: 
            case 21: {
                tempLeftX = 0.0;
                tempRightX = 23.0;
                break;
            }
            case 15: {
                tempLeftX = 23.0;
                tempRightX = 36.0;
                break;
            }
            case 25: {
                tempLeftX = 23.0;
                tempRightX = 56.0;
            }
            default: {
                tempLeftX = 0.0;
                tempRightX = 5.0;
            }
        }
        ItemFireWork.stateCheckFire = false;
        if (MenuScreen.stateLevel) {
            ItemBomb.isVisible = false;
        }
        if (!ItemBomb.isVisible && !this.gameWin.checkWin() && (GameScreen.isRunningGame > 5 && (keyState & 0x100) != 0 && !stateIsRunning || stateIsRunning)) {
            stateIsRunning = true;
            this.beta = Source.ALPHA * (double)(Arrow.indexArrow + 1);
            double temp = 0.0;
            int row = (int)ItemEgg.currentY / Source.SIZE_EGG;
            if (row % 2 == 0 && ItemEgg.stateEggChange || row % 2 == 1 && !ItemEgg.stateEggChange) {
                temp = Source.SIZE_EGG / 2;
            }
            int column = (int)(ItemEgg.currentX - temp - (double)Source.INIT_ROW) / Source.SIZE_EGG;
            this.speed = Source.SPEED;
            if (ItemEgg.currentY <= (double)ItemFoot.footY + this.moveSin(this.speed, this.beta)) {
                this.speed = 15.0;
            }
            if (ItemEgg.currentY >= 260.0 || this.checkCurrent(row, column)) {
                this.speed = 15.0;
            }
            if (stateColisonWallLeft || stateColisonWallRight) {
                this.speed = 11.5;
            }
            ItemEgg.currentX = !stateCollsionWall ? (ItemEgg.currentX -= this.moveCos(this.speed, this.beta)) : (ItemEgg.currentX -= this.moveCos(-this.speed, this.beta));
            if (MenuScreen.stateEndLess) {
                if (ItemEgg.currentY >= this.moveSin(this.speed, this.beta)) {
                    ItemEgg.currentY -= this.moveSin(this.speed, this.beta);
                } else {
                    ItemEgg.currentY = 0.0;
                    temp = 0.0;
                    temp = !ItemEgg.stateEggChange ? 0.0 : (double)(Source.SIZE_EGG / 2);
                    column = (int)((ItemEgg.currentX - temp - (double)Source.INIT_ROW) / (double)Source.SIZE_EGG);
                    row = 0;
                    int tempRow = 0;
                    int tempColumn = 0;
                    if (this.getTab(column, row) > 0) {
                        if (this.getTab(column, row + 1) == 0) {
                            tempRow = 1;
                            tempColumn = 0;
                        } else if (this.getTab(column, row + 1) > 0) {
                            if (Arrow.indexArrow != 15) {
                                if (this.XCurrent < ItemEgg.currentX) {
                                    tempRow = 1;
                                    tempColumn = -1;
                                } else {
                                    tempRow = 1;
                                    tempColumn = 1;
                                }
                            } else if (ItemEgg.tab[row + 1][column] == 0) {
                                tempRow = 1;
                                tempColumn = 0;
                            } else if (ItemEgg.tab[row + 1][column] > 0) {
                                tempRow = 1;
                                tempColumn = 1;
                            }
                        }
                    }
                    ItemEgg.tab[row + tempRow][column + tempColumn] = ItemEgg.currentEgg;
                    ItemMulti.fItemMulti[row + tempRow][column + tempColumn] = ItemMulti.currentItemMulti;
                    ItemFireWork.stateCheckFire = true;
                    ItemFireWork.rowFire = row + tempRow;
                    ItemFireWork.columnFire = column + tempColumn;
                    this.checkColisonListEgg(column + tempColumn, row + tempRow);
                    stateCollisonUpWall = true;
                    stateIsRunning = false;
                    stateRunningNextEgg = true;
                    ItemFireWork.stateCheckFire = true;
                }
            } else if (MenuScreen.stateLevel) {
                if (ItemFoot.footY > -4 && ItemEgg.currentY >= (double)(ItemFoot.footY + 4) + this.moveSin(this.speed, this.beta) || (ItemFoot.footY == -4 || ItemFoot.footY == -5) && ItemEgg.currentY >= (double)ItemFoot.footY + this.moveSin(this.speed, this.beta)) {
                    ItemEgg.currentY -= this.moveSin(this.speed, this.beta);
                } else {
                    this.updateWallUp();
                }
            }
            if (ItemEgg.currentX <= Source.WALL_X_MIN + tempLeftX) {
                stateColisonWallLeft = true;
                stateColisonWallRight = false;
                stateCollsionWall = !stateCollsionWall;
            }
            if (ItemEgg.currentX >= Source.WALL_X_MAX - (double)Source.EGG_WIDTH - tempRightX) {
                stateColisonWallLeft = false;
                stateColisonWallRight = true;
                stateCollsionWall = !stateCollsionWall;
            }
            if (ItemEgg.currentX >= Source.WALL_X_MIN) {
                stateColisonWallLeft = false;
            }
            if (ItemEgg.currentX <= Source.WALL_X_MAX) {
                stateColisonWallRight = false;
            }
            if (ItemEgg.currentX <= Source.WALL_X_MIN) {
                ItemEgg.currentX = Source.WALL_X_MIN;
            }
            if (ItemEgg.currentX >= Source.WALL_X_MAX) {
                ItemEgg.currentX = Source.WALL_X_MAX;
            }
            if (ItemEgg.currentY <= (double)ItemFoot.footY) {
                ItemEgg.currentY = ItemFoot.footY;
            }
        }
    }

    public void updateWallUp() {
        int tempRow = 0;
        int tempColumn = 0;
        int column = this.getPair((double)ItemEgg.currentX, (double)ItemEgg.currentY).second;
        int row = this.getPair((double)ItemEgg.currentX, (double)ItemEgg.currentY).first;
        if (this.getTab(column, row) > 0) {
            int newRow = 0;
            int newColumn = 0;
            if (this.getRadius(row, column) != null) {
                newRow = this.getRadius((int)row, (int)column).first;
                newColumn = this.getRadius((int)row, (int)column).second;
            }
            if (this.getTab(newColumn, newRow) == 0) {
                tempRow = newRow - row;
                tempColumn = newColumn - column;
            } else {
                tempRow = 1;
                tempColumn = 0;
                if (row % 2 == 0 && ItemEgg.stateEggChange || row % 2 == 1 && !ItemEgg.stateEggChange && this.getTab(column + 1, row + 1) == 0) {
                    tempColumn = 1;
                } else if (this.getTab(column, row + 1) == 0) {
                    tempColumn = 0;
                }
            }
        }
        ItemEgg.tab[row + tempRow][column + tempColumn] = ItemEgg.currentEgg;
        ItemMulti.fItemMulti[row + tempRow][column + tempColumn] = ItemMulti.currentItemMulti;
        ItemFireWork.rowFire = row + tempRow;
        ItemFireWork.columnFire = column + tempColumn;
        this.uRow = row + tempRow;
        this.uColumn = column + tempColumn;
        ItemFireWork.stateCheckFire = true;
        if (ItemEgg.tab[row + tempRow][column + tempColumn] > 0) {
            ++ItemColumn.countColumn;
        }
        ItemColumn.stateCheckColison = true;
        if (ItemColumn.countColumn < 10 && ItemColumn.stateCheckColison) {
            this.checkColisonListEgg(column + tempColumn, row + tempRow);
        }
        if (ItemColumn.countColumn >= 10 && !this.gameWin.checkWin() && !stateFootDown) {
            stateFootDown = true;
            ++ItemFoot.countAppearDown;
        }
        stateCollisonUpWall = true;
        stateIsRunning = false;
        stateColisonWallLeft = false;
        stateRunningNextEgg = true;
    }

    public static void updateEggFixed() {
        if (Arrow.indexArrow <= 9) {
            ItemEgg.currentX = 135.0;
        } else if (Arrow.indexArrow == 10) {
            ItemEgg.currentX = 134.0;
        } else if (Arrow.indexArrow == 11) {
            ItemEgg.currentX = 132.0;
        } else if (Arrow.indexArrow == 12) {
            ItemEgg.currentX = 131.0;
        } else if (Arrow.indexArrow == 13) {
            ItemEgg.currentX = 129.0;
        } else if (Arrow.indexArrow == 14) {
            ItemEgg.currentX = 128.0;
        } else if (Arrow.indexArrow == 15) {
            ItemEgg.currentX = 127.0;
        } else if (Arrow.indexArrow == 16) {
            ItemEgg.currentX = 125.0;
        } else if (Arrow.indexArrow == 17) {
            ItemEgg.currentX = 124.0;
        } else if (Arrow.indexArrow == 18) {
            ItemEgg.currentX = 122.0;
        } else if (Arrow.indexArrow == 19) {
            ItemEgg.currentX = 121.0;
        } else if (Arrow.indexArrow == 20) {
            ItemEgg.currentX = 119.0;
        } else if (Arrow.indexArrow >= 21) {
            ItemEgg.currentX = 118.0;
        }
        ItemEgg.currentY = Source.START_CURRENT_EGG_Y;
    }

    public void updateNext() {
        if (MenuScreen.stateLevel) {
            ItemBomb.isVisible = false;
        }
        if (MenuScreen.stateLevel && this.gameWin.checkWin()) {
            stateRunningNextEgg = false;
        }
        if (stateRunningNextEgg && !ItemBomb.isVisible) {
            if (MenuScreen.stateLevel) {
                CheckColisonEgg.updateArrayColor();
            }
            ItemEgg.currentEgg = 0;
            ItemMulti.currentItemMulti = 0;
            if (nColor > 0 && !CheckColisonEgg.checkArrayColor(ItemEgg.newNext) && this.getColor() > 0) {
                ItemEgg.newNext = this.getColor();
            }
            ItemEgg.nextX += 30.0;
            if (ItemEgg.newNextY > Source.START_NEXT_EGG_Y) {
                ItemEgg.newNextY -= 2.0;
            }
            if (ItemEgg.newNextY < Source.START_NEXT_EGG_Y) {
                ItemEgg.newNextY = Source.START_NEXT_EGG_Y;
            }
            ItemEgg.nextY = ItemEgg.nextY >= 0.0 ? (ItemEgg.nextY -= 30.0 * Function.sqr(0.5)) : (ItemEgg.nextY += 30.0 * Function.sqr(0.5));
            if (ItemEgg.nextX >= Source.START_CURRENT_EGG_X) {
                ItemEgg.stateUpdateBomb = false;
                stateIsRunning = false;
                stateRunningNextEgg = false;
                stateRunningNewNextEgg = false;
                ItemEgg.currentEgg = ItemEgg.next;
                ItemEgg.next = ItemEgg.newNext;
                ItemMulti.currentItemMulti = ItemMulti.nextItemMulti;
                ItemMulti.nextItemMulti = ItemMulti.newItemMulti;
                ItemMulti.newItemMulti = -1;
                CheckColisonEgg.resetCorrdinates();
                CheckColisonEgg.updateEggFixed();
                stateCollsionWall = false;
                stateCollisonUpWall = false;
                ItemEgg.newNext = 0;
                this.updateRandom();
                if (MenuScreen.stateLevel && ItemEgg.newNext == 0) {
                    this.updateRandom1();
                }
            }
            if (MenuScreen.stateLevel) {
                CheckColisonEgg.resetArrayColor();
            }
        }
    }

    public void updateRandom() {
        this.updateRandom1();
        this.updateRandom2();
        if (MenuScreen.stateLevel && ItemEgg.newNext > 0) {
            this.vectorSaveEgg.addElement(new Integer(ItemEgg.newNext));
            if (this.vectorSaveEgg.size() >= 3) {
                int u1 = Integer.parseInt(this.vectorSaveEgg.elementAt(0).toString());
                int u2 = Integer.parseInt(this.vectorSaveEgg.elementAt(1).toString());
                int u3 = Integer.parseInt(this.vectorSaveEgg.elementAt(2).toString());
                if (u1 == u2 && u2 == u3) {
                    this.vectorSaveEgg.removeAllElements();
                    ItemEgg.newNext = 0;
                    this.updateRandom1();
                }
            }
        }
    }

    public void updateRandom1() {
        if (MenuScreen.stateLevel) {
            int t = random.nextInt(GameScreen.vectorGameLevel.size());
            CheckColisonEgg.updateArrayColor();
            for (int i = 0; i < nColor; ++i) {
                System.out.println("i: " + i + " , a[i]: " + aColor[i]);
            }
            if (nColor > 0) {
                ItemEgg.newNext = aColor[random.nextInt(nColor)];
            } else if (this.gameWin.checkWin()) {
                ItemEgg.newNext = Integer.parseInt(GameScreen.vectorGameLevel.elementAt(t).toString());
            }
            CheckColisonEgg.resetArrayColor();
        } else {
            ItemEgg.newNext = 1 + random.nextInt(EndLess.type_number_egg);
        }
    }

    public void updateRandom2() {
        if (MenuScreen.stateLevel) {
            if (CheckColisonEgg.totalTab() >= 1 && CheckColisonEgg.totalTab() <= 3) {
                CheckColisonEgg.updateArrayColor();
                if (nColor > 0) {
                    ItemEgg.newNext = aColor[random.nextInt(nColor)];
                }
                CheckColisonEgg.resetArrayColor();
            } else if (this.checkRow9()) {
                CheckColisonEgg.resetArrayColor();
                CheckColisonEgg.updateArrayColor();
                colorEgg = 0;
                colorEgg = this.getColor();
                if (CheckColisonEgg.checkIndexColor(colorEgg)) {
                    this.vSaveNext.addElement(new Integer(colorEgg));
                    if (this.vSaveNext.size() >= 3) {
                        int u1 = Integer.parseInt(this.vSaveNext.elementAt(0).toString());
                        int u2 = Integer.parseInt(this.vSaveNext.elementAt(1).toString());
                        int u3 = Integer.parseInt(this.vSaveNext.elementAt(2).toString());
                        if (u1 == u2 && u2 == u3) {
                            colorEgg = 0;
                            CheckColisonEgg.resetArrayColor();
                            this.updateRandom1();
                            this.vSaveNext.removeAllElements();
                        }
                        this.vSaveNext.removeAllElements();
                    }
                }
                if (CheckColisonEgg.checkIndexColor(colorEgg)) {
                    ItemEgg.newNext = colorEgg;
                }
            }
        }
    }

    public Pair getCurrent(int row, int column) {
        int limit;
        this.valueMin = 1.0E7;
        int u = -1;
        int v = -1;
        int indexRowBegin = 0;
        int indexRowEnd = 2;
        int indexColumnBegin = -2;
        int indexColumnEnd = 1;
        Pair pair1 = null;
        Pair pair2 = null;
        if (this.vectorPairEgg.size() >= 2) {
            pair1 = (Pair)this.vectorPairEgg.lastElement();
            pair2 = (Pair)this.vectorPairEgg.elementAt(this.vectorPairEgg.size() - 2);
        }
        if ((limit = pair2.second - pair1.second) > 0) {
            indexColumnBegin = -3;
            indexColumnEnd = -1;
        }
        if (limit == 0) {
            indexColumnBegin = -2;
            indexColumnEnd = 2;
        }
        if (limit < 0) {
            indexColumnBegin = 0;
            indexColumnEnd = 3;
        }
        for (int i = indexColumnBegin; i <= indexColumnEnd; ++i) {
            for (int j = indexRowBegin; j <= indexRowEnd; ++j) {
                double value;
                if (row + i < 0 || column + j < 0) continue;
                double temp = 0.0;
                if ((row + i) % 2 == 0 && ItemEgg.stateEggChange || (row + i) % 2 == 1 && !ItemEgg.stateEggChange) {
                    temp = Source.SIZE_EGG / 2;
                }
                double XList = (double)(Source.SIZE_EGG * (column + j) + Source.INIT_ROW) + temp;
                double YList = Source.SIZE_EGG * (row + i);
                if (row + i < 0 || column + j < 0 || row + i > Source.ROW_MAX || column + j > Source.COLUMN_MAX || !(this.valueMin > (value = Math.sqrt(this.sqr(ItemEgg.currentX - XList) + this.sqr(ItemEgg.currentY - YList)))) || !(value <= (double)(10 * Source.SIZE_EGG)) || this.getTab(column + j, row + i) != 0 || !this.checkExitEgg(column + j, row + i)) continue;
                this.valueMin = Math.sqrt(this.sqr(ItemEgg.currentX - XList) + this.sqr(ItemEgg.currentY - YList));
                u = row + i;
                v = column + j;
            }
        }
        if (u != -1 && v != -1) {
            return new Pair(u, v);
        }
        return null;
    }

    public boolean checkCurrent(int row, int column) {
        for (int i = 2; i >= -2; --i) {
            for (int j = -2; j < 2; ++j) {
                if (!this.checkRowColumn(row + i, column + j) || this.getTab(column + j, row + i) == 0 || !(this.getDistance(row + i, column + j) < 11.5)) continue;
                return true;
            }
        }
        return false;
    }

    public Pair getPair(double currentX, double cutrentY) {
        Object pair = null;
        double temp = 0.0;
        if (stateIsRunning) {
            int row = (int)cutrentY / Source.SIZE_EGG;
            if (row % 2 == 0 && ItemEgg.stateEggChange || row % 2 == 1 && !ItemEgg.stateEggChange) {
                temp = Source.SIZE_EGG / 2;
            }
            int column = (int)(currentX - (double)Source.INIT_ROW - temp) / Source.SIZE_EGG;
            return new Pair(row, column);
        }
        return null;
    }

    public double moveCos(double speed, double alpha) {
        return speed * Math.cos(Math.toRadians(alpha));
    }

    public double moveSin(double speed, double alpha) {
        return speed * Math.sin(Math.toRadians(alpha));
    }

    public static void updateArrayColor() {
        CheckColisonEgg.resetArrayColor();
        for (int i = 0; i < Source.ROW_MAX; ++i) {
            for (int j = 0; j < Source.COLUMN_MAX; ++j) {
                if (ItemEgg.tab[i][j] <= 0 || ItemEgg.tab[i][j] == 9 || ItemEgg.tab[i][j] == 10 || !CheckColisonEgg.checkArrayColor(ItemEgg.tab[i][j]) && nColor != 0) continue;
                CheckColisonEgg.aColor[CheckColisonEgg.nColor++] = ItemEgg.tab[i][j];
            }
        }
        if (CheckColisonEgg.totalTab() >= 2) {
            if (ItemEgg.currentEgg > 0 && CheckColisonEgg.checkArrayColor(ItemEgg.currentEgg)) {
                CheckColisonEgg.aColor[CheckColisonEgg.nColor++] = ItemEgg.currentEgg;
            }
            if (ItemEgg.next > 0 && CheckColisonEgg.checkArrayColor(ItemEgg.next)) {
                CheckColisonEgg.aColor[CheckColisonEgg.nColor++] = ItemEgg.next;
            }
        }
    }

    public static boolean checkArrayColor(int t) {
        for (int i = 0; i < nColor; ++i) {
            if (aColor[i] != t) continue;
            return false;
        }
        return true;
    }

    public static void resetArrayColor() {
        nColor = 0;
        for (int i = 0; i < 100; ++i) {
            CheckColisonEgg.aColor[i] = 0;
        }
    }

    public static int totalTab() {
        int sum = 0;
        for (int i = 0; i < Source.ROW_MAX; ++i) {
            for (int j = 0; j < Source.COLUMN_MAX; ++j) {
                if (ItemEgg.tab[i][j] <= 0 || ItemEgg.tab[i][j] == 9 || ItemEgg.tab[i][j] == 10) continue;
                ++sum;
            }
        }
        return sum;
    }

    public boolean checkRow9() {
        int i;
        int indexRow = (ItemFoot.footY + 23) / Source.SIZE_EGG;
        if (CheckColisonEgg.totalTab() >= 15) {
            indexRow += 2;
        }
        for (i = 0; i < Source.COLUMN_MAX; ++i) {
            if (this.getTab(i, 10) <= 0) continue;
            return false;
        }
        for (i = indexRow; i < Source.ROW_MAX; ++i) {
            for (int j = 0; j < Source.COLUMN_MAX; ++j) {
                if (this.getTab(j, i) <= 0 || this.getTab(j, i) == 9) continue;
                return true;
            }
        }
        return false;
    }

    public int checkColor(int mx, int my) {
        int COLOR = this.getTab(mx, my);
        int sum = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (this.getTab(mx + i, mx + j) <= 0 || this.getTab(mx + i, mx + j) == COLOR) continue;
                ++sum;
            }
        }
        if (sum >= 6) {
            return 0;
        }
        if (COLOR != 0 && COLOR != 9) {
            if (this.getTab(mx - 1, my) == COLOR || this.getTab(mx + 1, my) == COLOR || this.getTab(mx, my - 1) == COLOR || this.getTab(mx, my + 1) == COLOR) {
                return COLOR;
            }
            if (my % 2 != ItemEgg.remainder && (this.getTab(mx + 1, my - 1) == COLOR || this.getTab(mx + 1, my + 1) == COLOR)) {
                return COLOR;
            }
            if (my % 2 == ItemEgg.remainder && (this.getTab(mx - 1, my - 1) == COLOR || this.getTab(mx - 1, my + 1) == COLOR)) {
                return COLOR;
            }
        }
        return 0;
    }

    public int getColor() {
        CheckColisonEgg.resetArrayColor();
        CheckColisonEgg.updateArrayColor();
        int COLOR = 0;
        for (int i = Source.ROW_MAX - 1; i > 0; --i) {
            for (int j = 0; j < Source.COLUMN_MAX; ++j) {
                if (this.getTab(j, i) == 0 || !CheckColisonEgg.checkIndexColor(COLOR = this.checkColor(i, j))) continue;
                return COLOR;
            }
        }
        CheckColisonEgg.resetArrayColor();
        return COLOR;
    }

    public static boolean checkIndexColor(int colorEggIndex) {
        CheckColisonEgg.updateArrayColor();
        if (colorEggIndex > 0 && colorEggIndex != 9 && colorEggIndex != 10 && !CheckColisonEgg.checkArrayColor(colorEggIndex)) {
            return true;
        }
        CheckColisonEgg.resetArrayColor();
        return false;
    }

    public boolean checkVector(Pair pair, Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            Pair pairEgg = (Pair)v.elementAt(i);
            if (pairEgg.first != pair.first || pairEgg.second != pair.second) continue;
            return false;
        }
        return true;
    }

    public double sqr(double x) {
        return x * x;
    }

    public StructPair getPairXY(int row, int column) {
        Object structPair = null;
        if (this.checkRowColumn(row, column)) {
            double temp = 0.0;
            if (row % 2 == 0 && ItemEgg.stateEggChange || row % 2 == 1 && !ItemEgg.stateEggChange) {
                temp = Source.SIZE_EGG / 2;
            }
            return new StructPair((double)(Source.SIZE_EGG * column + Source.INIT_ROW) + temp, Source.SIZE_EGG * row);
        }
        return null;
    }

    public boolean checkRowColumn(int row, int column) {
        return row >= 0 && column >= 0 && row <= Source.ROW_MAX && column <= Source.COLUMN_MAX;
    }

    public Pair getRadius(int row, int column) {
        for (int i = 1; i >= -1; --i) {
            for (int j = -1; j <= 1; ++j) {
                if (!this.checkRowColumn(row + i, column + j) || this.getTab(column + j, row + i) != 0 || !this.checkExitEgg(column + j, row + i) || !(this.getDistance(row + i, column + j) < 11.5)) continue;
                return new Pair(row + i, column + j);
            }
        }
        return null;
    }

    public double getDistance(int row, int column) {
        StructPair structPair1 = null;
        StructPair structPair2 = null;
        double XCenter = this.getPairXY((int)row, (int)column).first + 11.5;
        double YCenter = this.getPairXY((int)row, (int)column).second + 11.5;
        if (this.vectorSaveXY.size() >= 2) {
            structPair1 = (StructPair)this.vectorSaveXY.lastElement();
            structPair2 = (StructPair)this.vectorSaveXY.elementAt(this.vectorSaveXY.size() - 2);
            StructPair u = new StructPair(-(structPair1.second - structPair2.second), structPair1.first - structPair2.first);
            double delta = Math.abs(u.first * XCenter + u.second * YCenter - u.first * (structPair1.first + 11.5) - u.second * (structPair1.second + 11.5)) / Math.sqrt(this.sqr(u.first) + this.sqr(u.second));
            return delta;
        }
        return 1000.0;
    }
}

