/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class Sprite {
    int m_nX;
    int m_nY;
    int m_nCollisionRectX;
    int m_nCollisionRectY;
    int m_nCollisionRectWidth;
    int m_nCollisionRectHeight;
    int m_nCollidesCol;
    int m_nCollidesRow;
    int m_nFrW;
    int m_nFrH;
    int m_nFrameCount;
    int m_nCurrentSeqPos;
    int m_nCurrentFrame;
    Image m_image;
    int[] m_frameSequence;
    boolean m_bIsUseFrameSequence;
    short[] m_shFrameOffsetLeft;
    short[] m_shFrameOffsetTop;

    Sprite(Image image, int nFrameW, int nFrameH) throws NullPointerException, IllegalArgumentException {
        this.m_image = image;
        this.m_shFrameOffsetLeft = image.m_shFrameOffsetLeft;
        this.m_shFrameOffsetTop = image.m_shFrameOffsetTop;
        this.m_nFrW = nFrameW;
        this.m_nFrH = nFrameH;
        this.m_nFrameCount = image.m_images.length;
        if (this.m_nFrameCount == 0) {
            this.m_nFrameCount = 1;
        }
        this.m_nCollisionRectX = 0;
        this.m_nCollisionRectY = 0;
        this.m_nCollisionRectWidth = nFrameW;
        this.m_nCollisionRectHeight = nFrameH;
    }

    void dispose() {
        this.m_frameSequence = null;
        this.m_shFrameOffsetTop = null;
        this.m_shFrameOffsetLeft = null;
    }

    void setPosition(int x, int y) {
        this.m_nX = x;
        this.m_nY = y;
    }

    final void setFrame(int nFrame) throws IndexOutOfBoundsException {
        if (this.m_bIsUseFrameSequence) {
            this.m_nCurrentSeqPos = nFrame;
            this.m_nCurrentFrame = this.m_frameSequence[this.m_nCurrentSeqPos];
        } else {
            this.m_nCurrentFrame = nFrame;
        }
    }

    final void setTransform(int nManipulation) {
    }

    void paint(Graphics g) {
        this.m_image.paint(g, this.m_nCurrentFrame, this.m_nX, this.m_nY);
    }

    final boolean nextFrame() {
        boolean bHasFrames = true;
        if (this.m_bIsUseFrameSequence) {
            ++this.m_nCurrentSeqPos;
            if (this.m_nCurrentSeqPos >= this.m_frameSequence.length) {
                this.m_nCurrentSeqPos = 0;
                bHasFrames = false;
            }
            this.m_nCurrentFrame = this.m_frameSequence[this.m_nCurrentSeqPos];
        } else {
            ++this.m_nCurrentFrame;
            if (this.m_nCurrentFrame >= this.m_nFrameCount) {
                this.m_nCurrentFrame = 0;
                bHasFrames = false;
            }
        }
        return bHasFrames;
    }

    final int getFrameSequenceLength() {
        return this.m_frameSequence.length;
    }

    final void setFrameSequence(int[] frSq) {
        this.m_frameSequence = frSq;
        this.m_bIsUseFrameSequence = true;
        this.m_nCurrentSeqPos = 0;
        if (frSq == null) {
            this.m_bIsUseFrameSequence = false;
            this.m_nCurrentFrame = 0;
        } else {
            this.m_nCurrentFrame = this.m_frameSequence[this.m_nCurrentSeqPos];
        }
    }

    final void defineCollisionRectangle(int x, int y, int width, int height) {
        this.m_nCollisionRectX = x;
        this.m_nCollisionRectY = y;
        this.m_nCollisionRectWidth = width;
        this.m_nCollisionRectHeight = height;
    }

    final boolean collidesWith(Sprite s, boolean pixelLevel) {
        int otherLeft = s.m_nX + s.m_nCollisionRectX;
        int otherTop = s.m_nY + s.m_nCollisionRectY;
        int left = this.m_nX + this.m_nCollisionRectX;
        int top = this.m_nY + this.m_nCollisionRectY;
        return Game.intersectRect(otherLeft, otherTop, otherLeft + s.m_nCollisionRectWidth, otherTop + s.m_nCollisionRectHeight, left, top, left + this.m_nCollisionRectWidth, top + this.m_nCollisionRectHeight);
    }

    final boolean collidesWith(int x, int y, int width, int height) {
        int left = this.m_nX + this.m_nCollisionRectX;
        int top = this.m_nY + this.m_nCollisionRectY;
        return Game.intersectRect(x, y, x + width, y + height, left, top, left + this.m_nCollisionRectWidth, top + this.m_nCollisionRectHeight);
    }
}

