/*
 * Decompiled with CFR 0.152.
 */
package com.innovazione.bubbleshoot;

import com.innovazione.bubbleshoot.BmpWrap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;

public class BubbleManager {
    int bubblesLeft;
    BmpWrap[] bubbles;
    int[] countBubbles;

    public BubbleManager(BmpWrap[] bubbles) {
        this.bubbles = bubbles;
        this.countBubbles = new int[bubbles.length];
        this.bubblesLeft = 0;
    }

    public void saveState(DataOutputStream data) throws IOException {
        data.writeInt(this.bubblesLeft);
        data.writeInt(this.countBubbles.length);
        for (int i = 0; i < this.countBubbles.length; ++i) {
            data.writeInt(this.countBubbles[i]);
        }
    }

    public void restoreState(DataInputStream data) throws IOException {
        this.bubblesLeft = data.readInt();
        this.countBubbles = new int[data.readInt()];
        for (int i = 0; i < this.countBubbles.length; ++i) {
            this.countBubbles[i] = data.readInt();
        }
    }

    public void addBubble(BmpWrap bubble) {
        int n = this.findBubble(bubble);
        this.countBubbles[n] = this.countBubbles[n] + 1;
        ++this.bubblesLeft;
    }

    public void removeBubble(BmpWrap bubble) {
        int n = this.findBubble(bubble);
        this.countBubbles[n] = this.countBubbles[n] - 1;
        --this.bubblesLeft;
    }

    public int countBubbles() {
        return this.bubblesLeft;
    }

    public int nextBubbleIndex(Random rand) {
        int select = rand.nextInt() % this.bubbles.length;
        if (select < 0) {
            select = -select;
        }
        int count = -1;
        int position = -1;
        while (count != select) {
            if (++position == this.bubbles.length) {
                position = 0;
            }
            if (this.countBubbles[position] == 0) continue;
            ++count;
        }
        return position;
    }

    public BmpWrap nextBubble(Random rand) {
        return this.bubbles[this.nextBubbleIndex(rand)];
    }

    private int findBubble(BmpWrap bubble) {
        for (int i = 0; i < this.bubbles.length; ++i) {
            if (this.bubbles[i] != bubble) continue;
            return i;
        }
        return -1;
    }
}

