/*
 * Decompiled with CFR 0.152.
 */
package com.innovazione.bubbleshoot;

import com.innovazione.bubbleshoot.Sprite;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public abstract class GameScreen {
    private Vector sprites = new Vector();

    public final void saveSprites(DataOutputStream data, Vector savedSprites) throws IOException {
        data.writeInt(this.sprites.size());
        for (int i = 0; i < this.sprites.size(); ++i) {
            data.writeInt(((Sprite)this.sprites.elementAt(i)).getSavedId());
        }
    }

    public final void restoreSprites(DataInputStream data, Vector restoredSprites) throws IOException {
        this.sprites = new Vector();
        int numSprites = data.readInt();
        for (int i = 0; i < numSprites; ++i) {
            int spriteIdx = data.readInt();
            if (spriteIdx <= -1) continue;
            this.sprites.addElement(restoredSprites.elementAt(spriteIdx));
        }
    }

    public final void addSprite(Sprite sprite) {
        this.sprites.removeElement(sprite);
        this.sprites.addElement(sprite);
    }

    public final void removeSprite(Sprite sprite) {
        this.sprites.removeElement(sprite);
    }

    public final void spriteToBack(Sprite sprite) {
        this.sprites.removeElement(sprite);
        this.sprites.insertElementAt(sprite, 0);
    }

    public final void spriteToFront(Sprite sprite) {
        this.sprites.removeElement(sprite);
        this.sprites.addElement(sprite);
    }

    public void paint(Graphics g, double scale, int dx, int dy) {
        for (int i = 0; i < this.sprites.size(); ++i) {
            ((Sprite)this.sprites.elementAt(i)).paint(g, scale, dx, dy);
        }
    }

    public abstract boolean play(boolean var1, boolean var2, boolean var3, double var4, boolean var6, double var7, double var9, boolean var11, double var12);
}

