/*
 * Decompiled with CFR 0.152.
 */
package com.innovazione.bubbleshoot;

import com.innovazione.bubbleshoot.FrozenBubble;
import com.innovazione.bubbleshoot.SettingsManager;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class SoundManager
implements PlayerListener {
    public static final int SOUND_WON = 0;
    public static final int SOUND_LOST = 1;
    public static final int SOUND_LAUNCH = 2;
    public static final int SOUND_DESTROY = 3;
    public static final int SOUND_REBOUND = 4;
    public static final int SOUND_STICK = 5;
    public static final int SOUND_HURRY = 6;
    public static final int SOUND_NEWROOT = 7;
    public static final int SOUND_NOH = 8;
    private static final int NUM_SOUNDS = 9;
    private static final int MAX_LOADED_PLAYERS = 8;
    private static final int MAX_PLAYERS = SoundManager.supportsMixing() ? 3 : 1;
    private final Vector loadedPlayers = new Vector();
    private final Vector playing = new Vector();
    private final String[] resources = new String[9];
    static /* synthetic */ Class class$com$innovazione$bubbleshoot$SoundManager;

    public static boolean supportsMixing() {
        String s = System.getProperty("supports.mixing");
        return s != null && s.equalsIgnoreCase("true") && !FrozenBubble.isS60Phone();
    }

    public SoundManager() {
        this.resources[0] = "/sound/applause.wav";
        this.resources[1] = "/sound/lose.wav";
        this.resources[2] = "/sound/launch.wav";
        this.resources[3] = "/sound/destroy_group.wav";
        this.resources[4] = "/sound/rebound.wav";
        this.resources[5] = "/sound/stick.wav";
        this.resources[6] = "/sound/hurry.wav";
        this.resources[7] = "/sound/newroot_solo.wav";
        this.resources[8] = "/sound/noh.wav";
    }

    public final void playSound(int sound) {
        if (SettingsManager.isSoundOn()) {
            if (this.restart(sound)) {
                return;
            }
            Player player = null;
            InputStream stream = (class$com$innovazione$bubbleshoot$SoundManager == null ? (class$com$innovazione$bubbleshoot$SoundManager = SoundManager.class$("com.innovazione.bubbleshoot.SoundManager")) : class$com$innovazione$bubbleshoot$SoundManager).getResourceAsStream(this.resources[sound]);
            try {
                this.limitLoadedPlayers();
                player = Manager.createPlayer((InputStream)stream, (String)"audio/wav");
                player.realize();
                player.prefetch();
                player.addPlayerListener(null);
                this.start(sound, player);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanUp() {
        Vector vector = this.loadedPlayers;
        synchronized (vector) {
            while (!this.loadedPlayers.isEmpty()) {
                this.clean((SoundPlayer)this.loadedPlayers.firstElement());
            }
        }
    }

    public final void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("endOfMedia")) {
            this.stop(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean restart(int sound) {
        Vector vector = this.loadedPlayers;
        synchronized (vector) {
            for (int i = 0; i < this.loadedPlayers.size(); ++i) {
                SoundPlayer sp = (SoundPlayer)this.loadedPlayers.elementAt(i);
                if (sp.sound != sound) continue;
                this.loadedPlayers.removeElement(sp);
                this.loadedPlayers.addElement(sp);
                this.stop(sp.player);
                try {
                    sp.player.setMediaTime(0L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.start(sp.player);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void limitLoadedPlayers() {
        Vector vector = this.loadedPlayers;
        synchronized (vector) {
            try {
                while (this.loadedPlayers.size() >= 8) {
                    SoundPlayer sp = (SoundPlayer)this.loadedPlayers.firstElement();
                    this.clean(sp);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void start(int sound, Player player) {
        Vector vector = this.loadedPlayers;
        synchronized (vector) {
            this.loadedPlayers.addElement(new SoundPlayer(sound, player));
            this.start(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean(SoundPlayer sp) {
        Vector vector = this.loadedPlayers;
        synchronized (vector) {
            this.loadedPlayers.removeElement(sp);
            this.stop(sp.player);
            try {
                sp.player.deallocate();
                sp.player.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(Player player) {
        Vector vector = this.playing;
        synchronized (vector) {
            try {
                while (this.playing.size() >= MAX_PLAYERS) {
                    Player p = (Player)this.playing.firstElement();
                    this.playing.removeElementAt(0);
                    this.stop(p);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.playing.addElement(player);
            try {
                player.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(Player player) {
        Vector vector = this.playing;
        synchronized (vector) {
            this.playing.removeElement(player);
            try {
                if (player.getState() == 400) {
                    try {
                        player.stop();
                    }
                    catch (Exception e) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SoundPlayer {
        public final int sound;
        public final Player player;

        public SoundPlayer(int sound, Player player) {
            this.sound = sound;
            this.player = player;
        }
    }
}

