/*
 * Decompiled with CFR 0.152.
 */
package com.ratemyapp;

import com.ratemyapp.RateMyApp;
import com.ratemyapp.StorageHelper;
import java.util.Date;

class FeedbackHelper {
    public static final int FeedbackState_Inactive = 0;
    public static final int FeedbackState_Active = 1;
    public static final int FeedbackState_FirstReview = 2;
    public static final int FeedbackState_SecondReview = 3;
    public static final int FeedbackState_Feedback = 4;
    private StorageHelper storageHelper = null;
    private final String LaunchCountKey;
    private final String ReviewedKey;
    private final String LastLaunchDateKey;
    private int firstCount = 5;
    private int secondCount = 10;
    private boolean countDays = false;
    private int state;
    private int launchCount = 0;
    private boolean reviewed = false;
    private Date lastLaunchDate = new Date();
    private boolean reset = false;

    public FeedbackHelper() {
        this.LaunchCountKey = "RATE_MY_APP_LAUNCH_COUNT";
        this.ReviewedKey = "RATE_MY_APP_REVIEWED";
        this.LastLaunchDateKey = "RATE_MY_APP_LAST_LAUNCH_DATE";
        this.setState(1);
    }

    public Date getLastLaunchDate() {
        return this.lastLaunchDate;
    }

    public void setLastLaunchDate(Date value) {
        this.lastLaunchDate = value;
    }

    public boolean getIsReviewed() {
        return this.reviewed;
    }

    public void setIsReviewed(boolean value) {
        this.reviewed = value;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int value) {
        this.state = value;
    }

    public int getLaunchCount() {
        return this.launchCount;
    }

    public void setLaunchCount(int value) {
        this.launchCount = value;
    }

    public int getFirstCount() {
        return this.firstCount;
    }

    public void setFirstCount(int value) {
        this.firstCount = value;
    }

    public int getSecondCount() {
        return this.secondCount;
    }

    public void setSecondCount(int value) {
        this.secondCount = value;
    }

    public boolean getCountDays() {
        return this.countDays;
    }

    public void setCountDays(boolean value) {
        this.countDays = value;
    }

    public void launching() {
        if (this.state == 1) {
            this.loadState();
        }
    }

    public void reviewed() {
        this.setIsReviewed(true);
        this.storeState();
    }

    public void reset() {
        this.setLaunchCount(0);
        this.setIsReviewed(false);
        this.setLastLaunchDate(new Date());
        this.storeState();
    }

    public void loadState() {
        try {
            this.storageHelper = new StorageHelper();
            this.setLaunchCount(Integer.parseInt(this.storageHelper.getSetting("RATE_MY_APP_LAUNCH_COUNT"), 10));
            this.setIsReviewed(Integer.parseInt(this.storageHelper.getSetting("RATE_MY_APP_REVIEWED"), 10) == 1);
            this.setLastLaunchDate(new Date(Long.parseLong(this.storageHelper.getSetting("RATE_MY_APP_LAST_LAUNCH_DATE"))));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("FeedbackHelper.loadState - Failed to load state, Exception: " + e.getMessage());
        }
    }

    public void launch() {
        System.out.println("SETTINGS: " + this.getLaunchCount() + ", " + this.getIsReviewed() + ", " + this.getLastLaunchDate() + ", " + this.getFirstCount() + ", " + this.getSecondCount());
        long lastLaunchDay = this.getLastLaunchDate().getTime() / 86400000L;
        long thisLaunchDay = new Date().getTime() / 86400000L;
        if (!this.getIsReviewed()) {
            if (!this.getCountDays() || lastLaunchDay != thisLaunchDay) {
                this.setLaunchCount(this.getLaunchCount() + 1);
                this.setLastLaunchDate(new Date());
            }
            if (this.getLaunchCount() == this.getFirstCount()) {
                this.setState(2);
            } else if (this.getLaunchCount() == this.getSecondCount()) {
                this.setState(3);
            }
            new Thread(){

                public void run() {
                    FeedbackHelper.this.storeState();
                }
            }.start();
        }
    }

    private void storeState() {
        try {
            this.storageHelper.storeSetting("RATE_MY_APP_LAUNCH_COUNT", String.valueOf(this.getLaunchCount()), true);
            this.storageHelper.storeSetting("RATE_MY_APP_REVIEWED", String.valueOf(this.getIsReviewed() ? 1 : 0), true);
            this.storageHelper.storeSetting("RATE_MY_APP_LAST_LAUNCH_DATE", String.valueOf(this.lastLaunchDate.getTime()), true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("FeedbackHelper.storeState - Failed to store state, Exception: " + e.getMessage());
        }
    }

    public void review() throws Exception {
        RateMyApp.getInstance().getMIDlet().platformRequest("http://www.store.ovi.mobi/content/" + RateMyApp.getInstance().getAppID() + "/comments/add");
        this.reviewed();
    }
}

