/*
 * Decompiled with CFR 0.152.
 */
package com.ratemyapp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

class StorageHelper {
    private static final String RECORDSTORE_ID = "ratemyapp_settings";
    private Hashtable settings = null;
    private RecordStore recordStore = null;

    public StorageHelper() {
        try {
            this.loadSettings();
        }
        catch (Exception e) {
            this.settings = new Hashtable();
        }
    }

    public boolean storeSetting(String key, String value, boolean overwrite) throws Exception {
        byte[] valueBytes;
        block21: {
            if (this.settings.containsKey(key) && !overwrite) {
                return false;
            }
            valueBytes = null;
            ByteArrayOutputStream os = null;
            FilterOutputStream dos = null;
            try {
                try {
                    os = new ByteArrayOutputStream();
                    dos = new DataOutputStream(os);
                    ((DataOutputStream)dos).writeUTF(key);
                    ((DataOutputStream)dos).writeUTF(value);
                    valueBytes = os.toByteArray();
                }
                catch (Exception exception) {
                    try {
                        if (dos != null) {
                            dos.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        break block21;
                    }
                    catch (Exception exception2) {}
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (dos != null) {
                        dos.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (dos != null) {
                    dos.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (valueBytes != null) {
            this.startRecordStoreOperation();
            if (this.settings.containsKey(key)) {
                Setting setting = (Setting)this.settings.get(key);
                setting.setValue(value);
                this.recordStore.setRecord(setting.getRecordStoreID(), valueBytes, 0, valueBytes.length);
            } else {
                int recordStoreID = this.recordStore.addRecord(valueBytes, 0, valueBytes.length);
                this.settings.put(key, new Setting(recordStoreID, value));
            }
            this.finishRecordStoreOperation();
        }
        return true;
    }

    public String getSetting(String key) {
        if (this.settings.containsKey(key)) {
            return ((Setting)this.settings.get(key)).getValue();
        }
        return null;
    }

    public void removeSetting(String key) throws Exception {
        if (this.settings.containsKey(key)) {
            this.startRecordStoreOperation();
            this.recordStore.deleteRecord(((Setting)this.settings.get(key)).getRecordStoreID());
            this.finishRecordStoreOperation();
            this.settings.remove(key);
        }
    }

    private void loadSettings() throws Exception {
        this.settings = new Hashtable();
        this.startRecordStoreOperation();
        RecordEnumeration enumeration = this.recordStore.enumerateRecords(null, null, false);
        while (enumeration.hasNextElement()) {
            int recordStoreID = enumeration.nextRecordId();
            byte[] bytes = this.recordStore.getRecord(recordStoreID);
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(is);
            String key = dis.readUTF();
            String value = dis.readUTF();
            this.settings.put(key, new Setting(recordStoreID, value));
            dis.close();
            is.close();
        }
        this.finishRecordStoreOperation();
    }

    private void startRecordStoreOperation() throws Exception {
        this.recordStore = RecordStore.openRecordStore((String)RECORDSTORE_ID, (boolean)true);
    }

    private void finishRecordStoreOperation() throws Exception {
        this.recordStore.closeRecordStore();
    }

    private static class Setting {
        private int recordStoreID;
        private String value;

        public Setting(int recordStoreID, String value) {
            this.recordStoreID = recordStoreID;
            this.value = value;
        }

        public int getRecordStoreID() {
            return this.recordStoreID;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

