/*
 * Decompiled with CFR 0.152.
 */
import game.S;
import javax.microedition.lcdui.Image;

public class Ball {
    private boolean jump;
    private boolean fall;
    private boolean rb_fall;
    private boolean stop;
    private boolean[] vGBS;
    private int md;
    private int jd;
    private int jmd;
    private int x;
    private int y;
    private int bmx;
    private int bjx;
    private int bjy;
    private int bjmx;
    private int bfy;
    private int tw;
    private int th;
    private float j_speed;
    private float m_speed;
    private float rb;
    private float mspeed;
    private float jspeed;
    private float rb_speed;
    private float mt;
    private float jt;
    private float jmt;
    private float ft;
    private float jcs;
    private float jsn;
    private int[][][] sides;
    private int[][][] thorns_sides;
    private int[][][] fans_sides;
    private int[][][] gbs_sides;
    private long dtime;
    private Image[] d;
    private S ball;
    private Fan[] fans;
    private GlassBlock[] gbs;

    public Ball(S ball, float j_speed, float m_speed, float rb, int[][][] sides, int tw, int th) {
        this.ball = ball;
        this.j_speed = j_speed;
        this.m_speed = m_speed;
        this.rb = rb;
        this.sides = sides;
        this.tw = tw;
        this.th = th;
    }

    public void destroy(Image[] d) {
        this.d = d;
        this.dtime = System.currentTimeMillis();
    }

    public boolean destroying() {
        long time = System.currentTimeMillis() - this.dtime;
        if (time < 400L) {
            int bW = this.ball.getWidth();
            int bH = this.ball.getHeight();
            Image img = this.d[(int)(time / 50L)];
            this.ball.setImage(img, img.getWidth(), img.getHeight());
            this.ball.setPosition(this.ball.getX() + bW / 2 - this.ball.getWidth() / 2, this.ball.getY() + bH / 2 - this.ball.getHeight() / 2);
        } else {
            this.ball.setPosition(-this.ball.getWidth(), -this.ball.getHeight());
        }
        return time < 800L;
    }

    public void setThorns(int[][][] sides) {
        this.thorns_sides = sides;
    }

    public void setFans(Fan[] fans, int[][][] sides) {
        this.fans = fans;
        this.fans_sides = sides;
    }

    public void setGlassBlocks(GlassBlock[] gbs, int[][][] sides) {
        this.gbs = gbs;
        this.vGBS = new boolean[gbs.length];
        for (int i = 0; i < this.vGBS.length; ++i) {
            this.vGBS[i] = true;
        }
        this.gbs_sides = sides;
    }

    private boolean checkGlassBlocks(int x, int y) {
        for (int i = 0; i < this.gbs.length; ++i) {
            S gb = this.gbs[i].getGlassBlock();
            if (x == gb.getX() && y == gb.getY()) {
                this.gbs[i].crash();
                return true;
            }
            gb = null;
        }
        return false;
    }

    public void startMove(int d) {
        if (this.md == 0 && !this.jump) {
            this.mt = this.jmd != d ? 0.0f : this.jmt;
            this.bmx = this.jmd != d ? 0 : this.bjmx;
            this.mspeed = this.jmd != d ? this.m_speed : 0.0f;
            int n = this.md = this.jmd != d ? d : this.jmd;
            if (this.jmd != 0) {
                this.jmd = 0;
            }
        }
        if (this.jmd == 0 && this.jump) {
            this.jmt = 0.0f;
            this.bjmx = 0;
            this.jmd = d;
        }
    }

    public void updateMove(float t) {
        if (this.md != 0 && !this.jump) {
            if (!this.stop) {
                this.x = (int)((this.mspeed * this.mt + 9.8f * this.sqr(this.mt) / 2.0f) * 20.0f);
                this.mt += t;
                if (this.x != this.bmx) {
                    this.bmx = this.cLM(this.x, this.bmx, this.tw / 2);
                    this.ball.move(this.md == 1 ? -(this.x - this.bmx) : this.x - this.bmx, 0);
                }
                this.bmx = this.x;
            } else {
                this.x = (int)((this.mspeed * this.mt - 9.8f * this.sqr(this.mt) / 2.0f) * 20.0f);
                if (this.x >= this.bmx) {
                    this.mt += t;
                    if (this.x != this.bmx) {
                        this.bmx = this.cLM(this.x, this.bmx, this.tw / 2);
                        this.ball.move(this.md == 1 ? -(this.x - this.bmx) : this.x - this.bmx, 0);
                    }
                    this.bmx = this.x;
                } else {
                    this.stop = false;
                    this.md = 0;
                }
            }
            if (this.checkCollide(3)) {
                this.stopMove(1);
                this.mspeed *= this.rb;
                this.md = 2;
            }
            if (this.checkCollide(4)) {
                this.stopMove(2);
                this.mspeed *= this.rb;
                this.md = 1;
            }
        }
        if (this.jmd != 0 && this.jump) {
            this.x = (int)(9.8f * this.sqr(this.jmt) / 2.0f * 20.0f);
            this.jmt += t;
            if (this.x != this.bjmx) {
                this.bjmx = this.cLM(this.x, this.bjmx, this.tw / 2);
                this.ball.move(this.jmd == 1 ? -(this.x - this.bjmx) : this.x - this.bjmx, 0);
            }
            this.bjmx = this.x;
        }
    }

    public void stopMove(int d) {
        if (d == this.md && !this.jump) {
            this.mspeed += 9.8f * this.mt;
            this.mt = 0.0f;
            this.bmx = 0;
            this.stop = true;
        }
        if (d == this.jmd && this.jump) {
            this.jmd = 0;
        }
    }

    public void jump() {
        if (!(this.jump || this.fall || this.rb_fall)) {
            float angle = (float)Math.toRadians(this.md != 0 ? (this.mt < 1.0f ? (double)(90.0f - 22.5f * this.mt) : 67.5) : 90.0);
            this.jcs = (float)Math.cos(angle);
            this.jsn = (float)Math.sin(angle);
            this.jspeed = this.j_speed + (this.md != 0 && !this.stop ? (this.mt < 1.0f ? this.mt : 1.0f) : 0.0f);
            this.mt = 0.0f;
            this.jt = 0.0f;
            this.jd = this.md;
            if (this.md != 0) {
                this.md = 0;
            }
            this.jump = true;
        }
    }

    public void updateJump(float t) {
        if (this.jump && this.md == 0 && !this.fall && !this.rb_fall) {
            this.x = (int)(this.jspeed * this.jcs * this.jt * 100.0f);
            this.y = (int)((this.jspeed * this.jsn * this.jt - 9.8f * this.sqr(this.jt) / 2.0f) * 100.0f);
            this.jt += t;
            if (this.x != this.bjx) {
                this.bjx = this.cLM(this.x, this.bjx, this.tw / 2);
                this.ball.move(this.jd == 0 ? 0 : (this.jd == 1 ? -(this.x - this.bjx) : this.x - this.bjx), 0);
            }
            if (this.y != this.bjy) {
                this.bjy = this.cLM(this.y, this.bjy, this.th / 2);
                this.ball.move(0, -(this.y - this.bjy));
            }
            this.bjx = this.x;
            this.bjy = this.y;
            if (this.checkCollide(1)) {
                this.bjy = this.y;
                do {
                    this.y = (int)((this.jspeed * this.jsn * this.jt - 9.8f * this.sqr(this.jt) / 2.0f) * 100.0f);
                    this.jt += t;
                } while (this.y >= this.bjy);
                this.bjy = this.y;
                this.bjx = (int)(this.jspeed * this.jcs * this.jt * 100.0f);
            }
            if (this.checkCollide(2)) {
                this.bjx = 0;
                this.bjy = 0;
                this.jspeed = (float)Math.sqrt(this.sqr(this.jspeed * this.jcs) + this.sqr(this.jspeed * this.jsn - 9.8f * this.jt)) * this.rb;
                this.jt = 0.0f;
                if (this.sqr(this.jspeed) * this.sqr(this.jsn) / 19.6f * 100.0f < 1.0f / this.rb) {
                    this.jump = false;
                }
            }
            if (this.checkCollide(3)) {
                if (this.jmd != 0) {
                    this.jmt = 0.0f;
                    this.bjmx = 0;
                }
                this.jd = 2;
            }
            if (this.checkCollide(4)) {
                if (this.jmd != 0) {
                    this.jmt = 0.0f;
                    this.bjmx = 0;
                }
                this.jd = 1;
            }
        }
    }

    public void updateFall(float t) {
        if (!this.jump) {
            if (!this.fall && !this.rb_fall) {
                boolean fc = false;
                for (int i = 0; i < this.sides[1].length; ++i) {
                    if (this.ball.getY() < this.sides[1][i][0] - this.ball.getHeight() || this.ball.getY() >= this.sides[1][i][0] + this.th / 2 - this.ball.getHeight() / 2 || this.ball.getX() <= this.sides[1][i][1] - this.ball.getWidth() + 10 || this.ball.getX() >= this.sides[1][i][2] - 10) continue;
                    fc = true;
                }
                if (!fc) {
                    this.ft = 0.0f;
                    this.bfy = 0;
                    this.fall = true;
                }
            }
            if (this.fall) {
                this.y = (int)(9.8 * (double)this.sqr(this.ft) / 2.0 * 100.0);
                this.ft += t;
                if (this.y != this.bfy) {
                    this.bfy = this.cLM(this.y, this.bfy, this.th / 2);
                    this.ball.move(0, this.y - this.bfy);
                }
                this.bfy = this.y;
                if (this.checkCollide(2)) {
                    this.bfy = 0;
                    this.rb_speed = 9.8f * this.ft * this.rb;
                    this.ft = 0.0f;
                    this.fall = false;
                    this.rb_fall = true;
                }
            }
            if (this.rb_fall) {
                this.y = (int)(((double)(this.rb_speed * this.ft) - 9.8 * (double)this.sqr(this.ft) / 2.0) * 100.0);
                this.ft += t;
                if (this.y != this.bfy) {
                    this.bfy = this.cLM(this.y, this.bfy, this.th / 2);
                    this.ball.move(0, -(this.y - this.bfy));
                }
                this.bfy = this.y;
                if (this.checkCollide(1)) {
                    this.bfy = this.y;
                    do {
                        this.y = (int)((this.rb_speed * this.ft - 9.8f * this.sqr(this.ft) / 2.0f) * 100.0f);
                        this.ft += t;
                    } while (this.y >= this.bfy);
                    this.bfy = this.y;
                    if (this.md != 0) {
                        this.bmx = (int)((this.mspeed * this.mt + (!this.stop ? 9.8f : -9.8f) * (this.mt * this.mt) / 2.0f) * 20.0f);
                    }
                }
                if (this.checkCollide(2)) {
                    this.bfy = 0;
                    this.rb_speed = Math.abs(this.rb_speed - 9.8f * this.ft) * this.rb;
                    this.ft = 0.0f;
                    if (this.sqr(this.rb_speed) / 19.6f * 100.0f < 1.0f / this.rb) {
                        this.rb_fall = false;
                    }
                }
            }
            if (this.fall || this.rb_fall) {
                this.checkCollide(3);
                this.checkCollide(4);
            }
        }
    }

    public void updateFans(float t) {
        int bX = this.ball.getX() + this.ball.getWidth() / 2;
        int bY = this.ball.getY() + this.ball.getHeight() / 2;
        for (int i = 0; i < this.fans.length; ++i) {
            S fan = this.fans[i].getFan();
            int fX = fan.getX() + fan.getWidth() / 2;
            int fY = fan.getY() + fan.getHeight() / 2;
            switch (this.fans[i].getDirection()) {
                case 1: {
                    int dist;
                    if (bY >= fY - 45 && bY <= fY - fan.getHeight() / 2 && bX >= fX - 20 && bX <= fX + 20) {
                        dist = (int)(32.0f * this.fans[i].getTime() - 9.8f * this.sqr(this.fans[i].getTime()) / 2.0f);
                        if (dist >= this.fans[i].getBackDistance()) {
                            this.fans[i].setTime(this.fans[i].getTime() + t);
                            if (dist != this.fans[i].getBackDistance()) {
                                this.ball.move(0, -(dist - this.fans[i].getBackDistance()));
                            }
                            this.fans[i].setBackDistance(dist);
                        } else {
                            this.stop = false;
                            this.md = 0;
                            this.fans[i].setTime(0.0f);
                            this.fans[i].setBackDistance(0);
                        }
                        if (!this.stop) break;
                        this.md = 0;
                        this.stop = false;
                        this.fans[i].setTime(0.0f);
                        this.fans[i].setBackDistance(0);
                        break;
                    }
                    this.fans[i].setTime(0.0f);
                    this.fans[i].setBackDistance(0);
                    break;
                }
                case 2: {
                    int dist;
                    if (bY >= fY + fan.getHeight() / 2 && bY <= fY + 65 && bX >= fX - 20 && bX <= fX + 20) {
                        dist = (int)(96.0f * this.fans[i].getTime() - 9.8f * this.sqr(this.fans[i].getTime()) / 2.0f);
                        if (dist >= this.fans[i].getBackDistance()) {
                            this.fans[i].setTime(this.fans[i].getTime() + t);
                            if (dist != this.fans[i].getBackDistance()) {
                                this.ball.move(0, dist - this.fans[i].getBackDistance());
                            }
                            this.fans[i].setBackDistance(dist);
                        } else {
                            this.stop = false;
                            this.md = 0;
                            this.fans[i].setTime(0.0f);
                            this.fans[i].setBackDistance(0);
                        }
                        if (!this.stop) break;
                        this.md = 0;
                        this.stop = false;
                        this.fans[i].setTime(0.0f);
                        this.fans[i].setBackDistance(0);
                        break;
                    }
                    this.fans[i].setTime(0.0f);
                    this.fans[i].setBackDistance(0);
                    break;
                }
                case 3: {
                    int dist;
                    if (bX >= fX - 60 && bX <= fX - fan.getWidth() / 2 && bY >= fY - 15 && bY <= fY + 15) {
                        dist = (int)(36.0f * this.fans[i].getTime() - 9.8f * this.sqr(this.fans[i].getTime()) / 2.0f);
                        if (dist >= this.fans[i].getBackDistance()) {
                            this.fans[i].setTime(this.fans[i].getTime() + t);
                            if (dist != this.fans[i].getBackDistance()) {
                                this.ball.move(-(dist - this.fans[i].getBackDistance()), 0);
                            }
                            this.fans[i].setBackDistance(dist);
                        } else {
                            this.stop = false;
                            this.md = 0;
                            this.fans[i].setTime(0.0f);
                            this.fans[i].setBackDistance(0);
                        }
                        if (!this.stop) break;
                        this.md = 0;
                        this.stop = false;
                        this.fans[i].setTime(0.0f);
                        this.fans[i].setBackDistance(0);
                        break;
                    }
                    this.fans[i].setTime(0.0f);
                    this.fans[i].setBackDistance(0);
                    break;
                }
                case 4: {
                    int dist;
                    if (bX >= fX + fan.getWidth() / 2 && bX <= fX + 60 && bY >= fY - 15 && bY <= fY + 15) {
                        dist = (int)(36.0f * this.fans[i].getTime() - 9.8f * this.sqr(this.fans[i].getTime()) / 2.0f);
                        if (dist >= this.fans[i].getBackDistance()) {
                            this.fans[i].setTime(this.fans[i].getTime() + t);
                            if (dist != this.fans[i].getBackDistance()) {
                                this.ball.move(dist - this.fans[i].getBackDistance(), 0);
                            }
                            this.fans[i].setBackDistance(dist);
                        } else {
                            this.stop = false;
                            this.md = 0;
                            this.fans[i].setTime(0.0f);
                            this.fans[i].setBackDistance(0);
                        }
                        if (!this.stop) break;
                        this.md = 0;
                        this.stop = false;
                        this.fans[i].setTime(0.0f);
                        this.fans[i].setBackDistance(0);
                        break;
                    }
                    this.fans[i].setTime(0.0f);
                    this.fans[i].setBackDistance(0);
                }
            }
            fan = null;
        }
    }

    private boolean checkCollide(int d) {
        int j;
        for (j = 0; j < this.sides[d - 1].length; ++j) {
            if (!this.checkCollide(this.sides[d - 1][j], d)) continue;
            this.ball.setPosition((d <= 2 ? this.ball.getX() : this.sides[d - 1][j][0]) - (d == 4 ? this.ball.getWidth() : 0), (d >= 3 ? this.ball.getY() : this.sides[d - 1][j][0]) - (d == 2 ? this.ball.getHeight() : 0));
            return true;
        }
        for (j = 0; j < this.fans_sides[d - 1].length; ++j) {
            if (!this.checkCollide(this.fans_sides[d - 1][j], d)) continue;
            this.ball.setPosition((d <= 2 ? this.ball.getX() : this.fans_sides[d - 1][j][0]) - (d == 4 ? this.ball.getWidth() : 0), (d >= 3 ? this.ball.getY() : this.fans_sides[d - 1][j][0]) - (d == 2 ? this.ball.getHeight() : 0));
            return true;
        }
        if (d != 2) {
            for (j = 0; j < this.gbs_sides[d - 1].length; ++j) {
                if (!this.vGBS[j] || !this.checkCollide(this.gbs_sides[d - 1][j], d)) continue;
                this.ball.setPosition((d <= 2 ? this.ball.getX() : this.gbs_sides[d - 1][j][0]) - (d == 4 ? this.ball.getWidth() : 0), (d >= 3 ? this.ball.getY() : this.gbs_sides[d - 1][j][0]) - (d == 2 ? this.ball.getHeight() : 0));
                return true;
            }
        } else {
            for (j = 0; j < this.gbs_sides[d - 1].length; ++j) {
                if (!this.vGBS[j] || !this.checkCollide(this.gbs_sides[d - 1][j], d)) continue;
                this.ball.setPosition((d <= 2 ? this.ball.getX() : this.gbs_sides[d - 1][j][0]) - (d == 4 ? this.ball.getWidth() : 0), (d >= 3 ? this.ball.getY() : this.gbs_sides[d - 1][j][0]) - (d == 2 ? this.ball.getHeight() : 0));
                if (this.checkGlassBlocks(this.gbs_sides[d - 1][j][1], this.gbs_sides[d - 1][j][0])) {
                    this.vGBS[j] = false;
                }
                return true;
            }
        }
        if (d == 3 || d == 4) {
            for (j = 0; j < this.thorns_sides[d - 1].length; ++j) {
                if (this.ball.getX() <= (d == 3 ? this.thorns_sides[d - 1][j][0] - this.tw / 2 - this.ball.getWidth() / 2 : this.thorns_sides[d - 1][j][0] - this.ball.getWidth()) || this.ball.getX() >= (d == 3 ? this.thorns_sides[d - 1][j][0] : this.thorns_sides[d - 1][j][0] + this.tw / 2 - this.ball.getWidth() / 2) || this.ball.getY() <= this.thorns_sides[d - 1][j][1] - this.ball.getHeight() + 10 || this.ball.getY() >= this.thorns_sides[d - 1][j][2] - 10) continue;
                this.ball.setPosition(this.thorns_sides[d - 1][j][0] - (d == 4 ? this.ball.getWidth() : 0), this.ball.getY());
                return true;
            }
        }
        return false;
    }

    private boolean checkCollide(int[] side, int p) {
        if (p == 1 || p == 2) {
            return this.ball.getY() > (p == 1 ? side[0] - this.th / 2 - this.ball.getHeight() / 2 : side[0] - this.ball.getHeight()) && this.ball.getY() < (p == 1 ? side[0] : side[0] + this.th / 2 - this.ball.getHeight() / 2) && this.ball.getX() > side[1] - this.ball.getWidth() + 10 && this.ball.getX() < side[2] - 10;
        }
        if (p == 3 || p == 4) {
            return this.ball.getX() > (p == 3 ? side[0] - this.tw / 2 - this.ball.getWidth() / 2 : side[0] - this.ball.getWidth()) && this.ball.getX() < (p == 3 ? side[0] : side[0] + this.tw / 2 - this.ball.getWidth() / 2) && this.ball.getY() > side[1] - this.ball.getHeight() + 5 && this.ball.getY() < side[2] - 5;
        }
        return false;
    }

    private float sqr(float n) {
        return n * n;
    }

    private int cLM(int p, int bp, int dlong) {
        if (Math.abs(p - bp) > dlong) {
            if (p > bp) {
                return p - dlong;
            }
            if (p < bp) {
                return p + dlong;
            }
        }
        return bp;
    }
}

