/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DrawFont {
    private char[] cnums;
    private char[] cbfont;
    private char[] csfont;
    private Image[] nums;
    private Image[] bfont;
    private Image[] sfont;

    public DrawFont(Image nums, Image bfont, Image sfont) {
        Object[] objs = this.loadFont(nums, "nfont.dat");
        this.cnums = (char[])objs[0];
        this.nums = (Image[])objs[1];
        objs = this.loadFont(bfont, Localization.getLocaleAsString() + "_bfont.dat");
        this.cbfont = (char[])objs[0];
        this.bfont = (Image[])objs[1];
        objs = this.loadFont(sfont, Localization.getLocaleAsString() + "_sfont.dat");
        this.csfont = (char[])objs[0];
        this.sfont = (Image[])objs[1];
    }

    private Object[] loadFont(Image font, String path) {
        int p2;
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("/resources/" + path));
        String data = "";
        try {
            int ch;
            while ((ch = dis.readUnsignedByte()) != -1) {
                data = data + (char)ch;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        dis = null;
        Vector<String> vector = new Vector<String>();
        int p1 = 0;
        while ((p2 = data.indexOf("\r\n", p1)) != -1) {
            vector.addElement(data.substring(p1, p2));
            p1 = p2 + 2;
        }
        data = null;
        char[] chars = new char[vector.size()];
        Image[] imgs = new Image[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            String s = (String)vector.elementAt(i);
            chars[i] = s.charAt(0);
            imgs[i] = Image.createImage((Image)font, (int)Integer.parseInt(s.substring(s.indexOf(45) + 1, s.indexOf(45, s.indexOf(45) + 1))), (int)0, (int)Integer.parseInt(s.substring(s.indexOf(45, s.indexOf(45) + 1) + 1)), (int)font.getHeight(), (int)0);
        }
        vector = null;
        return new Object[]{chars, imgs};
    }

    public int getHeight() {
        return 33;
    }

    public int stringWidth(String s) {
        int width = 0;
        for (int i = 0; i < s.length(); ++i) {
            int j;
            char ch = this.check(s.charAt(i));
            if (ch == ' ') {
                width += 7;
                continue;
            }
            for (j = 0; j < this.nums.length; ++j) {
                if (ch != this.cnums[j]) continue;
                width += this.nums[j].getWidth() + 3;
            }
            for (j = 0; j < this.bfont.length; ++j) {
                if (ch != this.cbfont[j]) continue;
                width += this.bfont[j].getWidth() + (j == 5 ? -3 : 2);
            }
            for (j = 0; j < this.sfont.length; ++j) {
                if (ch != this.csfont[j]) continue;
                width += this.sfont[j].getWidth() + 2;
            }
        }
        return width;
    }

    public void drawString(Graphics g, int x, int y, String s) {
        for (int i = 0; i < s.length(); ++i) {
            int j;
            char ch = this.check(s.charAt(i));
            if (ch == ' ') {
                x += 7;
                continue;
            }
            for (j = 0; j < this.nums.length; ++j) {
                if (ch != this.cnums[j]) continue;
                g.drawImage(this.nums[j], x, y, 20);
                x += this.nums[j].getWidth() + 3;
            }
            for (j = 0; j < this.bfont.length; ++j) {
                if (ch != this.cbfont[j]) continue;
                g.drawImage(this.bfont[j], x, y, 20);
                x += this.bfont[j].getWidth() + (j == 5 ? -3 : 2);
            }
            for (j = 0; j < this.sfont.length; ++j) {
                if (ch != this.csfont[j]) continue;
                g.drawImage(this.sfont[j], x, y, 20);
                x += this.sfont[j].getWidth() + 2;
            }
        }
    }

    private char check(char charCode) {
        if (charCode >= '\u0410' && charCode <= '\u044f') {
            charCode = (char)(charCode - 848);
        }
        return charCode;
    }
}

