/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DrawText {
    private boolean wAlpha = false;
    private int color;
    private int tY;
    private int hText;
    private int scrolling;
    private int[] clip = new int[4];
    private int[] back_clip = new int[4];
    private float dist;
    private String[] fText;
    private Image[] font;

    public void loadFont(Image iFont) {
        int[][] pFont = this.getFontPoints();
        this.font = new Image[pFont.length];
        for (int i = 0; i < this.font.length; ++i) {
            this.font[i] = Image.createImage((Image)iFont, (int)pFont[i][0], (int)0, (int)pFont[i][1], (int)14, (int)0);
        }
        pFont = null;
        iFont = null;
    }

    private int[][] getFontPoints() {
        int p2;
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("/resources/" + Localization.getLocaleAsString() + "_font.dat"));
        String sPoints = "";
        try {
            int ch;
            while ((ch = dis.readUnsignedByte()) != -1) {
                sPoints = sPoints + (char)ch;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        dis = null;
        Vector<String> vector = new Vector<String>();
        int p1 = 0;
        while ((p2 = sPoints.indexOf("\r\n", p1)) != -1) {
            vector.addElement(sPoints.substring(p1, p2));
            p1 = p2 + 2;
        }
        sPoints = null;
        int[][] points = new int[vector.size()][2];
        for (int i = 0; i < points.length; ++i) {
            String point = (String)vector.elementAt(i);
            int p = point.indexOf(45);
            points[i][0] = Integer.parseInt(point.substring(0, p));
            points[i][1] = Integer.parseInt(point.substring(p + 1));
            point = null;
        }
        vector = null;
        return points;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setColorWithAlpha(boolean b) {
        this.wAlpha = b;
    }

    public void drawString(Graphics g, int x, int y, String string) {
        for (int i = 0; i < string.length(); ++i) {
            int charCode = this.checkCharCode(string.charAt(i));
            int[] argb = new int[this.font[charCode].getWidth() * this.font[charCode].getHeight()];
            this.font[charCode].getRGB(argb, 0, this.font[charCode].getWidth(), 0, 0, this.font[charCode].getWidth(), this.font[charCode].getHeight());
            for (int j = 0; j < argb.length; ++j) {
                argb[j] = this.wAlpha ? (int)((float)(argb[j] >> 24 & 0xFF) / 255.0f * (float)(this.color >> 24 & 0xFF)) << 24 | 0xFFFFFF : (argb[j] >> 24 & 0xFF) << 24 | this.color;
            }
            g.drawRGB(argb, 0, this.font[charCode].getWidth(), x, y, this.font[charCode].getWidth(), this.font[charCode].getHeight(), true);
            argb = null;
            x += this.font[charCode].getWidth() + 1;
        }
    }

    private int checkCharCode(int charCode) {
        if (charCode >= 32 && charCode <= 126) {
            charCode -= 32;
        }
        if (charCode >= 192 && charCode <= 255) {
            charCode -= 97;
        }
        if (charCode >= 1040 && charCode <= 1103) {
            charCode -= 945;
        }
        return charCode;
    }

    public int stringWidth(String string) {
        int width = 0;
        for (int i = 0; i < string.length(); ++i) {
            width += this.font[this.checkCharCode(string.charAt(i))].getWidth() + (i < string.length() - 1 ? 1 : 0);
        }
        return width;
    }

    public void setText(String text, int x, int y, int width, int height) {
        this.clip[0] = x;
        this.clip[1] = y;
        this.clip[2] = width;
        this.clip[3] = height;
        if (this.tY != 0) {
            this.tY = 0;
        }
        this.format(text, width);
    }

    public int setText(String text, int x, int y, int width) {
        this.clip[0] = x;
        this.clip[1] = y;
        this.clip[2] = width;
        if (this.tY != 0) {
            this.tY = 0;
        }
        this.format(text, width);
        this.clip[3] = this.hText;
        return this.clip[3];
    }

    private void format(String text, int width) {
        int i;
        int p2;
        if (this.fText != null) {
            this.fText = null;
        }
        Vector<String> pVector = new Vector<String>();
        int p1 = 0;
        while ((p2 = text.indexOf(10, p1)) != -1) {
            pVector.addElement(this.substring(text, p1, p2));
            p1 = p2 + 1;
        }
        if (p1 < text.length() - 1) {
            pVector.addElement(this.substring(text, p1));
        }
        Vector<String> fVector = new Vector<String>();
        for (i = 0; i < pVector.size(); ++i) {
            String line = (String)pVector.elementAt(i);
            if (line.length() > 0) {
                if (line.charAt(line.length() - 1) != ' ') {
                    line = line + ' ';
                }
                p1 = 0;
                int p = 0;
                while ((p2 = line.indexOf(32, p1)) != -1) {
                    if (this.stringWidth(this.substring(line, p, p2)) > width) {
                        fVector.addElement(this.substring(line, p, p1));
                        p = p1;
                    }
                    p1 = p2 + 1;
                }
                if (p < line.length() - 1) {
                    fVector.addElement(this.substring(line, p));
                }
            } else {
                fVector.addElement(line);
            }
            line = null;
        }
        pVector = null;
        this.hText = fVector.size() * 14;
        this.fText = new String[fVector.size()];
        for (i = 0; i < fVector.size(); ++i) {
            this.fText[i] = (String)fVector.elementAt(i);
        }
        fVector = null;
    }

    public String[] getArray() {
        return this.fText;
    }

    private String substring(String string, int p) {
        return string.substring(p);
    }

    private String substring(String string, int p1, int p2) {
        return string.substring(p1, p2);
    }

    public void drawText(Graphics g, boolean setClip) {
        if (setClip) {
            this.getClip(g);
        }
        g.setColor(0);
        if (setClip) {
            g.setClip(this.clip[0], this.clip[1], this.clip[2], this.clip[3]);
        }
        for (int i = 0; i < this.fText.length; ++i) {
            int Y;
            if (this.fText[i].length() <= 0 || (Y = this.clip[1] + (this.hText < this.clip[3] ? this.clip[3] / 2 - this.hText / 2 : this.tY) + i * 14) < this.clip[1] || Y >= this.clip[1] + this.clip[3]) continue;
            this.drawString(g, this.clip[0] + this.clip[2] / 2 - this.stringWidth(this.fText[i]) / 2, Y, this.fText[i]);
        }
        if (setClip) {
            this.setClip(g);
        }
    }

    public void setY(int i) {
        this.tY = i;
    }

    public int getY() {
        return this.tY;
    }

    public int getHText() {
        return this.hText;
    }

    private void getClip(Graphics g) {
        this.back_clip[0] = g.getClipX();
        this.back_clip[1] = g.getClipY();
        this.back_clip[2] = g.getClipWidth();
        this.back_clip[3] = g.getClipHeight();
    }

    private void setClip(Graphics g) {
        g.setClip(this.back_clip[0], this.back_clip[1], this.back_clip[2], this.back_clip[3]);
    }
}

