/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class MLoader {
    private int quantity;
    private ByteArrayInputStream bais;
    private Hashtable hashtable;

    public MLoader(String path, int level) {
        this.loadMaps(path);
        this.quantity = this.bais.read();
        int size = -1;
        int nLevel = 1;
        while ((size = this.getValue(3)) > 0) {
            if (nLevel == level) {
                this.getMap();
                break;
            }
            this.bais.skip(size);
            ++nLevel;
        }
        this.bais = null;
    }

    public MLoader(byte[] data) {
        this.bais = new ByteArrayInputStream(data);
        data = null;
        this.getMap();
        this.bais = null;
    }

    public int quantity() {
        return this.quantity;
    }

    private void getMap() {
        this.hashtable = new Hashtable();
        this.bais.skip(this.getValue(1));
        int[] lWH = new int[]{this.getValue(1), this.getValue(1)};
        this.hashtable.put("wh", lWH);
        int[][] tiles = new int[lWH[1]][lWH[0]];
        for (int i = 0; i < lWH[1]; ++i) {
            for (int j = 0; j < lWH[0]; ++j) {
                tiles[i][j] = this.getValue(1);
            }
        }
        lWH = null;
        this.hashtable.put("tiles", tiles);
        tiles = null;
        int[] lTime = new int[]{this.getValue(1), this.getValue(1)};
        this.hashtable.put("time", lTime);
        lTime = null;
        this.hashtable.put("points", "" + this.getValue(2));
    }

    private void loadMaps(String path) {
        InputStream is = this.getClass().getResourceAsStream(path);
        byte[] data = null;
        try {
            data = new byte[is.available()];
            is.read(data);
            is.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        is = null;
        this.bais = new ByteArrayInputStream(Encode.encode(data));
        data = null;
    }

    public Object get(String key) {
        return this.hashtable.get(key);
    }

    private int getValue(int d) {
        switch (d) {
            case 1: {
                return this.bais.read();
            }
            case 2: {
                return this.bais.read() * 256 + this.bais.read();
            }
            case 3: {
                return this.bais.read() * 65536 + this.bais.read() * 256 + this.bais.read();
            }
        }
        return 0;
    }
}

