/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MapList {
    private boolean wasMotion;
    private int sWidth;
    private int sHeight;
    private int cIndex;
    private int lHeight;
    private int lMax;
    private String[] list;
    private Image bg;
    private Image board;
    private Image title;
    private Image[] button;
    private Image[] button_long1;
    private Image[] button_long2;
    private Button m_create;
    private Button m_start;
    private Button m_back;
    private Button m_edit;
    private Button m_delete;
    private DrawText dt;
    private ScrollBar scrollBar;

    public MapList(int sWidth, int sHeight, String[] list, Image bg, Image board, Image title, Image[] button, Image[] button_long1, Image[] button_long2, DrawText dt) {
        this.sWidth = sWidth;
        this.sHeight = sHeight;
        this.list = list;
        this.bg = bg;
        this.board = board;
        this.title = title;
        this.button = button;
        this.button_long1 = button_long1;
        this.button_long2 = button_long2;
        this.dt = dt;
        this.lHeight = 22;
        this.lMax = 220 - title.getHeight();
        if (list.length * this.lHeight > this.lMax) {
            this.scrollBar = new ScrollBar(22, 30 + title.getHeight(), sWidth - 48, this.lMax, list.length * this.lHeight - this.lMax, list.length * this.lHeight, false);
        }
        this.m_create = new Button();
        this.m_start = new Button();
        this.m_back = new Button();
        this.m_edit = new Button();
        this.m_delete = new Button();
    }

    public Button getCreateButton() {
        return this.m_create;
    }

    public Button getStartButton() {
        return this.m_start;
    }

    public Button getBackButton() {
        return this.m_back;
    }

    public Button getEditButton() {
        return this.m_edit;
    }

    public Button getDeleteButton() {
        return this.m_delete;
    }

    public int getlMax() {
        return this.lMax;
    }

    public int getCurrentIndex() {
        return this.cIndex;
    }

    public void rebuild(String[] list) {
        this.list = list;
        if (this.cIndex < 0) {
            this.cIndex = 0;
        }
        if (this.cIndex > list.length - 1) {
            this.cIndex = list.length - 1;
        }
    }

    public boolean check(float fps_time, int pKey, int dKey, int pX, int pY, int rX, int rY, int dX, int dY) {
        int lY;
        int n = lY = this.scrollBar == null ? 0 : -this.scrollBar.getValue();
        if (pKey == -1 || pKey == 50 || pKey == 116) {
            if (this.cIndex > 0) {
                --this.cIndex;
                if (lY + this.lHeight * this.cIndex < 0 && this.scrollBar != null) {
                    this.scrollBar.setValue(this.scrollBar.getValue() - this.lHeight);
                }
            }
            if (this.scrollBar != null) {
                if (lY + this.lHeight * this.cIndex < 0) {
                    this.cIndex = -lY / this.lHeight;
                }
                if (lY + this.cIndex * this.lHeight > this.lMax) {
                    this.cIndex = (-lY + this.lMax) / this.lHeight;
                }
            }
        }
        if (pKey == -2 || pKey == 56 || pKey == 98) {
            if (this.cIndex < this.list.length - 1) {
                ++this.cIndex;
                if (lY + this.lHeight * this.cIndex > lY + this.lMax - this.lHeight && this.scrollBar != null) {
                    this.scrollBar.setValue(this.scrollBar.getValue() + this.lHeight);
                }
            }
            if (this.scrollBar != null) {
                if (lY + this.lHeight * this.cIndex < 0) {
                    this.cIndex = -lY / this.lHeight;
                }
                if (lY + this.cIndex * this.lHeight > this.lMax) {
                    this.cIndex = (-lY + this.lMax) / this.lHeight;
                }
            }
        }
        for (int i = 0; i < this.list.length; ++i) {
            if (!Wand.region(rX, rY, 26, 30 + this.title.getHeight() + lY + i * this.lHeight, this.sWidth - 56, this.lHeight) || this.wasMotion || rY < 30 + this.title.getHeight() || rY >= 30 + this.title.getHeight() + this.lMax) continue;
            if (this.cIndex != i) {
                this.cIndex = i;
                continue;
            }
            return true;
        }
        if (!this.wasMotion) {
            if (Wand.isAction(dX, dY)) {
                this.wasMotion = true;
            }
        } else if (Wand.isAction(rX, rY)) {
            this.wasMotion = false;
        }
        if (this.scrollBar != null) {
            this.scrollBar.pCheck(fps_time, dKey, pX, pY, rX, rY, dX, dY);
        }
        return false;
    }

    public void paint(Graphics g) {
        g.drawImage(this.bg, 0, 0, 20);
        g.drawImage(this.board, 20, 10, 20);
        if (this.list.length > 0) {
            g.drawImage(this.title, this.sWidth / 2 - this.title.getWidth() / 2, 20, 20);
            this.dt.setColor(0xFFFFFF);
            this.dt.drawString(g, this.sWidth / 2 - this.dt.stringWidth(Localization.getAloneText(64)) / 2, 20 + this.title.getHeight() / 2 - 7, Localization.getAloneText(64));
        }
        g.setClip(22, 30 + this.title.getHeight(), this.sWidth - 44, this.lMax);
        g.setColor(0x999999);
        int lY = this.scrollBar == null ? 0 : -this.scrollBar.getValue();
        for (int i = 0; i < this.list.length; ++i) {
            if (i == this.cIndex) {
                this.dt.setColor(0xE0E0E0);
                g.fillRect(40, 30 + this.title.getHeight() + lY + i * this.lHeight, this.sWidth - 80, this.lHeight);
            } else {
                this.dt.setColor(0);
            }
            this.dt.drawString(g, this.sWidth / 2 - this.dt.stringWidth(this.list[i]) / 2, 30 + this.title.getHeight() + lY + i * this.lHeight + this.lHeight / 2 - 7, this.list[i]);
        }
        this.dt.setColor(0xE0E0E0);
        if (this.list.length == 0) {
            String sign = Localization.getAloneText(0);
            this.dt.drawString(g, this.sWidth / 2 - this.dt.stringWidth(sign) / 2, 20 + this.lMax / 2 - 7, sign);
            sign = null;
        }
        g.setClip(0, 0, this.sWidth, this.sHeight);
        switch (Localization.getLocale()) {
            case 0: {
                String string = Localization.getAloneText(1);
                this.m_create.paint(g, 10 + this.dt.stringWidth(string) / 2 - this.button_long1[0].getWidth() / 2, this.sHeight - 24 + 7 - this.button_long1[0].getHeight() / 2 + 4, this.button_long1);
                this.m_edit.paint(g, this.sWidth / 2 - this.button_long1[0].getWidth() / 2, 28 + this.title.getHeight() + this.lMax + (this.sHeight - this.lMax - 44 - this.title.getHeight()) / 2 - 3 + 7 - this.button_long1[0].getHeight() / 2, this.button_long1);
                this.m_start.paint(g, this.sWidth / 2 - this.button_long1[0].getWidth() / 2, this.sHeight - 24 + 7 - this.button_long1[0].getHeight() / 2 + 4, this.button_long1);
                string = Localization.getAloneText(4);
                this.m_delete.paint(g, this.sWidth - this.dt.stringWidth(string) - 2 + this.dt.stringWidth(string) / 2 - this.button_long2[0].getWidth() / 2 - 5, 28 + this.title.getHeight() + this.lMax + (this.sHeight - this.lMax - 44 - this.title.getHeight()) / 2 - 3 + 7 - this.button_long2[0].getHeight() / 2, this.button_long2);
                string = Localization.getAloneText(5);
                this.m_back.paint(g, this.sWidth - this.dt.stringWidth(string) - 10 + this.dt.stringWidth(string) / 2 - this.button[0].getWidth() / 2, this.sHeight - 24 + 7 - this.button[0].getHeight() / 2 + 4, this.button);
                break;
            }
            case 1: {
                String string1 = Localization.getAloneText(1);
                this.m_create.paint(g, 10 + this.dt.stringWidth(string1) / 2 - this.button_long1[0].getWidth() / 2, this.sHeight - 24 + 7 - this.button_long1[0].getHeight() / 2 + 4, this.button_long1);
                this.m_edit.paint(g, this.sWidth / 2 - this.button_long2[0].getWidth() / 2, 28 + this.title.getHeight() + this.lMax + (this.sHeight - this.lMax - 44 - this.title.getHeight()) / 2 - 3 + 7 - this.button_long2[0].getHeight() / 2, this.button_long2);
                this.m_start.paint(g, this.sWidth / 2 - this.button_long2[0].getWidth() / 2, this.sHeight - 24 + 7 - this.button_long2[0].getHeight() / 2 + 4, this.button_long2);
                string1 = Localization.getAloneText(4);
                this.m_delete.paint(g, this.sWidth - this.dt.stringWidth(string1) - 2 + this.dt.stringWidth(string1) / 2 - this.button_long2[0].getWidth() / 2, 28 + this.title.getHeight() + this.lMax + (this.sHeight - this.lMax - 44 - this.title.getHeight()) / 2 - 3 + 7 - this.button_long2[0].getHeight() / 2, this.button_long2);
                string1 = Localization.getAloneText(5);
                this.m_back.paint(g, this.sWidth - this.dt.stringWidth(string1) - 10 + this.dt.stringWidth(string1) / 2 - this.button[0].getWidth() / 2, this.sHeight - 24 + 7 - this.button[0].getHeight() / 2 + 4, this.button);
            }
        }
        String string = Localization.getAloneText(1);
        this.dt.drawString(g, 10, this.sHeight - 20, string);
        string = null;
        string = Localization.getAloneText(2);
        this.dt.drawString(g, this.sWidth / 2 - this.dt.stringWidth(string) / 2, 28 + this.title.getHeight() + this.lMax + (this.sHeight - this.lMax - 44 - this.title.getHeight()) / 2 - 3, string);
        string = null;
        string = Localization.getAloneText(3);
        this.dt.drawString(g, this.sWidth / 2 - this.dt.stringWidth(string) / 2, this.sHeight - 20, string);
        string = null;
        string = Localization.getAloneText(4);
        this.dt.drawString(g, this.sWidth - this.dt.stringWidth(string) - (Localization.getLocale() == 0 ? 7 : 2), 28 + this.title.getHeight() + this.lMax + (this.sHeight - this.lMax - 44 - this.title.getHeight()) / 2 - 3, string);
        string = null;
        string = Localization.getAloneText(5);
        this.dt.drawString(g, this.sWidth - this.dt.stringWidth(string) - 10, this.sHeight - 20, string);
        if (this.scrollBar != null) {
            this.scrollBar.paint(g);
        }
    }
}

