/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class RMS {
    private static final String[] diff = new String[]{"EASY", "NORMAL", "HARD"};

    public boolean beContinued() {
        String[] list = RecordStore.listRecordStores();
        return list != null && list.length != 0;
    }

    public int getGameLevel(int[] rms) {
        return rms[4] == 1 ? rms[0] : (rms[4] == 2 ? rms[9] : rms[10]);
    }

    public void setGameLevel(int[] rms, int l) {
        this.setGameVar(l, rms[4] == 1 ? 0 : (rms[4] == 2 ? 9 : 10));
    }

    public boolean isPassed(int[] rms) {
        return rms[rms[4] == 1 ? 2 : (rms[4] == 2 ? 11 : 12)] == 1;
    }

    public void setPassed(int[] rms) {
        this.setGameVar(1, rms[4] == 1 ? 2 : (rms[4] == 2 ? 11 : 12));
    }

    public int[] getGameData() {
        int[] rms = null;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"GAME", (boolean)true);
            if (rs.getNumRecords() == 0) {
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("2".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
            }
            rms = new int[rs.getNumRecords()];
            for (int i = 0; i < rms.length; ++i) {
                rms[i] = Integer.parseInt(new String(rs.getRecord(i + 1)));
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return rms;
    }

    public float[] getBallData() {
        float[] rms = null;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"BALL", (boolean)true);
            if (rs.getNumRecords() == 0) {
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("4".getBytes(), 0, 1);
                rs.addRecord("60".getBytes(), 0, 2);
            }
            rms = new float[rs.getNumRecords()];
            for (int i = 0; i < rms.length; ++i) {
                rms[i] = Float.parseFloat(new String(rs.getRecord(i + 1)));
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return rms;
    }

    public void setGameVar(int var, int index) {
        byte[] temp_var = ("" + var).getBytes();
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"GAME", (boolean)true);
            if (rs.getNumRecords() == 0) {
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("2".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
            }
            rs.setRecord(index + 1, temp_var, 0, temp_var.length);
            rs.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            // empty catch block
        }
    }

    public void setGameVars(int[][] iValues) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"GAME", (boolean)true);
            if (rs.getNumRecords() == 0) {
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("2".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("0".getBytes(), 0, 1);
            }
            for (int i = 0; i < iValues.length; ++i) {
                byte[] temp_var = ("" + iValues[i][1]).getBytes();
                rs.setRecord(iValues[i][0] + 1, temp_var, 0, temp_var.length);
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void setBallVar(float var, int index) {
        String temp_var = "" + ((double)var + 0.01);
        int p = temp_var.indexOf(46);
        if (temp_var.length() - p - 1 > 1) {
            temp_var = temp_var.substring(0, p + 2);
        }
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"BALL", (boolean)true);
            if (rs.getNumRecords() == 0) {
                rs.addRecord("1".getBytes(), 0, 1);
                rs.addRecord("4".getBytes(), 0, 1);
                rs.addRecord("60".getBytes(), 0, 2);
            }
            rs.setRecord(index + 1, temp_var.getBytes(), 0, temp_var.length());
            rs.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            // empty catch block
        }
    }

    public int[][] getRecords(int d) {
        boolean sort;
        int i;
        int[][] records = null;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)("RECORDS_" + diff[d]), (boolean)true);
            records = new int[rs.getNumRecords() / 3][3];
            for (i = 0; i < records.length; ++i) {
                for (int j = 0; j < 3; ++j) {
                    records[i][j] = Integer.parseInt(new String(rs.getRecord(i * 3 + j + 1)));
                }
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            // empty catch block
        }
        do {
            sort = false;
            for (i = 0; i < records.length - 1; ++i) {
                if (records[i][1] <= records[i + 1][1]) continue;
                int[] record = records[i];
                records[i] = records[i + 1];
                records[i + 1] = record;
                record = null;
                sort = true;
            }
        } while (sort);
        return records;
    }

    public void upRecord(int d, int level, long time, int points) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)("RECORDS_" + diff[d]), (boolean)true);
            boolean addRecord = false;
            for (int i = 1; i <= rs.getNumRecords(); i += 3) {
                if (Integer.parseInt(new String(rs.getRecord(i))) != level) continue;
                if (time < (long)Integer.parseInt(new String(rs.getRecord(i + 1)))) {
                    rs.setRecord(i + 1, ("" + time).getBytes(), 0, ("" + time).length());
                }
                if (points > Integer.parseInt(new String(rs.getRecord(i + 2)))) {
                    rs.setRecord(i + 2, ("" + points).getBytes(), 0, ("" + points).length());
                }
                addRecord = true;
                break;
            }
            if (!addRecord) {
                rs.addRecord(("" + level).getBytes(), 0, ("" + level).length());
                rs.addRecord(("" + time).getBytes(), 0, ("" + time).length());
                rs.addRecord(("" + points).getBytes(), 0, ("" + points).length());
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            // empty catch block
        }
    }

    public String[] getLevelList() {
        String[] list = null;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"LEVELS", (boolean)true);
            list = new String[rs.getNumRecords() / 2];
            for (int i = 0; i < list.length; ++i) {
                list[i] = new String(rs.getRecord(i * 2 + 1));
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return list;
    }

    public byte[] getLevel(int index) {
        byte[] level = null;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"LEVELS", (boolean)true);
            level = rs.getRecord(index * 2 + 2);
            rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return level;
    }

    public void putLevel(String name, byte[] level) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"LEVELS", (boolean)true);
            rs.addRecord(name.getBytes(), 0, name.length());
            rs.addRecord(level, 0, level.length);
            rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void updateLevel(int index, byte[] level) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"LEVELS", (boolean)true);
            rs.setRecord(index * 2 + 2, level, 0, level.length);
            rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void deleteLevel(int index) {
        RecordStore rs = null;
        try {
            int i;
            rs = RecordStore.openRecordStore((String)"LEVELS", (boolean)true);
            Object name = new byte[rs.getNumRecords() / 2][];
            Object level = new byte[((byte[][])name).length][];
            for (i = 0; i < ((byte[][])level).length; ++i) {
                name[i] = rs.getRecord(i * 2 + 1);
                level[i] = rs.getRecord(i * 2 + 2);
            }
            rs.closeRecordStore();
            RecordStore.deleteRecordStore((String)"LEVELS");
            rs = RecordStore.openRecordStore((String)"LEVELS", (boolean)true);
            for (i = 0; i < ((byte[][])level).length; ++i) {
                if (i == index) continue;
                rs.addRecord(name[i], 0, name[i].length);
                rs.addRecord(level[i], 0, level[i].length);
            }
            level = null;
            name = null;
            rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void flush() {
        int backShowHelp = this.getGameData()[3];
        try {
            RecordStore.deleteRecordStore((String)"GAME");
            RecordStore.deleteRecordStore((String)"BALL");
            RecordStore.deleteRecordStore((String)"RECORDS");
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        this.setGameVar(backShowHelp, 3);
    }
}

