/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Records {
    private int sWidth;
    private int sHeight;
    private int lH;
    private int lMax;
    private int[] pWindow;
    private int[] mWindow;
    private int[] bColors = new int[]{0x999999, 0x999999};
    private String[][] records;
    private Image bg;
    private Image board;
    private Image[] button;
    private Button back;
    private DrawText dt;
    private ScrollBar scrollBar;
    private Slider slider;
    private RMS rms;

    public Records(int sWidth, int sHeight, RMS rms, Image bg, Image board, Image[] button, DrawText dt) {
        this.sWidth = sWidth;
        this.sHeight = sHeight;
        this.rms = rms;
        this.bg = bg;
        this.board = board;
        this.button = button;
        this.dt = dt;
        this.pWindow = new int[3];
        this.mWindow = new int[3];
        this.getRecords(rms.getGameData()[4] - 1);
        this.lH = 22;
        this.lMax = board.getHeight() - 24;
        this.back = new Button();
        String[] diff = Localization.getFullText(21);
        this.slider = new Slider(diff, sWidth / 2 - RB2.max(dt, diff[0], diff[1], diff[2]) / 2, 7, RB2.max(dt, diff[0], diff[1], diff[2]), 16, dt);
        this.slider.setIndex(rms.getGameData()[4] - 1);
        if (this.records.length > 0 && this.records.length > 0) {
            this.initScroll();
        }
    }

    private void initScroll() {
        if (this.lH * this.records.length > this.lMax - 46) {
            this.scrollBar = new ScrollBar(25, 50, this.sWidth - 50, this.lMax - 46, this.lH * this.records.length - (this.lMax - 46), this.lH * this.records.length, false);
            this.scrollBar.setVisibleScroll(false);
        }
    }

    public ScrollBar getScrollBar() {
        return this.scrollBar;
    }

    public Button getBackButton() {
        return this.back;
    }

    private int round(float f) {
        return (int)(f + 0.5f);
    }

    public void check(int pKey, int rKey, int dKey, int pX, int pY, int rX, int rY, int dX, int dY) {
        if (this.bColors[0] == 0x999999 && (pKey == -3 || pKey == 52 || pKey == 102) && this.slider.getIndex() > 0) {
            this.bColors[0] = 12155479;
        }
        if (this.bColors[0] == 12155479 && (rKey == -3 || rKey == 52 || rKey == 102) && this.slider.getIndex() > 0) {
            this.slider.setIndex(this.slider.getIndex() - 1);
            this.getRecords(this.slider.getIndex());
            this.bColors[0] = 0x999999;
        }
        if (this.bColors[1] == 0x999999 && (pKey == -4 || pKey == 54 || pKey == 104) && this.slider.getIndex() < 2) {
            this.bColors[1] = 12155479;
        }
        if (this.bColors[1] == 12155479 && (rKey == -4 || rKey == 54 || rKey == 104) && this.slider.getIndex() < 2) {
            this.slider.setIndex(this.slider.getIndex() + 1);
            this.getRecords(this.slider.getIndex());
            this.bColors[1] = 0x999999;
        }
        this.slider.pCheck(pX, pY, rX, rY, dX, dY);
        if (this.slider.hasValue()) {
            this.getRecords(this.slider.getIndex());
        }
        if (this.records.length > 0 && this.scrollBar != null) {
            int lY = -this.scrollBar.getValue();
            if ((dKey == -1 || dKey == 50 || dKey == 116) && lY < 0) {
                this.scrollBar.setValue(this.scrollBar.getValue() - 1);
            }
            if ((dKey == -2 || dKey == 56 || dKey == 98) && lY > this.lMax - 46 - this.lH * this.records.length) {
                this.scrollBar.setValue(this.scrollBar.getValue() + 1);
            }
        }
    }

    private void getRecords(int diff) {
        int[][] temp_records = this.rms.getRecords(diff);
        this.records = new String[temp_records.length][3];
        for (int j = 0; j < this.records.length; ++j) {
            this.records[j][0] = Localization.getAloneText(46) + temp_records[j][0];
            int second = (temp_records[j][1] - temp_records[j][1] / 60000 * 60000) / 1000;
            this.records[j][1] = temp_records[j][1] / 60000 + ":" + (second < 10 ? "0" : "") + second;
            this.records[j][2] = "" + temp_records[j][2];
            for (int k = 0; k < this.mWindow.length; ++k) {
                this.mWindow[k] = Math.max(this.mWindow[k], this.dt.stringWidth(this.records[j][k]) + 8);
            }
        }
        float mAll = this.mWindow[0] + this.mWindow[1] + this.mWindow[2];
        for (int j = 0; j < this.mWindow.length; ++j) {
            this.pWindow[j] = j == 0 ? 0 : this.pWindow[j - 1] + this.mWindow[j - 1];
            this.mWindow[j] = this.round((float)(this.sWidth - 50) * ((float)this.mWindow[j] / mAll));
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.bg, 0, 0, 20);
        g.drawImage(this.board, 20, 30, 20);
        this.dt.setColor(0xE0E0E0);
        this.slider.paint(g);
        g.setColor(this.bColors[0]);
        if (this.slider.getIndex() > 0) {
            g.fillTriangle(this.slider.getX() - 8, this.slider.getY() + 2, this.slider.getX() - 8, this.slider.getY() + this.slider.getHeight() - 2, this.slider.getX() - 18, this.slider.getY() + this.slider.getHeight() / 2);
        }
        g.setColor(this.bColors[1]);
        if (this.slider.getIndex() < 2) {
            g.fillTriangle(this.slider.getX() + this.slider.getWidth() + 8, this.slider.getY() + 2, this.slider.getX() + this.slider.getWidth() + 8, this.slider.getY() + this.slider.getHeight() - 2, this.slider.getX() + this.slider.getWidth() + 18, this.slider.getY() + this.slider.getHeight() / 2);
        }
        this.dt.setColor(0xD0D0D0);
        if (this.records.length == 0) {
            String sign = Localization.getAloneText(47);
            this.dt.drawString(g, this.sWidth / 2 - this.dt.stringWidth(sign) / 2, 30 + this.lMax / 2 - 7, sign);
            sign = null;
        } else {
            g.setClip(25, 42, this.sWidth - 50, this.lMax);
            g.setColor(0xD0D0D0);
            g.drawRect(25, 42, this.sWidth - 51, this.lMax - 1);
            for (int i = 0; i < this.records.length; ++i) {
                int lY = this.scrollBar != null ? -this.scrollBar.getValue() : 0;
                g.drawRect(25, 42 + lY + this.lH * i, this.sWidth - 51, this.lH);
                for (int j = 0; j < this.pWindow.length; ++j) {
                    if (j > 0) {
                        g.drawLine(25 + this.pWindow[j], 42 + lY + this.lH * i, 25 + this.pWindow[j], 42 + lY + this.lH * i + this.lH);
                    }
                    this.dt.drawString(g, 25 + this.pWindow[j] + this.mWindow[j] / 2 - this.dt.stringWidth(this.records[i][j]) / 2, 42 + lY + this.lH * i + this.lH / 2 - 7, this.records[i][j]);
                }
            }
        }
        g.setClip(0, 0, this.sWidth, this.sHeight);
        String string = Localization.getAloneText(39);
        this.dt.setColor(0xFFFFFF);
        int x = this.sWidth - this.dt.stringWidth(string) - 14;
        this.back.paint(g, x + this.dt.stringWidth(string) / 2 - this.button[0].getWidth() / 2, this.sHeight - 23 + 7 - this.button[0].getHeight() / 2, this.button);
        this.dt.drawString(g, x + 1, this.sHeight - 23, string);
        string = null;
    }
}

